/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.config.PropertiesProvider;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

public final class ExternalOptions {
    private String dsn;
    private String environment;
    private String release;
    private String dist;
    private String serverName;
    private Boolean enableUncaughtExceptionHandler;
    private Boolean debug;
    private Boolean enableDeduplication;
    private Double tracesSampleRate;
    private Double profilesSampleRate;
    private SentryOptions.RequestSize maxRequestBodySize;
    private final Map<String, String> tags = new ConcurrentHashMap<String, String>();
    private SentryOptions.Proxy proxy;
    private final List<String> inAppExcludes = new CopyOnWriteArrayList<String>();
    private final List<String> inAppIncludes = new CopyOnWriteArrayList<String>();
    private List<String> tracePropagationTargets = null;
    private final List<String> contextTags = new CopyOnWriteArrayList<String>();
    private String proguardUuid;
    private Long idleTimeout;
    private final Set<Class<? extends Throwable>> ignoredExceptionsForType = new CopyOnWriteArraySet<Class<? extends Throwable>>();
    private List<String> ignoredErrors;
    private Boolean printUncaughtStackTrace;
    private Boolean sendClientReports;
    private Set<String> bundleIds = new CopyOnWriteArraySet<String>();
    private Boolean enabled;
    private Boolean enablePrettySerializationOutput;
    private Boolean enableSpotlight;
    private String spotlightConnectionUrl;
    private List<String> ignoredCheckIns;
    private List<String> ignoredTransactions;
    private Boolean sendModules;
    private Boolean sendDefaultPii;
    private Boolean enableBackpressureHandling;
    private Boolean globalHubMode;
    private Boolean forceInit;
    private Boolean captureOpenTelemetryEvents;
    private SentryOptions.Cron cron;

    /*
     * WARNING - void declaration
     */
    public static ExternalOptions from(PropertiesProvider propertiesProvider, ILogger logger) {
        void var2_2;
        PropertiesProvider propertiesProvider2;
        ExternalOptions options = new ExternalOptions();
        options.setDsn(propertiesProvider.getProperty("dsn"));
        options.setEnvironment(propertiesProvider.getProperty("environment"));
        options.setRelease(propertiesProvider.getProperty("release"));
        options.setDist(propertiesProvider.getProperty("dist"));
        options.setServerName(propertiesProvider.getProperty("servername"));
        options.setEnableUncaughtExceptionHandler(propertiesProvider.getBooleanProperty("uncaught.handler.enabled"));
        options.setPrintUncaughtStackTrace(propertiesProvider.getBooleanProperty("uncaught.handler.print-stacktrace"));
        options.setTracesSampleRate(propertiesProvider.getDoubleProperty("traces-sample-rate"));
        options.setProfilesSampleRate(propertiesProvider.getDoubleProperty("profiles-sample-rate"));
        options.setDebug(propertiesProvider.getBooleanProperty("debug"));
        options.setEnableDeduplication(propertiesProvider.getBooleanProperty("enable-deduplication"));
        options.setSendClientReports(propertiesProvider.getBooleanProperty("send-client-reports"));
        options.setForceInit(propertiesProvider.getBooleanProperty("force-init"));
        Iterator<Map.Entry<String, String>> maxRequestBodySize = propertiesProvider.getProperty("max-request-body-size");
        if (maxRequestBodySize != null) {
            options.setMaxRequestBodySize(SentryOptions.RequestSize.valueOf(((String)((Object)maxRequestBodySize)).toUpperCase(Locale.ROOT)));
        }
        maxRequestBodySize = propertiesProvider.getMap("tags");
        for (Map.Entry<String, String> entry : maxRequestBodySize.entrySet()) {
            options.setTag(entry.getKey(), entry.getValue());
        }
        Iterator<String> proxyHost = propertiesProvider.getProperty("proxy.host");
        String string = propertiesProvider.getProperty("proxy.user");
        String proxyPass = propertiesProvider.getProperty("proxy.pass");
        String proxyPort = propertiesProvider.getProperty("proxy.port", "80");
        if (proxyHost != null) {
            options.setProxy(new SentryOptions.Proxy((String)((Object)proxyHost), proxyPort, string, proxyPass));
        }
        for (String string2 : propertiesProvider.getList("in-app-includes")) {
            options.addInAppInclude(string2);
        }
        for (String string3 : propertiesProvider.getList("in-app-excludes")) {
            options.addInAppExclude(string3);
        }
        List<String> tracePropagationTargets = null;
        if (propertiesProvider.getProperty("trace-propagation-targets") != null) {
            tracePropagationTargets = propertiesProvider.getList("trace-propagation-targets");
        }
        if (tracePropagationTargets == null && propertiesProvider.getProperty("tracing-origins") != null) {
            tracePropagationTargets = propertiesProvider.getList("tracing-origins");
        }
        if (tracePropagationTargets != null) {
            for (String tracePropagationTarget : tracePropagationTargets) {
                options.addTracePropagationTarget(tracePropagationTarget);
            }
        }
        for (String contextTag : propertiesProvider.getList("context-tags")) {
            options.addContextTag(contextTag);
        }
        options.setProguardUuid(propertiesProvider.getProperty("proguard-uuid"));
        for (String bundleId : propertiesProvider.getList("bundle-ids")) {
            options.addBundleId(bundleId);
        }
        options.setIdleTimeout(propertiesProvider.getLongProperty("idle-timeout"));
        options.setIgnoredErrors(propertiesProvider.getListOrNull("ignored-errors"));
        options.setEnabled(propertiesProvider.getBooleanProperty("enabled"));
        options.setEnablePrettySerializationOutput(propertiesProvider.getBooleanProperty("enable-pretty-serialization-output"));
        options.setSendModules(propertiesProvider.getBooleanProperty("send-modules"));
        options.setSendDefaultPii(propertiesProvider.getBooleanProperty("send-default-pii"));
        options.setIgnoredCheckIns(propertiesProvider.getListOrNull("ignored-checkins"));
        options.setIgnoredTransactions(propertiesProvider.getListOrNull("ignored-transactions"));
        options.setEnableBackpressureHandling(propertiesProvider.getBooleanProperty("enable-backpressure-handling"));
        options.setGlobalHubMode(propertiesProvider.getBooleanProperty("global-hub-mode"));
        options.setCaptureOpenTelemetryEvents(propertiesProvider.getBooleanProperty("capture-open-telemetry-events"));
        for (String ignoredExceptionType : propertiesProvider.getList("ignored-exceptions-for-type")) {
            try {
                Class<?> clazz = Class.forName(ignoredExceptionType);
                if (Throwable.class.isAssignableFrom(clazz)) {
                    options.addIgnoredExceptionForType(clazz);
                    continue;
                }
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s does not extend Throwable", ignoredExceptionType, ignoredExceptionType);
            }
            catch (ClassNotFoundException classNotFoundException) {
                logger.log(SentryLevel.WARNING, "Skipping setting %s as ignored-exception-for-type. Reason: %s class is not found", ignoredExceptionType, ignoredExceptionType);
            }
        }
        Long l = propertiesProvider.getLongProperty("cron.default-checkin-margin");
        Long cronDefaultMaxRuntime = propertiesProvider.getLongProperty("cron.default-max-runtime");
        String cronDefaultTimezone = propertiesProvider.getProperty("cron.default-timezone");
        Long cronDefaultFailureIssueThreshold = propertiesProvider.getLongProperty("cron.default-failure-issue-threshold");
        Long cronDefaultRecoveryThreshold = propertiesProvider.getLongProperty("cron.default-recovery-threshold");
        if (l != null || cronDefaultMaxRuntime != null || cronDefaultTimezone != null || cronDefaultFailureIssueThreshold != null || cronDefaultRecoveryThreshold != null) {
            void var1_1;
            void var3_3;
            SentryOptions.Cron cron = new SentryOptions.Cron();
            cron.setDefaultCheckinMargin(l);
            cron.setDefaultMaxRuntime((Long)var3_3);
            cron.setDefaultTimezone(cronDefaultTimezone);
            cron.setDefaultFailureIssueThreshold((Long)var1_1);
            cron.setDefaultRecoveryThreshold(cronDefaultRecoveryThreshold);
            options.setCron(cron);
        }
        options.setEnableSpotlight(propertiesProvider.getBooleanProperty("enable-spotlight"));
        options.setSpotlightConnectionUrl(propertiesProvider2.getProperty("spotlight-connection-url"));
        return var2_2;
    }

    public final String getDsn() {
        return this.dsn;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDsn(String dsn) {
        void var1_1;
        this.dsn = var1_1;
    }

    public final String getEnvironment() {
        return this.environment;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnvironment(String environment) {
        void var1_1;
        this.environment = var1_1;
    }

    public final String getRelease() {
        return this.release;
    }

    /*
     * WARNING - void declaration
     */
    public final void setRelease(String release) {
        void var1_1;
        this.release = var1_1;
    }

    public final String getDist() {
        return this.dist;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDist(String dist) {
        void var1_1;
        this.dist = var1_1;
    }

    public final String getServerName() {
        return this.serverName;
    }

    /*
     * WARNING - void declaration
     */
    public final void setServerName(String serverName) {
        void var1_1;
        this.serverName = var1_1;
    }

    public final Boolean getEnableUncaughtExceptionHandler() {
        return this.enableUncaughtExceptionHandler;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnableUncaughtExceptionHandler(Boolean enableUncaughtExceptionHandler) {
        void var1_1;
        this.enableUncaughtExceptionHandler = var1_1;
    }

    public final List<String> getTracePropagationTargets() {
        return this.tracePropagationTargets;
    }

    public final Boolean getDebug() {
        return this.debug;
    }

    /*
     * WARNING - void declaration
     */
    public final void setDebug(Boolean debug) {
        void var1_1;
        this.debug = var1_1;
    }

    public final Boolean getEnableDeduplication() {
        return this.enableDeduplication;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnableDeduplication(Boolean enableDeduplication) {
        void var1_1;
        this.enableDeduplication = var1_1;
    }

    public final Double getTracesSampleRate() {
        return this.tracesSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setTracesSampleRate(Double tracesSampleRate) {
        void var1_1;
        this.tracesSampleRate = var1_1;
    }

    public final Double getProfilesSampleRate() {
        return this.profilesSampleRate;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProfilesSampleRate(Double profilesSampleRate) {
        void var1_1;
        this.profilesSampleRate = var1_1;
    }

    public final SentryOptions.RequestSize getMaxRequestBodySize() {
        return this.maxRequestBodySize;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMaxRequestBodySize(SentryOptions.RequestSize maxRequestBodySize) {
        void var1_1;
        this.maxRequestBodySize = var1_1;
    }

    public final Map<String, String> getTags() {
        return this.tags;
    }

    public final SentryOptions.Proxy getProxy() {
        return this.proxy;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProxy(SentryOptions.Proxy proxy) {
        void var1_1;
        this.proxy = var1_1;
    }

    public final List<String> getInAppExcludes() {
        return this.inAppExcludes;
    }

    public final List<String> getInAppIncludes() {
        return this.inAppIncludes;
    }

    public final List<String> getContextTags() {
        return this.contextTags;
    }

    public final String getProguardUuid() {
        return this.proguardUuid;
    }

    /*
     * WARNING - void declaration
     */
    public final void setProguardUuid(String proguardUuid) {
        void var1_1;
        this.proguardUuid = var1_1;
    }

    public final Set<Class<? extends Throwable>> getIgnoredExceptionsForType() {
        return this.ignoredExceptionsForType;
    }

    /*
     * WARNING - void declaration
     */
    public final void addInAppInclude(String include) {
        void var1_1;
        this.inAppIncludes.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addInAppExclude(String exclude) {
        void var1_1;
        this.inAppExcludes.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addTracePropagationTarget(String tracePropagationTarget) {
        if (this.tracePropagationTargets == null) {
            this.tracePropagationTargets = new CopyOnWriteArrayList<String>();
        }
        if (!tracePropagationTarget.isEmpty()) {
            void var1_1;
            this.tracePropagationTargets.add((String)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void addContextTag(String contextTag) {
        void var1_1;
        this.contextTags.add((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void addIgnoredExceptionForType(Class<? extends Throwable> exceptionType) {
        void var1_1;
        this.ignoredExceptionsForType.add((Class<? extends Throwable>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void setTag(String key, String value) {
        void var2_2;
        void var1_1;
        this.tags.put((String)var1_1, (String)var2_2);
    }

    public final Boolean getPrintUncaughtStackTrace() {
        return this.printUncaughtStackTrace;
    }

    /*
     * WARNING - void declaration
     */
    public final void setPrintUncaughtStackTrace(Boolean printUncaughtStackTrace) {
        void var1_1;
        this.printUncaughtStackTrace = var1_1;
    }

    public final Long getIdleTimeout() {
        return this.idleTimeout;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIdleTimeout(Long idleTimeout) {
        void var1_1;
        this.idleTimeout = var1_1;
    }

    public final List<String> getIgnoredErrors() {
        return this.ignoredErrors;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIgnoredErrors(List<String> ignoredErrors) {
        void var1_1;
        this.ignoredErrors = var1_1;
    }

    public final Boolean getSendClientReports() {
        return this.sendClientReports;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSendClientReports(Boolean sendClientReports) {
        void var1_1;
        this.sendClientReports = var1_1;
    }

    public final Set<String> getBundleIds() {
        return this.bundleIds;
    }

    /*
     * WARNING - void declaration
     */
    public final void addBundleId(String bundleId) {
        void var1_1;
        this.bundleIds.add((String)var1_1);
    }

    public final Boolean isEnabled() {
        return this.enabled;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnabled(Boolean enabled) {
        void var1_1;
        this.enabled = var1_1;
    }

    public final Boolean isEnablePrettySerializationOutput() {
        return this.enablePrettySerializationOutput;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnablePrettySerializationOutput(Boolean enablePrettySerializationOutput) {
        void var1_1;
        this.enablePrettySerializationOutput = var1_1;
    }

    public final Boolean isSendModules() {
        return this.sendModules;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSendModules(Boolean sendModules) {
        void var1_1;
        this.sendModules = var1_1;
    }

    public final Boolean isSendDefaultPii() {
        return this.sendDefaultPii;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSendDefaultPii(Boolean sendDefaultPii) {
        void var1_1;
        this.sendDefaultPii = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIgnoredCheckIns(List<String> ignoredCheckIns) {
        void var1_1;
        this.ignoredCheckIns = var1_1;
    }

    public final List<String> getIgnoredCheckIns() {
        return this.ignoredCheckIns;
    }

    /*
     * WARNING - void declaration
     */
    public final void setIgnoredTransactions(List<String> ignoredTransactions) {
        void var1_1;
        this.ignoredTransactions = var1_1;
    }

    public final List<String> getIgnoredTransactions() {
        return this.ignoredTransactions;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnableBackpressureHandling(Boolean enableBackpressureHandling) {
        void var1_1;
        this.enableBackpressureHandling = var1_1;
    }

    public final Boolean isEnableBackpressureHandling() {
        return this.enableBackpressureHandling;
    }

    /*
     * WARNING - void declaration
     */
    public final void setGlobalHubMode(Boolean globalHubMode) {
        void var1_1;
        this.globalHubMode = var1_1;
    }

    public final Boolean isGlobalHubMode() {
        return this.globalHubMode;
    }

    /*
     * WARNING - void declaration
     */
    public final void setForceInit(Boolean forceInit) {
        void var1_1;
        this.forceInit = var1_1;
    }

    public final Boolean isForceInit() {
        return this.forceInit;
    }

    public final SentryOptions.Cron getCron() {
        return this.cron;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCron(SentryOptions.Cron cron) {
        void var1_1;
        this.cron = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnableSpotlight(Boolean enableSpotlight) {
        void var1_1;
        this.enableSpotlight = var1_1;
    }

    public final Boolean isEnableSpotlight() {
        return this.enableSpotlight;
    }

    public final String getSpotlightConnectionUrl() {
        return this.spotlightConnectionUrl;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSpotlightConnectionUrl(String spotlightConnectionUrl) {
        void var1_1;
        this.spotlightConnectionUrl = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCaptureOpenTelemetryEvents(Boolean captureOpenTelemetryEvents) {
        void var1_1;
        this.captureOpenTelemetryEvents = var1_1;
    }

    public final Boolean isCaptureOpenTelemetryEvents() {
        return this.captureOpenTelemetryEvents;
    }
}

