/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.EventProcessor;
import io.sentry.Hint;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.util.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public final class DuplicateEventDetectionEventProcessor
implements EventProcessor {
    private final Map<Throwable, Object> capturedObjects = Collections.synchronizedMap(new WeakHashMap());
    private final SentryOptions options;

    /*
     * WARNING - void declaration
     */
    public DuplicateEventDetectionEventProcessor(SentryOptions options) {
        void var1_1;
        this.options = (SentryOptions)Objects.requireNonNull(var1_1, "options are required");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryEvent process(SentryEvent event, Hint hint) {
        void var1_1;
        if (this.options.isEnableDeduplication()) {
            Throwable throwable = event.getThrowable();
            if (throwable != null) {
                void var2_2;
                if (this.capturedObjects.containsKey(throwable) || DuplicateEventDetectionEventProcessor.containsAnyKey(this.capturedObjects, DuplicateEventDetectionEventProcessor.allCauses(throwable))) {
                    this.options.getLogger().log(SentryLevel.DEBUG, "Duplicate Exception detected. Event %s will be discarded.", event.getEventId());
                    return null;
                }
                this.capturedObjects.put((Throwable)var2_2, null);
            }
        } else {
            this.options.getLogger().log(SentryLevel.DEBUG, "Event deduplication is disabled.", new Object[0]);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static <T> boolean containsAnyKey(Map<T, Object> map, List<T> list) {
        for (T entry : list) {
            void var2_2;
            if (!map.containsKey(var2_2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static List<Throwable> allCauses(Throwable throwable) {
        void var1_1;
        Throwable ex;
        ArrayList<Throwable> causes = new ArrayList<Throwable>();
        while (ex.getCause() != null) {
            causes.add(ex.getCause());
            ex = ex.getCause();
        }
        return var1_1;
    }
}

