/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.Attachment;
import io.sentry.Breadcrumb;
import io.sentry.CombinedContextsView;
import io.sentry.EventProcessor;
import io.sentry.IScope;
import io.sentry.ISentryClient;
import io.sentry.ISpan;
import io.sentry.ITransaction;
import io.sentry.NoOpSentryClient;
import io.sentry.PropagationContext;
import io.sentry.Scope;
import io.sentry.ScopeType;
import io.sentry.SentryEvent;
import io.sentry.SentryLevel;
import io.sentry.SentryOptions;
import io.sentry.Session;
import io.sentry.internal.eventprocessor.EventProcessorAndOrder;
import io.sentry.protocol.Contexts;
import io.sentry.protocol.Request;
import io.sentry.protocol.SentryId;
import io.sentry.protocol.User;
import io.sentry.util.EventProcessorUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CombinedScopeView
implements IScope {
    private final IScope globalScope;
    private final IScope isolationScope;
    private final IScope scope;

    /*
     * WARNING - void declaration
     */
    public CombinedScopeView(IScope globalScope, IScope isolationScope, IScope scope) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.globalScope = var1_1;
        this.isolationScope = var2_2;
        this.scope = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryLevel getLevel() {
        SentryLevel current = this.scope.getLevel();
        if (current != null) {
            return current;
        }
        SentryLevel isolation = this.isolationScope.getLevel();
        if (isolation != null) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getLevel();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setLevel(SentryLevel level) {
        void var1_1;
        this.getDefaultWriteScope().setLevel((SentryLevel)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String getTransactionName() {
        String current = this.scope.getTransactionName();
        if (current != null) {
            return current;
        }
        String isolation = this.isolationScope.getTransactionName();
        if (isolation != null) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getTransactionName();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ISpan getSpan() {
        ISpan current = this.scope.getSpan();
        if (current != null) {
            return current;
        }
        ISpan isolation = this.isolationScope.getSpan();
        if (isolation != null) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getSpan();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final User getUser() {
        User current = this.scope.getUser();
        if (current != null) {
            return current;
        }
        User isolation = this.isolationScope.getUser();
        if (isolation != null) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getUser();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setUser(User user) {
        void var1_1;
        this.getDefaultWriteScope().setUser((User)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Request getRequest() {
        Request current = this.scope.getRequest();
        if (current != null) {
            return current;
        }
        Request isolation = this.isolationScope.getRequest();
        if (isolation != null) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getRequest();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<String> getFingerprint() {
        List<String> current = this.scope.getFingerprint();
        if (!current.isEmpty()) {
            return current;
        }
        List<String> isolation = this.isolationScope.getFingerprint();
        if (!isolation.isEmpty()) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getFingerprint();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Queue<Breadcrumb> getBreadcrumbs() {
        void var2_2;
        void var1_1;
        ArrayList<Breadcrumb> allBreadcrumbs = new ArrayList<Breadcrumb>();
        allBreadcrumbs.addAll(this.globalScope.getBreadcrumbs());
        allBreadcrumbs.addAll(this.isolationScope.getBreadcrumbs());
        allBreadcrumbs.addAll(this.scope.getBreadcrumbs());
        Collections.sort(allBreadcrumbs);
        Queue<Breadcrumb> breadcrumbs = Scope.createBreadcrumbsList(this.scope.getOptions().getMaxBreadcrumbs());
        breadcrumbs.addAll((Collection<Breadcrumb>)var1_1);
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ITransaction getTransaction() {
        ITransaction current = this.scope.getTransaction();
        if (current != null) {
            return current;
        }
        ITransaction isolation = this.isolationScope.getTransaction();
        if (isolation != null) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getTransaction();
    }

    @Override
    public final void clear() {
        this.getDefaultWriteScope().clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, String> getTags() {
        void var1_1;
        ConcurrentHashMap<String, String> allTags = new ConcurrentHashMap<String, String>();
        allTags.putAll(this.globalScope.getTags());
        allTags.putAll(this.isolationScope.getTags());
        allTags.putAll(this.scope.getTags());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map<String, Object> getExtras() {
        void var1_1;
        ConcurrentHashMap<String, Object> allTags = new ConcurrentHashMap<String, Object>();
        allTags.putAll(this.globalScope.getExtras());
        allTags.putAll(this.isolationScope.getExtras());
        allTags.putAll(this.scope.getExtras());
        return var1_1;
    }

    @Override
    public final Contexts getContexts() {
        return new CombinedContextsView(this.globalScope.getContexts(), this.isolationScope.getContexts(), this.scope.getContexts(), this.getOptions().getDefaultScopeType());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setContexts(String key, String value) {
        void var2_2;
        void var1_1;
        this.getDefaultWriteScope().setContexts((String)var1_1, (String)var2_2);
    }

    private IScope getDefaultWriteScope() {
        return this.getSpecificScope(null);
    }

    /*
     * WARNING - void declaration
     */
    final IScope getSpecificScope(ScopeType scopeType) {
        if (scopeType != null) {
            void var1_1;
            switch (1.$SwitchMap$io$sentry$ScopeType[var1_1.ordinal()]) {
                case 1: {
                    return this.scope;
                }
                case 2: {
                    return this.isolationScope;
                }
                case 3: {
                    return this.globalScope;
                }
                case 4: {
                    return this;
                }
            }
        }
        switch (this.getOptions().getDefaultScopeType()) {
            case CURRENT: {
                return this.scope;
            }
            case ISOLATION: {
                return this.isolationScope;
            }
            case GLOBAL: {
                return this.globalScope;
            }
        }
        return this.scope;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<Attachment> getAttachments() {
        void var1_1;
        CopyOnWriteArrayList<Attachment> allAttachments = new CopyOnWriteArrayList<Attachment>();
        allAttachments.addAll(this.globalScope.getAttachments());
        allAttachments.addAll(this.isolationScope.getAttachments());
        allAttachments.addAll(this.scope.getAttachments());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final List<EventProcessorAndOrder> getEventProcessorsWithOrder() {
        void var1_1;
        CopyOnWriteArrayList<EventProcessorAndOrder> allEventProcessors = new CopyOnWriteArrayList<EventProcessorAndOrder>();
        allEventProcessors.addAll(this.globalScope.getEventProcessorsWithOrder());
        allEventProcessors.addAll(this.isolationScope.getEventProcessorsWithOrder());
        allEventProcessors.addAll(this.scope.getEventProcessorsWithOrder());
        Collections.sort(allEventProcessors);
        return var1_1;
    }

    @Override
    public final List<EventProcessor> getEventProcessors() {
        return EventProcessorUtils.unwrap(this.getEventProcessorsWithOrder());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Session withSession(Scope.IWithSession sessionCallback) {
        void var1_1;
        return this.getDefaultWriteScope().withSession((Scope.IWithSession)var1_1);
    }

    @Override
    public final SentryOptions getOptions() {
        return this.globalScope.getOptions();
    }

    @Override
    public final PropagationContext getPropagationContext() {
        return this.getDefaultWriteScope().getPropagationContext();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final PropagationContext withPropagationContext(Scope.IWithPropagationContext callback) {
        void var1_1;
        return this.getDefaultWriteScope().withPropagationContext((Scope.IWithPropagationContext)var1_1);
    }

    @Override
    public final IScope clone() {
        return new CombinedScopeView(this.globalScope, this.isolationScope.clone(), this.scope.clone());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void setLastEventId(SentryId lastEventId) {
        void var1_1;
        this.globalScope.setLastEventId(lastEventId);
        this.isolationScope.setLastEventId(lastEventId);
        this.scope.setLastEventId((SentryId)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void bindClient(ISentryClient client) {
        void var1_1;
        this.getDefaultWriteScope().bindClient((ISentryClient)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ISentryClient getClient() {
        ISentryClient current = this.scope.getClient();
        if (!(current instanceof NoOpSentryClient)) {
            return current;
        }
        ISentryClient isolation = this.isolationScope.getClient();
        if (!(isolation instanceof NoOpSentryClient)) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getClient();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void assignTraceContext(SentryEvent event) {
        void var1_1;
        this.globalScope.assignTraceContext((SentryEvent)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void replaceOptions(SentryOptions options) {
        void var1_1;
        this.globalScope.replaceOptions((SentryOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final SentryId getReplayId() {
        SentryId current = this.scope.getReplayId();
        if (!SentryId.EMPTY_ID.equals(current)) {
            return current;
        }
        SentryId isolation = this.isolationScope.getReplayId();
        if (!SentryId.EMPTY_ID.equals(isolation)) {
            void var1_1;
            return var1_1;
        }
        return this.globalScope.getReplayId();
    }
}

