/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Queue;

final class CircularFifoQueue<E>
extends AbstractCollection<E>
implements Serializable,
Queue<E> {
    private transient E[] elements;
    private transient int start = 0;
    private transient int end = 0;
    private transient boolean full = false;
    private final int maxElements;

    public CircularFifoQueue() {
        this(32);
    }

    /*
     * WARNING - void declaration
     */
    CircularFifoQueue(int size) {
        void var1_1;
        if (size <= 0) {
            throw new IllegalArgumentException("The size must be greater than 0");
        }
        this.elements = new Object[var1_1];
        this.maxElements = this.elements.length;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int size() {
        void var1_1;
        int size = this.end < this.start ? this.maxElements - this.start + this.end : (this.end == this.start ? (this.full ? this.maxElements : 0) : this.end - this.start);
        return (int)var1_1;
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    public final boolean isAtFullCapacity() {
        return this.size() == this.maxElements;
    }

    @Override
    public final void clear() {
        this.full = false;
        this.start = 0;
        this.end = 0;
        Arrays.fill(this.elements, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var1_1;
        if (element == null) {
            throw new NullPointerException("Attempted to add null object to queue");
        }
        if (this.isAtFullCapacity()) {
            this.remove();
        }
        this.elements[this.end++] = var1_1;
        if (this.end >= this.maxElements) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.full = true;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean offer(E element) {
        void var1_1;
        return this.add(var1_1);
    }

    @Override
    public final E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.remove();
    }

    @Override
    public final E element() {
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        return this.peek();
    }

    @Override
    public final E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elements[this.start];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final E remove() {
        void var1_1;
        if (this.isEmpty()) {
            throw new NoSuchElementException("queue is empty");
        }
        E element = this.elements[this.start];
        if (element != null) {
            this.elements[this.start++] = null;
            if (this.start >= this.maxElements) {
                this.start = 0;
            }
            this.full = false;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int increment(int index) {
        void var1_1;
        if (++index >= this.maxElements) {
            index = 0;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private int decrement(int index) {
        void var1_1;
        if (--index < 0) {
            index = this.maxElements - 1;
        }
        return (int)var1_1;
    }

    @Override
    public final Iterator<E> iterator() {
        return new Iterator<E>(this){
            private int index;
            private int lastReturnedIndex;
            private boolean isFirst;
            final /* synthetic */ CircularFifoQueue this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.index = this.this$0.start;
                this.lastReturnedIndex = -1;
                this.isFirst = this.this$0.full;
            }

            @Override
            public boolean hasNext() {
                return this.isFirst || this.index != this.this$0.end;
            }

            @Override
            public E next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.isFirst = false;
                this.lastReturnedIndex = this.index;
                this.index = CircularFifoQueue.access$300(this.this$0, this.index);
                return this.this$0.elements[this.lastReturnedIndex];
            }

            @Override
            public void remove() {
                if (this.lastReturnedIndex == -1) {
                    throw new IllegalStateException();
                }
                if (this.lastReturnedIndex == this.this$0.start) {
                    this.this$0.remove();
                    this.lastReturnedIndex = -1;
                    return;
                }
                int pos = this.lastReturnedIndex + 1;
                if (this.this$0.start < this.lastReturnedIndex && pos < this.this$0.end) {
                    System.arraycopy(this.this$0.elements, pos, this.this$0.elements, this.lastReturnedIndex, this.this$0.end - pos);
                } else {
                    while (pos != this.this$0.end) {
                        if (pos >= this.this$0.maxElements) {
                            ((CircularFifoQueue)this.this$0).elements[pos - 1] = this.this$0.elements[0];
                            pos = 0;
                            continue;
                        }
                        ((CircularFifoQueue)this.this$0).elements[CircularFifoQueue.access$600((CircularFifoQueue)this.this$0, (int)pos)] = this.this$0.elements[pos];
                        pos = CircularFifoQueue.access$300(this.this$0, pos);
                    }
                }
                this.lastReturnedIndex = -1;
                CircularFifoQueue.access$202(this.this$0, CircularFifoQueue.access$600(this.this$0, this.this$0.end));
                ((CircularFifoQueue)this.this$0).elements[((CircularFifoQueue)this.this$0).end] = null;
                CircularFifoQueue.access$102(this.this$0, false);
                this.index = CircularFifoQueue.access$600(this.this$0, this.index);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$300(CircularFifoQueue x0, int x1) {
        void var1_1;
        return x0.increment((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$600(CircularFifoQueue x0, int x1) {
        void var1_1;
        return x0.decrement((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$202(CircularFifoQueue x0, int x1) {
        void var1_1;
        x0.end = var1_1;
        return x0.end;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$102(CircularFifoQueue x0, boolean x1) {
        void var1_1;
        x0.full = var1_1;
        return x0.full;
    }
}

