/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.DateUtils;
import io.sentry.ILogger;
import io.sentry.JsonDeserializer;
import io.sentry.JsonSerializable;
import io.sentry.ObjectReader;
import io.sentry.ObjectWriter;
import io.sentry.SentryLevel;
import io.sentry.util.CollectionUtils;
import io.sentry.util.Objects;
import io.sentry.vendor.gson.stream.JsonToken;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Breadcrumb
implements JsonSerializable,
Comparable<Breadcrumb> {
    private final Long timestampMs;
    private Date timestamp;
    private final Long nanos;
    private String message;
    private String type;
    private Map<String, Object> data = new ConcurrentHashMap<String, Object>();
    private String category;
    private String origin;
    private SentryLevel level;
    private Map<String, Object> unknown;

    /*
     * WARNING - void declaration
     */
    public Breadcrumb(Date timestamp) {
        void var1_1;
        this.nanos = System.nanoTime();
        this.timestamp = var1_1;
        this.timestampMs = null;
    }

    /*
     * WARNING - void declaration
     */
    public Breadcrumb(long timestamp) {
        void var1_1;
        this.nanos = System.nanoTime();
        this.timestampMs = (long)var1_1;
        this.timestamp = null;
    }

    /*
     * WARNING - void declaration
     */
    Breadcrumb(Breadcrumb breadcrumb) {
        void var1_1;
        this.nanos = System.nanoTime();
        this.timestamp = breadcrumb.timestamp;
        this.timestampMs = breadcrumb.timestampMs;
        this.message = breadcrumb.message;
        this.type = breadcrumb.type;
        this.category = breadcrumb.category;
        this.origin = breadcrumb.origin;
        Map<String, Object> dataClone = CollectionUtils.newConcurrentHashMap(breadcrumb.data);
        if (dataClone != null) {
            void var2_2;
            this.data = var2_2;
        }
        this.unknown = CollectionUtils.newConcurrentHashMap(breadcrumb.unknown);
        this.level = var1_1.level;
    }

    public Breadcrumb() {
        this(System.currentTimeMillis());
    }

    public final Date getTimestamp() {
        if (this.timestamp != null) {
            return (Date)this.timestamp.clone();
        }
        if (this.timestampMs != null) {
            this.timestamp = DateUtils.getDateTime(this.timestampMs);
            return this.timestamp;
        }
        throw new IllegalStateException("No timestamp set for breadcrumb");
    }

    public final String getMessage() {
        return this.message;
    }

    /*
     * WARNING - void declaration
     */
    public final void setMessage(String message) {
        void var1_1;
        this.message = var1_1;
    }

    public final String getType() {
        return this.type;
    }

    /*
     * WARNING - void declaration
     */
    public final void setType(String type) {
        void var1_1;
        this.type = var1_1;
    }

    public final Map<String, Object> getData() {
        return this.data;
    }

    /*
     * WARNING - void declaration
     */
    public final void setData(String key, Object value) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return;
        }
        if (value == null) {
            this.removeData(key);
            return;
        }
        this.data.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final void removeData(String key) {
        void var1_1;
        if (key == null) {
            return;
        }
        this.data.remove(var1_1);
    }

    public final String getCategory() {
        return this.category;
    }

    /*
     * WARNING - void declaration
     */
    public final void setCategory(String category) {
        void var1_1;
        this.category = var1_1;
    }

    public final SentryLevel getLevel() {
        return this.level;
    }

    /*
     * WARNING - void declaration
     */
    public final void setLevel(SentryLevel level) {
        void var1_1;
        this.level = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Breadcrumb that = (Breadcrumb)o;
        return this.getTimestamp().getTime() == that.getTimestamp().getTime() && Objects.equals(this.message, that.message) && Objects.equals(this.type, that.type) && Objects.equals(this.category, that.category) && Objects.equals(this.origin, that.origin) && this.level == var1_1.level;
    }

    public final int hashCode() {
        return Objects.hash(this.timestamp, this.message, this.type, this.category, this.origin, this.level);
    }

    /*
     * WARNING - void declaration
     */
    public final void setUnknown(Map<String, Object> unknown) {
        void var1_1;
        this.unknown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Breadcrumb o) {
        void var1_1;
        return this.nanos.compareTo(var1_1.nanos);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void serialize(ObjectWriter writer, ILogger logger) throws IOException {
        void var1_1;
        writer.beginObject();
        writer.name("timestamp").value(logger, this.getTimestamp());
        if (this.message != null) {
            writer.name("message").value(this.message);
        }
        if (this.type != null) {
            writer.name("type").value(this.type);
        }
        writer.name("data").value(logger, this.data);
        if (this.category != null) {
            writer.name("category").value(this.category);
        }
        if (this.origin != null) {
            writer.name("origin").value(this.origin);
        }
        if (this.level != null) {
            writer.name("level").value(logger, this.level);
        }
        if (this.unknown != null) {
            for (String key : this.unknown.keySet()) {
                Object value = this.unknown.get(key);
                writer.name(key);
                writer.value(logger, value);
            }
        }
        var1_1.endObject();
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$002(Breadcrumb x0, String x1) {
        void var1_1;
        x0.message = var1_1;
        return x0.message;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$102(Breadcrumb x0, String x1) {
        void var1_1;
        x0.type = var1_1;
        return x0.type;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Map access$202(Breadcrumb x0, Map x1) {
        void var1_1;
        x0.data = var1_1;
        return x0.data;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$302(Breadcrumb x0, String x1) {
        void var1_1;
        x0.category = var1_1;
        return x0.category;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ String access$402(Breadcrumb x0, String x1) {
        void var1_1;
        x0.origin = var1_1;
        return x0.origin;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ SentryLevel access$502(Breadcrumb x0, SentryLevel x1) {
        void var1_1;
        x0.level = var1_1;
        return x0.level;
    }

    public static final class Deserializer
    implements JsonDeserializer<Breadcrumb> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final Breadcrumb deserialize(ObjectReader reader, ILogger logger) throws Exception {
            void var1_1;
            void var3_3;
            reader.beginObject();
            Date timestamp = DateUtils.getCurrentDateTime();
            String message = null;
            String type = null;
            Map data = new ConcurrentHashMap();
            String category = null;
            String origin = null;
            SentryLevel level = null;
            ConcurrentHashMap<String, Object> unknown = null;
            block20: while (reader.peek() == JsonToken.NAME) {
                void exception2;
                String nextName;
                switch (nextName = reader.nextName()) {
                    case "timestamp": {
                        Date deserializedDate = reader.nextDateOrNull(logger);
                        if (deserializedDate == null) continue block20;
                        timestamp = deserializedDate;
                        continue block20;
                    }
                    case "message": {
                        message = reader.nextStringOrNull();
                        continue block20;
                    }
                    case "type": {
                        type = reader.nextStringOrNull();
                        continue block20;
                    }
                    case "data": {
                        Map deserializedData = CollectionUtils.newConcurrentHashMap((Map)reader.nextObjectOrNull());
                        if (deserializedData == null) continue block20;
                        data = deserializedData;
                        continue block20;
                    }
                    case "category": {
                        category = reader.nextStringOrNull();
                        continue block20;
                    }
                    case "origin": {
                        origin = reader.nextStringOrNull();
                        continue block20;
                    }
                    case "level": {
                        try {
                            level = new SentryLevel.Deserializer().deserialize(reader, logger);
                        }
                        catch (Exception exception2) {
                            logger.log(SentryLevel.ERROR, exception2, "Error when deserializing SentryLevel", new Object[0]);
                        }
                        continue block20;
                    }
                }
                if (unknown == null) {
                    unknown = new ConcurrentHashMap<String, Object>();
                }
                reader.nextUnknown(logger, unknown, (String)exception2);
            }
            Breadcrumb breadcrumb = new Breadcrumb((Date)var3_3);
            Breadcrumb.access$002(breadcrumb, message);
            Breadcrumb.access$102(breadcrumb, type);
            Breadcrumb.access$202(breadcrumb, data);
            Breadcrumb.access$302(breadcrumb, category);
            Breadcrumb.access$402(breadcrumb, origin);
            Breadcrumb.access$502(breadcrumb, level);
            breadcrumb.setUnknown(unknown);
            var1_1.endObject();
            return breadcrumb;
        }
    }
}

