/*
 * Decompiled with CFR 0.152.
 */
package io.sentry;

import io.sentry.ILogger;
import io.sentry.IScope;
import io.sentry.ISentryLifecycleToken;
import io.sentry.PropagationContext;
import io.sentry.SentryEvent;
import io.sentry.SentryOptions;
import io.sentry.SpanContext;
import io.sentry.TraceContext;
import io.sentry.TracesSamplingDecision;
import io.sentry.protocol.SentryId;
import io.sentry.util.AutoClosableReentrantLock;
import io.sentry.util.SampleRateUtils;
import io.sentry.util.StringUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public final class Baggage {
    static final Integer MAX_BAGGAGE_STRING_LENGTH = 8192;
    static final Integer MAX_BAGGAGE_LIST_MEMBER_COUNT = 64;
    private static final DecimalFormatterThreadLocal decimalFormatter = new DecimalFormatterThreadLocal();
    private final ConcurrentHashMap<String, String> keyValues;
    private final AutoClosableReentrantLock keyValuesLock = new AutoClosableReentrantLock();
    private Double sampleRate;
    private Double sampleRand;
    private final String thirdPartyHeader;
    private boolean mutable;
    private final boolean shouldFreeze;
    final ILogger logger;

    /*
     * WARNING - void declaration
     */
    public static Baggage fromEvent(SentryEvent event, SentryOptions options) {
        void var2_2;
        void var3_3;
        Baggage baggage = new Baggage(options.getLogger());
        SpanContext trace = event.getContexts().getTrace();
        baggage.setTraceId(trace != null ? var3_3.getTraceId().toString() : null);
        baggage.setPublicKey(options.retrieveParsedDsn().getPublicKey());
        baggage.setRelease(event.getRelease());
        baggage.setEnvironment(event.getEnvironment());
        baggage.setTransaction(event.getTransaction());
        baggage.setSampleRate(null);
        baggage.setSampled(null);
        baggage.setSampleRand(null);
        Object replayId = event.getContexts().get("replay_id");
        if (replayId != null && !replayId.toString().equals(SentryId.EMPTY_ID.toString())) {
            SentryEvent sentryEvent;
            void var1_1;
            baggage.setReplayId(var1_1.toString());
            sentryEvent.getContexts().remove("replay_id");
        }
        baggage.freeze();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Baggage(ILogger logger) {
        this(new ConcurrentHashMap<String, String>(), null, null, null, true, false, (ILogger)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Baggage(ConcurrentHashMap<String, String> keyValues, Double sampleRate, Double sampleRand, String thirdPartyHeader, boolean isMutable, boolean shouldFreeze, ILogger logger) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.keyValues = var1_1;
        this.sampleRate = var2_2;
        this.sampleRand = var3_3;
        this.logger = logger;
        this.thirdPartyHeader = thirdPartyHeader;
        this.mutable = isMutable;
        this.shouldFreeze = shouldFreeze;
    }

    public final void freeze() {
        this.mutable = false;
    }

    public final boolean isMutable() {
        return this.mutable;
    }

    public final boolean isShouldFreeze() {
        return this.shouldFreeze;
    }

    /*
     * WARNING - void declaration
     */
    public final String get(String key) {
        void var1_1;
        if (key == null) {
            return null;
        }
        return this.keyValues.get(var1_1);
    }

    public final String getTraceId() {
        return this.get("sentry-trace_id");
    }

    /*
     * WARNING - void declaration
     */
    public final void setTraceId(String traceId) {
        void var1_1;
        this.set("sentry-trace_id", (String)var1_1);
    }

    public final String getPublicKey() {
        return this.get("sentry-public_key");
    }

    /*
     * WARNING - void declaration
     */
    public final void setPublicKey(String publicKey) {
        void var1_1;
        this.set("sentry-public_key", (String)var1_1);
    }

    public final String getEnvironment() {
        return this.get("sentry-environment");
    }

    /*
     * WARNING - void declaration
     */
    public final void setEnvironment(String environment) {
        void var1_1;
        this.set("sentry-environment", (String)var1_1);
    }

    public final String getRelease() {
        return this.get("sentry-release");
    }

    /*
     * WARNING - void declaration
     */
    public final void setRelease(String release) {
        void var1_1;
        this.set("sentry-release", (String)var1_1);
    }

    public final String getUserId() {
        return this.get("sentry-user_id");
    }

    public final String getTransaction() {
        return this.get("sentry-transaction");
    }

    /*
     * WARNING - void declaration
     */
    public final void setTransaction(String transaction) {
        void var1_1;
        this.set("sentry-transaction", (String)var1_1);
    }

    public final Double getSampleRate() {
        return this.sampleRate;
    }

    public final String getSampled() {
        return this.get("sentry-sampled");
    }

    /*
     * WARNING - void declaration
     */
    public final void setSampleRate(Double sampleRate) {
        if (this.isMutable()) {
            void var1_1;
            this.sampleRate = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void forceSetSampleRate(Double sampleRate) {
        void var1_1;
        this.sampleRate = var1_1;
    }

    public final Double getSampleRand() {
        return this.sampleRand;
    }

    /*
     * WARNING - void declaration
     */
    public final void setSampleRand(Double sampleRand) {
        if (this.isMutable()) {
            void var1_1;
            this.sampleRand = var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setSampled(String sampled) {
        void var1_1;
        this.set("sentry-sampled", (String)var1_1);
    }

    public final String getReplayId() {
        return this.get("sentry-replay_id");
    }

    /*
     * WARNING - void declaration
     */
    public final void setReplayId(String replayId) {
        void var1_1;
        this.set("sentry-replay_id", (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final void set(String key, String value) {
        if (this.mutable) {
            void var2_2;
            void var1_1;
            if (value == null) {
                this.keyValues.remove(key);
                return;
            }
            this.keyValues.put((String)var1_1, (String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public final Map<String, Object> getUnknown() {
        void var1_1;
        ConcurrentHashMap<String, String> unknown = new ConcurrentHashMap<String, String>();
        ISentryLifecycleToken ignored = this.keyValuesLock.acquire();
        try {
            for (Map.Entry<String, String> keyValue : this.keyValues.entrySet()) {
                String key = keyValue.getKey();
                String value = keyValue.getValue();
                if (DSCKeys.ALL.contains(key) || value == null) continue;
                String unknownKey = key.replaceFirst("sentry-", "");
                unknown.put(unknownKey, value);
            }
            if (ignored != null) {
                ignored.close();
            }
        }
        catch (Throwable throwable) {
            if (ignored != null) {
                try {
                    void var2_2;
                    var2_2.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
            }
            throw throwable;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final void setValuesFromSamplingDecision(TracesSamplingDecision samplingDecision) {
        if (samplingDecision == null) {
            return;
        }
        this.setSampled(StringUtils.toString(Baggage.sampled(samplingDecision)));
        if (samplingDecision.getSampleRand() != null) {
            this.setSampleRand(Baggage.sampleRand(samplingDecision));
        }
        if (samplingDecision.getSampleRate() != null) {
            void var1_1;
            this.forceSetSampleRate(Baggage.sampleRate((TracesSamplingDecision)var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void setValuesFromScope(IScope scope, SentryOptions options) {
        void var2_2;
        void var3_3;
        PropagationContext propagationContext = scope.getPropagationContext();
        SentryId replayId = scope.getReplayId();
        this.setTraceId(var3_3.getTraceId().toString());
        this.setPublicKey(options.retrieveParsedDsn().getPublicKey());
        this.setRelease(options.getRelease());
        this.setEnvironment(var2_2.getEnvironment());
        if (!SentryId.EMPTY_ID.equals(replayId)) {
            void var1_1;
            this.setReplayId(var1_1.toString());
        }
        this.setTransaction(null);
        this.setSampleRate(null);
        this.setSampled(null);
    }

    private static Double sampleRate(TracesSamplingDecision samplingDecision) {
        TracesSamplingDecision tracesSamplingDecision;
        if (samplingDecision == null) {
            return null;
        }
        return tracesSamplingDecision.getSampleRate();
    }

    private static Double sampleRand(TracesSamplingDecision samplingDecision) {
        TracesSamplingDecision tracesSamplingDecision;
        if (samplingDecision == null) {
            return null;
        }
        return tracesSamplingDecision.getSampleRand();
    }

    private static String sampleRateToString(Double sampleRateAsDouble) {
        Double d;
        if (!SampleRateUtils.isValidTracesSampleRate(sampleRateAsDouble, false)) {
            return null;
        }
        return ((DecimalFormat)decimalFormatter.get()).format(d);
    }

    private static Boolean sampled(TracesSamplingDecision samplingDecision) {
        TracesSamplingDecision tracesSamplingDecision;
        if (samplingDecision == null) {
            return null;
        }
        return tracesSamplingDecision.getSampled();
    }

    /*
     * WARNING - void declaration
     */
    public final TraceContext toTraceContext() {
        String traceIdString = this.getTraceId();
        String replayIdString = this.getReplayId();
        String publicKey = this.getPublicKey();
        if (traceIdString != null && publicKey != null) {
            void var1_1;
            void var2_2;
            void var3_3;
            TraceContext traceContext = new TraceContext(new SentryId(traceIdString), (String)var3_3, this.getRelease(), this.getEnvironment(), this.getUserId(), this.getTransaction(), Baggage.sampleRateToString(this.getSampleRate()), this.getSampled(), replayIdString == null ? null : new SentryId((String)var2_2), Baggage.sampleRateToString(this.getSampleRand()));
            traceContext.setUnknown(this.getUnknown());
            return var1_1;
        }
        return null;
    }

    public static final class DSCKeys {
        public static final List<String> ALL = Arrays.asList("sentry-trace_id", "sentry-public_key", "sentry-release", "sentry-user_id", "sentry-environment", "sentry-transaction", "sentry-sample_rate", "sentry-sample_rand", "sentry-sampled", "sentry-replay_id");
    }

    private static class DecimalFormatterThreadLocal
    extends ThreadLocal<DecimalFormat> {
        private DecimalFormatterThreadLocal() {
        }

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat("#.################", DecimalFormatSymbols.getInstance(Locale.ROOT));
        }
    }
}

