/*
 * Decompiled with CFR 0.152.
 */
package io.github.g00fy2.versioncompare;

import io.github.g00fy2.versioncompare.VersionComparator;
import java.util.ArrayList;
import java.util.List;

public class Version
implements Comparable<Version> {
    private final String originalString;
    private final List<Integer> subversionNumbers = new ArrayList<Integer>();
    private final List<Integer> subversionNumbersWithoutTrailingZeros = new ArrayList<Integer>();
    private String suffix = "";

    /*
     * WARNING - void declaration
     */
    public Version(String versionString) {
        this((String)var1_1, false);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Version(String versionString, boolean throwExceptions) {
        void var1_1;
        void var2_2;
        if (var2_2 != false) {
            if (versionString == null) {
                throw new NullPointerException("Argument versionString is null");
            }
            if (!VersionComparator.startsNumeric(versionString)) {
                throw new IllegalArgumentException("Argument versionString is no valid version");
            }
        }
        this.originalString = var1_1;
        this.initVersion();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isLowerThan(Version otherVersion) {
        void var1_1;
        int subversionsResult = VersionComparator.compareSubversionNumbers(this.subversionNumbersWithoutTrailingZeros, otherVersion.subversionNumbersWithoutTrailingZeros);
        if (subversionsResult != 0) {
            void var2_2;
            return var2_2 < 0;
        }
        return VersionComparator.compareSuffix(this.suffix, var1_1.suffix) < 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isEqual(Version otherVersion) {
        void var1_1;
        return VersionComparator.compareSubversionNumbers(this.subversionNumbersWithoutTrailingZeros, otherVersion.subversionNumbersWithoutTrailingZeros) == 0 && VersionComparator.compareSuffix(this.suffix, var1_1.suffix) == 0;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAtLeast(String otherVersion) {
        void var1_1;
        return this.isAtLeast(new Version((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAtLeast(Version otherVersion) {
        void var1_1;
        return this.isAtLeast((Version)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public boolean isAtLeast(Version otherVersion, boolean ignoreSuffix) {
        void var3_3;
        void var2_2;
        int subversionsResult = VersionComparator.compareSubversionNumbers(this.subversionNumbersWithoutTrailingZeros, otherVersion.subversionNumbersWithoutTrailingZeros);
        if (subversionsResult == 0 && var2_2 == false) {
            void var1_1;
            return VersionComparator.compareSuffix(this.suffix, var1_1.suffix) >= 0;
        }
        return var3_3 >= 0;
    }

    /*
     * WARNING - void declaration
     */
    private void initVersion() {
        if (this.originalString != null && VersionComparator.startsNumeric(this.originalString)) {
            void var1_1;
            String[] versionTokens = this.originalString.replaceAll("\\s", "").split("\\.");
            boolean suffixFound = false;
            StringBuilder suffixSb = null;
            block0: for (void versionToken : var1_1) {
                if (suffixFound) {
                    suffixSb.append(".");
                    suffixSb.append((String)versionToken);
                    continue;
                }
                if (VersionComparator.isNumeric((CharSequence)versionToken)) {
                    this.subversionNumbers.add(VersionComparator.safeParseInt((String)versionToken));
                    continue;
                }
                for (int i = 0; i < versionToken.length(); ++i) {
                    if (Character.isDigit(versionToken.charAt(i))) continue;
                    suffixSb = new StringBuilder();
                    if (i > 0) {
                        this.subversionNumbers.add(VersionComparator.safeParseInt(versionToken.substring(0, i)));
                        suffixSb.append(versionToken.substring(i));
                    } else {
                        suffixSb.append((String)versionToken);
                    }
                    suffixFound = true;
                    continue block0;
                }
            }
            this.subversionNumbersWithoutTrailingZeros.addAll(this.subversionNumbers);
            while (!this.subversionNumbersWithoutTrailingZeros.isEmpty() && this.subversionNumbersWithoutTrailingZeros.lastIndexOf(0) == this.subversionNumbersWithoutTrailingZeros.size() - 1) {
                this.subversionNumbersWithoutTrailingZeros.remove(this.subversionNumbersWithoutTrailingZeros.lastIndexOf(0));
            }
            if (suffixSb != null) {
                void var3_3;
                this.suffix = var3_3.toString();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compareTo(Version version) {
        void var1_1;
        if (this.isEqual(version)) {
            return 0;
        }
        if (this.isLowerThan((Version)var1_1)) {
            return -1;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        if (o instanceof Version && this.isEqual((Version)o)) {
            return true;
        }
        return super.equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final int hashCode() {
        void var3_3;
        void var1_1;
        void var2_2;
        int hash = 31 + this.subversionNumbersWithoutTrailingZeros.hashCode();
        if (this.suffix.isEmpty()) {
            return hash;
        }
        int releaseQualifier = VersionComparator.qualifierToNumber(this.suffix);
        int releaseQualifierVersion = VersionComparator.preReleaseVersion(this.suffix, releaseQualifier);
        hash = hash * 31 + var2_2;
        var1_1 = var1_1 * 31 + var3_3;
        return (int)var1_1;
    }
}

