/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.arch.core.internal.FastSafeIterableMap;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.LifecycleRegistryKt;
import androidx.lifecycle.LifecycleRegistry_desktopKt;
import androidx.lifecycle.Lifecycling;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0017\u0018\u0000 ?2\u00020\u0001:\u0002@?B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\bJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0010\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0017\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0017\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0017\u0010\rJ\u0017\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0013J\u0017\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001a\u0010\bJ\u0017\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u001b\u0010\bJ\u000f\u0010\u001c\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0015J\u0017\u0010\u001f\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u001dH\u0002\u00a2\u0006\u0004\b\u001f\u0010 R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!R\"\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020#0\"8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b$\u0010%R\u0016\u0010\u0016\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u0016\u0010&R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00020'8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010(R\u0016\u0010*\u001a\u00020)8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b*\u0010+R\u0016\u0010,\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b,\u0010!R\u0016\u0010-\u001a\u00020\u00048\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b-\u0010!R&\u00100\u001a\u0012\u0012\u0004\u0012\u00020\t0.j\b\u0012\u0004\u0012\u00020\t`/8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b0\u00101R$\u00105\u001a\u00020\t2\u0006\u0010\u0016\u001a\u00020\t8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b2\u00103\"\u0004\b4\u0010\rR\u001a\u00107\u001a\b\u0012\u0004\u0012\u00020\t068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b7\u00108R\u001a\u0010<\u001a\b\u0012\u0004\u0012\u00020\t098VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0014\u0010=\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010>"}, d2={"Landroidx/lifecycle/LifecycleRegistry;", "Landroidx/lifecycle/Lifecycle;", "Landroidx/lifecycle/LifecycleOwner;", "provider", "", "enforceMainThread", "<init>", "(Landroidx/lifecycle/LifecycleOwner;Z)V", "(Landroidx/lifecycle/LifecycleOwner;)V", "Landroidx/lifecycle/Lifecycle$State;", "next", "", "moveToState", "(Landroidx/lifecycle/Lifecycle$State;)V", "Landroidx/lifecycle/LifecycleObserver;", "observer", "calculateTargetState", "(Landroidx/lifecycle/LifecycleObserver;)Landroidx/lifecycle/Lifecycle$State;", "addObserver", "(Landroidx/lifecycle/LifecycleObserver;)V", "popParentState", "()V", "state", "pushParentState", "removeObserver", "lifecycleOwner", "forwardPass", "backwardPass", "sync", "", "methodName", "enforceMainThreadIfNeeded", "(Ljava/lang/String;)V", "Z", "Landroidx/arch/core/internal/FastSafeIterableMap;", "Landroidx/lifecycle/LifecycleRegistry$ObserverWithState;", "observerMap", "Landroidx/arch/core/internal/FastSafeIterableMap;", "Landroidx/lifecycle/Lifecycle$State;", "Ljava/lang/ref/WeakReference;", "Ljava/lang/ref/WeakReference;", "", "addingObserverCounter", "I", "handlingEvent", "newEventOccurred", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "parentStates", "Ljava/util/ArrayList;", "getCurrentState", "()Landroidx/lifecycle/Lifecycle$State;", "setCurrentState", "currentState", "Lkotlinx/coroutines/flow/MutableStateFlow;", "_currentStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lkotlinx/coroutines/flow/StateFlow;", "getCurrentStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "currentStateFlow", "isSynced", "()Z", "Companion", "ObserverWithState"})
@SourceDebugExtension(value={"SMAP\nLifecycleRegistry.jvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LifecycleRegistry.jvm.kt\nandroidx/lifecycle/LifecycleRegistry\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,346:1\n1#2:347\n*E\n"})
public class LifecycleRegistry
extends Lifecycle {
    public static final Companion Companion = new Companion(null);
    private final boolean enforceMainThread;
    private FastSafeIterableMap<LifecycleObserver, ObserverWithState> observerMap;
    private Lifecycle.State state;
    private final WeakReference<LifecycleOwner> lifecycleOwner;
    private int addingObserverCounter;
    private boolean handlingEvent;
    private boolean newEventOccurred;
    private ArrayList<Lifecycle.State> parentStates;
    private final MutableStateFlow<Lifecycle.State> _currentStateFlow;

    /*
     * WARNING - void declaration
     */
    private LifecycleRegistry(LifecycleOwner provider, boolean enforceMainThread) {
        void var1_1;
        void var2_2;
        this.enforceMainThread = var2_2;
        this.observerMap = new FastSafeIterableMap();
        this.state = Lifecycle.State.INITIALIZED;
        this.parentStates = new ArrayList();
        this.lifecycleOwner = new WeakReference<void>(var1_1);
        this._currentStateFlow = StateFlowKt.MutableStateFlow((Object)Lifecycle.State.INITIALIZED);
    }

    /*
     * WARNING - void declaration
     */
    public LifecycleRegistry(LifecycleOwner provider) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)provider, (String)"provider");
        this((LifecycleOwner)var1_1, true);
    }

    public Lifecycle.State getCurrentState() {
        return this.state;
    }

    /*
     * WARNING - void declaration
     */
    public void setCurrentState(Lifecycle.State state) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.enforceMainThreadIfNeeded("setCurrentState");
        this.moveToState((Lifecycle.State)var1_1);
    }

    public StateFlow<Lifecycle.State> getCurrentStateFlow() {
        return FlowKt.asStateFlow(this._currentStateFlow);
    }

    /*
     * WARNING - void declaration
     */
    private final void moveToState(Lifecycle.State next) {
        void var1_1;
        if (this.state == next) {
            return;
        }
        LifecycleRegistryKt.checkLifecycleStateTransition((LifecycleOwner)this.lifecycleOwner.get(), this.state, next);
        this.state = var1_1;
        if (this.handlingEvent || this.addingObserverCounter != 0) {
            this.newEventOccurred = true;
            return;
        }
        this.handlingEvent = true;
        this.sync();
        this.handlingEvent = false;
        if (this.state == Lifecycle.State.DESTROYED) {
            this.observerMap = new FastSafeIterableMap();
        }
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isSynced() {
        void var2_2;
        void var1_1;
        if (this.observerMap.size() == 0) {
            return true;
        }
        Map.Entry entry = this.observerMap.eldest();
        Intrinsics.checkNotNull((Object)entry);
        Lifecycle.State eldestObserverState = ((ObserverWithState)entry.getValue()).getState();
        Map.Entry entry2 = this.observerMap.newest();
        Intrinsics.checkNotNull((Object)entry2);
        Lifecycle.State newestObserverState = ((ObserverWithState)entry2.getValue()).getState();
        return var1_1 == newestObserverState && this.state == var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private final Lifecycle.State calculateTargetState(LifecycleObserver observer) {
        void var2_2;
        void var1_1;
        observer = this.observerMap.ceil(observer);
        Object object = observer;
        Lifecycle.State siblingState = observer != null && (object = (ObserverWithState)object.getValue()) != null ? ((ObserverWithState)object).getState() : null;
        Lifecycle.State parentState = !((Collection)this.parentStates).isEmpty() ? this.parentStates.get(this.parentStates.size() - 1) : null;
        Companion companion = Companion;
        return companion.min$lifecycle_runtime(companion.min$lifecycle_runtime(this.state, (Lifecycle.State)var1_1), (Lifecycle.State)var2_2);
    }

    public void addObserver(LifecycleObserver observer) {
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.enforceMainThreadIfNeeded("addObserver");
        Lifecycle.State initialState = this.state == Lifecycle.State.DESTROYED ? Lifecycle.State.DESTROYED : Lifecycle.State.INITIALIZED;
        ObserverWithState statefulObserver = new ObserverWithState(observer, initialState);
        ObserverWithState observerWithState = (ObserverWithState)this.observerMap.putIfAbsent((Object)observer, (Object)statefulObserver);
        if (observerWithState != null) {
            return;
        }
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.lifecycleOwner.get();
        if (lifecycleOwner == null) {
            return;
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        boolean isReentrance = this.addingObserverCounter != 0 || this.handlingEvent;
        Lifecycle.State targetState = this.calculateTargetState(observer);
        int n = this.addingObserverCounter;
        this.addingObserverCounter = n + 1;
        while (statefulObserver.getState().compareTo((Enum)targetState) < 0 && this.observerMap.contains((Object)observer)) {
            Lifecycle.Event event;
            this.pushParentState(statefulObserver.getState());
            if (Lifecycle.Event.Companion.upFrom(statefulObserver.getState()) == null) {
                throw new IllegalStateException("no event up from " + statefulObserver.getState());
            }
            statefulObserver.dispatchEvent(lifecycleOwner2, event);
            this.popParentState();
            targetState = this.calculateTargetState(observer);
        }
        if (!isReentrance) {
            this.sync();
        }
        n = this.addingObserverCounter;
        this.addingObserverCounter = n + -1;
    }

    private final void popParentState() {
        this.parentStates.remove(this.parentStates.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    private final void pushParentState(Lifecycle.State state) {
        void var1_1;
        this.parentStates.add((Lifecycle.State)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeObserver(LifecycleObserver observer) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.enforceMainThreadIfNeeded("removeObserver");
        this.observerMap.remove((Object)var1_1);
    }

    private final void forwardPass(LifecycleOwner lifecycleOwner) {
        SafeIterableMap.IteratorWithAdditions iteratorWithAdditions = this.observerMap.iteratorWithAdditions();
        Intrinsics.checkNotNullExpressionValue((Object)iteratorWithAdditions, (String)"iteratorWithAdditions(...)");
        Iterator ascendingIterator = (Iterator)iteratorWithAdditions;
        while (ascendingIterator.hasNext() && !this.newEventOccurred) {
            Map.Entry entry = (Map.Entry)ascendingIterator.next();
            LifecycleObserver key = (LifecycleObserver)entry.getKey();
            ObserverWithState observer = (ObserverWithState)entry.getValue();
            while (observer.getState().compareTo((Enum)this.state) < 0 && !this.newEventOccurred && this.observerMap.contains((Object)key)) {
                Lifecycle.Event event;
                this.pushParentState(observer.getState());
                if (Lifecycle.Event.Companion.upFrom(observer.getState()) == null) {
                    throw new IllegalStateException("no event up from " + observer.getState());
                }
                observer.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    private final void backwardPass(LifecycleOwner lifecycleOwner) {
        Iterator iterator = this.observerMap.descendingIterator();
        Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"descendingIterator(...)");
        Iterator descendingIterator = iterator;
        while (descendingIterator.hasNext() && !this.newEventOccurred) {
            Map.Entry entry = (Map.Entry)descendingIterator.next();
            Intrinsics.checkNotNull((Object)entry);
            LifecycleObserver key = (LifecycleObserver)entry.getKey();
            ObserverWithState observer = (ObserverWithState)entry.getValue();
            while (observer.getState().compareTo((Enum)this.state) > 0 && !this.newEventOccurred && this.observerMap.contains((Object)key)) {
                Lifecycle.Event event;
                if (Lifecycle.Event.Companion.downFrom(observer.getState()) == null) {
                    throw new IllegalStateException("no event down from " + observer.getState());
                }
                this.pushParentState(event.getTargetState());
                observer.dispatchEvent(lifecycleOwner, event);
                this.popParentState();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void sync() {
        LifecycleOwner lifecycleOwner = (LifecycleOwner)this.lifecycleOwner.get();
        if (lifecycleOwner == null) {
            throw new IllegalStateException("LifecycleOwner of this LifecycleRegistry is already garbage collected. It is too late to change lifecycle state.");
        }
        LifecycleOwner lifecycleOwner2 = lifecycleOwner;
        while (!this.isSynced()) {
            void var2_2;
            this.newEventOccurred = false;
            Map.Entry entry = this.observerMap.eldest();
            Intrinsics.checkNotNull((Object)entry);
            if (this.state.compareTo((Enum)((ObserverWithState)entry.getValue()).getState()) < 0) {
                this.backwardPass(lifecycleOwner2);
            }
            Map.Entry newest = this.observerMap.newest();
            if (this.newEventOccurred || newest == null || this.state.compareTo((Enum)((ObserverWithState)var2_2.getValue()).getState()) <= 0) continue;
            this.forwardPass(lifecycleOwner2);
        }
        this.newEventOccurred = false;
        this._currentStateFlow.setValue((Object)this.getCurrentState());
    }

    private final void enforceMainThreadIfNeeded(String methodName) {
        if (this.enforceMainThread && !LifecycleRegistry_desktopKt.isMainThread()) {
            String string;
            string = "Method " + (String)string + " must be called on the main thread";
            throw new IllegalStateException(string.toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    public /* synthetic */ LifecycleRegistry(LifecycleOwner provider, boolean enforceMainThread, DefaultConstructorMarker $constructor_marker) {
        this((LifecycleOwner)var1_1, (boolean)var2_2);
        void var2_2;
        void var1_1;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ!\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\t2\b\u0010\u000b\u001a\u0004\u0018\u00010\tH\u0001\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Landroidx/lifecycle/LifecycleRegistry$Companion;", "", "<init>", "()V", "Landroidx/lifecycle/LifecycleOwner;", "owner", "Landroidx/lifecycle/LifecycleRegistry;", "createUnsafe", "(Landroidx/lifecycle/LifecycleOwner;)Landroidx/lifecycle/LifecycleRegistry;", "Landroidx/lifecycle/Lifecycle$State;", "state1", "state2", "min$lifecycle_runtime", "(Landroidx/lifecycle/Lifecycle$State;Landroidx/lifecycle/Lifecycle$State;)Landroidx/lifecycle/Lifecycle$State;", "min"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final LifecycleRegistry createUnsafe(LifecycleOwner owner) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
            return new LifecycleRegistry((LifecycleOwner)var1_1, false, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        public final Lifecycle.State min$lifecycle_runtime(Lifecycle.State state1, Lifecycle.State state2) {
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)state1, (String)"state1");
            if (state2 != null && state2.compareTo((Enum)state1) < 0) {
                void var2_2;
                return var2_2;
            }
            return var1_1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001f\u0010\r\u001a\u00020\f2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\u001c\u0010\u000f\u001a\u00020\u00048\u0006@\u0006X\u0086\f\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0016\u0010\u0014\u001a\u00020\u00138\u0006@\u0006X\u0086\f\u00a2\u0006\u0006\n\u0004\b\u0014\u0010\u0015"}, d2={"Landroidx/lifecycle/LifecycleRegistry$ObserverWithState;", "", "Landroidx/lifecycle/LifecycleObserver;", "observer", "Landroidx/lifecycle/Lifecycle$State;", "initialState", "<init>", "(Landroidx/lifecycle/LifecycleObserver;Landroidx/lifecycle/Lifecycle$State;)V", "Landroidx/lifecycle/LifecycleOwner;", "owner", "Landroidx/lifecycle/Lifecycle$Event;", "event", "", "dispatchEvent", "(Landroidx/lifecycle/LifecycleOwner;Landroidx/lifecycle/Lifecycle$Event;)V", "state", "Landroidx/lifecycle/Lifecycle$State;", "getState", "()Landroidx/lifecycle/Lifecycle$State;", "Landroidx/lifecycle/LifecycleEventObserver;", "lifecycleObserver", "Landroidx/lifecycle/LifecycleEventObserver;"})
    public static final class ObserverWithState {
        private Lifecycle.State state;
        public LifecycleEventObserver lifecycleObserver;

        /*
         * WARNING - void declaration
         */
        public ObserverWithState(LifecycleObserver observer, Lifecycle.State initialState) {
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)initialState, (String)"initialState");
            void v0 = var1_1;
            Intrinsics.checkNotNull((Object)v0);
            this.lifecycleObserver = Lifecycling.lifecycleEventObserver((Object)v0);
            this.state = var2_2;
        }

        public final Lifecycle.State getState() {
            return this.state;
        }

        /*
         * WARNING - void declaration
         */
        public final void dispatchEvent(LifecycleOwner owner, Lifecycle.Event event) {
            void var3_3;
            void var2_2;
            void var1_1;
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            Lifecycle.State newState = event.getTargetState();
            this.state = Companion.min$lifecycle_runtime(this.state, newState);
            void v0 = var1_1;
            Intrinsics.checkNotNull((Object)v0);
            this.lifecycleObserver.onStateChanged((LifecycleOwner)v0, (Lifecycle.Event)var2_2);
            this.state = var3_3;
        }
    }
}

