/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.ui.subject;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.LocalDate;
import me.him188.ani.app.data.models.subject.ContinueWatchingStatus;
import me.him188.ani.app.data.models.subject.SubjectProgressInfo;
import me.him188.ani.app.tools.WeekFormatter;
import me.him188.ani.app.ui.subject.AiringLabelKt;
import me.him188.ani.datasources.api.PackedDateKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0007\u0018\u00002\u00020\u0001B!\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\tR\u001d\u0010\u000f\u001a\u0004\u0018\u00010\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0012\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\fR\u001b\u0010\u0014\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\f\u001a\u0004\b\u0014\u0010\u0015R\u001d\u0010\u001a\u001a\u0004\u0018\u00010\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\f\u001a\u0004\b\u0018\u0010\u0019R\u001b\u0010\u001f\u001a\u00020\u001b8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\f\u001a\u0004\b\u001d\u0010\u001eR\u001b\u0010\"\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010\f\u001a\u0004\b!\u0010\u0015"}, d2={"Lme/him188/ani/app/ui/subject/SubjectProgressState;", "", "Landroidx/compose/runtime/State;", "Lme/him188/ani/app/data/models/subject/SubjectProgressInfo;", "info", "Lme/him188/ani/app/tools/WeekFormatter;", "weekFormatter", "<init>", "(Landroidx/compose/runtime/State;Lme/him188/ani/app/tools/WeekFormatter;)V", "Lme/him188/ani/app/tools/WeekFormatter;", "Lme/him188/ani/app/data/models/subject/ContinueWatchingStatus;", "continueWatchingStatus$delegate", "Landroidx/compose/runtime/State;", "getContinueWatchingStatus", "()Lme/him188/ani/app/data/models/subject/ContinueWatchingStatus;", "continueWatchingStatus", "", "isLatestEpisodeWatched$delegate", "isLatestEpisodeWatched", "isDone$delegate", "isDone", "()Z", "", "episodeIdToPlay$delegate", "getEpisodeIdToPlay", "()Ljava/lang/Integer;", "episodeIdToPlay", "", "buttonText$delegate", "getButtonText", "()Ljava/lang/String;", "buttonText", "buttonIsPrimary$delegate", "getButtonIsPrimary", "buttonIsPrimary"})
@SourceDebugExtension(value={"SMAP\nSubjectProgressState.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SubjectProgressState.kt\nme/him188/ani/app/ui/subject/SubjectProgressState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,89:1\n85#2:90\n85#2:91\n85#2:92\n85#2:93\n85#2:94\n85#2:95\n*S KotlinDebug\n*F\n+ 1 SubjectProgressState.kt\nme/him188/ani/app/ui/subject/SubjectProgressState\n*L\n29#1:90\n36#1:91\n43#1:92\n47#1:93\n51#1:94\n80#1:95\n*E\n"})
public final class SubjectProgressState {
    private final WeekFormatter weekFormatter;
    private final State continueWatchingStatus$delegate;
    public final State isLatestEpisodeWatched$delegate;
    private final State isDone$delegate;
    private final State episodeIdToPlay$delegate;
    private final State buttonText$delegate;
    private final State buttonIsPrimary$delegate;

    /*
     * WARNING - void declaration
     */
    public SubjectProgressState(State<SubjectProgressInfo> info, WeekFormatter weekFormatter) {
        void var1_1;
        void var2_2;
        Intrinsics.checkNotNullParameter(info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)weekFormatter, (String)"weekFormatter");
        this.weekFormatter = var2_2;
        this.continueWatchingStatus$delegate = SnapshotStateKt.derivedStateOf(() -> SubjectProgressState.continueWatchingStatus_delegate$lambda$0(info));
        this.isLatestEpisodeWatched$delegate = SnapshotStateKt.derivedStateOf(() -> SubjectProgressState.isLatestEpisodeWatched_delegate$lambda$0(this));
        this.isDone$delegate = SnapshotStateKt.derivedStateOf(() -> SubjectProgressState.isDone_delegate$lambda$0(this));
        this.episodeIdToPlay$delegate = SnapshotStateKt.derivedStateOf(() -> SubjectProgressState.episodeIdToPlay_delegate$lambda$0((State)var1_1));
        this.buttonText$delegate = SnapshotStateKt.derivedStateOf(() -> SubjectProgressState.buttonText_delegate$lambda$0(this));
        this.buttonIsPrimary$delegate = SnapshotStateKt.derivedStateOf(() -> SubjectProgressState.buttonIsPrimary_delegate$lambda$0(this));
    }

    public /* synthetic */ SubjectProgressState(State state, WeekFormatter weekFormatter, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            weekFormatter = WeekFormatter.Companion.getSystem();
        }
        this((State<SubjectProgressInfo>)state, weekFormatter);
    }

    private final ContinueWatchingStatus getContinueWatchingStatus() {
        State state = this.continueWatchingStatus$delegate;
        return (ContinueWatchingStatus)state.getValue();
    }

    public final boolean isDone() {
        State state = this.isDone$delegate;
        return (Boolean)state.getValue();
    }

    public final Integer getEpisodeIdToPlay() {
        State state = this.episodeIdToPlay$delegate;
        return (Integer)state.getValue();
    }

    public final String getButtonText() {
        State state = this.buttonText$delegate;
        return (String)state.getValue();
    }

    public final boolean getButtonIsPrimary() {
        State state = this.buttonIsPrimary$delegate;
        return (Boolean)state.getValue();
    }

    private static final ContinueWatchingStatus continueWatchingStatus_delegate$lambda$0(State $info) {
        SubjectProgressInfo subjectProgressInfo = (SubjectProgressInfo)$info.getValue();
        if (subjectProgressInfo != null) {
            return subjectProgressInfo.getContinueWatchingStatus();
        }
        return null;
    }

    private static final boolean isLatestEpisodeWatched_delegate$lambda$0(SubjectProgressState this$0) {
        return this$0.getContinueWatchingStatus() instanceof ContinueWatchingStatus.Watched;
    }

    private static final boolean isDone_delegate$lambda$0(SubjectProgressState this$0) {
        return Intrinsics.areEqual((Object)this$0.getContinueWatchingStatus(), (Object)ContinueWatchingStatus.Done.INSTANCE);
    }

    private static final Integer episodeIdToPlay_delegate$lambda$0(State $info) {
        SubjectProgressInfo subjectProgressInfo = (SubjectProgressInfo)$info.getValue();
        if (subjectProgressInfo != null) {
            return subjectProgressInfo.getNextEpisodeIdToPlay();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String buttonText_delegate$lambda$0(SubjectProgressState this$0) {
        void var1_1;
        ContinueWatchingStatus s = ((SubjectProgressState)this$0).getContinueWatchingStatus();
        if (s instanceof ContinueWatchingStatus.Continue) {
            return "\u7ee7\u7eed\u89c2\u770b " + AiringLabelKt.renderEpAndSort(((ContinueWatchingStatus.Continue)s).getEpisodeEp(), ((ContinueWatchingStatus.Continue)s).getEpisodeSort());
        }
        if (Intrinsics.areEqual((Object)s, (Object)ContinueWatchingStatus.Done.INSTANCE)) {
            return "\u5df2\u770b\u5b8c";
        }
        if (s instanceof ContinueWatchingStatus.NotOnAir) {
            LocalDate date = PackedDateKt.toLocalDateOrNull-OMxPjI8((int)((ContinueWatchingStatus.NotOnAir)s).getAirDate-pedHg2M());
            if (date != null) {
                this$0 = WeekFormatter.format$default((WeekFormatter)((SubjectProgressState)this$0).weekFormatter, (LocalDate)date, null, (int)2, null);
                return (String)this$0 + "\u5f00\u64ad";
            }
            return "\u8fd8\u672a\u5f00\u64ad";
        }
        if (Intrinsics.areEqual((Object)s, (Object)ContinueWatchingStatus.Start.INSTANCE)) {
            return "\u5f00\u59cb\u89c2\u770b";
        }
        if (s instanceof ContinueWatchingStatus.Watched) {
            LocalDate date = PackedDateKt.toLocalDateOrNull-OMxPjI8((int)((ContinueWatchingStatus.Watched)s).getNextEpisodeAirDate-pedHg2M());
            if (date != null) {
                void var2_3;
                String string;
                string = WeekFormatter.format$default((WeekFormatter)((SubjectProgressState)((Object)string)).weekFormatter, (LocalDate)var2_3, null, (int)2, null);
                return (String)string + "\u66f4\u65b0";
            }
            return "\u770b\u8fc7 " + AiringLabelKt.renderEpAndSort(((ContinueWatchingStatus.Watched)s).getEpisodeEp(), ((ContinueWatchingStatus.Watched)s).getEpisodeSort());
        }
        if (var1_1 == null) {
            return "\u672a\u77e5";
        }
        throw new NoWhenBranchMatchedException();
    }

    private static final boolean buttonIsPrimary_delegate$lambda$0(SubjectProgressState this$0) {
        SubjectProgressState subjectProgressState = this$0.getContinueWatchingStatus();
        return subjectProgressState instanceof ContinueWatchingStatus.Start || subjectProgressState instanceof ContinueWatchingStatus.Continue;
    }
}

