/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.ui.subject;

import androidx.compose.runtime.SnapshotStateKt;
import androidx.compose.runtime.State;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.him188.ani.app.data.models.subject.ContinueWatchingStatus;
import me.him188.ani.app.data.models.subject.SubjectAiringInfo;
import me.him188.ani.app.data.models.subject.SubjectAiringInfoKt;
import me.him188.ani.app.data.models.subject.SubjectAiringKind;
import me.him188.ani.app.data.models.subject.SubjectProgressInfo;
import me.him188.ani.app.ui.subject.AiringLabelKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u000b\b\u0007\u0018\u00002\u00020\u0001B'\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0002\u0012\u000e\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0002\u00a2\u0006\u0004\b\u0007\u0010\bR\u001d\u0010\r\u001a\u0004\u0018\u00010\u00038BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u000b\u0010\fR\u001d\u0010\u0011\u001a\u0004\u0018\u00010\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\n\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0014\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\nR\u001d\u0010\u0019\u001a\u0004\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\n\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u001d\u001a\u00020\u00128FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\n\u001a\u0004\b\u001b\u0010\u001cR\u001d\u0010 \u001a\u0004\u0018\u00010\u00158FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001e\u0010\n\u001a\u0004\b\u001f\u0010\u0018"}, d2={"Lme/him188/ani/app/ui/subject/AiringLabelState;", "", "Landroidx/compose/runtime/State;", "Lme/him188/ani/app/data/models/subject/SubjectAiringInfo;", "airingInfoState", "Lme/him188/ani/app/data/models/subject/SubjectProgressInfo;", "progressInfoState", "<init>", "(Landroidx/compose/runtime/State;Landroidx/compose/runtime/State;)V", "airingInfo$delegate", "Landroidx/compose/runtime/State;", "getAiringInfo", "()Lme/him188/ani/app/data/models/subject/SubjectAiringInfo;", "airingInfo", "progressInfo$delegate", "getProgressInfo", "()Lme/him188/ani/app/data/models/subject/SubjectProgressInfo;", "progressInfo", "", "isLoading$delegate", "isLoading", "", "progressText$delegate", "getProgressText", "()Ljava/lang/String;", "progressText", "highlightProgress$delegate", "getHighlightProgress", "()Z", "highlightProgress", "totalEpisodesText$delegate", "getTotalEpisodesText", "totalEpisodesText"})
@SourceDebugExtension(value={"SMAP\nAiringLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AiringLabel.kt\nme/him188/ani/app/ui/subject/AiringLabelState\n+ 2 SnapshotState.kt\nandroidx/compose/runtime/SnapshotStateKt__SnapshotStateKt\n*L\n1#1,187:1\n85#2:188\n85#2:189\n85#2:190\n85#2:191\n85#2:192\n85#2:193\n*S KotlinDebug\n*F\n+ 1 AiringLabel.kt\nme/him188/ani/app/ui/subject/AiringLabelState\n*L\n45#1:188\n46#1:189\n48#1:190\n55#1:191\n106#1:192\n125#1:193\n*E\n"})
public final class AiringLabelState {
    private final State airingInfo$delegate;
    private final State progressInfo$delegate;
    public final State isLoading$delegate;
    private final State progressText$delegate;
    private final State highlightProgress$delegate;
    private final State totalEpisodesText$delegate;

    /*
     * WARNING - void declaration
     */
    public AiringLabelState(State<SubjectAiringInfo> airingInfoState, State<SubjectProgressInfo> progressInfoState) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter(airingInfoState, (String)"airingInfoState");
        Intrinsics.checkNotNullParameter(progressInfoState, (String)"progressInfoState");
        this.airingInfo$delegate = var1_1;
        this.progressInfo$delegate = var2_2;
        this.isLoading$delegate = SnapshotStateKt.derivedStateOf(() -> AiringLabelState.isLoading_delegate$lambda$0(this));
        this.progressText$delegate = SnapshotStateKt.derivedStateOf(() -> AiringLabelState.progressText_delegate$lambda$0(this));
        this.highlightProgress$delegate = SnapshotStateKt.derivedStateOf(() -> AiringLabelState.highlightProgress_delegate$lambda$0(this));
        this.totalEpisodesText$delegate = SnapshotStateKt.derivedStateOf(() -> AiringLabelState.totalEpisodesText_delegate$lambda$0(this));
    }

    private final SubjectAiringInfo getAiringInfo() {
        State state = this.airingInfo$delegate;
        return (SubjectAiringInfo)state.getValue();
    }

    private final SubjectProgressInfo getProgressInfo() {
        State state = this.progressInfo$delegate;
        return (SubjectProgressInfo)state.getValue();
    }

    public final String getProgressText() {
        State state = this.progressText$delegate;
        return (String)state.getValue();
    }

    public final boolean getHighlightProgress() {
        State state = this.highlightProgress$delegate;
        return (Boolean)state.getValue();
    }

    public final String getTotalEpisodesText() {
        State state = this.totalEpisodesText$delegate;
        return (String)state.getValue();
    }

    private static final boolean isLoading_delegate$lambda$0(AiringLabelState this$0) {
        AiringLabelState airingLabelState;
        return this$0.getAiringInfo() == null || airingLabelState.getProgressInfo() == null;
    }

    /*
     * WARNING - void declaration
     */
    private static final String progressText_delegate$lambda$0(AiringLabelState this$0) {
        SubjectAiringInfo airingInfo = this$0.getAiringInfo();
        AiringLabelState progressInfo = this$0.getProgressInfo();
        if (airingInfo == null || progressInfo == null) {
            return null;
        }
        switch (WhenMappings.$EnumSwitchMapping$0[airingInfo.getKind().ordinal()]) {
            case 1: {
                return "\u672a\u5f00\u64ad";
            }
            case 2: {
                AiringLabelState s = progressInfo.getContinueWatchingStatus();
                if (Intrinsics.areEqual((Object)s, (Object)ContinueWatchingStatus.Done.INSTANCE)) {
                    return "\u5df2\u770b\u5b8c";
                }
                if (s instanceof ContinueWatchingStatus.Watched) {
                    return "\u770b\u8fc7 " + AiringLabelKt.renderEpAndSort(((ContinueWatchingStatus.Watched)s).getEpisodeEp(), ((ContinueWatchingStatus.Watched)s).getEpisodeSort());
                }
                if (s instanceof ContinueWatchingStatus.Continue || s instanceof ContinueWatchingStatus.NotOnAir || s instanceof ContinueWatchingStatus.Start) {
                    void var1_1;
                    if (airingInfo.getLatestSort() == null) {
                        return "\u8fde\u8f7d\u4e2d";
                    }
                    return "\u8fde\u8f7d\u81f3 " + AiringLabelKt.renderEpAndSort(airingInfo.getLatestEp(), var1_1.getLatestSort());
                }
                throw new NoWhenBranchMatchedException();
            }
            case 3: {
                AiringLabelState airingLabelState;
                AiringLabelState s;
                s = s.getContinueWatchingStatus();
                if (Intrinsics.areEqual((Object)s, (Object)ContinueWatchingStatus.Done.INSTANCE)) {
                    return "\u5df2\u770b\u5b8c";
                }
                if (s instanceof ContinueWatchingStatus.Watched) {
                    return "\u770b\u8fc7 " + AiringLabelKt.renderEpAndSort(((ContinueWatchingStatus.Watched)s).getEpisodeEp(), ((ContinueWatchingStatus.Watched)s).getEpisodeSort());
                }
                if (s instanceof ContinueWatchingStatus.Continue) {
                    return "\u770b\u8fc7 " + AiringLabelKt.renderEpAndSort(((ContinueWatchingStatus.Continue)s).getWatchedEpisodeEp(), ((ContinueWatchingStatus.Continue)s).getWatchedEpisodeSort());
                }
                if (s instanceof ContinueWatchingStatus.NotOnAir || Intrinsics.areEqual((Object)airingLabelState, (Object)ContinueWatchingStatus.Start.INSTANCE)) {
                    return "\u5df2\u5b8c\u7ed3";
                }
                throw new NoWhenBranchMatchedException();
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    /*
     * WARNING - void declaration
     */
    private static final boolean highlightProgress_delegate$lambda$0(AiringLabelState this$0) {
        AiringLabelState airingLabelState;
        SubjectProgressInfo subjectProgressInfo = this$0.getProgressInfo();
        ContinueWatchingStatus continueWatchingStatus = subjectProgressInfo != null ? subjectProgressInfo.getContinueWatchingStatus() : null;
        SubjectAiringInfo subjectAiringInfo = airingLabelState.getAiringInfo();
        boolean bl = subjectAiringInfo != null ? SubjectAiringInfoKt.isOnAir((SubjectAiringInfo)subjectAiringInfo) : false;
        if (bl) {
            boolean bl2;
            void var1_1;
            airingLabelState = var1_1;
            if (airingLabelState instanceof ContinueWatchingStatus.Continue) {
                bl2 = true;
            } else if (Intrinsics.areEqual((Object)airingLabelState, (Object)ContinueWatchingStatus.Start.INSTANCE) || Intrinsics.areEqual((Object)airingLabelState, (Object)ContinueWatchingStatus.Done.INSTANCE) || airingLabelState instanceof ContinueWatchingStatus.NotOnAir || airingLabelState instanceof ContinueWatchingStatus.Watched || airingLabelState == null) {
                bl2 = false;
            } else {
                throw new NoWhenBranchMatchedException();
            }
            if (bl2) {
                return true;
            }
        }
        return false;
    }

    private static final String totalEpisodesText_delegate$lambda$0(AiringLabelState this$0) {
        SubjectAiringInfo subjectAiringInfo = this$0.getAiringInfo();
        if (subjectAiringInfo == null) {
            return null;
        }
        AiringLabelState airingLabelState = subjectAiringInfo;
        return SubjectAiringInfoKt.computeTotalEpisodeText((SubjectAiringInfo)subjectAiringInfo);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SubjectAiringKind.values().length];
            try {
                nArray[SubjectAiringKind.UPCOMING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SubjectAiringKind.ON_AIR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            try {
                nArray[SubjectAiringKind.COMPLETED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {}
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

