/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.app.ui.foundation;

import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.ImageBitmap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import me.him188.ani.app.ui.foundation.Cluster;
import me.him188.ani.app.ui.foundation.RGBColor;
import me.him188.ani.app.ui.foundation.WeightedRGBPoint;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0011\u0010\u0002\u001a\u00020\u0001*\u00020\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003\u001a3\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0007H\u0002\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Landroidx/compose/ui/graphics/ImageBitmap;", "Landroidx/compose/ui/graphics/Color;", "themeColor", "(Landroidx/compose/ui/graphics/ImageBitmap;)J", "", "Lme/him188/ani/app/ui/foundation/WeightedRGBPoint;", "points", "", "k", "maxIterations", "Lme/him188/ani/app/ui/foundation/Cluster;", "kMeansPlusPlus", "(Ljava/util/List;II)Ljava/util/List;"})
@SourceDebugExtension(value={"SMAP\nImageUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ImageUtils.kt\nme/him188/ani/app/ui/foundation/ImageUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,179:1\n1999#2,5:180\n2005#2,8:186\n1563#2:194\n1634#2,3:195\n360#2,7:198\n1563#2:205\n1634#2,3:206\n1869#2,2:209\n2423#2,14:211\n1#3:185\n*S KotlinDebug\n*F\n+ 1 ImageUtils.kt\nme/him188/ani/app/ui/foundation/ImageUtilsKt\n*L\n76#1:180,5\n76#1:186,8\n123#1:194\n123#1:195,3\n133#1:198,7\n137#1:205\n137#1:206,3\n144#1:209,2\n148#1:211,14\n*E\n"})
public final class ImageUtilsKt {
    /*
     * WARNING - void declaration
     */
    public static final long themeColor(ImageBitmap $this$themeColor) {
        Object v2;
        Intrinsics.checkNotNullParameter((Object)$this$themeColor, (String)"<this>");
        int width2 = $this$themeColor.getWidth();
        int height = $this$themeColor.getHeight();
        int[] pixels = new int[width2 * height];
        $this$themeColor.readPixels(pixels, 0, 0, width2, height, 0, width2);
        Object points = new ArrayList();
        double centerX = (double)width2 / 2.0;
        double centerY = (double)height / 2.0;
        double d = centerX;
        double d2 = centerY;
        double maxDistance = Math.sqrt(d * d + d2 * d2);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width2; ++x) {
                int pixel = pixels[y * width2 + x];
                if (pixel >>> 24 <= 128) continue;
                double distanceFromCenter = Math.sqrt(((double)x - centerX) * ((double)x - centerX) + ((double)y - centerY) * ((double)y - centerY));
                double weight = 1.0 - distanceFromCenter / maxDistance * 0.5;
                int r = pixel >> 16 & 0xFF;
                int g = pixel >> 8 & 0xFF;
                int b = pixel & 0xFF;
                points.add(new WeightedRGBPoint(new RGBColor(r, g, b), weight));
            }
        }
        if (points.isEmpty()) {
            return Color.Companion.getBlack-0d7_KjU();
        }
        List<Cluster> list = ImageUtilsKt.kMeansPlusPlus((List<WeightedRGBPoint>)points, 5, 15);
        Iterable iterable = list;
        Iterator iterator$iv = iterable.iterator();
        if (!iterator$iv.hasNext()) {
            v2 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v2 = maxElem$iv;
            } else {
                Cluster cluster = (Cluster)maxElem$iv;
                Iterable iterable2 = cluster.getPoints();
                double d3 = 0.0;
                for (Object width2 : iterable2) {
                    void var1_2;
                    width2 = (WeightedRGBPoint)width2;
                    double d4 = d3;
                    double d5 = var1_2.getWeight();
                    d3 = d4 + d5;
                }
                double maxValue$iv = d3 * (double)cluster.getPoints().size();
                do {
                    Object e$iv = iterator$iv.next();
                    Cluster cluster2 = (Cluster)e$iv;
                    points = cluster2.getPoints();
                    double d6 = 0.0;
                    Iterator iterator = points.iterator();
                    while (iterator.hasNext()) {
                        Object object;
                        points = iterator.next();
                        points = (WeightedRGBPoint)points;
                        double d7 = d6;
                        double d8 = ((WeightedRGBPoint)object).getWeight();
                        d6 = d7 + d8;
                    }
                    double v$iv = d6 * (double)cluster2.getPoints().size();
                    if (Double.compare(maxValue$iv, v$iv) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v2 = maxElem$iv;
            }
        }
        Cluster cluster = v2;
        if (cluster == null) {
            return Color.Companion.getBlack-0d7_KjU();
        }
        Cluster cluster3 = cluster;
        RGBColor rGBColor = cluster.getCentroid();
        int r = rGBColor.component1();
        int g = rGBColor.component2();
        int b = rGBColor.component3();
        return ColorKt.Color$default((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)0.0f, null, (int)24, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Cluster> kMeansPlusPlus(List<WeightedRGBPoint> points, int k, int maxIterations) {
        void var1_2;
        boolean changed;
        void $this$mapTo$iv$iv;
        void var3_4;
        List<WeightedRGBPoint> list;
        Object item$iv$iv2;
        List centroids = new ArrayList();
        Random.Default random = Random.Default;
        centroids.add(((WeightedRGBPoint)CollectionsKt.random((Collection)points, (Random)((Random)Random.Default))).getRgb());
        while (centroids.size() < k) {
            int n;
            block20: {
                void $this$indexOfFirst$iv;
                Object point;
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv;
                double totalDistance = 0.0;
                Iterable iterable = $this$map$iv = (Iterable)points;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    double minDistance;
                    WeightedRGBPoint weightedRGBPoint = (WeightedRGBPoint)item$iv$iv2;
                    list = destination$iv$iv;
                    Iterator iterator = ((Iterable)centroids).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    RGBColor centroid = (RGBColor)iterator.next();
                    double d = ((WeightedRGBPoint)point).getRgb().distanceTo(centroid);
                    while (iterator.hasNext()) {
                        RGBColor centroid2 = (RGBColor)iterator.next();
                        double d2 = ((WeightedRGBPoint)point).getRgb().distanceTo(centroid2);
                        d = Math.min(d, d2);
                    }
                    double d3 = minDistance = d;
                    list.add((WeightedRGBPoint)((Object)Double.valueOf(totalDistance += d3 * d3 * ((WeightedRGBPoint)point).getWeight())));
                }
                List distances = (List)destination$iv$iv;
                double threshold = random.nextDouble() * totalDistance;
                destination$iv$iv = distances;
                list = points;
                int index$iv = 0;
                item$iv$iv2 = $this$indexOfFirst$iv.iterator();
                while (item$iv$iv2.hasNext()) {
                    double d;
                    point = item$iv$iv2.next();
                    double d4 = ((Number)point).doubleValue();
                    if (d >= threshold) {
                        n = index$iv;
                        break block20;
                    }
                    ++index$iv;
                }
                n = -1;
            }
            int n2 = n;
            RGBColor nextCentroid = list.get(n2).getRgb();
            centroids.add(nextCentroid);
        }
        Iterable $this$map$iv = (Iterable)var3_4;
        Iterator iterator = $this$map$iv;
        List<WeightedRGBPoint> destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        for (Object item$iv$iv222 : $this$mapTo$iv$iv) {
            void it;
            item$iv$iv2 = (RGBColor)item$iv$iv222;
            list = destination$iv$iv;
            list.add((WeightedRGBPoint)((Object)new Cluster((RGBColor)it, null, 2, null)));
        }
        List clusters = destination$iv$iv;
        int iteration = 0;
        do {
            Object e$iv;
            Object item$iv$iv222;
            iterator = clusters;
            Iterator $this$indexOfFirst$iv = iterator.iterator();
            while ($this$indexOfFirst$iv.hasNext()) {
                Iterator iterator2 = $this$indexOfFirst$iv.next();
                item$iv$iv222 = (Cluster)((Object)iterator2);
                ((Cluster)item$iv$iv222).getPoints().clear();
            }
            for (WeightedRGBPoint point : points) {
                Object v3;
                item$iv$iv222 = clusters;
                Iterator iterator$iv = item$iv$iv222.iterator();
                if (!iterator$iv.hasNext()) {
                    v3 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v3 = minElem$iv;
                    } else {
                        Cluster it = (Cluster)minElem$iv;
                        double minValue$iv = point.getRgb().distanceTo(it.getCentroid());
                        do {
                            e$iv = iterator$iv.next();
                            Cluster it2 = (Cluster)e$iv;
                            double v$iv = point.getRgb().distanceTo(it2.getCentroid());
                            if (Double.compare(minValue$iv, v$iv) <= 0) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v3 = minElem$iv;
                    }
                }
                if ((Cluster)v3 == null) continue;
                ((Cluster)((Object)$this$indexOfFirst$iv)).getPoints().add(point);
            }
            changed = false;
            for (Cluster cluster : clusters) {
                RGBColor rGBColor;
                double d;
                double d5;
                double d6;
                Object object2;
                if (cluster.getPoints().isEmpty()) continue;
                Iterable item$iv$iv222 = cluster.getPoints();
                double d7 = 0.0;
                for (Object object2 : item$iv$iv222) {
                    void it;
                    e$iv = (WeightedRGBPoint)object2;
                    double d8 = d7;
                    d6 = it.getWeight();
                    d7 = d8 + d6;
                }
                double totalWeight = d7;
                Iterable iterable = cluster.getPoints();
                double d9 = 0.0;
                for (Object e : iterable) {
                    void it;
                    WeightedRGBPoint v$iv = (WeightedRGBPoint)e;
                    d6 = d9;
                    d5 = (double)it.getRgb().getR() * it.getWeight();
                    d9 = d6 + d5;
                }
                iterable = cluster.getPoints();
                int n = (int)(d9 / totalWeight);
                d9 = 0.0;
                for (Object e : iterable) {
                    WeightedRGBPoint it = (WeightedRGBPoint)e;
                    d = d9;
                    double d10 = (double)it.getRgb().getG() * it.getWeight();
                    d9 = d + d10;
                }
                d = d9;
                iterable = cluster.getPoints();
                int n3 = (int)(d / totalWeight);
                d9 = 0.0;
                object2 = iterable.iterator();
                while (object2.hasNext()) {
                    Object e;
                    e = object2.next();
                    WeightedRGBPoint it = (WeightedRGBPoint)e;
                    d5 = d9;
                    double d11 = (double)it.getRgb().getB() * it.getWeight();
                    d9 = d5 + d11;
                }
                d5 = d9;
                int n4 = (int)(d5 / totalWeight);
                int n5 = n3;
                int item$iv$iv222 = n;
                RGBColor newCentroid = new RGBColor(item$iv$iv222, n5, n4);
                if (!(rGBColor.distanceTo(cluster.getCentroid()) > 0.1)) continue;
                changed = true;
                cluster.setCentroid(newCentroid);
            }
        } while (changed && ++iteration < maxIterations);
        return var1_2;
    }
}

