/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;

public abstract class W32Errors
implements WinError {
    public static final boolean SUCCEEDED(int hr) {
        return hr >= 0;
    }

    public static final boolean FAILED(int hr) {
        return hr < 0;
    }

    public static final boolean SUCCEEDED(WinNT.HRESULT hr) {
        WinNT.HRESULT hRESULT;
        return hr == null || W32Errors.SUCCEEDED(hRESULT.intValue());
    }

    public static final boolean FAILED(WinNT.HRESULT hr) {
        WinNT.HRESULT hRESULT;
        return hr != null && W32Errors.FAILED(hRESULT.intValue());
    }

    public static final int HRESULT_CODE(int hr) {
        return hr & 0xFFFF;
    }

    public static final int SCODE_CODE(int sc) {
        return sc & 0xFFFF;
    }

    public static final int HRESULT_FACILITY(int hr) {
        return hr >> 16 & 0x1FFF;
    }

    public static final int SCODE_FACILITY(short sc) {
        return (short)(sc >> 16) & 0x1FFF;
    }

    public static short HRESULT_SEVERITY(int hr) {
        return (short)(hr >> 31 & 1);
    }

    public static short SCODE_SEVERITY(short sc) {
        return (short)((short)(sc >> 31) & 1);
    }

    /*
     * WARNING - void declaration
     */
    public static int MAKE_HRESULT(short sev, short fac, short code) {
        void var2_2;
        void var1_1;
        return sev << 31 | var1_1 << 16 | var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static final int MAKE_SCODE(short sev, short fac, short code) {
        void var2_2;
        void var1_1;
        return sev << 31 | var1_1 << 16 | var2_2;
    }

    public static final WinNT.HRESULT HRESULT_FROM_WIN32(int x) {
        int n;
        return new WinNT.HRESULT(x <= 0 ? x : n & 0xFFFF | 0x70000 | Integer.MIN_VALUE);
    }

    public static final int FILTER_HRESULT_FROM_FLT_NTSTATUS(int x) {
        return x & 0x8000FFFF | 0x1F0000;
    }
}

