/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Native;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import java.util.ArrayList;

public abstract class Secur32Util {
    /*
     * WARNING - void declaration
     */
    public static String getUserNameEx(int format) {
        void var1_1;
        void var3_4;
        char[] buffer2 = new char[128];
        IntByReference len = new IntByReference(buffer2.length);
        boolean result = Secur32.INSTANCE.GetUserNameEx(format, buffer2, len);
        if (!result) {
            void var2_3;
            int n;
            int buffer2 = Kernel32.INSTANCE.GetLastError();
            switch (buffer2) {
                case 234: {
                    buffer2 = new char[len.getValue() + 1];
                    break;
                }
                default: {
                    throw new Win32Exception(Native.getLastError());
                }
            }
            result = Secur32.INSTANCE.GetUserNameEx(n, buffer2, (IntByReference)var2_3);
        }
        if (var3_4 == false) {
            throw new Win32Exception(Native.getLastError());
        }
        return Native.toString((char[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static SecurityPackage[] getSecurityPackages() {
        void var0;
        void var1_1;
        void var2_3;
        IntByReference pcPackages = new IntByReference();
        Sspi.PSecPkgInfo pPackageInfo = new Sspi.PSecPkgInfo();
        int rc = Secur32.INSTANCE.EnumerateSecurityPackages(pcPackages, pPackageInfo);
        if (rc != 0) {
            throw new Win32Exception(rc);
        }
        Sspi.SecPkgInfo.ByReference[] packagesInfo = pPackageInfo.toArray(pcPackages.getValue());
        ArrayList<SecurityPackage> packages = new ArrayList<SecurityPackage>(pcPackages.getValue());
        for (void packageInfo : var2_3) {
            SecurityPackage securityPackage = new SecurityPackage();
            new SecurityPackage().name = packageInfo.Name.toString();
            securityPackage.comment = packageInfo.Comment.toString();
            packages.add(securityPackage);
        }
        int n = Secur32.INSTANCE.FreeContextBuffer(var1_1.pPkgInfo.getPointer());
        if (n != 0) {
            throw new Win32Exception(n);
        }
        return var0.toArray(new SecurityPackage[0]);
    }

    public static class SecurityPackage {
        public String name;
        public String comment;
    }
}

