/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32;

import com.sun.jna.Memory;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.BaseTSD;
import com.sun.jna.platform.win32.Ddeml;
import com.sun.jna.platform.win32.User32Util;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.win32.W32APIOptions;
import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DdemlUtil {

    public static interface IDdeConnectionList
    extends Closeable {
        public Ddeml.HCONVLIST getHandle();

        public IDdeConnection queryNextServer(IDdeConnection var1);

        @Override
        public void close();
    }

    public static interface IDdeClient
    extends Closeable {
        public Integer getInstanceIdentitifier();

        public void initialize(int var1) throws DdemlException;

        public Ddeml.HSZ createStringHandle(String var1) throws DdemlException;

        public String queryString(Ddeml.HSZ var1) throws DdemlException;

        public boolean freeStringHandle(Ddeml.HSZ var1);

        public boolean keepStringHandle(Ddeml.HSZ var1);

        public void nameService(Ddeml.HSZ var1, int var2) throws DdemlException;

        public void nameService(String var1, int var2) throws DdemlException;

        public int getLastError();

        public IDdeConnection connect(Ddeml.HSZ var1, Ddeml.HSZ var2, Ddeml.CONVCONTEXT var3);

        public IDdeConnection connect(String var1, String var2, Ddeml.CONVCONTEXT var3);

        public Ddeml.HDDEDATA createDataHandle(Pointer var1, int var2, int var3, Ddeml.HSZ var4, int var5, int var6);

        public void freeDataHandle(Ddeml.HDDEDATA var1);

        public Ddeml.HDDEDATA addData(Ddeml.HDDEDATA var1, Pointer var2, int var3, int var4);

        public int getData(Ddeml.HDDEDATA var1, Pointer var2, int var3, int var4);

        public Pointer accessData(Ddeml.HDDEDATA var1, WinDef.DWORDByReference var2);

        public void unaccessData(Ddeml.HDDEDATA var1);

        public void postAdvise(Ddeml.HSZ var1, Ddeml.HSZ var2);

        public void postAdvise(String var1, String var2);

        public void abandonTransactions();

        public IDdeConnectionList connectList(Ddeml.HSZ var1, Ddeml.HSZ var2, IDdeConnectionList var3, Ddeml.CONVCONTEXT var4);

        public IDdeConnectionList connectList(String var1, String var2, IDdeConnectionList var3, Ddeml.CONVCONTEXT var4);

        public boolean enableCallback(int var1);

        public boolean uninitialize();

        public IDdeConnection wrap(Ddeml.HCONV var1);

        public void registerAdvstartHandler(AdvstartHandler var1);

        public void unregisterAdvstartHandler(AdvstartHandler var1);

        public void registerAdvstopHandler(AdvstopHandler var1);

        public void unregisterAdvstopHandler(AdvstopHandler var1);

        public void registerConnectHandler(ConnectHandler var1);

        public void unregisterConnectHandler(ConnectHandler var1);

        public void registerAdvReqHandler(AdvreqHandler var1);

        public void unregisterAdvReqHandler(AdvreqHandler var1);

        public void registerRequestHandler(RequestHandler var1);

        public void unregisterRequestHandler(RequestHandler var1);

        public void registerWildconnectHandler(WildconnectHandler var1);

        public void unregisterWildconnectHandler(WildconnectHandler var1);

        public void registerAdvdataHandler(AdvdataHandler var1);

        public void unregisterAdvdataHandler(AdvdataHandler var1);

        public void registerExecuteHandler(ExecuteHandler var1);

        public void unregisterExecuteHandler(ExecuteHandler var1);

        public void registerPokeHandler(PokeHandler var1);

        public void unregisterPokeHandler(PokeHandler var1);

        public void registerConnectConfirmHandler(ConnectConfirmHandler var1);

        public void unregisterConnectConfirmHandler(ConnectConfirmHandler var1);

        public void registerDisconnectHandler(DisconnectHandler var1);

        public void unregisterDisconnectHandler(DisconnectHandler var1);

        public void registerErrorHandler(ErrorHandler var1);

        public void unregisterErrorHandler(ErrorHandler var1);

        public void registerRegisterHandler(RegisterHandler var1);

        public void unregisterRegisterHandler(RegisterHandler var1);

        public void registerXactCompleteHandler(XactCompleteHandler var1);

        public void unregisterXactCompleteHandler(XactCompleteHandler var1);

        public void registerUnregisterHandler(UnregisterHandler var1);

        public void unregisterUnregisterHandler(UnregisterHandler var1);

        public void registerMonitorHandler(MonitorHandler var1);

        public void unregisterMonitorHandler(MonitorHandler var1);
    }

    public static interface IDdeConnection
    extends Closeable {
        public Ddeml.HCONV getConv();

        public void execute(String var1, int var2, WinDef.DWORDByReference var3, BaseTSD.DWORD_PTR var4);

        public void poke(Pointer var1, int var2, Ddeml.HSZ var3, int var4, int var5, WinDef.DWORDByReference var6, BaseTSD.DWORD_PTR var7);

        public void poke(Pointer var1, int var2, String var3, int var4, int var5, WinDef.DWORDByReference var6, BaseTSD.DWORD_PTR var7);

        public Ddeml.HDDEDATA request(Ddeml.HSZ var1, int var2, int var3, WinDef.DWORDByReference var4, BaseTSD.DWORD_PTR var5);

        public Ddeml.HDDEDATA request(String var1, int var2, int var3, WinDef.DWORDByReference var4, BaseTSD.DWORD_PTR var5);

        public Ddeml.HDDEDATA clientTransaction(Pointer var1, int var2, Ddeml.HSZ var3, int var4, int var5, int var6, WinDef.DWORDByReference var7, BaseTSD.DWORD_PTR var8);

        public Ddeml.HDDEDATA clientTransaction(Pointer var1, int var2, String var3, int var4, int var5, int var6, WinDef.DWORDByReference var7, BaseTSD.DWORD_PTR var8);

        public void advstart(Ddeml.HSZ var1, int var2, int var3, WinDef.DWORDByReference var4, BaseTSD.DWORD_PTR var5);

        public void advstart(String var1, int var2, int var3, WinDef.DWORDByReference var4, BaseTSD.DWORD_PTR var5);

        public void advstop(Ddeml.HSZ var1, int var2, int var3, WinDef.DWORDByReference var4, BaseTSD.DWORD_PTR var5);

        public void advstop(String var1, int var2, int var3, WinDef.DWORDByReference var4, BaseTSD.DWORD_PTR var5);

        public void abandonTransaction(int var1);

        public void abandonTransactions();

        public void impersonateClient();

        @Override
        public void close();

        public void reconnect();

        public boolean enableCallback(int var1);

        public void setUserHandle(int var1, BaseTSD.DWORD_PTR var2) throws DdemlException;

        public Ddeml.CONVINFO queryConvInfo(int var1) throws DdemlException;
    }

    public static class DdemlException
    extends RuntimeException {
        private static final Map<Integer, String> ERROR_CODE_MAP;
        private final int errorCode;

        /*
         * WARNING - void declaration
         */
        public static DdemlException create(int errorCode) {
            int n;
            void var1_1;
            String errorName = ERROR_CODE_MAP.get(errorCode);
            return new DdemlException(errorCode, String.format("%s (Code: 0x%X)", errorName != null ? var1_1 : "", n));
        }

        /*
         * WARNING - void declaration
         */
        public DdemlException(int errorCode, String message) {
            super((String)var2_2);
            void var1_1;
            void var2_2;
            this.errorCode = var1_1;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            HashMap<Integer, String> errorCodeMapBuilder = new HashMap<Integer, String>();
            for (Field f : Ddeml.class.getFields()) {
                String name = f.getName();
                if (!name.startsWith("DMLERR_") || name.equals("DMLERR_FIRST") || name.equals("DMLERR_LAST")) continue;
                try {
                    errorCodeMapBuilder.put(f.getInt(null), name);
                }
                catch (IllegalAccessException | IllegalArgumentException ex) {
                    void var0_1;
                    throw new RuntimeException((Throwable)var0_1);
                }
            }
            ERROR_CODE_MAP = Collections.unmodifiableMap(var0);
        }
    }

    public static class DdeAdapter
    implements Ddeml.DdeCallback {
        private static final Logger LOG = Logger.getLogger(DdeAdapter.class.getName());
        private int idInst;
        private final List<AdvstartHandler> advstartHandler = new CopyOnWriteArrayList<AdvstartHandler>();
        private final List<AdvstopHandler> advstopHandler = new CopyOnWriteArrayList<AdvstopHandler>();
        private final List<ConnectHandler> connectHandler = new CopyOnWriteArrayList<ConnectHandler>();
        private final List<AdvreqHandler> advReqHandler = new CopyOnWriteArrayList<AdvreqHandler>();
        private final List<RequestHandler> requestHandler = new CopyOnWriteArrayList<RequestHandler>();
        private final List<WildconnectHandler> wildconnectHandler = new CopyOnWriteArrayList<WildconnectHandler>();
        private final List<AdvdataHandler> advdataHandler = new CopyOnWriteArrayList<AdvdataHandler>();
        private final List<ExecuteHandler> executeHandler = new CopyOnWriteArrayList<ExecuteHandler>();
        private final List<PokeHandler> pokeHandler = new CopyOnWriteArrayList<PokeHandler>();
        private final List<ConnectConfirmHandler> connectConfirmHandler = new CopyOnWriteArrayList<ConnectConfirmHandler>();
        private final List<DisconnectHandler> disconnectHandler = new CopyOnWriteArrayList<DisconnectHandler>();
        private final List<ErrorHandler> errorHandler = new CopyOnWriteArrayList<ErrorHandler>();
        private final List<RegisterHandler> registerHandler = new CopyOnWriteArrayList<RegisterHandler>();
        private final List<XactCompleteHandler> xactCompleteHandler = new CopyOnWriteArrayList<XactCompleteHandler>();
        private final List<UnregisterHandler> unregisterHandler = new CopyOnWriteArrayList<UnregisterHandler>();
        private final List<MonitorHandler> monitorHandler = new CopyOnWriteArrayList<MonitorHandler>();

        /*
         * WARNING - void declaration
         */
        public void setInstanceIdentifier(int idInst) {
            void var1_1;
            this.idInst = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public WinDef.PVOID ddeCallback(int wType, int wFmt, Ddeml.HCONV hConv, Ddeml.HSZ hsz1, Ddeml.HSZ hsz22, Ddeml.HDDEDATA hData, BaseTSD.ULONG_PTR lData1, BaseTSD.ULONG_PTR lData2) {
            try {
                switch (wType) {
                    case 4144: {
                        boolean booleanResult = this.onAdvstart(wType, wFmt, hConv, (Ddeml.HSZ)hsz1, hsz22);
                        return new WinDef.PVOID(Pointer.createConstant((int)new WinDef.BOOL(booleanResult).intValue()));
                    }
                    case 4194: {
                        boolean booleanResult;
                        Ddeml.CONVCONTEXT convcontext = null;
                        if (lData1.toPointer() != null) {
                            convcontext = new Ddeml.CONVCONTEXT(new Pointer(lData1.longValue()));
                        }
                        booleanResult = this.onConnect(booleanResult ? 1 : 0, (Ddeml.HSZ)hsz1, hsz22, convcontext, lData2 != null && lData2.intValue() != 0);
                        return new WinDef.PVOID(Pointer.createConstant((int)new WinDef.BOOL(booleanResult).intValue()));
                    }
                    case 8226: {
                        Ddeml.CONVCONTEXT convcontext;
                        boolean booleanResult;
                        int count = lData1.intValue() & 0xFFFF;
                        Ddeml.HDDEDATA data = this.onAdvreq(booleanResult ? 1 : 0, wFmt, (Ddeml.HCONV)((Object)convcontext), (Ddeml.HSZ)hsz1, hsz22, count);
                        if (data == null) {
                            return new WinDef.PVOID();
                        }
                        return new WinDef.PVOID(data.getPointer());
                    }
                    case 8368: {
                        void data;
                        Ddeml.CONVCONTEXT convcontext;
                        Ddeml.HDDEDATA data2 = this.onRequest((int)data, wFmt, (Ddeml.HCONV)((Object)convcontext), (Ddeml.HSZ)hsz1, hsz22);
                        if (data2 == null) {
                            return new WinDef.PVOID();
                        }
                        return new WinDef.PVOID(data2.getPointer());
                    }
                    case 8418: {
                        void var3_7;
                        Ddeml.HSZPAIR[] hszPairs;
                        Ddeml.CONVCONTEXT convcontext = null;
                        if (lData1.toPointer() != null) {
                            convcontext = new Ddeml.CONVCONTEXT(new Pointer(lData1.longValue()));
                        }
                        if ((hszPairs = this.onWildconnect((int)data, (Ddeml.HSZ)hsz1, hsz22, convcontext, lData2 != null && lData2.intValue() != 0)) == null || hszPairs.length == 0) {
                            return new WinDef.PVOID();
                        }
                        int size = 0;
                        hsz1 = hszPairs;
                        int hsz22 = hszPairs.length;
                        for (int count = 0; count < hsz22; ++count) {
                            Ddeml.HSZPAIR hp = hsz1[count];
                            hp.write();
                            size += hp.size();
                        }
                        Ddeml.HDDEDATA data3 = Ddeml.INSTANCE.DdeCreateDataHandle(this.idInst, hszPairs[0].getPointer(), (int)var3_7, 0, null, wFmt, 0);
                        return new WinDef.PVOID(data3.getPointer());
                    }
                    case 16400: {
                        void count;
                        Ddeml.HSZ hsz22;
                        void var3_6;
                        int intResult = this.onAdvdata((int)data, wFmt, (Ddeml.HCONV)var3_6, (Ddeml.HSZ)hsz1, hsz22, (Ddeml.HDDEDATA)count);
                        return new WinDef.PVOID(Pointer.createConstant((int)intResult));
                    }
                    case 16464: {
                        int intResult;
                        void count;
                        void var3_6;
                        intResult = this.onExecute(intResult, (Ddeml.HCONV)var3_6, (Ddeml.HSZ)hsz1, (Ddeml.HDDEDATA)count);
                        Ddeml.INSTANCE.DdeFreeDataHandle((Ddeml.HDDEDATA)count);
                        return new WinDef.PVOID(Pointer.createConstant((int)intResult));
                    }
                    case 16528: {
                        void var1_1;
                        int intResult;
                        void count;
                        Ddeml.HSZ hsz22;
                        void var3_6;
                        intResult = this.onPoke(intResult, wFmt, (Ddeml.HCONV)var3_6, (Ddeml.HSZ)hsz1, hsz22, (Ddeml.HDDEDATA)count);
                        return new WinDef.PVOID(Pointer.createConstant((int)var1_1));
                    }
                    case 32832: {
                        void var1_1;
                        Ddeml.HSZ hsz22;
                        void var3_6;
                        this.onAdvstop((int)var1_1, wFmt, (Ddeml.HCONV)var3_6, (Ddeml.HSZ)hsz1, hsz22);
                        break;
                    }
                    case 32882: {
                        void var1_1;
                        Ddeml.HSZ hsz22;
                        void var3_6;
                        this.onConnectConfirm((int)var1_1, (Ddeml.HCONV)var3_6, (Ddeml.HSZ)hsz1, hsz22, lData2 != null && lData2.intValue() != 0);
                        break;
                    }
                    case 32962: {
                        void var1_1;
                        void var3_6;
                        this.onDisconnect((int)var1_1, (Ddeml.HCONV)var3_6, lData2 != null && lData2.intValue() != 0);
                        break;
                    }
                    case 32770: {
                        void var1_1;
                        void var3_6;
                        this.onError((int)var1_1, (Ddeml.HCONV)var3_6, (int)(lData2.longValue() & 0xFFFFL));
                        break;
                    }
                    case 32930: {
                        void var1_1;
                        Ddeml.HSZ hsz22;
                        this.onRegister((int)var1_1, (Ddeml.HSZ)hsz1, hsz22);
                        break;
                    }
                    case 32896: {
                        void var7_15;
                        void var2_5;
                        void var1_1;
                        void count;
                        Ddeml.HSZ hsz22;
                        void var3_6;
                        this.onXactComplete((int)var1_1, (int)var2_5, (Ddeml.HCONV)var3_6, (Ddeml.HSZ)hsz1, hsz22, (Ddeml.HDDEDATA)count, (BaseTSD.ULONG_PTR)var7_15, lData2);
                        break;
                    }
                    case 32978: {
                        void var1_1;
                        Ddeml.HSZ hsz22;
                        this.onUnregister((int)var1_1, (Ddeml.HSZ)hsz1, hsz22);
                        break;
                    }
                    case 33010: {
                        void var1_1;
                        void count;
                        this.onMonitor((int)var1_1, (Ddeml.HDDEDATA)count, lData2.intValue());
                        break;
                    }
                    default: {
                        void var1_1;
                        LOG.log(Level.FINE, String.format("Not implemented Operation - Transaction type: 0x%X (%s)", (int)var1_1, null));
                        break;
                    }
                }
            }
            catch (BlockException blockException) {
                return new WinDef.PVOID(Pointer.createConstant((int)-1));
            }
            catch (Throwable ex) {
                LOG.log(Level.WARNING, "Exception in DDECallback", ex);
            }
            return new WinDef.PVOID();
        }

        /*
         * WARNING - void declaration
         */
        public void registerAdvstartHandler(AdvstartHandler handler) {
            void var1_1;
            this.advstartHandler.add((AdvstartHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterAdvstartHandler(AdvstartHandler handler) {
            void var1_1;
            this.advstartHandler.remove(var1_1);
        }

        private boolean onAdvstart(int transactionType, int dataFormat, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ item) {
            boolean oneHandlerTrue = false;
            for (AdvstartHandler advstartHandler : this.advstartHandler) {
                if (!advstartHandler.onAdvstart(transactionType, dataFormat, hconv, topic, item)) continue;
                oneHandlerTrue = true;
            }
            return oneHandlerTrue;
        }

        /*
         * WARNING - void declaration
         */
        public void registerAdvstopHandler(AdvstopHandler handler) {
            void var1_1;
            this.advstopHandler.add((AdvstopHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterAdvstopHandler(AdvstopHandler handler) {
            void var1_1;
            this.advstopHandler.remove(var1_1);
        }

        private void onAdvstop(int transactionType, int dataFormat, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ item) {
            for (AdvstopHandler advstopHandler : this.advstopHandler) {
                advstopHandler.onAdvstop(transactionType, dataFormat, hconv, topic, item);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerConnectHandler(ConnectHandler handler) {
            void var1_1;
            this.connectHandler.add((ConnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterConnectHandler(ConnectHandler handler) {
            void var1_1;
            this.connectHandler.remove(var1_1);
        }

        private boolean onConnect(int transactionType, Ddeml.HSZ topic, Ddeml.HSZ service, Ddeml.CONVCONTEXT convcontext, boolean sameInstance) {
            boolean oneHandlerTrue = false;
            for (ConnectHandler connectHandler : this.connectHandler) {
                if (!connectHandler.onConnect(transactionType, topic, service, convcontext, sameInstance)) continue;
                oneHandlerTrue = true;
            }
            return oneHandlerTrue;
        }

        /*
         * WARNING - void declaration
         */
        public void registerAdvReqHandler(AdvreqHandler handler) {
            void var1_1;
            this.advReqHandler.add((AdvreqHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterAdvReqHandler(AdvreqHandler handler) {
            void var1_1;
            this.advReqHandler.remove(var1_1);
        }

        private Ddeml.HDDEDATA onAdvreq(int transactionType, int dataFormat, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ item, int count) {
            for (AdvreqHandler advreqHandler : this.advReqHandler) {
                Ddeml.HDDEDATA result = advreqHandler.onAdvreq(transactionType, dataFormat, hconv, topic, item, count);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void registerRequestHandler(RequestHandler handler) {
            void var1_1;
            this.requestHandler.add((RequestHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterRequestHandler(RequestHandler handler) {
            void var1_1;
            this.requestHandler.remove(var1_1);
        }

        private Ddeml.HDDEDATA onRequest(int transactionType, int dataFormat, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ item) {
            for (RequestHandler requestHandler : this.requestHandler) {
                Ddeml.HDDEDATA result = requestHandler.onRequest(transactionType, dataFormat, hconv, topic, item);
                if (result == null) continue;
                return result;
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public void registerWildconnectHandler(WildconnectHandler handler) {
            void var1_1;
            this.wildconnectHandler.add((WildconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterWildconnectHandler(WildconnectHandler handler) {
            void var1_1;
            this.wildconnectHandler.remove(var1_1);
        }

        private Ddeml.HSZPAIR[] onWildconnect(int transactionType, Ddeml.HSZ topic, Ddeml.HSZ service, Ddeml.CONVCONTEXT convcontext, boolean sameInstance) {
            ArrayList<Ddeml.HSZPAIR> hszpairs = new ArrayList<Ddeml.HSZPAIR>(1);
            for (WildconnectHandler handler : this.wildconnectHandler) {
                hszpairs.addAll(handler.onWildconnect(transactionType, topic, service, convcontext, sameInstance));
            }
            return hszpairs.toArray(new Ddeml.HSZPAIR[0]);
        }

        /*
         * WARNING - void declaration
         */
        public void registerAdvdataHandler(AdvdataHandler handler) {
            void var1_1;
            this.advdataHandler.add((AdvdataHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterAdvdataHandler(AdvdataHandler handler) {
            void var1_1;
            this.advdataHandler.remove(var1_1);
        }

        private int onAdvdata(int transactionType, int dataFormat, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ item, Ddeml.HDDEDATA hdata) {
            for (AdvdataHandler advdataHandler : this.advdataHandler) {
                int result = advdataHandler.onAdvdata(transactionType, dataFormat, hconv, topic, item, hdata);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        public void registerExecuteHandler(ExecuteHandler handler) {
            void var1_1;
            this.executeHandler.add((ExecuteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterExecuteHandler(ExecuteHandler handler) {
            void var1_1;
            this.executeHandler.remove(var1_1);
        }

        private int onExecute(int transactionType, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HDDEDATA commandString) {
            for (ExecuteHandler executeHandler : this.executeHandler) {
                int result = executeHandler.onExecute(transactionType, hconv, topic, commandString);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        public void registerPokeHandler(PokeHandler handler) {
            void var1_1;
            this.pokeHandler.add((PokeHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterPokeHandler(PokeHandler handler) {
            void var1_1;
            this.pokeHandler.remove(var1_1);
        }

        private int onPoke(int transactionType, int dataFormat, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ item, Ddeml.HDDEDATA hdata) {
            for (PokeHandler pokeHandler : this.pokeHandler) {
                int result = pokeHandler.onPoke(transactionType, dataFormat, hconv, topic, item, hdata);
                if (result == 0) continue;
                return result;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        public void registerConnectConfirmHandler(ConnectConfirmHandler handler) {
            void var1_1;
            this.connectConfirmHandler.add((ConnectConfirmHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterConnectConfirmHandler(ConnectConfirmHandler handler) {
            void var1_1;
            this.connectConfirmHandler.remove(var1_1);
        }

        private void onConnectConfirm(int transactionType, Ddeml.HCONV hconv, Ddeml.HSZ topic, Ddeml.HSZ service, boolean sameInstance) {
            for (ConnectConfirmHandler connectConfirmHandler : this.connectConfirmHandler) {
                connectConfirmHandler.onConnectConfirm(transactionType, hconv, topic, service, sameInstance);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerDisconnectHandler(DisconnectHandler handler) {
            void var1_1;
            this.disconnectHandler.add((DisconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterDisconnectHandler(DisconnectHandler handler) {
            void var1_1;
            this.disconnectHandler.remove(var1_1);
        }

        private void onDisconnect(int transactionType, Ddeml.HCONV hconv, boolean sameInstance) {
            for (DisconnectHandler disconnectHandler : this.disconnectHandler) {
                disconnectHandler.onDisconnect(transactionType, hconv, sameInstance);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerErrorHandler(ErrorHandler handler) {
            void var1_1;
            this.errorHandler.add((ErrorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterErrorHandler(ErrorHandler handler) {
            void var1_1;
            this.errorHandler.remove(var1_1);
        }

        private void onError(int transactionType, Ddeml.HCONV hconv, int errorCode) {
            for (ErrorHandler errorHandler : this.errorHandler) {
                errorHandler.onError(transactionType, hconv, errorCode);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerRegisterHandler(RegisterHandler handler) {
            void var1_1;
            this.registerHandler.add((RegisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterRegisterHandler(RegisterHandler handler) {
            void var1_1;
            this.registerHandler.remove(var1_1);
        }

        private void onRegister(int transactionType, Ddeml.HSZ baseServiceName, Ddeml.HSZ instanceSpecificServiceName) {
            for (RegisterHandler registerHandler : this.registerHandler) {
                registerHandler.onRegister(transactionType, baseServiceName, instanceSpecificServiceName);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerXactCompleteHandler(XactCompleteHandler handler) {
            void var1_1;
            this.xactCompleteHandler.add((XactCompleteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void xactCompleteXactCompleteHandler(XactCompleteHandler handler) {
            void var1_1;
            this.xactCompleteHandler.remove(var1_1);
        }

        private void onXactComplete(int transactionType, int dataFormat, Ddeml.HCONV hConv, Ddeml.HSZ topic, Ddeml.HSZ item, Ddeml.HDDEDATA hdata, BaseTSD.ULONG_PTR transactionIdentifier, BaseTSD.ULONG_PTR statusFlag) {
            for (XactCompleteHandler xactCompleteHandler : this.xactCompleteHandler) {
                xactCompleteHandler.onXactComplete(transactionType, dataFormat, hConv, topic, item, hdata, transactionIdentifier, statusFlag);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerUnregisterHandler(UnregisterHandler handler) {
            void var1_1;
            this.unregisterHandler.add((UnregisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterUnregisterHandler(UnregisterHandler handler) {
            void var1_1;
            this.unregisterHandler.remove(var1_1);
        }

        private void onUnregister(int transactionType, Ddeml.HSZ baseServiceName, Ddeml.HSZ instanceSpecificServiceName) {
            for (UnregisterHandler unregisterHandler : this.unregisterHandler) {
                unregisterHandler.onUnregister(transactionType, baseServiceName, instanceSpecificServiceName);
            }
        }

        /*
         * WARNING - void declaration
         */
        public void registerMonitorHandler(MonitorHandler handler) {
            void var1_1;
            this.monitorHandler.add((MonitorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void unregisterMonitorHandler(MonitorHandler handler) {
            void var1_1;
            this.monitorHandler.remove(var1_1);
        }

        private void onMonitor(int transactionType, Ddeml.HDDEDATA hdata, int dwData2) {
            for (MonitorHandler monitorHandler : this.monitorHandler) {
                monitorHandler.onMonitor(transactionType, hdata, dwData2);
            }
        }

        public static class BlockException
        extends RuntimeException {
        }
    }

    public static interface MonitorHandler {
        public void onMonitor(int var1, Ddeml.HDDEDATA var2, int var3);
    }

    public static interface PokeHandler {
        public int onPoke(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5, Ddeml.HDDEDATA var6);
    }

    public static interface ExecuteHandler {
        public int onExecute(int var1, Ddeml.HCONV var2, Ddeml.HSZ var3, Ddeml.HDDEDATA var4);
    }

    public static interface UnregisterHandler {
        public void onUnregister(int var1, Ddeml.HSZ var2, Ddeml.HSZ var3);
    }

    public static interface XactCompleteHandler {
        public void onXactComplete(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5, Ddeml.HDDEDATA var6, BaseTSD.ULONG_PTR var7, BaseTSD.ULONG_PTR var8);
    }

    public static interface RegisterHandler {
        public void onRegister(int var1, Ddeml.HSZ var2, Ddeml.HSZ var3);
    }

    public static interface ErrorHandler {
        public void onError(int var1, Ddeml.HCONV var2, int var3);
    }

    public static interface DisconnectHandler {
        public void onDisconnect(int var1, Ddeml.HCONV var2, boolean var3);
    }

    public static interface ConnectConfirmHandler {
        public void onConnectConfirm(int var1, Ddeml.HCONV var2, Ddeml.HSZ var3, Ddeml.HSZ var4, boolean var5);
    }

    public static interface AdvdataHandler {
        public int onAdvdata(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5, Ddeml.HDDEDATA var6);
    }

    public static interface WildconnectHandler {
        public List<Ddeml.HSZPAIR> onWildconnect(int var1, Ddeml.HSZ var2, Ddeml.HSZ var3, Ddeml.CONVCONTEXT var4, boolean var5);
    }

    public static interface RequestHandler {
        public Ddeml.HDDEDATA onRequest(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5);
    }

    public static interface AdvreqHandler {
        public Ddeml.HDDEDATA onAdvreq(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5, int var6);
    }

    public static interface ConnectHandler {
        public boolean onConnect(int var1, Ddeml.HSZ var2, Ddeml.HSZ var3, Ddeml.CONVCONTEXT var4, boolean var5);
    }

    public static interface AdvstopHandler {
        public void onAdvstop(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5);
    }

    public static interface AdvstartHandler {
        public boolean onAdvstart(int var1, int var2, Ddeml.HCONV var3, Ddeml.HSZ var4, Ddeml.HSZ var5);
    }

    public static class DdeClient
    implements IDdeClient {
        private Integer idInst;
        private final DdeAdapter ddeAdapter = new DdeAdapter();

        @Override
        public Integer getInstanceIdentitifier() {
            return this.idInst;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void initialize(int afCmd) throws DdemlException {
            void var2_3;
            WinDef.DWORDByReference pidInst = new WinDef.DWORDByReference();
            Integer result = Ddeml.INSTANCE.DdeInitialize(pidInst, this.ddeAdapter, afCmd, 0);
            if (result != 0) {
                void var1_2;
                throw DdemlException.create(var1_2.intValue());
            }
            this.idInst = var2_3.getValue().intValue();
            if (this.ddeAdapter instanceof DdeAdapter) {
                this.ddeAdapter.setInstanceIdentifier(this.idInst);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HSZ createStringHandle(String value) throws DdemlException {
            void var1_1;
            void var2_2;
            if (value == null) {
                return null;
            }
            int codePage = W32APIOptions.DEFAULT_OPTIONS == W32APIOptions.UNICODE_OPTIONS ? 1200 : 1004;
            Ddeml.HSZ handle = Ddeml.INSTANCE.DdeCreateStringHandle(this.idInst, value, (int)var2_2);
            if (handle == null) {
                throw DdemlException.create(this.getLastError());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void nameService(Ddeml.HSZ name, int afCmd) throws DdemlException {
            void var2_2;
            Ddeml.HDDEDATA hDDEDATA;
            hDDEDATA = Ddeml.INSTANCE.DdeNameService(this.idInst, (Ddeml.HSZ)((Object)hDDEDATA), new Ddeml.HSZ(), (int)var2_2);
            if (hDDEDATA == null) {
                throw DdemlException.create(this.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void nameService(String name, int afCmd) throws DdemlException {
            Ddeml.HSZ nameHSZ = null;
            try {
                void var2_3;
                void var1_1;
                nameHSZ = this.createStringHandle((String)var1_1);
                this.nameService(nameHSZ, (int)var2_3);
                this.freeStringHandle(nameHSZ);
            }
            catch (Throwable throwable) {
                void var3_4;
                this.freeStringHandle((Ddeml.HSZ)var3_4);
                throw throwable;
            }
        }

        @Override
        public int getLastError() {
            return Ddeml.INSTANCE.DdeGetLastError(this.idInst);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection connect(Ddeml.HSZ service, Ddeml.HSZ topic, Ddeml.CONVCONTEXT convcontext) {
            void var1_1;
            void var3_3;
            void var2_2;
            Ddeml.HCONV hconv = Ddeml.INSTANCE.DdeConnect(this.idInst, service, (Ddeml.HSZ)var2_2, (Ddeml.CONVCONTEXT)var3_3);
            if (hconv == null) {
                throw DdemlException.create(this.getLastError());
            }
            return new DdeConnection(this, (Ddeml.HCONV)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection connect(String service, String topic, Ddeml.CONVCONTEXT convcontext) {
            IDdeConnection iDdeConnection;
            Ddeml.HSZ serviceHSZ = null;
            Ddeml.HSZ topicHSZ = null;
            try {
                void var3_4;
                void var2_3;
                serviceHSZ = this.createStringHandle((String)((Object)iDdeConnection));
                topicHSZ = this.createStringHandle((String)var2_3);
                iDdeConnection = this.connect(serviceHSZ, topicHSZ, (Ddeml.CONVCONTEXT)var3_4);
                this.freeStringHandle(topicHSZ);
            }
            catch (Throwable throwable) {
                this.freeStringHandle(topicHSZ);
                this.freeStringHandle(serviceHSZ);
                throw throwable;
            }
            this.freeStringHandle(serviceHSZ);
            return iDdeConnection;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String queryString(Ddeml.HSZ value) throws DdemlException {
            String string;
            Memory buffer;
            block5: {
                int byteWidth;
                int codePage;
                if (W32APIOptions.DEFAULT_OPTIONS == W32APIOptions.UNICODE_OPTIONS) {
                    codePage = 1200;
                    byteWidth = 2;
                } else {
                    codePage = 1004;
                    byteWidth = 1;
                }
                buffer = new Memory((long)(byteWidth * 257));
                try {
                    void var2_3;
                    Ddeml.INSTANCE.DdeQueryString(this.idInst, (Ddeml.HSZ)((Object)string), (Pointer)buffer, 256, (int)var2_3);
                    if (W32APIOptions.DEFAULT_OPTIONS != W32APIOptions.UNICODE_OPTIONS) break block5;
                    string = buffer.getWideString(0L);
                }
                catch (Throwable throwable) {
                    void var3_5;
                    var3_5.valid();
                    throw throwable;
                }
                buffer.valid();
                return string;
            }
            string = buffer.getString(0L);
            buffer.valid();
            return string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA createDataHandle(Pointer pSrc, int cb, int cbOff, Ddeml.HSZ hszItem, int wFmt, int afCmd) {
            void var1_1;
            void var3_3;
            void var2_2;
            Ddeml.HDDEDATA returnData = Ddeml.INSTANCE.DdeCreateDataHandle(this.idInst, pSrc, (int)var2_2, (int)var3_3, hszItem, wFmt, afCmd);
            if (returnData == null) {
                throw DdemlException.create(this.getLastError());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void freeDataHandle(Ddeml.HDDEDATA hData) {
            void var1_1;
            boolean bl = Ddeml.INSTANCE.DdeFreeDataHandle((Ddeml.HDDEDATA)var1_1);
            if (!bl) {
                throw DdemlException.create(this.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA addData(Ddeml.HDDEDATA hData, Pointer pSrc, int cb, int cbOff) {
            void var1_1;
            void var3_3;
            void var2_2;
            Ddeml.HDDEDATA newHandle = Ddeml.INSTANCE.DdeAddData(hData, (Pointer)var2_2, (int)var3_3, cbOff);
            if (newHandle == null) {
                throw DdemlException.create(this.getLastError());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getData(Ddeml.HDDEDATA hData, Pointer pDst, int cbMax, int cbOff) {
            void var1_2;
            void var3_5;
            int result = Ddeml.INSTANCE.DdeGetData(hData, pDst, (int)var3_5, cbOff);
            int errorCode = this.getLastError();
            if (errorCode != 0) {
                void var2_4;
                throw DdemlException.create((int)var2_4);
            }
            return (int)var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Pointer accessData(Ddeml.HDDEDATA hData, WinDef.DWORDByReference pcbDataSize) {
            void var1_1;
            void var2_2;
            Pointer result = Ddeml.INSTANCE.DdeAccessData(hData, (WinDef.DWORDByReference)var2_2);
            if (result == null) {
                throw DdemlException.create(this.getLastError());
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unaccessData(Ddeml.HDDEDATA hData) {
            void var1_1;
            boolean bl = Ddeml.INSTANCE.DdeUnaccessData((Ddeml.HDDEDATA)var1_1);
            if (!bl) {
                throw DdemlException.create(this.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void postAdvise(Ddeml.HSZ hszTopic, Ddeml.HSZ hszItem) {
            void var2_3;
            void var1_1;
            boolean bl = Ddeml.INSTANCE.DdePostAdvise(this.idInst, (Ddeml.HSZ)var1_1, (Ddeml.HSZ)var2_3);
            if (!bl) {
                throw DdemlException.create(this.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void postAdvise(String topic, String item) {
            Ddeml.HSZ itemHSZ = null;
            Ddeml.HSZ topicHSZ = null;
            try {
                void var2_3;
                void var1_1;
                topicHSZ = this.createStringHandle((String)var1_1);
                itemHSZ = this.createStringHandle((String)var2_3);
                this.postAdvise(topicHSZ, itemHSZ);
                this.freeStringHandle(topicHSZ);
            }
            catch (Throwable throwable) {
                void var3_4;
                this.freeStringHandle(topicHSZ);
                this.freeStringHandle((Ddeml.HSZ)var3_4);
                throw throwable;
            }
            this.freeStringHandle(itemHSZ);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean freeStringHandle(Ddeml.HSZ value) {
            void var1_1;
            if (value == null) {
                return true;
            }
            return Ddeml.INSTANCE.DdeFreeStringHandle(this.idInst, (Ddeml.HSZ)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean keepStringHandle(Ddeml.HSZ value) {
            void var1_1;
            return Ddeml.INSTANCE.DdeKeepStringHandle(this.idInst, (Ddeml.HSZ)var1_1);
        }

        @Override
        public void abandonTransactions() {
            boolean bl = Ddeml.INSTANCE.DdeAbandonTransaction(this.idInst, null, 0);
            if (!bl) {
                throw DdemlException.create(this.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnectionList connectList(Ddeml.HSZ service, Ddeml.HSZ topic, IDdeConnectionList existingList, Ddeml.CONVCONTEXT ctx) {
            void var1_1;
            void var3_3;
            void var2_2;
            Ddeml.HCONVLIST convlist = Ddeml.INSTANCE.DdeConnectList(this.idInst, service, (Ddeml.HSZ)var2_2, existingList != null ? var3_3.getHandle() : null, ctx);
            if (convlist == null) {
                throw DdemlException.create(this.getLastError());
            }
            return new DdeConnectionList(this, (Ddeml.HCONVLIST)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnectionList connectList(String service, String topic, IDdeConnectionList existingList, Ddeml.CONVCONTEXT ctx) {
            IDdeConnectionList iDdeConnectionList;
            Ddeml.HSZ serviceHSZ = null;
            Ddeml.HSZ topicHSZ = null;
            try {
                void var3_4;
                void var2_3;
                serviceHSZ = this.createStringHandle((String)((Object)iDdeConnectionList));
                topicHSZ = this.createStringHandle((String)var2_3);
                iDdeConnectionList = this.connectList(serviceHSZ, topicHSZ, (IDdeConnectionList)var3_4, ctx);
                this.freeStringHandle(topicHSZ);
            }
            catch (Throwable throwable) {
                this.freeStringHandle(topicHSZ);
                this.freeStringHandle(serviceHSZ);
                throw throwable;
            }
            this.freeStringHandle(serviceHSZ);
            return iDdeConnectionList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean enableCallback(int wCmd) {
            void var2_2;
            int n;
            boolean result = Ddeml.INSTANCE.DdeEnableCallback(this.idInst, null, wCmd);
            if (!result && n != 2 && (n = this.getLastError()) != 0) {
                throw DdemlException.create(this.getLastError());
            }
            return (boolean)var2_2;
        }

        @Override
        public boolean uninitialize() {
            return Ddeml.INSTANCE.DdeUninitialize(this.idInst);
        }

        @Override
        public void close() {
            this.uninitialize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection wrap(Ddeml.HCONV hconv) {
            void var1_1;
            return new DdeConnection(this, (Ddeml.HCONV)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterDisconnectHandler(DisconnectHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterDisconnectHandler((DisconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvstartHandler(AdvstartHandler handler) {
            void var1_1;
            this.ddeAdapter.registerAdvstartHandler((AdvstartHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvstartHandler(AdvstartHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterAdvstartHandler((AdvstartHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvstopHandler(AdvstopHandler handler) {
            void var1_1;
            this.ddeAdapter.registerAdvstopHandler((AdvstopHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvstopHandler(AdvstopHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterAdvstopHandler((AdvstopHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerConnectHandler(ConnectHandler handler) {
            void var1_1;
            this.ddeAdapter.registerConnectHandler((ConnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterConnectHandler(ConnectHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterConnectHandler((ConnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvReqHandler(AdvreqHandler handler) {
            void var1_1;
            this.ddeAdapter.registerAdvReqHandler((AdvreqHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvReqHandler(AdvreqHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterAdvReqHandler((AdvreqHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerRequestHandler(RequestHandler handler) {
            void var1_1;
            this.ddeAdapter.registerRequestHandler((RequestHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterRequestHandler(RequestHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterRequestHandler((RequestHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerWildconnectHandler(WildconnectHandler handler) {
            void var1_1;
            this.ddeAdapter.registerWildconnectHandler((WildconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterWildconnectHandler(WildconnectHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterWildconnectHandler((WildconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvdataHandler(AdvdataHandler handler) {
            void var1_1;
            this.ddeAdapter.registerAdvdataHandler((AdvdataHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvdataHandler(AdvdataHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterAdvdataHandler((AdvdataHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerExecuteHandler(ExecuteHandler handler) {
            void var1_1;
            this.ddeAdapter.registerExecuteHandler((ExecuteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterExecuteHandler(ExecuteHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterExecuteHandler((ExecuteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerPokeHandler(PokeHandler handler) {
            void var1_1;
            this.ddeAdapter.registerPokeHandler((PokeHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterPokeHandler(PokeHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterPokeHandler((PokeHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerConnectConfirmHandler(ConnectConfirmHandler handler) {
            void var1_1;
            this.ddeAdapter.registerConnectConfirmHandler((ConnectConfirmHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterConnectConfirmHandler(ConnectConfirmHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterConnectConfirmHandler((ConnectConfirmHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerDisconnectHandler(DisconnectHandler handler) {
            void var1_1;
            this.ddeAdapter.registerDisconnectHandler((DisconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerErrorHandler(ErrorHandler handler) {
            void var1_1;
            this.ddeAdapter.registerErrorHandler((ErrorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterErrorHandler(ErrorHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterErrorHandler((ErrorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerRegisterHandler(RegisterHandler handler) {
            void var1_1;
            this.ddeAdapter.registerRegisterHandler((RegisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterRegisterHandler(RegisterHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterRegisterHandler((RegisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerXactCompleteHandler(XactCompleteHandler handler) {
            void var1_1;
            this.ddeAdapter.registerXactCompleteHandler((XactCompleteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterXactCompleteHandler(XactCompleteHandler handler) {
            void var1_1;
            this.ddeAdapter.xactCompleteXactCompleteHandler((XactCompleteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerUnregisterHandler(UnregisterHandler handler) {
            void var1_1;
            this.ddeAdapter.registerUnregisterHandler((UnregisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterUnregisterHandler(UnregisterHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterUnregisterHandler((UnregisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerMonitorHandler(MonitorHandler handler) {
            void var1_1;
            this.ddeAdapter.registerMonitorHandler((MonitorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterMonitorHandler(MonitorHandler handler) {
            void var1_1;
            this.ddeAdapter.unregisterMonitorHandler((MonitorHandler)var1_1);
        }
    }

    public static class DdeConnectionList
    implements IDdeConnectionList {
        private final IDdeClient client;
        private final Ddeml.HCONVLIST convList;

        /*
         * WARNING - void declaration
         */
        public DdeConnectionList(IDdeClient client, Ddeml.HCONVLIST convList) {
            void var1_1;
            void var2_2;
            this.convList = var2_2;
            this.client = var1_1;
        }

        @Override
        public Ddeml.HCONVLIST getHandle() {
            return this.convList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection queryNextServer(IDdeConnection prevConnection) {
            Ddeml.HCONV conv = Ddeml.INSTANCE.DdeQueryNextServer(this.convList, prevConnection != null ? prevConnection.getConv() : null);
            if (conv != null) {
                void var1_1;
                return new DdeConnection(this.client, (Ddeml.HCONV)var1_1);
            }
            return null;
        }

        @Override
        public void close() {
            boolean bl = Ddeml.INSTANCE.DdeDisconnectList(this.convList);
            if (!bl) {
                throw DdemlException.create(this.client.getLastError());
            }
        }
    }

    public static class DdeConnection
    implements IDdeConnection {
        private Ddeml.HCONV conv;
        private final IDdeClient client;

        /*
         * WARNING - void declaration
         */
        public DdeConnection(IDdeClient client, Ddeml.HCONV conv) {
            void var1_1;
            void var2_2;
            this.conv = var2_2;
            this.client = var1_1;
        }

        @Override
        public Ddeml.HCONV getConv() {
            return this.conv;
        }

        @Override
        public void abandonTransaction(int transactionId) {
            boolean bl;
            bl = Ddeml.INSTANCE.DdeAbandonTransaction(this.client.getInstanceIdentitifier(), this.conv, bl ? 1 : 0);
            if (!bl) {
                throw DdemlException.create(this.client.getLastError());
            }
        }

        @Override
        public void abandonTransactions() {
            boolean bl = Ddeml.INSTANCE.DdeAbandonTransaction(this.client.getInstanceIdentitifier(), this.conv, 0);
            if (!bl) {
                throw DdemlException.create(this.client.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA clientTransaction(Pointer data, int dataLength, Ddeml.HSZ item, int wFmt, int transaction, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            void var1_1;
            void var3_3;
            void var2_2;
            Ddeml.HDDEDATA returnData;
            if (timeout == -1 && result == null) {
                result = new WinDef.DWORDByReference();
            }
            if ((returnData = Ddeml.INSTANCE.DdeClientTransaction(data, (int)var2_2, this.conv, (Ddeml.HSZ)var3_3, wFmt, transaction, timeout, result)) == null) {
                throw DdemlException.create(this.client.getLastError());
            }
            if (userHandle != null) {
                if (timeout != -1) {
                    this.setUserHandle(-1, userHandle);
                } else {
                    this.setUserHandle(result.getValue().intValue(), userHandle);
                }
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA clientTransaction(Pointer data, int dataLength, String item, int wFmt, int transaction, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            Ddeml.HSZ itemHSZ = null;
            try {
                void var2_3;
                Ddeml.HDDEDATA hDDEDATA;
                void var3_4;
                itemHSZ = this.client.createStringHandle((String)var3_4);
                hDDEDATA = this.clientTransaction((Pointer)hDDEDATA, (int)var2_3, itemHSZ, wFmt, transaction, timeout, result, userHandle);
                return hDDEDATA;
            }
            finally {
                this.client.freeStringHandle(itemHSZ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void poke(Pointer data, int dataLength, Ddeml.HSZ item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.clientTransaction((Pointer)var1_1, (int)var2_2, (Ddeml.HSZ)var3_3, wFmt, 16528, timeout, result, userHandle);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void poke(Pointer data, int dataLength, String item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            Ddeml.HSZ itemHSZ = null;
            try {
                void var2_3;
                void var1_1;
                void var3_4;
                itemHSZ = this.client.createStringHandle((String)var3_4);
                this.poke((Pointer)var1_1, (int)var2_3, itemHSZ, wFmt, timeout, result, userHandle);
                return;
            }
            finally {
                this.client.freeStringHandle(itemHSZ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA request(Ddeml.HSZ item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientTransaction(Pointer.NULL, 0, (Ddeml.HSZ)var1_1, (int)var2_2, 8368, (int)var3_3, result, userHandle);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA request(String item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            Ddeml.HSZ itemHSZ = null;
            try {
                void var3_4;
                void var2_3;
                Ddeml.HDDEDATA hDDEDATA;
                itemHSZ = this.client.createStringHandle((String)((Object)hDDEDATA));
                hDDEDATA = this.request(itemHSZ, (int)var2_3, (int)var3_4, result, userHandle);
                return hDDEDATA;
            }
            finally {
                this.client.freeStringHandle(itemHSZ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void execute(String executeString, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            void var3_3;
            void var2_2;
            void var1_1;
            Memory mem = new Memory((long)((executeString.length() << 1) + 2));
            mem.setWideString(0L, (String)var1_1);
            Memory memory = mem;
            this.clientTransaction((Pointer)memory, (int)memory.size(), (Ddeml.HSZ)null, 0, 16464, (int)var2_2, (WinDef.DWORDByReference)var3_3, userHandle);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void advstart(Ddeml.HSZ item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.clientTransaction(Pointer.NULL, 0, (Ddeml.HSZ)var1_1, (int)var2_2, 4144, (int)var3_3, result, userHandle);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void advstart(String item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            Ddeml.HSZ itemHSZ = null;
            try {
                void var3_4;
                void var2_3;
                void var1_1;
                itemHSZ = this.client.createStringHandle((String)var1_1);
                this.advstart(itemHSZ, (int)var2_3, (int)var3_4, result, userHandle);
                return;
            }
            finally {
                this.client.freeStringHandle(itemHSZ);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void advstop(Ddeml.HSZ item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.clientTransaction(Pointer.NULL, 0, (Ddeml.HSZ)var1_1, (int)var2_2, 32832, (int)var3_3, result, userHandle);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void advstop(String item, int wFmt, int timeout, WinDef.DWORDByReference result, BaseTSD.DWORD_PTR userHandle) {
            Ddeml.HSZ itemHSZ = null;
            try {
                void var3_4;
                void var2_3;
                void var1_1;
                itemHSZ = this.client.createStringHandle((String)var1_1);
                this.advstop(itemHSZ, (int)var2_3, (int)var3_4, result, userHandle);
                return;
            }
            finally {
                this.client.freeStringHandle(itemHSZ);
            }
        }

        @Override
        public void impersonateClient() {
            boolean bl = Ddeml.INSTANCE.DdeImpersonateClient(this.conv);
            if (!bl) {
                throw DdemlException.create(this.client.getLastError());
            }
        }

        @Override
        public void close() {
            boolean bl = Ddeml.INSTANCE.DdeDisconnect(this.conv);
            if (!bl) {
                throw DdemlException.create(this.client.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void reconnect() {
            Ddeml.HCONV newConv = Ddeml.INSTANCE.DdeReconnect(this.conv);
            if (newConv != null) {
                void var1_1;
                this.conv = var1_1;
                return;
            }
            throw DdemlException.create(this.client.getLastError());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean enableCallback(int wCmd) {
            void var2_2;
            void var1_1;
            boolean result = Ddeml.INSTANCE.DdeEnableCallback(this.client.getInstanceIdentitifier(), this.conv, wCmd);
            if (!result && var1_1 == 2) {
                throw DdemlException.create(this.client.getLastError());
            }
            return (boolean)var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void setUserHandle(int id, BaseTSD.DWORD_PTR hUser) throws DdemlException {
            void var2_2;
            boolean bl;
            if (!(bl = Ddeml.INSTANCE.DdeSetUserHandle(this.conv, bl ? 1 : 0, (BaseTSD.DWORD_PTR)var2_2))) {
                throw DdemlException.create(this.client.getLastError());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.CONVINFO queryConvInfo(int idTransaction) throws DdemlException {
            void var2_2;
            int n;
            Ddeml.CONVINFO convInfo = new Ddeml.CONVINFO();
            new Ddeml.CONVINFO().cb = convInfo.size();
            convInfo.ConvCtxt.cb = convInfo.ConvCtxt.size();
            convInfo.write();
            n = Ddeml.INSTANCE.DdeQueryConvInfo(this.conv, n, convInfo);
            if (n == 0) {
                throw DdemlException.create(this.client.getLastError());
            }
            return var2_2;
        }
    }

    private static class MessageLoopWrapper
    implements InvocationHandler {
        private final Object delegate;
        private final User32Util.MessageLoopThread loopThread;

        /*
         * WARNING - void declaration
         */
        public MessageLoopWrapper(User32Util.MessageLoopThread thread, Object delegate) {
            void var2_2;
            void var1_1;
            this.loopThread = var1_1;
            this.delegate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                void var2_2;
                Object result = method.invoke(this.delegate, args);
                Class wrapClass = null;
                if (result instanceof IDdeConnection) {
                    wrapClass = IDdeConnection.class;
                } else if (result instanceof IDdeConnectionList) {
                    wrapClass = IDdeConnectionList.class;
                } else if (result instanceof IDdeClient) {
                    wrapClass = IDdeClient.class;
                }
                if (wrapClass != null && var2_2.getReturnType().isAssignableFrom(wrapClass)) {
                    result = this.wrap(result, wrapClass);
                }
                return result;
            }
            catch (InvocationTargetException invocationTargetException) {
                void var1_1;
                InvocationTargetException ex = invocationTargetException;
                Throwable cause = invocationTargetException.getCause();
                if (cause instanceof Exception) {
                    void var3_3;
                    throw (Exception)var3_3;
                }
                throw var1_1;
            }
        }

        /*
         * WARNING - void declaration
         */
        private <V> V wrap(V delegate, Class clazz) {
            Object object;
            void var2_2;
            ClassLoader classLoader = StandaloneDdeClient.class.getClassLoader();
            Class[] classArray = new Class[]{clazz};
            User32Util.MessageLoopThread messageLoopThread = this.loopThread;
            Objects.requireNonNull(messageLoopThread);
            Object messageLoopHandler = Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new User32Util.MessageLoopThread.Handler(messageLoopThread, delegate));
            object = Proxy.newProxyInstance(StandaloneDdeClient.class.getClassLoader(), new Class[]{var2_2}, (InvocationHandler)new MessageLoopWrapper(this.loopThread, object));
            return (V)object;
        }
    }

    public static class StandaloneDdeClient
    implements IDdeClient,
    Closeable {
        private final User32Util.MessageLoopThread messageLoop = new User32Util.MessageLoopThread();
        private final IDdeClient ddeClient = new DdeClient();
        private final IDdeClient clientDelegate;

        /*
         * WARNING - void declaration
         */
        public StandaloneDdeClient() {
            void var1_1;
            ClassLoader classLoader = StandaloneDdeClient.class.getClassLoader();
            Class[] classArray = new Class[]{IDdeClient.class};
            User32Util.MessageLoopThread messageLoopThread = this.messageLoop;
            Objects.requireNonNull(messageLoopThread);
            IDdeClient messageLoopHandler = (IDdeClient)Proxy.newProxyInstance(classLoader, classArray, (InvocationHandler)new User32Util.MessageLoopThread.Handler(messageLoopThread, this.ddeClient));
            this.clientDelegate = (IDdeClient)Proxy.newProxyInstance(StandaloneDdeClient.class.getClassLoader(), new Class[]{IDdeClient.class}, (InvocationHandler)new MessageLoopWrapper(this.messageLoop, var1_1));
            this.messageLoop.setDaemon(true);
            this.messageLoop.start();
        }

        @Override
        public Integer getInstanceIdentitifier() {
            return this.ddeClient.getInstanceIdentitifier();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void initialize(int afCmd) throws DdemlException {
            void var1_1;
            this.clientDelegate.initialize((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HSZ createStringHandle(String value) throws DdemlException {
            void var1_1;
            return this.clientDelegate.createStringHandle((String)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void nameService(Ddeml.HSZ name, int afCmd) throws DdemlException {
            void var2_2;
            void var1_1;
            this.clientDelegate.nameService((Ddeml.HSZ)var1_1, (int)var2_2);
        }

        @Override
        public int getLastError() {
            return this.clientDelegate.getLastError();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection connect(Ddeml.HSZ service, Ddeml.HSZ topic, Ddeml.CONVCONTEXT convcontext) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.connect((Ddeml.HSZ)var1_1, (Ddeml.HSZ)var2_2, (Ddeml.CONVCONTEXT)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String queryString(Ddeml.HSZ value) throws DdemlException {
            void var1_1;
            return this.clientDelegate.queryString((Ddeml.HSZ)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA createDataHandle(Pointer pSrc, int cb, int cbOff, Ddeml.HSZ hszItem, int wFmt, int afCmd) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.createDataHandle((Pointer)var1_1, (int)var2_2, (int)var3_3, hszItem, wFmt, afCmd);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void freeDataHandle(Ddeml.HDDEDATA hData) {
            void var1_1;
            this.clientDelegate.freeDataHandle((Ddeml.HDDEDATA)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Ddeml.HDDEDATA addData(Ddeml.HDDEDATA hData, Pointer pSrc, int cb, int cbOff) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.addData((Ddeml.HDDEDATA)var1_1, (Pointer)var2_2, (int)var3_3, cbOff);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getData(Ddeml.HDDEDATA hData, Pointer pDst, int cbMax, int cbOff) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.getData((Ddeml.HDDEDATA)var1_1, (Pointer)var2_2, (int)var3_3, cbOff);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Pointer accessData(Ddeml.HDDEDATA hData, WinDef.DWORDByReference pcbDataSize) {
            void var2_2;
            void var1_1;
            return this.clientDelegate.accessData((Ddeml.HDDEDATA)var1_1, (WinDef.DWORDByReference)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unaccessData(Ddeml.HDDEDATA hData) {
            void var1_1;
            this.clientDelegate.unaccessData((Ddeml.HDDEDATA)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void postAdvise(Ddeml.HSZ hszTopic, Ddeml.HSZ hszItem) {
            void var2_2;
            void var1_1;
            this.clientDelegate.postAdvise((Ddeml.HSZ)var1_1, (Ddeml.HSZ)var2_2);
        }

        @Override
        public void close() throws IOException {
            this.clientDelegate.uninitialize();
            this.messageLoop.exit();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean freeStringHandle(Ddeml.HSZ value) {
            void var1_1;
            return this.clientDelegate.freeStringHandle((Ddeml.HSZ)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean keepStringHandle(Ddeml.HSZ value) {
            void var1_1;
            return this.clientDelegate.keepStringHandle((Ddeml.HSZ)var1_1);
        }

        @Override
        public void abandonTransactions() {
            this.clientDelegate.abandonTransactions();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnectionList connectList(Ddeml.HSZ service, Ddeml.HSZ topic, IDdeConnectionList existingList, Ddeml.CONVCONTEXT ctx) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.connectList((Ddeml.HSZ)var1_1, (Ddeml.HSZ)var2_2, (IDdeConnectionList)var3_3, ctx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean enableCallback(int wCmd) {
            void var1_1;
            return this.clientDelegate.enableCallback((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection wrap(Ddeml.HCONV conv) {
            void var1_1;
            return this.clientDelegate.wrap((Ddeml.HCONV)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnection connect(String service, String topic, Ddeml.CONVCONTEXT convcontext) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.connect((String)var1_1, (String)var2_2, (Ddeml.CONVCONTEXT)var3_3);
        }

        @Override
        public boolean uninitialize() {
            return this.clientDelegate.uninitialize();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void postAdvise(String hszTopic, String hszItem) {
            void var2_2;
            void var1_1;
            this.clientDelegate.postAdvise((String)var1_1, (String)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IDdeConnectionList connectList(String service, String topic, IDdeConnectionList existingList, Ddeml.CONVCONTEXT ctx) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.clientDelegate.connectList((String)var1_1, (String)var2_2, (IDdeConnectionList)var3_3, ctx);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void nameService(String name, int afCmd) throws DdemlException {
            void var2_2;
            void var1_1;
            this.clientDelegate.nameService((String)var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvstartHandler(AdvstartHandler handler) {
            void var1_1;
            this.clientDelegate.registerAdvstartHandler((AdvstartHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvstartHandler(AdvstartHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterAdvstartHandler((AdvstartHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvstopHandler(AdvstopHandler handler) {
            void var1_1;
            this.clientDelegate.registerAdvstopHandler((AdvstopHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvstopHandler(AdvstopHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterAdvstopHandler((AdvstopHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerConnectHandler(ConnectHandler handler) {
            void var1_1;
            this.clientDelegate.registerConnectHandler((ConnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterConnectHandler(ConnectHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterConnectHandler((ConnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvReqHandler(AdvreqHandler handler) {
            void var1_1;
            this.clientDelegate.registerAdvReqHandler((AdvreqHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvReqHandler(AdvreqHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterAdvReqHandler((AdvreqHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerRequestHandler(RequestHandler handler) {
            void var1_1;
            this.clientDelegate.registerRequestHandler((RequestHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterRequestHandler(RequestHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterRequestHandler((RequestHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerWildconnectHandler(WildconnectHandler handler) {
            void var1_1;
            this.clientDelegate.registerWildconnectHandler((WildconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterWildconnectHandler(WildconnectHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterWildconnectHandler((WildconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerAdvdataHandler(AdvdataHandler handler) {
            void var1_1;
            this.clientDelegate.registerAdvdataHandler((AdvdataHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterAdvdataHandler(AdvdataHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterAdvdataHandler((AdvdataHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerExecuteHandler(ExecuteHandler handler) {
            void var1_1;
            this.clientDelegate.registerExecuteHandler((ExecuteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterExecuteHandler(ExecuteHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterExecuteHandler((ExecuteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerPokeHandler(PokeHandler handler) {
            void var1_1;
            this.clientDelegate.registerPokeHandler((PokeHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterPokeHandler(PokeHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterPokeHandler((PokeHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerConnectConfirmHandler(ConnectConfirmHandler handler) {
            void var1_1;
            this.clientDelegate.registerConnectConfirmHandler((ConnectConfirmHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterConnectConfirmHandler(ConnectConfirmHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterConnectConfirmHandler((ConnectConfirmHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerDisconnectHandler(DisconnectHandler handler) {
            void var1_1;
            this.clientDelegate.registerDisconnectHandler((DisconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterDisconnectHandler(DisconnectHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterDisconnectHandler((DisconnectHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerErrorHandler(ErrorHandler handler) {
            void var1_1;
            this.clientDelegate.registerErrorHandler((ErrorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterErrorHandler(ErrorHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterErrorHandler((ErrorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerRegisterHandler(RegisterHandler handler) {
            void var1_1;
            this.clientDelegate.registerRegisterHandler((RegisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterRegisterHandler(RegisterHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterRegisterHandler((RegisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerXactCompleteHandler(XactCompleteHandler handler) {
            void var1_1;
            this.clientDelegate.registerXactCompleteHandler((XactCompleteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterXactCompleteHandler(XactCompleteHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterXactCompleteHandler((XactCompleteHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerUnregisterHandler(UnregisterHandler handler) {
            void var1_1;
            this.clientDelegate.registerUnregisterHandler((UnregisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterUnregisterHandler(UnregisterHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterUnregisterHandler((UnregisterHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void registerMonitorHandler(MonitorHandler handler) {
            void var1_1;
            this.clientDelegate.registerMonitorHandler((MonitorHandler)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void unregisterMonitorHandler(MonitorHandler handler) {
            void var1_1;
            this.clientDelegate.unregisterMonitorHandler((MonitorHandler)var1_1);
        }
    }
}

