/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna.platform.win32.COM.util;

import com.sun.jna.Pointer;
import com.sun.jna.WString;
import com.sun.jna.platform.win32.COM.COMException;
import com.sun.jna.platform.win32.COM.COMUtils;
import com.sun.jna.platform.win32.COM.Dispatch;
import com.sun.jna.platform.win32.COM.DispatchListener;
import com.sun.jna.platform.win32.COM.IDispatchCallback;
import com.sun.jna.platform.win32.COM.Unknown;
import com.sun.jna.platform.win32.COM.util.Convert;
import com.sun.jna.platform.win32.COM.util.IComEventCallbackListener;
import com.sun.jna.platform.win32.COM.util.ObjectFactory;
import com.sun.jna.platform.win32.COM.util.annotation.ComEventCallback;
import com.sun.jna.platform.win32.COM.util.annotation.ComInterface;
import com.sun.jna.platform.win32.COM.util.annotation.ComMethod;
import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.OaIdl;
import com.sun.jna.platform.win32.OleAuto;
import com.sun.jna.platform.win32.Variant;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinError;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.ptr.PointerByReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CallbackProxy
implements IDispatchCallback {
    private static boolean DEFAULT_BOOLEAN;
    private static byte DEFAULT_BYTE;
    private static short DEFAULT_SHORT;
    private static int DEFAULT_INT;
    private static long DEFAULT_LONG;
    private static float DEFAULT_FLOAT;
    private static double DEFAULT_DOUBLE;
    ObjectFactory factory;
    Class<?> comEventCallbackInterface;
    IComEventCallbackListener comEventCallbackListener;
    Guid.REFIID listenedToRiid;
    public DispatchListener dispatchListener;
    Map<OaIdl.DISPID, Method> dsipIdMap;

    /*
     * WARNING - void declaration
     */
    public CallbackProxy(ObjectFactory factory, Class<?> comEventCallbackInterface, IComEventCallbackListener comEventCallbackListener) {
        void var2_2;
        void var3_3;
        void var1_1;
        this.factory = var1_1;
        this.comEventCallbackInterface = comEventCallbackInterface;
        this.comEventCallbackListener = var3_3;
        this.listenedToRiid = this.createRIID(comEventCallbackInterface);
        this.dsipIdMap = this.createDispIdMap((Class<?>)var2_2);
        this.dispatchListener = new DispatchListener(this);
    }

    /*
     * WARNING - void declaration
     */
    private Guid.REFIID createRIID(Class<?> comEventCallbackInterface) {
        void var1_1;
        ComInterface comInterfaceAnnotation = comEventCallbackInterface.getAnnotation(ComInterface.class);
        if (comInterfaceAnnotation == null) {
            throw new COMException("advise: Interface must define a value for either iid via the ComInterface annotation");
        }
        String iidStr = comInterfaceAnnotation.iid();
        if (iidStr == null || iidStr.isEmpty()) {
            throw new COMException("ComInterface must define a value for iid");
        }
        return new Guid.REFIID(new Guid.IID((String)var1_1).getPointer());
    }

    /*
     * WARNING - void declaration
     */
    private Map<OaIdl.DISPID, Method> createDispIdMap(Class<?> comEventCallbackInterface) {
        void var2_2;
        Method[] methodArray;
        HashMap<OaIdl.DISPID, Method> map = new HashMap<OaIdl.DISPID, Method>();
        for (Method meth : methodArray.getMethods()) {
            ComEventCallback callbackAnnotation = meth.getAnnotation(ComEventCallback.class);
            ComMethod methodAnnotation = meth.getAnnotation(ComMethod.class);
            if (methodAnnotation != null) {
                int dispId = methodAnnotation.dispId();
                if (-1 == dispId) {
                    dispId = this.fetchDispIdFromName(callbackAnnotation);
                }
                if (dispId == -1) {
                    this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + meth.getName() + " not found", null);
                }
                map.put(new OaIdl.DISPID(dispId), meth);
                continue;
            }
            if (callbackAnnotation == null) continue;
            int dispId = callbackAnnotation.dispid();
            if (-1 == dispId) {
                dispId = this.fetchDispIdFromName(callbackAnnotation);
            }
            if (dispId == -1) {
                this.comEventCallbackListener.errorReceivingCallbackEvent("DISPID for " + meth.getName() + " not found", null);
            }
            map.put(new OaIdl.DISPID(dispId), meth);
        }
        return var2_2;
    }

    private int fetchDispIdFromName(ComEventCallback annotation) {
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    void invokeOnThread(OaIdl.DISPID dispIdMember, Guid.REFIID riid, WinDef.LCID lcid, WinDef.WORD wFlags, OleAuto.DISPPARAMS.ByReference pDispParams) {
        int i;
        Variant.VARIANT[] arguments = pDispParams.getArgs();
        Method eventMethod = this.dsipIdMap.get(dispIdMember);
        if (eventMethod == null) {
            this.comEventCallbackListener.errorReceivingCallbackEvent("No method found with dispId = " + dispIdMember, null);
            return;
        }
        OaIdl.DISPID[] positionMap = pDispParams.getRgdispidNamedArgs();
        Class<?>[] paramTypes = eventMethod.getParameterTypes();
        Object[] params = new Object[paramTypes.length];
        for (i = 0; i < params.length && arguments.length - positionMap.length - i > 0; ++i) {
            Class<?> targetClass = paramTypes[i];
            Variant.VARIANT varg = arguments[arguments.length - i - 1];
            params[i] = Convert.toJavaObject(varg, targetClass, this.factory, true, false);
        }
        for (i = 0; i < positionMap.length; ++i) {
            int targetPosition = positionMap[i].intValue();
            if (targetPosition >= params.length) continue;
            Class<?> targetClass = paramTypes[targetPosition];
            Variant.VARIANT varg = arguments[i];
            params[targetPosition] = Convert.toJavaObject(varg, targetClass, this.factory, true, false);
        }
        for (i = 0; i < params.length; ++i) {
            if (params[i] != null || !paramTypes[i].isPrimitive()) continue;
            if (paramTypes[i].equals(Boolean.TYPE)) {
                params[i] = DEFAULT_BOOLEAN;
                continue;
            }
            if (paramTypes[i].equals(Byte.TYPE)) {
                params[i] = DEFAULT_BYTE;
                continue;
            }
            if (paramTypes[i].equals(Short.TYPE)) {
                params[i] = DEFAULT_SHORT;
                continue;
            }
            if (paramTypes[i].equals(Integer.TYPE)) {
                params[i] = DEFAULT_INT;
                continue;
            }
            if (paramTypes[i].equals(Long.TYPE)) {
                params[i] = DEFAULT_LONG;
                continue;
            }
            if (paramTypes[i].equals(Float.TYPE)) {
                params[i] = Float.valueOf(DEFAULT_FLOAT);
                continue;
            }
            if (paramTypes[i].equals(Double.TYPE)) {
                params[i] = DEFAULT_DOUBLE;
                continue;
            }
            throw new IllegalArgumentException("Class type " + paramTypes[i].getName() + " not mapped to primitive default value.");
        }
        try {
            eventMethod.invoke((Object)this.comEventCallbackListener, params);
            return;
        }
        catch (Exception e) {
            void var3_4;
            ArrayList<String> decodedClassNames = new ArrayList<String>(params.length);
            Object[] objectArray = params;
            int n = params.length;
            for (int j = 0; j < n; ++j) {
                void var2_3;
                Object o = objectArray[j];
                if (o == null) {
                    decodedClassNames.add("NULL");
                    continue;
                }
                decodedClassNames.add(var2_3.getClass().getName());
            }
            this.comEventCallbackListener.errorReceivingCallbackEvent("Exception invoking method " + var3_4 + " supplied: " + ((Object)decodedClassNames).toString(), e);
            return;
        }
    }

    @Override
    public Pointer getPointer() {
        return this.dispatchListener.getPointer();
    }

    @Override
    public WinNT.HRESULT GetTypeInfoCount(WinDef.UINTByReference pctinfo) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT GetTypeInfo(WinDef.UINT iTInfo, WinDef.LCID lcid, PointerByReference ppTInfo) {
        return new WinNT.HRESULT(-2147467263);
    }

    @Override
    public WinNT.HRESULT GetIDsOfNames(Guid.REFIID riid, WString[] rgszNames, int cNames, WinDef.LCID lcid, OaIdl.DISPIDByReference rgDispId) {
        return new WinNT.HRESULT(-2147467263);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WinNT.HRESULT Invoke(OaIdl.DISPID dispIdMember, Guid.REFIID riid, WinDef.LCID lcid, WinDef.WORD wFlags, OleAuto.DISPPARAMS.ByReference pDispParams, Variant.VARIANT.ByReference pVarResult, OaIdl.EXCEPINFO.ByReference pExcepInfo, IntByReference puArgErr) {
        void var3_3;
        void var2_2;
        void var1_1;
        assert (COMUtils.comIsInitialized()) : "Assumption about COM threading broken.";
        this.invokeOnThread((OaIdl.DISPID)var1_1, (Guid.REFIID)var2_2, (WinDef.LCID)var3_3, wFlags, pDispParams);
        return WinError.S_OK;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public WinNT.HRESULT QueryInterface(Guid.REFIID refid, PointerByReference ppvObject) {
        void var1_1;
        if (ppvObject == null) {
            return new WinNT.HRESULT(-2147467261);
        }
        if (refid.equals((Object)this.listenedToRiid)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (refid.getValue().equals((Object)Unknown.IID_IUNKNOWN)) {
            ppvObject.setValue(this.getPointer());
            return WinError.S_OK;
        }
        if (var1_1.getValue().equals((Object)Dispatch.IID_IDISPATCH)) {
            void var2_2;
            var2_2.setValue(this.getPointer());
            return WinError.S_OK;
        }
        return new WinNT.HRESULT(-2147467262);
    }

    @Override
    public int AddRef() {
        return 0;
    }

    @Override
    public int Release() {
        return 0;
    }
}

