/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.parser.TokenQueue;
import org.jsoup.select.CombiningEvaluator;
import org.jsoup.select.Evaluator;
import org.jsoup.select.Selector;
import org.jsoup.select.StructuralEvaluator;

public class QueryParser {
    private static final char[] Combinators = new char[]{',', '>', '+', '~', ' '};
    private static final String[] AttributeEvals = new String[]{"=", "!=", "^=", "$=", "*=", "~="};
    private final TokenQueue tq;
    private final String query;
    private final List<Evaluator> evals = new ArrayList<Evaluator>();
    private static final Pattern NTH_AB = Pattern.compile("(([+-])?(\\d+)?)n(\\s*([+-])?\\s*\\d+)?", 2);
    private static final Pattern NTH_B = Pattern.compile("([+-])?(\\d+)");

    /*
     * WARNING - void declaration
     */
    private QueryParser(String query) {
        void var1_1;
        Validate.notEmpty(query);
        this.query = query = query.trim();
        this.tq = new TokenQueue((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static Evaluator parse(String query) {
        try {
            query = new QueryParser((String)query);
            return ((QueryParser)query).parse();
        }
        catch (IllegalArgumentException e) {
            void var0_1;
            throw new Selector.SelectorParseException(var0_1.getMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    Evaluator parse() {
        this.tq.consumeWhitespace();
        if (this.tq.matchesAny(Combinators)) {
            this.evals.add(new StructuralEvaluator.Root());
            QueryParser queryParser = this;
            queryParser.combinator(queryParser.tq.consume());
        } else {
            this.evals.add(this.consumeEvaluator());
        }
        while (!this.tq.isEmpty()) {
            void var1_1;
            boolean seenWhite = this.tq.consumeWhitespace();
            if (this.tq.matchesAny(Combinators)) {
                QueryParser queryParser = this;
                queryParser.combinator(queryParser.tq.consume());
                continue;
            }
            if (var1_1 != false) {
                this.combinator(' ');
                continue;
            }
            this.evals.add(this.consumeEvaluator());
        }
        if (this.evals.size() == 1) {
            return this.evals.get(0);
        }
        return new CombiningEvaluator.And(this.evals);
    }

    /*
     * WARNING - void declaration
     */
    private void combinator(char combinator) {
        Evaluator rootEval;
        Evaluator currentEval;
        this.tq.consumeWhitespace();
        String string = this.consumeSubQuery();
        Evaluator newEval = QueryParser.parse(string);
        boolean replaceRightMost = false;
        if (this.evals.size() == 1) {
            currentEval = this.evals.get(0);
            rootEval = currentEval;
            if (currentEval instanceof CombiningEvaluator.Or && combinator != ',') {
                currentEval = ((CombiningEvaluator.Or)currentEval).rightMostEvaluator();
                assert (currentEval != null);
                replaceRightMost = true;
            }
        } else {
            currentEval = new CombiningEvaluator.And(this.evals);
            rootEval = currentEval;
        }
        this.evals.clear();
        switch (combinator) {
            case '>': {
                StructuralEvaluator.ImmediateParentRun run = currentEval instanceof StructuralEvaluator.ImmediateParentRun ? (StructuralEvaluator.ImmediateParentRun)currentEval : new StructuralEvaluator.ImmediateParentRun(currentEval);
                run.add(newEval);
                currentEval = run;
                break;
            }
            case ' ': {
                currentEval = new CombiningEvaluator.And(new StructuralEvaluator.Parent(currentEval), newEval);
                break;
            }
            case '+': {
                currentEval = new CombiningEvaluator.And(new StructuralEvaluator.ImmediatePreviousSibling(currentEval), newEval);
                break;
            }
            case '~': {
                currentEval = new CombiningEvaluator.And(new StructuralEvaluator.PreviousSibling(currentEval), newEval);
                break;
            }
            case ',': {
                void var1_3;
                CombiningEvaluator.Or or;
                if (currentEval instanceof CombiningEvaluator.Or) {
                    or = (CombiningEvaluator.Or)currentEval;
                } else {
                    or = new CombiningEvaluator.Or();
                    or.add(currentEval);
                }
                or.add(newEval);
                currentEval = var1_3;
                break;
            }
            default: {
                void var1_1;
                throw new Selector.SelectorParseException("Unknown combinator '%s'", Character.valueOf((char)var1_1));
            }
        }
        if (replaceRightMost) {
            ((CombiningEvaluator.Or)rootEval).replaceRightMostEvaluator(currentEval);
        } else {
            void var3_7;
            rootEval = var3_7;
        }
        this.evals.add((Evaluator)((Object)string));
    }

    /*
     * WARNING - void declaration
     */
    private String consumeSubQuery() {
        void var1_1;
        StringBuilder sq = StringUtil.borrowBuilder();
        boolean seenClause = false;
        while (!this.tq.isEmpty()) {
            if (this.tq.matchesAny(Combinators)) {
                if (seenClause) break;
                sq.append(this.tq.consume());
                continue;
            }
            seenClause = true;
            if (this.tq.matches("(")) {
                sq.append("(").append(this.tq.chompBalanced('(', ')')).append(")");
                continue;
            }
            if (this.tq.matches("[")) {
                sq.append("[").append(this.tq.chompBalanced('[', ']')).append("]");
                continue;
            }
            if (this.tq.matches("\\")) {
                sq.append(this.tq.consume());
                if (this.tq.isEmpty()) continue;
                sq.append(this.tq.consume());
                continue;
            }
            sq.append(this.tq.consume());
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    private Evaluator consumeEvaluator() {
        if (this.tq.matchChomp("#")) {
            return this.byId();
        }
        if (this.tq.matchChomp(".")) {
            return this.byClass();
        }
        if (this.tq.matchesWord() || this.tq.matches("*|")) {
            return this.byTag();
        }
        if (this.tq.matches("[")) {
            return this.byAttribute();
        }
        if (this.tq.matchChomp("*")) {
            return new Evaluator.AllElements();
        }
        if (this.tq.matchChomp(":")) {
            return this.parsePseudoSelector();
        }
        throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
    }

    private Evaluator parsePseudoSelector() {
        switch (this.tq.consumeCssIdentifier()) {
            case "lt": {
                return new Evaluator.IndexLessThan(this.consumeIndex());
            }
            case "gt": {
                return new Evaluator.IndexGreaterThan(this.consumeIndex());
            }
            case "eq": {
                return new Evaluator.IndexEquals(this.consumeIndex());
            }
            case "has": {
                return this.has();
            }
            case "is": {
                return this.is();
            }
            case "contains": {
                return this.contains(false);
            }
            case "containsOwn": {
                return this.contains(true);
            }
            case "containsWholeText": {
                return this.containsWholeText(false);
            }
            case "containsWholeOwnText": {
                return this.containsWholeText(true);
            }
            case "containsData": {
                return this.containsData();
            }
            case "matches": {
                return this.matches(false);
            }
            case "matchesOwn": {
                return this.matches(true);
            }
            case "matchesWholeText": {
                return this.matchesWholeText(false);
            }
            case "matchesWholeOwnText": {
                return this.matchesWholeText(true);
            }
            case "not": {
                return this.not();
            }
            case "nth-child": {
                return this.cssNthChild(false, false);
            }
            case "nth-last-child": {
                return this.cssNthChild(true, false);
            }
            case "nth-of-type": {
                return this.cssNthChild(false, true);
            }
            case "nth-last-of-type": {
                return this.cssNthChild(true, true);
            }
            case "first-child": {
                return new Evaluator.IsFirstChild();
            }
            case "last-child": {
                return new Evaluator.IsLastChild();
            }
            case "first-of-type": {
                return new Evaluator.IsFirstOfType();
            }
            case "last-of-type": {
                return new Evaluator.IsLastOfType();
            }
            case "only-child": {
                return new Evaluator.IsOnlyChild();
            }
            case "only-of-type": {
                return new Evaluator.IsOnlyOfType();
            }
            case "empty": {
                return new Evaluator.IsEmpty();
            }
            case "root": {
                return new Evaluator.IsRoot();
            }
            case "matchText": {
                return new Evaluator.MatchText();
            }
        }
        throw new Selector.SelectorParseException("Could not parse query '%s': unexpected token at '%s'", this.query, this.tq.remainder());
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator byId() {
        void var1_1;
        String id = this.tq.consumeCssIdentifier();
        Validate.notEmpty(id);
        return new Evaluator.Id((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator byClass() {
        void var1_1;
        String className = this.tq.consumeCssIdentifier();
        Validate.notEmpty(className);
        return new Evaluator.Class(var1_1.trim());
    }

    private Evaluator byTag() {
        String string;
        String plainTag;
        String tagName = Normalizer.normalize(this.tq.consumeElementSelector());
        Validate.notEmpty(tagName);
        if (tagName.startsWith("*|")) {
            plainTag = tagName.substring(2);
            return new CombiningEvaluator.Or(new Evaluator.Tag(plainTag), new Evaluator.TagEndsWith(":" + plainTag));
        }
        if (plainTag.endsWith("|*")) {
            String ns = plainTag.substring(0, plainTag.length() - 2) + ":";
            return new Evaluator.TagStartsWith(string);
        }
        if (string.contains("|")) {
            string = string.replace("|", ":");
        }
        return new Evaluator.Tag(string);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator byAttribute() {
        void var1_1;
        Evaluator eval;
        TokenQueue cq = new TokenQueue(this.tq.chompBalanced('[', ']'));
        String key = cq.consumeToAny(AttributeEvals);
        Validate.notEmpty(key);
        cq.consumeWhitespace();
        if (cq.isEmpty()) {
            eval = key.startsWith("^") ? new Evaluator.AttributeStarting(key.substring(1)) : (key.equals("*") ? new Evaluator.AttributeStarting("") : new Evaluator.Attribute(key));
        } else if (((TokenQueue)((Object)eval)).matchChomp("=")) {
            eval = new Evaluator.AttributeWithValue(key, ((TokenQueue)((Object)eval)).remainder());
        } else if (((TokenQueue)((Object)eval)).matchChomp("!=")) {
            eval = new Evaluator.AttributeWithValueNot(key, ((TokenQueue)((Object)eval)).remainder());
        } else if (((TokenQueue)((Object)eval)).matchChomp("^=")) {
            eval = new Evaluator.AttributeWithValueStarting(key, ((TokenQueue)((Object)eval)).remainder());
        } else if (((TokenQueue)((Object)eval)).matchChomp("$=")) {
            eval = new Evaluator.AttributeWithValueEnding(key, ((TokenQueue)((Object)eval)).remainder());
        } else if (((TokenQueue)((Object)eval)).matchChomp("*=")) {
            eval = new Evaluator.AttributeWithValueContaining(key, ((TokenQueue)((Object)eval)).remainder());
        } else if (((TokenQueue)((Object)eval)).matchChomp("~=")) {
            void var2_2;
            eval = new Evaluator.AttributeWithValueMatching((String)var2_2, Pattern.compile(((TokenQueue)((Object)eval)).remainder()));
        } else {
            throw new Selector.SelectorParseException("Could not parse attribute query '%s': unexpected token at '%s'", this.query, ((TokenQueue)((Object)eval)).remainder());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator cssNthChild(boolean backwards, boolean ofType) {
        void var1_2;
        void var3_5;
        void eval;
        void var2_3;
        void b;
        void a2;
        int b2;
        int a2;
        String arg = Normalizer.normalize(this.consumeParens());
        Matcher mAB = NTH_AB.matcher(arg);
        Matcher mB = NTH_B.matcher(arg);
        if ("odd".equals(arg)) {
            a2 = 2;
            b2 = 1;
        } else if ("even".equals(a2)) {
            a2 = 2;
            b2 = 0;
        } else if (b.matches()) {
            a2 = b.group(3) != null ? Integer.parseInt(b.group(1).replaceFirst("^\\+", "")) : 1;
            b2 = b.group(4) != null ? Integer.parseInt(b.group(4).replaceFirst("^\\+", "")) : 0;
        } else if (mB.matches()) {
            a2 = 0;
            b2 = Integer.parseInt(mB.group().replaceFirst("^\\+", ""));
        } else {
            throw new Selector.SelectorParseException("Could not parse nth-index '%s': unexpected format", a2);
        }
        Evaluator.CssNthEvaluator eval2 = var2_3 != false ? (backwards ? new Evaluator.IsNthLastOfType(a2, b2) : new Evaluator.IsNthOfType(a2, b2)) : (eval != false ? new Evaluator.IsNthLastChild(a2, b2) : new Evaluator.IsNthChild((int)var3_5, b2));
        return var1_2;
    }

    private String consumeParens() {
        return this.tq.chompBalanced('(', ')');
    }

    /*
     * WARNING - void declaration
     */
    private int consumeIndex() {
        void var1_1;
        String index = this.consumeParens().trim();
        Validate.isTrue(StringUtil.isNumeric(index), "Index must be numeric");
        return Integer.parseInt((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator has() {
        void var1_1;
        String subQuery = this.consumeParens();
        Validate.notEmpty(subQuery, ":has(selector) sub-select must not be empty");
        return new StructuralEvaluator.Has(QueryParser.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator is() {
        void var1_1;
        String subQuery = this.consumeParens();
        Validate.notEmpty(subQuery, ":is(selector) sub-select must not be empty");
        return new StructuralEvaluator.Is(QueryParser.parse((String)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator contains(boolean own) {
        void var3_3;
        void var1_1;
        void var2_2;
        String query = own ? ":containsOwn" : ":contains";
        String searchText = TokenQueue.unescape(this.consumeParens());
        Validate.notEmpty(searchText, (String)var2_2 + "(text) query must not be empty");
        if (var1_1 != false) {
            return new Evaluator.ContainsOwnText(searchText);
        }
        return new Evaluator.ContainsText((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator containsWholeText(boolean own) {
        void var3_3;
        void var1_1;
        void var2_2;
        String query = own ? ":containsWholeOwnText" : ":containsWholeText";
        String searchText = TokenQueue.unescape(this.consumeParens());
        Validate.notEmpty(searchText, (String)var2_2 + "(text) query must not be empty");
        if (var1_1 != false) {
            return new Evaluator.ContainsWholeOwnText(searchText);
        }
        return new Evaluator.ContainsWholeText((String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator containsData() {
        void var1_1;
        String searchText = TokenQueue.unescape(this.consumeParens());
        Validate.notEmpty(searchText, ":containsData(text) query must not be empty");
        return new Evaluator.ContainsData((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator matches(boolean own) {
        void var3_3;
        void var1_1;
        void var2_2;
        String query = own ? ":matchesOwn" : ":matches";
        String regex = this.consumeParens();
        Validate.notEmpty(regex, (String)var2_2 + "(regex) query must not be empty");
        if (var1_1 != false) {
            return new Evaluator.MatchesOwn(Pattern.compile(regex));
        }
        return new Evaluator.Matches(Pattern.compile((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator matchesWholeText(boolean own) {
        void var3_3;
        void var1_1;
        void var2_2;
        String query = own ? ":matchesWholeOwnText" : ":matchesWholeText";
        String regex = this.consumeParens();
        Validate.notEmpty(regex, (String)var2_2 + "(regex) query must not be empty");
        if (var1_1 != false) {
            return new Evaluator.MatchesWholeOwnText(Pattern.compile(regex));
        }
        return new Evaluator.MatchesWholeText(Pattern.compile((String)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    private Evaluator not() {
        void var1_1;
        String subQuery = this.consumeParens();
        Validate.notEmpty(subQuery, ":not(selector) subselect must not be empty");
        return new StructuralEvaluator.Not(QueryParser.parse((String)var1_1));
    }

    public String toString() {
        return this.query;
    }
}

