/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import org.jsoup.helper.Validate;
import org.jsoup.nodes.Node;
import org.jsoup.select.NodeVisitor;

public class NodeTraversor {
    public static void traverse(NodeVisitor visitor, Node root) {
        Validate.notNull(visitor);
        Validate.notNull(root);
        Node node = root;
        int depth = 0;
        while (node != null) {
            Node parent = node.parentNode();
            int origSize = parent != null ? parent.childNodeSize() : 0;
            Node next = node.nextSibling();
            visitor.head(node, depth);
            if (parent != null && !node.hasParent()) {
                if (origSize == parent.childNodeSize()) {
                    node = parent.childNode(node.siblingIndex());
                } else {
                    node = next;
                    if (node != null) continue;
                    node = parent;
                    --depth;
                    continue;
                }
            }
            if (node.childNodeSize() > 0) {
                node = node.childNode(0);
                ++depth;
                continue;
            }
            while (true) {
                assert (node != null);
                if (node.nextSibling() != null || depth <= 0) break;
                visitor.tail(node, depth);
                node = node.parentNode();
                --depth;
            }
            visitor.tail(node, depth);
            if (node == root) break;
            node = node.nextSibling();
        }
    }
}

