/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.select;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.select.Selector;

public class Elements
extends ArrayList<Element> {
    public Elements() {
    }

    /*
     * WARNING - void declaration
     */
    public Elements(int initialCapacity) {
        super((int)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Elements(List<Element> elements) {
        super(var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Elements clone() {
        void var1_1;
        Elements clone = new Elements(this.size());
        for (Element e : this) {
            void var3_3;
            clone.add(var3_3.clone());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String attr(String attributeKey) {
        for (Element element : this) {
            void var3_3;
            if (!element.hasAttr(attributeKey)) continue;
            return var3_3.attr(attributeKey);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    public String text() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Element element : this) {
            void var3_3;
            if (sb.length() != 0) {
                sb.append(" ");
            }
            sb.append(var3_3.text());
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String outerHtml() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        for (Element element : this) {
            void var3_3;
            if (sb.length() != 0) {
                sb.append("\n");
            }
            sb.append(var3_3.outerHtml());
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    @Override
    public String toString() {
        return this.outerHtml();
    }

    public Elements remove() {
        for (Element element : this) {
            element.remove();
        }
        return this;
    }

    public Elements select(String query) {
        return Selector.select(query, this);
    }

    public Element last() {
        if (this.isEmpty()) {
            return null;
        }
        Elements elements = this;
        return (Element)elements.get(elements.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element set(int index, Element element) {
        void var1_2;
        void var2_3;
        Validate.notNull(element);
        Element old = super.set(index, element);
        old.replaceWith((Node)var2_3);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element remove(int index) {
        void var1_2;
        Element old = (Element)super.remove(index);
        old.remove();
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object o) {
        void var1_2;
        int index = super.indexOf(o);
        if (index == -1) {
            return false;
        }
        this.remove((int)var1_2);
        return true;
    }

    @Override
    public void clear() {
        this.remove();
        super.clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        void var2_2;
        Iterator iterator;
        boolean anyRemoved = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object o = iterator.next();
            anyRemoved |= this.remove(var3_3);
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        void var2_2;
        boolean anyRemoved = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (c.contains(el)) continue;
            it.remove();
            anyRemoved = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeIf(Predicate<? super Element> filter) {
        void var2_2;
        boolean anyRemoved = false;
        Iterator it = this.iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            if (!filter.test(el)) continue;
            it.remove();
            anyRemoved = true;
        }
        return (boolean)var2_2;
    }

    @Override
    public void replaceAll(UnaryOperator<Element> operator) {
        for (int i = 0; i < this.size(); ++i) {
            this.set(i, (Element)operator.apply((Element)this.get(i)));
        }
    }
}

