/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import java.io.Reader;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.LeafNode;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.parser.Token;
import org.jsoup.parser.TreeBuilder;

public class XmlTreeBuilder
extends TreeBuilder {
    @Override
    ParseSettings defaultSettings() {
        return ParseSettings.preserveCase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initialiseParse(Reader input, String baseUri, Parser parser) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.initialiseParse((Reader)var1_1, (String)var2_2, (Parser)var3_3);
        this.doc.outputSettings().syntax(Document.OutputSettings.Syntax.xml).escapeMode(Entities.EscapeMode.xhtml).prettyPrint(false);
    }

    @Override
    public String defaultNamespace() {
        return "http://www.w3.org/XML/1998/namespace";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean process(Token token) {
        this.currentToken = token;
        switch (token.type) {
            case StartTag: {
                this.insertElementFor(token.asStartTag());
                break;
            }
            case EndTag: {
                this.popStackToClose(token.asEndTag());
                break;
            }
            case Comment: {
                this.insertCommentFor(token.asComment());
                break;
            }
            case Character: {
                this.insertCharacterFor(token.asCharacter());
                break;
            }
            case Doctype: {
                this.insertDoctypeFor(token.asDoctype());
                break;
            }
            case EOF: {
                break;
            }
            default: {
                void var1_1;
                Validate.fail("Unexpected token type: " + (Object)((Object)var1_1.type));
            }
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    void insertElementFor(Token.StartTag startTag) {
        void var1_1;
        void var3_3;
        Tag tag = this.tagFor(startTag.name(), this.settings);
        if (startTag.attributes != null) {
            startTag.attributes.deduplicate(this.settings);
        }
        Element el = new Element(tag, null, this.settings.normalizeAttributes(startTag.attributes));
        this.currentElement().appendChild(el);
        this.push((Element)var3_3);
        if (var1_1.isSelfClosing()) {
            void var2_2;
            var2_2.setSelfClosing();
            this.pop();
        }
    }

    /*
     * WARNING - void declaration
     */
    void insertLeafNode(LeafNode node) {
        void var1_1;
        this.currentElement().appendChild(node);
        this.onNodeInserted((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void insertCommentFor(Token.Comment commentToken) {
        void var3_3;
        void var2_2;
        XmlDeclaration decl;
        Comment comment;
        Comment insert = comment = new Comment(commentToken.getData());
        if (commentToken.bogus && comment.isXmlDeclaration() && (decl = var2_2.asXmlDeclaration()) != null) {
            void var1_1;
            insert = var1_1;
        }
        this.insertLeafNode((LeafNode)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    void insertCharacterFor(Token.Character token) {
        void var2_2;
        void var1_1;
        String data = token.getData();
        this.insertLeafNode(var1_1.isCData() ? new CDataNode(data) : new TextNode((String)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    void insertDoctypeFor(Token.Doctype token) {
        void var2_2;
        void var1_1;
        DocumentType doctypeNode = new DocumentType(this.settings.normalizeTag(token.getName()), token.getPublicIdentifier(), token.getSystemIdentifier());
        doctypeNode.setPubSysKey(var1_1.getPubSysKey());
        this.insertLeafNode((LeafNode)var2_2);
    }

    protected void popStackToClose(Token.EndTag endTag) {
        Element element;
        int pos;
        String elName = this.settings.normalizeTag(endTag.tagName);
        Element firstFound = null;
        int bottom = this.stack.size() - 1;
        int upper = bottom >= 256 ? bottom - 256 : 0;
        for (pos = this.stack.size() - 1; pos >= upper; --pos) {
            Element next = this.stack.get(pos);
            if (!((Node)next).nodeName().equals(elName)) continue;
            firstFound = next;
            break;
        }
        if (firstFound == null) {
            return;
        }
        for (pos = this.stack.size() - 1; pos >= 0 && (element = this.pop()) != firstFound; --pos) {
        }
    }
}

