/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.parser;

import org.jsoup.helper.Validate;
import org.jsoup.internal.StringUtil;

public class TokenQueue {
    private String queue;
    private int pos = 0;
    private static final String[] ElementSelectorChars = new String[]{"*", "|", "_", "-"};
    private static final String[] CssIdentifierChars = new String[]{"-", "_"};

    /*
     * WARNING - void declaration
     */
    public TokenQueue(String data) {
        void var1_1;
        Validate.notNull(data);
        this.queue = var1_1;
    }

    public boolean isEmpty() {
        return this.remainingLength() == 0;
    }

    private int remainingLength() {
        return this.queue.length() - this.pos;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matches(String seq) {
        void var1_1;
        return this.queue.regionMatches(true, this.pos, seq, 0, var1_1.length());
    }

    public boolean matchesAny(String ... seq) {
        String[] stringArray = seq;
        int n = seq.length;
        for (int i = 0; i < n; ++i) {
            String s = stringArray[i];
            if (!this.matches(s)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchesAny(char ... seq) {
        void var1_1;
        if (this.isEmpty()) {
            return false;
        }
        for (void c : var1_1) {
            if (this.queue.charAt(this.pos) != c) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean matchChomp(String seq) {
        if (this.matches(seq)) {
            void var1_1;
            this.pos += var1_1.length();
            return true;
        }
        return false;
    }

    public boolean matchesWhitespace() {
        return !this.isEmpty() && StringUtil.isWhitespace(this.queue.charAt(this.pos));
    }

    public boolean matchesWord() {
        return !this.isEmpty() && Character.isLetterOrDigit(this.queue.charAt(this.pos));
    }

    public char consume() {
        return this.queue.charAt(this.pos++);
    }

    /*
     * WARNING - void declaration
     */
    public String consumeToAny(String ... seq) {
        void var2_2;
        int start = this.pos;
        while (!this.isEmpty() && !this.matchesAny(seq)) {
            ++this.pos;
        }
        return this.queue.substring((int)var2_2, this.pos);
    }

    /*
     * WARNING - void declaration
     */
    public String chompBalanced(char open, char close) {
        void var3_3;
        String out;
        int start = -1;
        int end = -1;
        int depth = 0;
        int last = 0;
        boolean inSingleQuote = false;
        boolean inDoubleQuote = false;
        boolean inRegexQE = false;
        while (!this.isEmpty()) {
            block15: {
                char c;
                block16: {
                    block13: {
                        block14: {
                            c = this.consume();
                            if (last == 92) break block13;
                            if (c == '\'' && c != open && !inDoubleQuote) {
                                inSingleQuote = !inSingleQuote;
                            } else if (c == '\"' && c != open && !inSingleQuote) {
                                boolean bl = inDoubleQuote = !inDoubleQuote;
                            }
                            if (!inSingleQuote && !inDoubleQuote && !inRegexQE) break block14;
                            last = c;
                            break block15;
                        }
                        if (c == open) {
                            ++depth;
                            if (start == -1) {
                                start = this.pos;
                            }
                        } else if (c == close) {
                            --depth;
                        }
                        break block16;
                    }
                    if (c == 'Q') {
                        inRegexQE = true;
                    } else if (c == 'E') {
                        inRegexQE = false;
                    }
                }
                if (depth > 0 && last != 0) {
                    end = this.pos;
                }
                last = c;
            }
            if (depth > 0) continue;
        }
        String string = out = end >= 0 ? this.queue.substring((int)var3_3, end) : "";
        if (depth > 0) {
            Validate.fail("Did not find balanced marker at '" + out + "'");
        }
        return out;
    }

    /*
     * WARNING - void declaration
     */
    public static String unescape(String in) {
        void var1_1;
        Object object;
        StringBuilder out = StringUtil.borrowBuilder();
        Object last = 0;
        char[] cArray = ((String)object).toCharArray();
        object = cArray;
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            Object c = object[i];
            if (c == 92) {
                if (last == 92) {
                    out.append((char)c);
                    c = false;
                }
            } else {
                out.append((char)c);
            }
            last = c;
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean consumeWhitespace() {
        void var1_1;
        boolean seen = false;
        while (this.matchesWhitespace()) {
            ++this.pos;
            seen = true;
        }
        return (boolean)var1_1;
    }

    public String consumeElementSelector() {
        return this.consumeEscapedCssIdentifier(ElementSelectorChars);
    }

    public String consumeCssIdentifier() {
        return this.consumeEscapedCssIdentifier(CssIdentifierChars);
    }

    /*
     * WARNING - void declaration
     */
    private String consumeEscapedCssIdentifier(String ... matches) {
        void var1_1;
        void var3_3;
        void var2_2;
        int start = this.pos;
        boolean escaped = false;
        while (!this.isEmpty()) {
            if (this.queue.charAt(this.pos) == '\\' && this.remainingLength() > 1) {
                escaped = true;
                this.pos += 2;
                continue;
            }
            if (!this.matchesCssIdentifier(matches)) break;
            ++this.pos;
        }
        String consumed = this.queue.substring((int)var2_2, this.pos);
        if (var3_3 != false) {
            return TokenQueue.unescape(consumed);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean matchesCssIdentifier(String ... matches) {
        void var1_1;
        return this.matchesWord() || this.matchesAny((String[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String remainder() {
        void var1_1;
        String remainder = this.queue.substring(this.pos);
        this.pos = this.queue.length();
        return var1_1;
    }

    public String toString() {
        return this.queue.substring(this.pos);
    }
}

