/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jsoup.helper.Validate;
import org.jsoup.nodes.Node;

public class NodeIterator<T extends Node>
implements Iterator<T> {
    private Node root;
    private T next;
    private Node current;
    private Node previous;
    private Node currentParent;
    private final Class<T> type;

    /*
     * WARNING - void declaration
     */
    public NodeIterator(Node start, Class<T> type) {
        void var1_1;
        void var2_2;
        Validate.notNull(start);
        Validate.notNull(type);
        this.type = var2_2;
        this.restart((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void restart(Node start) {
        void var1_1;
        if (this.type.isInstance(start)) {
            this.next = start;
        }
        NodeIterator nodeIterator = this;
        nodeIterator.previous = this.current = var1_1;
        nodeIterator.root = this.current;
        this.currentParent = this.current.parent();
    }

    @Override
    public boolean hasNext() {
        this.maybeFindNext();
        return this.next != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public T next() {
        void var1_1;
        this.maybeFindNext();
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        T result = this.next;
        this.previous = this.current;
        this.current = this.next;
        this.currentParent = this.current.parent();
        this.next = null;
        return var1_1;
    }

    private void maybeFindNext() {
        if (this.next != null) {
            return;
        }
        if (this.currentParent != null && !this.current.hasParent()) {
            this.current = this.previous;
        }
        this.next = this.findNextNode();
    }

    /*
     * WARNING - void declaration
     */
    private T findNextNode() {
        void var1_1;
        Node node = this.current;
        do {
            if (node.childNodeSize() > 0) {
                node = node.childNode(0);
            } else if (this.root.equals(node)) {
                node = null;
            } else if (node.nextSibling() != null) {
                node = node.nextSibling();
            } else {
                do {
                    if ((node = node.parent()) != null && !this.root.equals(node)) continue;
                    return null;
                } while (node.nextSibling() == null);
                node = node.nextSibling();
            }
            if (node != null) continue;
            return null;
        } while (!this.type.isInstance(node));
        return var1_1;
    }

    @Override
    public void remove() {
        this.current.remove();
    }
}

