/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jsoup.helper.ChangeNotifyingArrayList;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.CDataNode;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.NodeUtils;
import org.jsoup.nodes.Range;
import org.jsoup.nodes.TextNode;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Tag;
import org.jsoup.select.Collector;
import org.jsoup.select.Elements;
import org.jsoup.select.Evaluator;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;
import org.jsoup.select.Selector;

public class Element
extends Node {
    private static final List<Element> EmptyChildren = Collections.emptyList();
    private static final Pattern ClassSplit = Pattern.compile("\\s+");
    private static final String BaseUriKey = Attributes.internalKey("baseUri");
    private Tag tag;
    private WeakReference<List<Element>> shadowChildrenRef;
    List<Node> childNodes;
    Attributes attributes;

    /*
     * WARNING - void declaration
     */
    public Element(String tag) {
        this(Tag.valueOf((String)var1_1, "http://www.w3.org/1999/xhtml", ParseSettings.preserveCase), "", null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element(Tag tag, String baseUri, Attributes attributes) {
        void var1_1;
        void var3_3;
        Validate.notNull(tag);
        this.childNodes = EmptyNodes;
        this.attributes = var3_3;
        this.tag = var1_1;
        if (baseUri != null) {
            void var2_2;
            this.setBaseUri((String)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Element(Tag tag, String baseUri) {
        this((Tag)var1_1, (String)var2_2, null);
        void var2_2;
        void var1_1;
    }

    @Override
    protected List<Node> ensureChildNodes() {
        if (this.childNodes == EmptyNodes) {
            this.childNodes = new NodeList(this, 4);
        }
        return this.childNodes;
    }

    @Override
    protected boolean hasAttributes() {
        return this.attributes != null;
    }

    @Override
    public Attributes attributes() {
        if (this.attributes == null) {
            this.attributes = new Attributes();
        }
        return this.attributes;
    }

    @Override
    public String baseUri() {
        return Element.searchUpForAttribute(this, BaseUriKey);
    }

    private static String searchUpForAttribute(Element start, String key) {
        for (Element el = start; el != null; el = el.parent()) {
            if (el.attributes == null || !el.attributes.hasKey(key)) continue;
            return el.attributes.get(key);
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void doSetBaseUri(String baseUri) {
        void var1_1;
        ((Node)this).attributes().put(BaseUriKey, (String)var1_1);
    }

    @Override
    public int childNodeSize() {
        return this.childNodes.size();
    }

    @Override
    public String nodeName() {
        return this.tag.getName();
    }

    public String tagName() {
        return this.tag.getName();
    }

    @Override
    public String normalName() {
        return this.tag.normalName();
    }

    /*
     * WARNING - void declaration
     */
    public boolean elementIs(String normalName, String namespace) {
        void var2_2;
        void var1_1;
        return this.tag.normalName().equals(var1_1) && this.tag.namespace().equals(var2_2);
    }

    public Tag tag() {
        return this.tag;
    }

    public boolean isBlock() {
        return this.tag.isBlock();
    }

    public String id() {
        if (this.attributes != null) {
            return this.attributes.getIgnoreCase("id");
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element attr(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        super.attr((String)var1_1, (String)var2_2);
        return this;
    }

    @Override
    public final Element parent() {
        return (Element)this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public Element child(int index) {
        void var1_1;
        return this.childElementsList().get((int)var1_1);
    }

    public int childrenSize() {
        return this.childElementsList().size();
    }

    public Elements children() {
        return new Elements(this.childElementsList());
    }

    /*
     * WARNING - void declaration
     */
    List<Element> childElementsList() {
        void var1_1;
        ArrayList<Element> children;
        if (((Node)this).childNodeSize() == 0) {
            return EmptyChildren;
        }
        if (this.shadowChildrenRef == null || (children = (ArrayList<Element>)this.shadowChildrenRef.get()) == null) {
            int size = this.childNodes.size();
            children = new ArrayList<Element>(size);
            for (int i = 0; i < size; ++i) {
                Node node = this.childNodes.get(i);
                if (!(node instanceof Element)) continue;
                children.add((Element)node);
            }
            this.shadowChildrenRef = new WeakReference(children);
        }
        return var1_1;
    }

    @Override
    void nodelistChanged() {
        super.nodelistChanged();
        this.shadowChildrenRef = null;
    }

    public Stream<Element> stream() {
        return NodeUtils.stream(this, Element.class);
    }

    /*
     * WARNING - void declaration
     */
    private <T> List<T> filterNodes(Class<T> clazz) {
        void var1_1;
        return this.childNodes.stream().filter(clazz::isInstance).map(((Class)var1_1)::cast).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    public List<TextNode> textNodes() {
        return this.filterNodes(TextNode.class);
    }

    public Elements select(String cssQuery) {
        return Selector.select(cssQuery, this);
    }

    public Elements select(Evaluator evaluator) {
        return Selector.select(evaluator, this);
    }

    public Element selectFirst(String cssQuery) {
        return Selector.selectFirst(cssQuery, this);
    }

    /*
     * WARNING - void declaration
     */
    public Element appendChild(Node child) {
        void var1_1;
        Validate.notNull(child);
        this.reparentChild(child);
        this.ensureChildNodes();
        this.childNodes.add(child);
        var1_1.setSiblingIndex(this.childNodes.size() - 1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element appendChildren(Collection<? extends Node> children) {
        void var1_1;
        this.insertChildren(-1, (Collection<? extends Node>)var1_1);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element prependChild(Node child) {
        void var1_1;
        Validate.notNull(child);
        this.addChildren(0, new Node[]{var1_1});
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element insertChildren(int index, Collection<? extends Node> children) {
        void var2_2;
        void var1_1;
        void var3_3;
        Validate.notNull(children, "Children collection to be inserted must not be null.");
        int currentSize = ((Node)this).childNodeSize();
        if (index < 0) {
            index += currentSize + 1;
        }
        Validate.isTrue(index >= 0 && index <= var3_3, "Insert position out of bounds.");
        children = new ArrayList<Node>(children);
        Node[] nodeArray = ((ArrayList)children).toArray(new Node[0]);
        this.addChildren((int)var1_1, (Node[])var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Element appendElement(String tagName) {
        void var1_1;
        return this.appendElement((String)var1_1, this.tag.namespace());
    }

    /*
     * WARNING - void declaration
     */
    public Element appendElement(String tagName, String namespace) {
        void var1_1;
        void var2_2;
        Element child = new Element(Tag.valueOf(tagName, (String)var2_2, NodeUtils.parser(this).settings()), ((Node)this).baseUri());
        this.appendChild(child);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Element prependElement(String tagName) {
        void var1_1;
        return this.prependElement((String)var1_1, this.tag.namespace());
    }

    /*
     * WARNING - void declaration
     */
    public Element prependElement(String tagName, String namespace) {
        void var1_1;
        void var2_2;
        Element child = new Element(Tag.valueOf(tagName, (String)var2_2, NodeUtils.parser(this).settings()), ((Node)this).baseUri());
        this.prependChild(child);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element before(Node node) {
        void var1_1;
        return (Element)super.before((Node)var1_1);
    }

    @Override
    public Element empty() {
        for (Node node : this.childNodes) {
            var1_1.next().parentNode = null;
        }
        this.childNodes.clear();
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Elements siblingElements() {
        void var2_2;
        Iterator iterator;
        if (this.parentNode == null) {
            return new Elements(0);
        }
        List<Element> elements = this.parent().childElementsList();
        Elements siblings = new Elements(elements.size() - 1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Element el = (Element)iterator.next();
            if (el == this) continue;
            siblings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Element nextElementSibling() {
        Node next = this;
        while ((next = next.nextSibling()) != null) {
            void var1_1;
            if (!(next instanceof Element)) continue;
            return (Element)var1_1;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Element previousElementSibling() {
        Node prev = this;
        while ((prev = prev.previousSibling()) != null) {
            void var1_1;
            if (!(prev instanceof Element)) continue;
            return (Element)var1_1;
        }
        return null;
    }

    public Element firstElementSibling() {
        if (this.parent() != null) {
            return this.parent().firstElementChild();
        }
        return this;
    }

    public int elementSiblingIndex() {
        if (this.parent() == null) {
            return 0;
        }
        Element element = this;
        return Element.indexInList(element, element.parent().childElementsList());
    }

    private static <E extends Element> int indexInList(Element search, List<E> elements) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            if (elements.get(i) != search) continue;
            return i;
        }
        return 0;
    }

    public Element firstElementChild() {
        for (Node child = this.firstChild(); child != null; child = child.nextSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    public Element lastElementChild() {
        for (Node child = this.lastChild(); child != null; child = child.previousSibling()) {
            if (!(child instanceof Element)) continue;
            return (Element)child;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByTag(String tagName) {
        void var1_1;
        Validate.notEmpty(tagName);
        tagName = Normalizer.normalize(tagName);
        return Collector.collect(new Evaluator.Tag((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public Elements getElementsByClass(String className) {
        void var1_1;
        Validate.notEmpty(className);
        return Collector.collect(new Evaluator.Class((String)var1_1), this);
    }

    /*
     * WARNING - void declaration
     */
    public String text() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        NodeTraversor.traverse(new TextAccumulator(accum), this);
        return StringUtil.releaseBuilder((StringBuilder)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    public String wholeText() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        this.nodeStream().forEach(node -> {
            StringBuilder stringBuilder;
            Element.appendWholeText(node, stringBuilder);
        });
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static void appendWholeText(Node node, StringBuilder accum) {
        Node node2;
        if (node instanceof TextNode) {
            accum.append(((TextNode)node).getWholeText());
            return;
        }
        if (node2.nameIs("br")) {
            void var1_1;
            var1_1.append("\n");
        }
    }

    /*
     * WARNING - void declaration
     */
    public String wholeOwnText() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        int size = ((Node)this).childNodeSize();
        for (int i = 0; i < size; ++i) {
            Node node = this.childNodes.get(i);
            Element.appendWholeText(node, accum);
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String ownText() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        this.ownText(sb);
        return StringUtil.releaseBuilder((StringBuilder)var1_1).trim();
    }

    /*
     * WARNING - void declaration
     */
    private void ownText(StringBuilder accum) {
        for (int i = 0; i < ((Node)this).childNodeSize(); ++i) {
            void var3_3;
            Node child = this.childNodes.get(i);
            if (child instanceof TextNode) {
                TextNode textNode = (TextNode)child;
                Element.appendNormalisedText(accum, (TextNode)var3_3);
                continue;
            }
            if (!var3_3.nameIs("br") || TextNode.lastCharIsWhitespace(accum)) continue;
            accum.append(" ");
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void appendNormalisedText(StringBuilder accum, TextNode textNode) {
        StringBuilder stringBuilder;
        void var2_2;
        void var1_1;
        String text = textNode.getWholeText();
        if (Element.preserveWhitespace(textNode.parentNode) || var1_1 instanceof CDataNode) {
            accum.append(text);
            return;
        }
        StringUtil.appendNormalisedWhitespace(accum, (String)var2_2, TextNode.lastCharIsWhitespace(stringBuilder));
    }

    static boolean preserveWhitespace(Node node) {
        if (node instanceof Element) {
            Node el = (Element)node;
            int i = 0;
            do {
                if (((Element)el).tag.preserveWhitespace()) {
                    return true;
                }
                el = ((Element)el).parent();
            } while (++i < 6 && el != null);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public String data() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        this.traverse((childNode, depth) -> {
            Comment comment;
            DataNode data;
            if (childNode instanceof DataNode) {
                data = (DataNode)childNode;
                sb.append(data.getWholeData());
                return;
            }
            if (data instanceof Comment) {
                comment = (Comment)((Object)data);
                sb.append(comment.getData());
                return;
            }
            if (comment instanceof CDataNode) {
                void var1_1;
                StringBuilder stringBuilder;
                CDataNode cDataNode = (CDataNode)((Object)comment);
                stringBuilder.append(var1_1.getWholeText());
            }
        });
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasClass(String className) {
        void var3_3;
        if (this.attributes == null) {
            return false;
        }
        String classAttr = this.attributes.getIgnoreCase("class");
        int len = classAttr.length();
        int wantLen = className.length();
        if (len == 0 || len < wantLen) {
            return false;
        }
        if (len == wantLen) {
            return className.equalsIgnoreCase(classAttr);
        }
        boolean inClass = false;
        int start = 0;
        for (int i = 0; i < len; ++i) {
            if (Character.isWhitespace(classAttr.charAt(i))) {
                if (!inClass) continue;
                if (i - start == wantLen && classAttr.regionMatches(true, start, className, 0, wantLen)) {
                    return true;
                }
                inClass = false;
                continue;
            }
            if (inClass) continue;
            inClass = true;
            start = i;
        }
        if (inClass && var3_3 - start == wantLen) {
            void var1_1;
            void var2_2;
            return var2_2.regionMatches(true, start, (String)var1_1, 0, wantLen);
        }
        return false;
    }

    public Range endSourceRange() {
        return Range.of(this, false);
    }

    /*
     * WARNING - void declaration
     */
    boolean shouldIndent(Document.OutputSettings out) {
        void var1_1;
        return out.prettyPrint() && this.isFormatAsBlock(out) && !this.isInlineable((Document.OutputSettings)var1_1) && !Element.preserveWhitespace(this.parentNode);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlHead(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        void var1_1;
        if (this.shouldIndent(out) && (!(accum instanceof StringBuilder) || ((StringBuilder)accum).length() > 0)) {
            void var2_2;
            this.indent(accum, (int)var2_2, out);
        }
        accum.append('<').append(this.tagName());
        if (this.attributes != null) {
            this.attributes.html(accum, out);
        }
        if (this.childNodes.isEmpty() && this.tag.isSelfClosing()) {
            void var3_3;
            if (var3_3.syntax() == Document.OutputSettings.Syntax.html && this.tag.isEmpty()) {
                accum.append('>');
                return;
            }
            accum.append(" />");
            return;
        }
        var1_1.append('>');
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void outerHtmlTail(Appendable accum, int depth, Document.OutputSettings out) throws IOException {
        if (!this.childNodes.isEmpty() || !this.tag.isSelfClosing()) {
            void var1_1;
            if (out.prettyPrint() && !this.childNodes.isEmpty() && (this.tag.formatAsBlock() && !Element.preserveWhitespace(this.parentNode) || out.outline() && (this.childNodes.size() > 1 || this.childNodes.size() == 1 && this.childNodes.get(0) instanceof Element))) {
                void var3_3;
                void var2_2;
                this.indent(accum, (int)var2_2, (Document.OutputSettings)var3_3);
            }
            var1_1.append("</").append(this.tagName()).append('>');
        }
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder accum = StringUtil.borrowBuilder();
        ((Node)this).html(accum);
        String html = StringUtil.releaseBuilder(accum);
        if (NodeUtils.outputSettings(this).prettyPrint()) {
            return html.trim();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T extends Appendable> T html(T appendable) {
        void var1_1;
        int size = this.childNodes.size();
        for (int i = 0; i < size; ++i) {
            this.childNodes.get(i).outerHtml(appendable);
        }
        return var1_1;
    }

    @Override
    public Element clone() {
        return (Element)super.clone();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Element doClone(Node parent) {
        void var1_1;
        Element clone = (Element)super.doClone(parent);
        ((Element)super.doClone(parent)).attributes = this.attributes != null ? this.attributes.clone() : null;
        clone.childNodes = new NodeList(clone, this.childNodes.size());
        clone.childNodes.addAll(this.childNodes);
        return var1_1;
    }

    @Override
    public Element root() {
        return (Element)super.root();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Element traverse(NodeVisitor nodeVisitor) {
        void var1_1;
        return (Element)super.traverse((NodeVisitor)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isFormatAsBlock(Document.OutputSettings out) {
        void var1_1;
        return this.tag.isBlock() || this.parent() != null && this.parent().tag().formatAsBlock() || var1_1.outline();
    }

    /*
     * WARNING - void declaration
     */
    private boolean isInlineable(Document.OutputSettings out) {
        void var1_1;
        if (!this.tag.isInline()) {
            return false;
        }
        return (this.parent() == null || this.parent().isBlock()) && !this.isEffectivelyFirst() && !var1_1.outline() && !this.nameIs("br");
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$000(StringBuilder x0, TextNode x1) {
        void var1_1;
        Element.appendNormalisedText(x0, (TextNode)var1_1);
    }

    private static final class NodeList
    extends ChangeNotifyingArrayList<Node> {
        private final Element owner;

        /*
         * WARNING - void declaration
         */
        NodeList(Element owner, int initialCapacity) {
            super((int)var2_2);
            void var1_1;
            void var2_2;
            this.owner = var1_1;
        }

        @Override
        public final void onContentsChanged() {
            this.owner.nodelistChanged();
        }
    }

    private static class TextAccumulator
    implements NodeVisitor {
        private final StringBuilder accum;

        /*
         * WARNING - void declaration
         */
        public TextAccumulator(StringBuilder accum) {
            void var1_1;
            this.accum = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void head(Node node, int depth) {
            TextNode textNode;
            if (node instanceof TextNode) {
                textNode = (TextNode)node;
                Element.access$000(this.accum, textNode);
                return;
            }
            if (textNode instanceof Element) {
                void var1_1;
                Element element = (Element)((Object)textNode);
                if (this.accum.length() > 0 && (element.isBlock() || var1_1.nameIs("br")) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void tail(Node node, int depth) {
            if (node instanceof Element) {
                void var1_1;
                void var2_3;
                Element element = (Element)node;
                Node next = node.nextSibling();
                if (var2_3.isBlock() && (next instanceof TextNode || next instanceof Element && !((Element)var1_1).tag.formatAsBlock()) && !TextNode.lastCharIsWhitespace(this.accum)) {
                    this.accum.append(' ');
                }
            }
        }
    }
}

