/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import org.jsoup.helper.DataUtil;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.ParseSettings;
import org.jsoup.parser.Parser;
import org.jsoup.parser.Tag;
import org.jsoup.select.Evaluator;

public class Document
extends Element {
    private OutputSettings outputSettings = new OutputSettings();
    private Parser parser;
    private QuirksMode quirksMode = QuirksMode.noQuirks;
    private final String location;
    private boolean updateMetaCharset = false;
    private static final Evaluator titleEval = new Evaluator.Tag("title");

    /*
     * WARNING - void declaration
     */
    public Document(String namespace, String baseUri) {
        super(Tag.valueOf("#root", (String)var1_1, ParseSettings.htmlDefault), baseUri);
        void var2_2;
        void var1_1;
        this.location = var2_2;
        this.parser = Parser.htmlParser();
    }

    /*
     * WARNING - void declaration
     */
    public Document(String baseUri) {
        this("http://www.w3.org/1999/xhtml", (String)var1_1);
        void var1_1;
    }

    private Element htmlEl() {
        for (Element el = this.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("html")) continue;
            return el;
        }
        return this.appendElement("html");
    }

    /*
     * WARNING - void declaration
     */
    public Element head() {
        void var1_1;
        Element html = this.htmlEl();
        for (Element el = html.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("head")) continue;
            return el;
        }
        return var1_1.prependElement("head");
    }

    /*
     * WARNING - void declaration
     */
    public Element body() {
        void var1_1;
        Element html = this.htmlEl();
        for (Element el = html.firstElementChild(); el != null; el = el.nextElementSibling()) {
            if (!el.nameIs("body") && !el.nameIs("frameset")) continue;
            return el;
        }
        return var1_1.appendElement("body");
    }

    @Override
    public String outerHtml() {
        return super.html();
    }

    @Override
    public String nodeName() {
        return "#document";
    }

    /*
     * WARNING - void declaration
     */
    public void charset(Charset charset) {
        void var1_1;
        this.updateMetaCharsetElement(true);
        this.outputSettings.charset((Charset)var1_1);
        this.ensureMetaCharsetElement();
    }

    public Charset charset() {
        return this.outputSettings.charset();
    }

    /*
     * WARNING - void declaration
     */
    public void updateMetaCharsetElement(boolean update) {
        void var1_1;
        this.updateMetaCharset = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Document clone() {
        void var1_1;
        Document clone = (Document)super.clone();
        ((Document)super.clone()).outputSettings = this.outputSettings.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Document shallowClone() {
        void var1_1;
        Document clone = new Document(this.tag().namespace(), ((Node)this).baseUri());
        if (this.attributes != null) {
            clone.attributes = this.attributes.clone();
        }
        clone.outputSettings = this.outputSettings.clone();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void ensureMetaCharsetElement() {
        block3: {
            void var1_1;
            XmlDeclaration decl;
            block4: {
                block6: {
                    block5: {
                        Element metaCharset;
                        if (!this.updateMetaCharset) break block3;
                        OutputSettings.Syntax syntax = this.outputSettings().syntax();
                        if (syntax == OutputSettings.Syntax.html) {
                            metaCharset = this.selectFirst("meta[charset]");
                            if (metaCharset != null) {
                                metaCharset.attr("charset", this.charset().displayName());
                            } else {
                                this.head().appendElement("meta").attr("charset", this.charset().displayName());
                            }
                            this.select("meta[name=charset]").remove();
                            return;
                        }
                        if (metaCharset != OutputSettings.Syntax.xml) break block3;
                        Node node = this.ensureChildNodes().get(0);
                        if (!(node instanceof XmlDeclaration)) break block4;
                        decl = (XmlDeclaration)node;
                        if (!decl.name().equals("xml")) break block5;
                        ((Node)decl).attr("encoding", this.charset().displayName());
                        if (!((Node)decl).hasAttr("version")) break block6;
                        ((Node)decl).attr("version", "1.0");
                        break block3;
                    }
                    decl = new XmlDeclaration("xml", false);
                    ((Node)decl).attr("version", "1.0");
                    ((Node)decl).attr("encoding", this.charset().displayName());
                    this.prependChild(decl);
                }
                return;
            }
            decl = new XmlDeclaration("xml", false);
            ((Node)decl).attr("version", "1.0");
            ((Node)decl).attr("encoding", this.charset().displayName());
            this.prependChild((Node)var1_1);
        }
    }

    public OutputSettings outputSettings() {
        return this.outputSettings;
    }

    public QuirksMode quirksMode() {
        return this.quirksMode;
    }

    /*
     * WARNING - void declaration
     */
    public Document quirksMode(QuirksMode quirksMode) {
        void var1_1;
        this.quirksMode = var1_1;
        return this;
    }

    public Parser parser() {
        return this.parser;
    }

    /*
     * WARNING - void declaration
     */
    public Document parser(Parser parser) {
        void var1_1;
        this.parser = var1_1;
        return this;
    }

    public static class OutputSettings
    implements Cloneable {
        private Entities.EscapeMode escapeMode = Entities.EscapeMode.base;
        private Charset charset;
        Entities.CoreCharset coreCharset;
        private final ThreadLocal<CharsetEncoder> encoderThreadLocal = new ThreadLocal();
        private boolean prettyPrint = true;
        private boolean outline = false;
        private int indentAmount = 1;
        private int maxPaddingWidth = 30;
        private Syntax syntax = Syntax.html;

        public OutputSettings() {
            this.charset(DataUtil.UTF_8);
        }

        public Entities.EscapeMode escapeMode() {
            return this.escapeMode;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings escapeMode(Entities.EscapeMode escapeMode) {
            void var1_1;
            this.escapeMode = var1_1;
            return this;
        }

        public Charset charset() {
            return this.charset;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings charset(Charset charset) {
            void var1_1;
            this.charset = charset;
            this.coreCharset = Entities.CoreCharset.byName(var1_1.name());
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings charset(String charset) {
            void var1_1;
            this.charset(Charset.forName((String)var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        CharsetEncoder prepareEncoder() {
            void var1_1;
            CharsetEncoder encoder = this.charset.newEncoder();
            this.encoderThreadLocal.set(encoder);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        CharsetEncoder encoder() {
            CharsetEncoder encoder = this.encoderThreadLocal.get();
            if (encoder != null) {
                void var1_1;
                return var1_1;
            }
            return this.prepareEncoder();
        }

        public Syntax syntax() {
            return this.syntax;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings syntax(Syntax syntax) {
            void var1_1;
            this.syntax = syntax;
            if (var1_1 == Syntax.xml) {
                this.escapeMode(Entities.EscapeMode.xhtml);
            }
            return this;
        }

        public boolean prettyPrint() {
            return this.prettyPrint;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings prettyPrint(boolean pretty) {
            void var1_1;
            this.prettyPrint = var1_1;
            return this;
        }

        public boolean outline() {
            return this.outline;
        }

        public int indentAmount() {
            return this.indentAmount;
        }

        public int maxPaddingWidth() {
            return this.maxPaddingWidth;
        }

        /*
         * WARNING - void declaration
         */
        public OutputSettings clone() {
            void var1_1;
            OutputSettings clone;
            try {
                clone = (OutputSettings)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new RuntimeException(e);
            }
            clone.charset(this.charset.name());
            clone.escapeMode = Entities.EscapeMode.valueOf(this.escapeMode.name());
            return var1_1;
        }

        public static final class Syntax
        extends Enum<Syntax> {
            public static final /* enum */ Syntax html = new Syntax();
            public static final /* enum */ Syntax xml = new Syntax();
            private static final /* synthetic */ Syntax[] $VALUES;

            private static /* synthetic */ Syntax[] $values() {
                return new Syntax[]{html, xml};
            }

            static {
                $VALUES = Syntax.$values();
            }
        }
    }

    public static final class QuirksMode
    extends Enum<QuirksMode> {
        public static final /* enum */ QuirksMode noQuirks = new QuirksMode();
        public static final /* enum */ QuirksMode quirks = new QuirksMode();
        public static final /* enum */ QuirksMode limitedQuirks = new QuirksMode();
        private static final /* synthetic */ QuirksMode[] $VALUES;

        private static /* synthetic */ QuirksMode[] $values() {
            return new QuirksMode[]{noQuirks, quirks, limitedQuirks};
        }

        static {
            $VALUES = QuirksMode.$values();
        }
    }
}

