/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.nodes;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Pattern;
import org.jsoup.SerializationException;
import org.jsoup.helper.Validate;
import org.jsoup.internal.Normalizer;
import org.jsoup.internal.StringUtil;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Entities;

public class Attribute
implements Cloneable,
Map.Entry<String, String> {
    private static final String[] booleanAttributes = new String[]{"allowfullscreen", "async", "autofocus", "checked", "compact", "declare", "default", "defer", "disabled", "formnovalidate", "hidden", "inert", "ismap", "itemscope", "multiple", "muted", "nohref", "noresize", "noshade", "novalidate", "nowrap", "open", "readonly", "required", "reversed", "seamless", "selected", "sortable", "truespeed", "typemustmatch"};
    private String key;
    private String val;
    Attributes parent;
    private static final Pattern xmlKeyValid = Pattern.compile("[a-zA-Z_:][-a-zA-Z0-9_:.]*");
    private static final Pattern xmlKeyReplace = Pattern.compile("[^-a-zA-Z0-9_:.]+");
    private static final Pattern htmlKeyValid = Pattern.compile("[^\\x00-\\x1f\\x7f-\\x9f \"'/=]+");
    private static final Pattern htmlKeyReplace = Pattern.compile("[\\x00-\\x1f\\x7f-\\x9f \"'/=]+");

    /*
     * WARNING - void declaration
     */
    public Attribute(String key, String val, Attributes parent) {
        void var3_3;
        void var2_2;
        void var1_1;
        Validate.notNull(key);
        key = key.trim();
        Validate.notEmpty(key);
        this.key = var1_1;
        this.val = var2_2;
        this.parent = var3_3;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public String getValue() {
        return Attributes.checkNotNull(this.val);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String setValue(String val) {
        void var2_2;
        void var1_1;
        int i;
        String oldVal = this.val;
        if (this.parent != null && (i = this.parent.indexOfKey(this.key)) != -1) {
            oldVal = this.parent.get(this.key);
            this.parent.vals[var3_3] = val;
        }
        this.val = var1_1;
        return Attributes.checkNotNull(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public String html() {
        void var1_1;
        StringBuilder sb = StringUtil.borrowBuilder();
        try {
            this.html(sb, new Document("").outputSettings());
        }
        catch (IOException exception) {
            void var1_2;
            throw new SerializationException((Throwable)var1_2);
        }
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void html(Appendable accum, Document.OutputSettings out) throws IOException {
        void var2_2;
        void var1_1;
        Attribute.html(this.key, this.val, (Appendable)var1_1, (Document.OutputSettings)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected static void html(String key, String val, Appendable accum, Document.OutputSettings out) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        String string;
        if ((key = Attribute.getValidKey(key, out.syntax())) == null) {
            return;
        }
        Attribute.htmlNoValidate(string, (String)var1_1, (Appendable)var2_2, (Document.OutputSettings)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static void htmlNoValidate(String key, String val, Appendable accum, Document.OutputSettings out) throws IOException {
        String string;
        accum.append(key);
        if (!Attribute.shouldCollapseAttribute(string, val, out)) {
            void var2_2;
            void var3_3;
            void var1_1;
            accum.append("=\"");
            Entities.escape(accum, Attributes.checkNotNull(var1_1), (Document.OutputSettings)var3_3, false, true, false, false, false);
            var2_2.append('\"');
        }
    }

    /*
     * WARNING - void declaration
     */
    public static String getValidKey(String key, Document.OutputSettings.Syntax syntax) {
        String string;
        void var1_1;
        if (syntax == Document.OutputSettings.Syntax.xml && !xmlKeyValid.matcher(key).matches()) {
            if (xmlKeyValid.matcher(key = xmlKeyReplace.matcher(key).replaceAll("_")).matches()) {
                return key;
            }
            return null;
        }
        if (var1_1 == Document.OutputSettings.Syntax.html && !htmlKeyValid.matcher(key).matches()) {
            if (htmlKeyValid.matcher(key = htmlKeyReplace.matcher(key).replaceAll("_")).matches()) {
                return key;
            }
            return null;
        }
        return string;
    }

    public String toString() {
        return this.html();
    }

    /*
     * WARNING - void declaration
     */
    protected static boolean shouldCollapseAttribute(String key, String val, Document.OutputSettings out) {
        String string;
        void var1_1;
        return out.syntax() == Document.OutputSettings.Syntax.html && (val == null || (val.isEmpty() || var1_1.equalsIgnoreCase(key)) && Attribute.isBooleanAttribute(string));
    }

    public static boolean isBooleanAttribute(String key) {
        String string;
        return Arrays.binarySearch(booleanAttributes, Normalizer.lowerCase(string)) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Attribute attribute = (Attribute)o;
        if (this.key != null ? !this.key.equals(attribute.key) : attribute.key != null) {
            return false;
        }
        if (this.val != null) {
            return this.val.equals(attribute.val);
        }
        return var1_1.val == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = this.key != null ? this.key.hashCode() : 0;
        var1_1 = var1_1 * 31 + (this.val != null ? this.val.hashCode() : 0);
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public Attribute clone() {
        try {
            return (Attribute)super.clone();
        }
        catch (CloneNotSupportedException e) {
            void var1_1;
            throw new RuntimeException((Throwable)var1_1);
        }
    }
}

