/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Stack;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;

public final class StringUtil {
    static final String[] padding = new String[]{"", " ", "  ", "   ", "    ", "     ", "      ", "       ", "        ", "         ", "          ", "           ", "            ", "             ", "              ", "               ", "                ", "                 ", "                  ", "                   ", "                    "};
    private static final Pattern extraDotSegmentsPattern = Pattern.compile("^/(?>(?>\\.\\.?/)+)");
    private static final Pattern validUriScheme = Pattern.compile("^[a-zA-Z][a-zA-Z0-9+-.]*:");
    private static final Pattern controlChars = Pattern.compile("[\\x00-\\x1f]*");
    private static final ThreadLocal<Stack<StringBuilder>> threadLocalBuilders = ThreadLocal.withInitial(Stack::new);

    /*
     * WARNING - void declaration
     */
    public static String join(Collection<?> strings, String sep) {
        void var1_1;
        return StringUtil.join(strings.iterator(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String join(Iterator<?> strings, String sep) {
        void var1_1;
        void var2_2;
        if (!strings.hasNext()) {
            return "";
        }
        String start = strings.next().toString();
        if (!strings.hasNext()) {
            return start;
        }
        StringJoiner j = new StringJoiner(sep);
        j.add(var2_2);
        while (strings.hasNext()) {
            j.add(strings.next());
        }
        return var1_1.complete();
    }

    /*
     * WARNING - void declaration
     */
    public static String padding(int width, int maxPaddingWidth) {
        void var1_2;
        Validate.isTrue(width >= 0, "width must be >= 0");
        Validate.isTrue(maxPaddingWidth >= -1);
        if (maxPaddingWidth != -1) {
            width = Math.min(width, maxPaddingWidth);
        }
        if (width < padding.length) {
            return padding[width];
        }
        char[] out = new char[width];
        for (int i = 0; i < width; ++i) {
            out[i] = 32;
        }
        return String.valueOf((char[])var1_2);
    }

    public static boolean isBlank(String string) {
        if (string == null || string.length() == 0) {
            return true;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (StringUtil.isWhitespace(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNumeric(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        int l = string.length();
        for (int i = 0; i < l; ++i) {
            if (Character.isDigit(string.codePointAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(int c) {
        int n;
        return c == 32 || c == 9 || c == 10 || c == 12 || n == 13;
    }

    public static boolean isActuallyWhitespace(int c) {
        int n;
        return c == 32 || c == 9 || c == 10 || c == 12 || c == 13 || n == 160;
    }

    public static boolean isInvisibleChar(int c) {
        int n;
        return c == 8203 || n == 173;
    }

    /*
     * WARNING - void declaration
     */
    public static String normaliseWhitespace(String string) {
        void var1_1;
        String string2;
        StringBuilder sb = StringUtil.borrowBuilder();
        StringUtil.appendNormalisedWhitespace(sb, string2, false);
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    public static void appendNormalisedWhitespace(StringBuilder accum, String string, boolean stripLeading) {
        int c;
        boolean lastWasWhite = false;
        boolean reachedNonWhite = false;
        int len = string.length();
        for (int i = 0; i < len; i += Character.charCount(c)) {
            c = string.codePointAt(i);
            if (StringUtil.isActuallyWhitespace(c)) {
                if (stripLeading && !reachedNonWhite || lastWasWhite) continue;
                accum.append(' ');
                lastWasWhite = true;
                continue;
            }
            if (StringUtil.isInvisibleChar(c)) continue;
            accum.appendCodePoint(c);
            lastWasWhite = false;
            reachedNonWhite = true;
        }
    }

    public static boolean in(String needle, String ... haystack) {
        int len = haystack.length;
        for (int i = 0; i < len; ++i) {
            if (!haystack[i].equals(needle)) continue;
            return true;
        }
        return false;
    }

    public static boolean inSorted(String needle, String[] haystack) {
        String string;
        return Arrays.binarySearch(haystack, string) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    public static URL resolve(URL base, String relUrl) throws MalformedURLException {
        void var1_1;
        URL uRL;
        if ((relUrl = StringUtil.stripControlChars(relUrl)).startsWith("?")) {
            relUrl = base.getPath() + relUrl;
        }
        URL url = new URL(base, relUrl);
        String fixedFile = extraDotSegmentsPattern.matcher(url.getFile()).replaceFirst("/");
        if (url.getRef() != null) {
            fixedFile = fixedFile + "#" + url.getRef();
        }
        return new URL(url.getProtocol(), url.getHost(), uRL.getPort(), (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static String resolve(String baseUrl, String relUrl) {
        baseUrl = StringUtil.stripControlChars(baseUrl);
        relUrl = StringUtil.stripControlChars(relUrl);
        try {
            Object object;
            Object base;
            try {
                base = new URL(baseUrl);
            }
            catch (MalformedURLException malformedURLException) {
                base = new URL(relUrl);
                return ((URL)base).toExternalForm();
            }
            return StringUtil.resolve((URL)object, relUrl).toExternalForm();
        }
        catch (MalformedURLException malformedURLException) {
            if (validUriScheme.matcher(relUrl).find()) {
                void var1_1;
                return var1_1;
            }
            return "";
        }
    }

    private static String stripControlChars(String input) {
        String string;
        return controlChars.matcher(string).replaceAll("");
    }

    /*
     * WARNING - void declaration
     */
    public static StringBuilder borrowBuilder() {
        void var0;
        Stack<StringBuilder> builders = threadLocalBuilders.get();
        if (builders.empty()) {
            return new StringBuilder(8192);
        }
        return (StringBuilder)var0.pop();
    }

    /*
     * WARNING - void declaration
     */
    public static String releaseBuilder(StringBuilder sb) {
        void var1_1;
        StringBuilder stringBuilder;
        Validate.notNull(sb);
        String string = sb.toString();
        if (sb.length() > 8192) {
            sb = new StringBuilder(8192);
        } else {
            sb.delete(0, sb.length());
        }
        Stack<StringBuilder> builders = threadLocalBuilders.get();
        builders.push(stringBuilder);
        while (builders.size() > 8) {
            builders.pop();
        }
        return var1_1;
    }

    public static class StringJoiner {
        StringBuilder sb = StringUtil.borrowBuilder();
        final String separator;
        boolean first = true;

        /*
         * WARNING - void declaration
         */
        public StringJoiner(String separator) {
            void var1_1;
            this.separator = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public StringJoiner add(Object stringy) {
            void var1_1;
            Validate.notNull(this.sb);
            if (!this.first) {
                this.sb.append(this.separator);
            }
            this.sb.append(var1_1);
            this.first = false;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public String complete() {
            void var1_1;
            String string = StringUtil.releaseBuilder(this.sb);
            this.sb = null;
            return var1_1;
        }
    }
}

