/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.internal;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketTimeoutException;
import java.nio.ByteBuffer;
import org.jsoup.Progress;
import org.jsoup.helper.Validate;

public class ControllableInputStream
extends FilterInputStream {
    private final BufferedInputStream buff;
    private final boolean capped;
    private final int maxSize;
    private long startTime;
    private long timeout = 0L;
    private int remaining;
    private int markPos;
    private boolean interrupted;
    private Progress<?> progress;
    private Object progressContext;
    private int contentLength = -1;
    private int readPos = 0;

    /*
     * WARNING - void declaration
     */
    private ControllableInputStream(BufferedInputStream in, int maxSize) {
        super(in);
        void var2_2;
        void var1_1;
        Validate.isTrue(maxSize >= 0);
        this.buff = var1_1;
        this.capped = maxSize != 0;
        this.maxSize = maxSize;
        this.remaining = var2_2;
        this.markPos = -1;
        this.startTime = System.nanoTime();
    }

    /*
     * WARNING - void declaration
     */
    public static ControllableInputStream wrap(InputStream in, int bufferSize, int maxSize) {
        void var2_2;
        void var1_1;
        InputStream inputStream;
        if (in instanceof ControllableInputStream) {
            return (ControllableInputStream)in;
        }
        if (in instanceof BufferedInputStream) {
            return new ControllableInputStream((BufferedInputStream)in, maxSize);
        }
        return new ControllableInputStream(new BufferedInputStream(inputStream, (int)var1_1), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.readPos == 0) {
            this.emitProgress();
        }
        if (this.interrupted || this.capped && this.remaining <= 0) {
            return -1;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.interrupted = true;
            return -1;
        }
        if (this.expired()) {
            throw new SocketTimeoutException("Read timeout");
        }
        if (this.capped && len > this.remaining) {
            len = this.remaining;
        }
        try {
            void var3_5;
            void var2_4;
            int read = super.read(b, (int)var2_4, (int)var3_5);
            if (read == -1) {
                this.contentLength = this.readPos;
            } else {
                this.remaining -= read;
                this.readPos += read;
            }
            this.emitProgress();
            return read;
        }
        catch (SocketTimeoutException e) {
            if (this.expired()) {
                void var1_3;
                throw var1_3;
            }
            return 0;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer readToByteBuffer(InputStream in, int max) throws IOException {
        int read;
        Validate.isTrue(max >= 0, "maxSize must be 0 (unlimited) or larger");
        Validate.notNull(in);
        boolean localCapped = max > 0;
        int bufferSize = localCapped && max < 32768 ? max : 32768;
        byte[] readBuffer = new byte[bufferSize];
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(bufferSize);
        int remaining = max;
        while ((read = in.read(readBuffer, 0, localCapped ? Math.min(remaining, bufferSize) : bufferSize)) != -1) {
            void var1_1;
            if (localCapped) {
                if (read >= remaining) {
                    outStream.write(readBuffer, 0, remaining);
                    break;
                }
                remaining -= read;
            }
            outStream.write(readBuffer, 0, (int)var1_1);
        }
        return ByteBuffer.wrap(outStream.toByteArray());
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.remaining = this.maxSize - this.markPos;
        this.readPos = this.markPos;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mark(int readlimit) {
        void var1_1;
        super.mark((int)var1_1);
        this.markPos = this.maxSize - this.remaining;
    }

    /*
     * WARNING - void declaration
     */
    private void emitProgress() {
        void var1_1;
        if (this.progress == null) {
            return;
        }
        float percent = this.contentLength > 0 ? Math.min(100.0f, (float)this.readPos * 100.0f / (float)this.contentLength) : 0.0f;
        this.progress.onProgress(this.readPos, this.contentLength, percent, this.progressContext);
        if (var1_1 == 100.0f) {
            this.progress = null;
        }
    }

    private boolean expired() {
        if (this.timeout == 0L) {
            return false;
        }
        long l = System.nanoTime();
        long l2 = l - this.startTime;
        return l2 > this.timeout;
    }
}

