/*
 * Decompiled with CFR 0.152.
 */
package org.jsoup.helper;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.helper.Validate;
import org.jsoup.internal.ControllableInputStream;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.XmlDeclaration;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public final class DataUtil {
    private static final Pattern charsetPattern = Pattern.compile("(?i)\\bcharset=\\s*(?:[\"'])?([^\\s,;\"']*)");
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    static final String defaultCharsetName = UTF_8.name();
    private static final char[] mimeBoundaryChars = "-_1234567890abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".toCharArray();

    /*
     * WARNING - void declaration
     */
    public static Document load(InputStream in, String charsetName, String baseUri) throws IOException {
        void var2_2;
        void var1_1;
        return DataUtil.parseInputStream(in, (String)var1_1, (String)var2_2, Parser.htmlParser());
    }

    /*
     * WARNING - void declaration
     */
    public static Document load(InputStream in, String charsetName, String baseUri, Parser parser) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return DataUtil.parseInputStream(in, (String)var1_1, (String)var2_2, (Parser)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static Document parseInputStream(InputStream input, String charsetName, String baseUri, Parser parser) throws IOException {
        Document document;
        if (input == null) {
            return new Document(baseUri);
        }
        CharsetDoc charsetDoc = null;
        try {
            void var3_4;
            void var2_3;
            void var1_2;
            charsetDoc = DataUtil.detectCharset(input, (String)var1_2, baseUri, parser);
            Document doc = DataUtil.parseInputStream(charsetDoc, (String)var2_3, (Parser)var3_4);
        }
        finally {
            if (charsetDoc != null) {
                charsetDoc.input.close();
            }
        }
        return document;
    }

    /*
     * WARNING - void declaration
     */
    static CharsetDoc detectCharset(InputStream input, String charsetName, String baseUri, Parser parser) throws IOException {
        void var2_3;
        InputStream inputStream;
        void var1_1;
        Document doc = null;
        InputStream wrappedInputStream = ControllableInputStream.wrap(input, 32768, 0);
        wrappedInputStream.mark(32768);
        ByteBuffer firstBytes = DataUtil.readToByteBuffer(wrappedInputStream, 5119);
        boolean fullyRead = wrappedInputStream.read() == -1;
        wrappedInputStream.reset();
        BomCharset bomCharset = DataUtil.detectCharsetFromBom(firstBytes);
        if (bomCharset != null) {
            charsetName = bomCharset.charset;
        }
        if (charsetName == null) {
            Object defaultDecoded;
            try {
                defaultDecoded = UTF_8.decode(firstBytes);
                doc = ((CharBuffer)defaultDecoded).hasArray() ? ((Parser)parser).parseInput(new CharArrayReader(((CharBuffer)defaultDecoded).array(), ((CharBuffer)defaultDecoded).arrayOffset(), ((Buffer)defaultDecoded).limit()), baseUri) : ((Parser)parser).parseInput(((CharBuffer)defaultDecoded).toString(), baseUri);
            }
            catch (UncheckedIOException uncheckedIOException) {
                defaultDecoded = uncheckedIOException;
                throw uncheckedIOException.getCause();
            }
            Elements metaElements = doc.select("meta[http-equiv=content-type], meta[charset]");
            String foundCharset = null;
            for (Element meta : metaElements) {
                if (meta.hasAttr("http-equiv")) {
                    foundCharset = DataUtil.getCharsetFromContentType(meta.attr("content"));
                }
                if (foundCharset == null && meta.hasAttr("charset")) {
                    foundCharset = meta.attr("charset");
                }
                if (foundCharset == null) continue;
            }
            if (foundCharset == null && ((Node)doc).childNodeSize() > 0) {
                Comment comment;
                Node first = doc.childNode(0);
                XmlDeclaration decl = null;
                if (first instanceof XmlDeclaration) {
                    decl = (XmlDeclaration)first;
                } else if (first instanceof Comment && (comment = (Comment)first).isXmlDeclaration()) {
                    void var3_4;
                    decl = var3_4.asXmlDeclaration();
                }
                if (decl != null && decl.name().equalsIgnoreCase("xml")) {
                    foundCharset = ((Node)decl).attr("encoding");
                }
            }
            if ((foundCharset = DataUtil.validateCharset(foundCharset)) != null && !foundCharset.equalsIgnoreCase(defaultCharsetName)) {
                charsetName = foundCharset = foundCharset.trim().replaceAll("[\"']", "");
                doc = null;
            } else if (!fullyRead) {
                doc = null;
            }
        } else {
            Validate.notEmpty(charsetName, "Must set charset arg to character set of file to parse. Set to null to attempt to detect from HTML");
        }
        if (charsetName == null) {
            charsetName = defaultCharsetName;
        }
        Charset charset = charsetName.equals(defaultCharsetName) ? UTF_8 : Charset.forName((String)var1_1);
        boolean skip = bomCharset != null && bomCharset.offset;
        return new CharsetDoc(charset, doc, inputStream, (boolean)var2_3);
    }

    /*
     * WARNING - void declaration
     */
    static Document parseInputStream(CharsetDoc charsetDoc, String baseUri, Parser parser) throws IOException {
        Object object;
        if (charsetDoc.doc != null) {
            return charsetDoc.doc;
        }
        InputStream input = charsetDoc.input;
        Validate.notNull(input);
        Charset charset = charsetDoc.charset;
        BufferedReader reader = new BufferedReader(new InputStreamReader(input, charset), 32768);
        try {
            Object doc;
            DataUtil.maybeSkipBom(reader, charsetDoc);
            try {
                void var1_2;
                void var2_4;
                doc = var2_4.parseInput(reader, (String)var1_2);
            }
            catch (UncheckedIOException uncheckedIOException) {
                doc = uncheckedIOException;
                throw uncheckedIOException.getCause();
            }
            ((Document)doc).outputSettings().charset(charset);
            if (!charset.canEncode()) {
                ((Document)doc).charset(UTF_8);
            }
        }
        catch (Throwable doc) {
            try {
                void var3_5;
                var3_5.close();
            }
            catch (Throwable throwable) {
                doc.addSuppressed(throwable);
            }
            throw doc;
        }
        reader.close();
        return object;
    }

    static void maybeSkipBom(Reader reader, CharsetDoc charsetDoc) throws IOException {
        if (charsetDoc.skip) {
            Reader reader2;
            long l = reader2.skip(1L);
            Validate.isTrue(l == 1L);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ByteBuffer readToByteBuffer(InputStream inStream, int maxSize) throws IOException {
        void var1_1;
        return ControllableInputStream.readToByteBuffer(inStream, (int)var1_1);
    }

    static String getCharsetFromContentType(String contentType) {
        if (contentType == null) {
            return null;
        }
        Matcher m = charsetPattern.matcher(contentType);
        if (m.find()) {
            Matcher matcher;
            matcher = matcher.group(1).trim();
            matcher = ((String)((Object)matcher)).replace("charset=", "");
            return DataUtil.validateCharset((String)((Object)matcher));
        }
        return null;
    }

    private static String validateCharset(String cs) {
        if (cs == null || cs.length() == 0) {
            return null;
        }
        cs = cs.trim().replaceAll("[\"']", "");
        try {
            if (Charset.isSupported(cs)) {
                return cs;
            }
            if (Charset.isSupported(cs = cs.toUpperCase(Locale.ENGLISH))) {
                String string;
                return string;
            }
        }
        catch (IllegalCharsetNameException illegalCharsetNameException) {}
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static BomCharset detectCharsetFromBom(ByteBuffer byteData) {
        void var2_2;
        ByteBuffer buffer = byteData;
        ((Buffer)buffer).mark();
        byte[] bom = new byte[4];
        if (byteData.remaining() >= bom.length) {
            void var1_1;
            ByteBuffer byteBuffer;
            byteBuffer.get(bom);
            var1_1.rewind();
        }
        if (bom[0] == 0 && bom[1] == 0 && bom[2] == -2 && bom[3] == -1 || bom[0] == -1 && bom[1] == -2 && bom[2] == 0 && bom[3] == 0) {
            return new BomCharset("UTF-32", false);
        }
        if (bom[0] == -2 && bom[1] == -1 || bom[0] == -1 && bom[1] == -2) {
            return new BomCharset("UTF-16", false);
        }
        if (bom[0] == -17 && bom[1] == -69 && var2_2[2] == -65) {
            return new BomCharset("UTF-8", true);
        }
        return null;
    }

    static class CharsetDoc {
        Charset charset;
        InputStream input;
        Document doc;
        boolean skip;

        /*
         * WARNING - void declaration
         */
        CharsetDoc(Charset charset, Document doc, InputStream input, boolean skip) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.charset = var1_1;
            this.input = var3_3;
            this.doc = var2_2;
            this.skip = skip;
        }
    }

    private static class BomCharset {
        private final String charset;
        private final boolean offset;

        /*
         * WARNING - void declaration
         */
        public BomCharset(String charset, boolean offset) {
            void var2_2;
            void var1_1;
            this.charset = var1_1;
            this.offset = var2_2;
        }
    }
}

