/*
 * Decompiled with CFR 0.152.
 */
package androidx.lifecycle;

import androidx.lifecycle.ClassesInfoCache;
import androidx.lifecycle.CompositeGeneratedAdaptersObserver;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.DefaultLifecycleObserverAdapter;
import androidx.lifecycle.GeneratedAdapter;
import androidx.lifecycle.LifecycleEventObserver;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.ReflectiveGenericLifecycleObserver;
import androidx.lifecycle.SingleGeneratedAdapterObserver;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0004\u001a\u00020\u0001H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007J'\u0010\u000b\u001a\u00020\t2\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b2\u0006\u0010\u0004\u001a\u00020\u0001H\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ%\u0010\u000f\u001a\f\u0012\u0006\b\u0001\u0012\u00020\t\u0018\u00010\b2\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001b\u0010\u0012\u001a\u00020\u00112\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001b\u0010\u0014\u001a\u00020\u00112\n\u0010\u000e\u001a\u0006\u0012\u0002\b\u00030\rH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u001d\u0010\u0016\u001a\u00020\u00152\f\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\rH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bR$\u0010\u001d\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u00110\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010\u001eR2\u0010 \u001a \u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b0\u001f0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b \u0010\u001e"}, d2={"Landroidx/lifecycle/Lifecycling;", "", "<init>", "()V", "object", "Landroidx/lifecycle/LifecycleEventObserver;", "lifecycleEventObserver", "(Ljava/lang/Object;)Landroidx/lifecycle/LifecycleEventObserver;", "Ljava/lang/reflect/Constructor;", "Landroidx/lifecycle/GeneratedAdapter;", "constructor", "createGeneratedAdapter", "(Ljava/lang/reflect/Constructor;Ljava/lang/Object;)Landroidx/lifecycle/GeneratedAdapter;", "Ljava/lang/Class;", "klass", "generatedConstructor", "(Ljava/lang/Class;)Ljava/lang/reflect/Constructor;", "", "getObserverConstructorType", "(Ljava/lang/Class;)I", "resolveObserverCallbackType", "", "isLifecycleParent", "(Ljava/lang/Class;)Z", "", "className", "getAdapterName", "(Ljava/lang/String;)Ljava/lang/String;", "", "callbackCache", "Ljava/util/Map;", "", "classToAdapters"})
public final class Lifecycling {
    public static final Lifecycling INSTANCE = new Lifecycling();
    private static final Map<Class<?>, Integer> callbackCache = new HashMap();
    private static final Map<Class<?>, List<Constructor<? extends GeneratedAdapter>>> classToAdapters = new HashMap();

    private Lifecycling() {
    }

    @JvmStatic
    public static final LifecycleEventObserver lifecycleEventObserver(Object object) {
        GeneratedAdapter[] generatedAdapterArray;
        int n;
        Intrinsics.checkNotNullParameter((Object)object, (String)"object");
        boolean isLifecycleEventObserver = object instanceof LifecycleEventObserver;
        boolean isDefaultLifecycleObserver = object instanceof DefaultLifecycleObserver;
        if (isLifecycleEventObserver && isDefaultLifecycleObserver) {
            return new DefaultLifecycleObserverAdapter((DefaultLifecycleObserver)object, (LifecycleEventObserver)object);
        }
        if (n != 0) {
            return new DefaultLifecycleObserverAdapter((DefaultLifecycleObserver)object, null);
        }
        if (isLifecycleEventObserver) {
            return (LifecycleEventObserver)object;
        }
        Class<?> klass = object.getClass();
        n = INSTANCE.getObserverConstructorType(klass);
        if (n == 2) {
            GeneratedAdapter[] generatedAdapter;
            List<Constructor<? extends GeneratedAdapter>> list = classToAdapters.get(klass);
            Intrinsics.checkNotNull(list);
            List<Constructor<? extends GeneratedAdapter>> constructors = list;
            if (list.size() == 1) {
                generatedAdapter = INSTANCE.createGeneratedAdapter(constructors.get(0), object);
                return new SingleGeneratedAdapterObserver((GeneratedAdapter)generatedAdapter);
            }
            n = 0;
            int n2 = constructors.size();
            GeneratedAdapter[] generatedAdapterArray2 = new GeneratedAdapter[n2];
            while (n < n2) {
                int n3 = n++;
                generatedAdapterArray2[n3] = INSTANCE.createGeneratedAdapter(constructors.get(n3), generatedAdapter);
            }
            GeneratedAdapter[] adapters = generatedAdapterArray2;
            return new CompositeGeneratedAdaptersObserver(generatedAdapterArray);
        }
        return new ReflectiveGenericLifecycleObserver(generatedAdapterArray);
    }

    /*
     * WARNING - void declaration
     */
    private final GeneratedAdapter createGeneratedAdapter(Constructor<? extends GeneratedAdapter> constructor, Object object) {
        void var1_1;
        try {
            void var2_5;
            Object[] objectArray = constructor;
            Object[] objectArray2 = new Object[1];
            constructor = objectArray2;
            objectArray2[0] = var2_5;
            constructor = objectArray.newInstance(constructor);
            Intrinsics.checkNotNull(constructor);
            constructor = (GeneratedAdapter)constructor;
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            void var1_4;
            throw new RuntimeException((Throwable)var1_4);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private final Constructor<? extends GeneratedAdapter> generatedConstructor(Class<?> klass) {
        Constructor<? extends GeneratedAdapter> constructor;
        try {
            void var1_1;
            String string;
            Package aPackage = klass.getPackage();
            String name = klass.getCanonicalName();
            Package package_ = aPackage;
            Class[] fullPackage = package_ != null ? package_.getName() : "";
            Intrinsics.checkNotNull((Object)fullPackage);
            if (((CharSequence)fullPackage).length() == 0) {
                string = name;
            } else {
                Intrinsics.checkNotNull((Object)name);
                String string2 = name.substring(fullPackage.length() + 1);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            }
            name = string;
            Intrinsics.checkNotNull((Object)string);
            Object adapterName = Lifecycling.getAdapterName(name);
            fullPackage = Class.forName((String)(((CharSequence)fullPackage).length() == 0 ? adapterName : (String)fullPackage + '.' + (String)adapterName));
            Intrinsics.checkNotNull(fullPackage, (String)"null cannot be cast to non-null type java.lang.Class<out androidx.lifecycle.GeneratedAdapter>");
            adapterName = fullPackage;
            Class[] classArray = new Class[1];
            fullPackage = classArray;
            classArray[0] = var1_1;
            Constructor constructor2 = fullPackage.getDeclaredConstructor(fullPackage);
            if (!constructor2.isAccessible()) {
                constructor2.setAccessible(true);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            constructor = null;
        }
        catch (NoSuchMethodException e) {
            void var3_4;
            throw new RuntimeException((Throwable)var3_4);
        }
        return constructor;
    }

    /*
     * WARNING - void declaration
     */
    private final int getObserverConstructorType(Class<?> klass) {
        void var2_3;
        void var1_1;
        Integer callbackCache = Lifecycling.callbackCache.get(klass);
        if (callbackCache != null) {
            return callbackCache;
        }
        int type = this.resolveObserverCallbackType(klass);
        Lifecycling.callbackCache.put((Class<?>)var1_1, type);
        return (int)var2_3;
    }

    /*
     * WARNING - void declaration
     */
    private final int resolveObserverCallbackType(Class<?> klass) {
        Iterator iterator;
        if (klass.getCanonicalName() == null) {
            return 1;
        }
        Constructor<? extends GeneratedAdapter> constructor22 = this.generatedConstructor(klass);
        if (constructor22 != null) {
            classToAdapters.put(klass, CollectionsKt.listOf(constructor22));
            return 2;
        }
        boolean constructor22 = ClassesInfoCache.sInstance.hasLifecycleMethods(klass);
        if (constructor22) {
            return 1;
        }
        Class<?> superclass = klass.getSuperclass();
        List adapterConstructors = null;
        if (this.isLifecycleParent(superclass)) {
            Intrinsics.checkNotNull(superclass);
            if (this.getObserverConstructorType(superclass) == 1) {
                return 1;
            }
            List<Constructor<? extends GeneratedAdapter>> list = classToAdapters.get(iterator);
            Intrinsics.checkNotNull(list);
            adapterConstructors = new ArrayList(list);
        }
        iterator = ArrayIteratorKt.iterator((Object[])klass.getInterfaces());
        while (iterator.hasNext()) {
            Class intrface = (Class)iterator.next();
            if (!this.isLifecycleParent(intrface)) continue;
            Intrinsics.checkNotNull((Object)intrface);
            if (this.getObserverConstructorType(intrface) == 1) {
                return 1;
            }
            if (adapterConstructors == null) {
                adapterConstructors = new ArrayList();
            }
            List<Constructor<? extends GeneratedAdapter>> list = classToAdapters.get(intrface);
            Intrinsics.checkNotNull(list);
            adapterConstructors.addAll((Collection)list);
        }
        if (adapterConstructors != null) {
            void var3_5;
            void var1_1;
            classToAdapters.put((Class<?>)var1_1, (List<Constructor<GeneratedAdapter>>)((List<Constructor<? extends GeneratedAdapter>>)var3_5));
            return 2;
        }
        return 1;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isLifecycleParent(Class<?> klass) {
        void var1_1;
        return klass != null && LifecycleObserver.class.isAssignableFrom((Class<?>)var1_1);
    }

    @JvmStatic
    public static final String getAdapterName(String className) {
        String string;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        return StringsKt.replace$default((String)string, (String)".", (String)"_", (boolean)false, (int)4, null) + "_LifecycleAdapter";
    }
}

