/*
 * Decompiled with CFR 0.152.
 */
package me.him188.ani.utils.ipparser;

import inet.ipaddr.IPAddress;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv6.IPv6Address;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\u000b"}, d2={"Lme/him188/ani/utils/ipparser/IPAddressParser;", "", "<init>", "()V", "", "ip", "Linet/ipaddr/IPAddress;", "parse", "(Ljava/lang/String;)Linet/ipaddr/IPAddress;", "Lkotlin/text/Regex;", "ipv4Pattern", "Lkotlin/text/Regex;", "ipv6Pattern"})
public final class IPAddressParser {
    public static final IPAddressParser INSTANCE = new IPAddressParser();
    private static final Regex ipv4Pattern = new Regex("^(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");
    private static final Regex ipv6Pattern = new Regex("^(?:(?:[0-9a-fA-F]{1,4}:){7}[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,7}:|(?:[0-9a-fA-F]{1,4}:){1,6}:[0-9a-fA-F]{1,4}|(?:[0-9a-fA-F]{1,4}:){1,5}(?::[0-9a-fA-F]{1,4}){1,2}|(?:[0-9a-fA-F]{1,4}:){1,4}(?::[0-9a-fA-F]{1,4}){1,3}|(?:[0-9a-fA-F]{1,4}:){1,3}(?::[0-9a-fA-F]{1,4}){1,4}|(?:[0-9a-fA-F]{1,4}:){1,2}(?::[0-9a-fA-F]{1,4}){1,5}|[0-9a-fA-F]{1,4}:(?:(?::[0-9a-fA-F]{1,4}){1,6})|:(?:(?::[0-9a-fA-F]{1,4}){1,7}|:)|fe80:(?::[0-9a-fA-F]{0,4}){0,4}%[0-9a-zA-Z]+|::(?:ffff(?::0{1,4})?:)?(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\\.){3}(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])|(?:[0-9a-fA-F]{1,4}:){1,4}:(?:(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9])\\.){3}(?:25[0-5]|(?:2[0-4]|1?[0-9])?[0-9]))$");

    private IPAddressParser() {
    }

    /*
     * WARNING - void declaration
     */
    public final IPAddress parse(String ip) {
        IPAddress iPAddress;
        Intrinsics.checkNotNullParameter((Object)ip, (String)"ip");
        ip = StringsKt.removePrefix((String)ip, (CharSequence)"::ffff:");
        try {
            IPv4Address iPv4Address;
            InetAddress addr = InetAddress.getByName(ip);
            if (addr instanceof Inet4Address) {
                if (!ipv4Pattern.matches((CharSequence)ip)) {
                    return null;
                }
                iPv4Address = new IPv4Address(((Inet4Address)addr).getAddress());
            } else if (addr instanceof Inet6Address) {
                void var1_1;
                if (!ipv6Pattern.matches((CharSequence)var1_1)) {
                    return null;
                }
                iPv4Address = new IPv6Address(((Inet6Address)iPAddress).getAddress());
            } else {
                iPv4Address = null;
            }
            iPAddress = (IPAddress)iPv4Address;
        }
        catch (Exception exception) {
            return null;
        }
        return iPAddress;
    }
}

