/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.FlingCalculator;
import androidx.compose.animation.SplineBasedDecayAnimationSpec_desktopKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001f\u0010\f\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ'\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J'\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\u0014\u0010\u0011R\u0014\u0010\u0016\u001a\u00020\u00158\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R\u0014\u0010\u001a\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019"}, d2={"Landroidx/compose/animation/SplineBasedFloatDecayAnimationSpec;", "Landroidx/compose/animation/core/FloatDecayAnimationSpec;", "Landroidx/compose/ui/unit/Density;", "density", "<init>", "(Landroidx/compose/ui/unit/Density;)V", "", "startVelocity", "flingDistance", "(F)F", "initialValue", "initialVelocity", "getTargetValue", "(FF)F", "", "playTimeNanos", "getValueFromNanos", "(JFF)F", "getDurationNanos", "(FF)J", "getVelocityFromNanos", "Landroidx/compose/animation/FlingCalculator;", "flingCalculator", "Landroidx/compose/animation/FlingCalculator;", "getAbsVelocityThreshold", "()F", "absVelocityThreshold"})
public final class SplineBasedFloatDecayAnimationSpec
implements FloatDecayAnimationSpec {
    private final FlingCalculator flingCalculator;

    /*
     * WARNING - void declaration
     */
    public SplineBasedFloatDecayAnimationSpec(Density density) {
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.flingCalculator = new FlingCalculator(SplineBasedDecayAnimationSpec_desktopKt.getPlatformFlingScrollFriction(), (Density)var1_1);
    }

    public final float getAbsVelocityThreshold() {
        return 0.0f;
    }

    /*
     * WARNING - void declaration
     */
    private final float flingDistance(float startVelocity) {
        void var1_1;
        return this.flingCalculator.flingDistance(startVelocity) * Math.signum((float)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final float getTargetValue(float initialValue, float initialVelocity) {
        void var2_2;
        return initialValue + this.flingDistance((float)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final float getValueFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        void var3_2;
        long playTimeMillis = playTimeNanos / 1000000L;
        return (float)(var3_2 + this.flingCalculator.flingInfo(initialVelocity).position(playTimeMillis));
    }

    /*
     * WARNING - void declaration
     */
    public final long getDurationNanos(float initialValue, float initialVelocity) {
        void var2_2;
        return this.flingCalculator.flingDuration((float)var2_2) * 1000000L;
    }

    public final float getVelocityFromNanos(long playTimeNanos, float initialValue, float initialVelocity) {
        long playTimeMillis = playTimeNanos / 1000000L;
        return this.flingCalculator.flingInfo(initialVelocity).velocity(playTimeMillis);
    }
}

