/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedFloatDecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpec;
import androidx.compose.animation.core.DecayAnimationSpecKt;
import androidx.compose.animation.core.FloatDecayAnimationSpec;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a'\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0003H\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a!\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b\"\u0004\b\u0000\u0010\b2\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"", "splinePositions", "splineTimes", "", "nbSamples", "", "computeSplineInfo", "([F[FI)V", "T", "Landroidx/compose/ui/unit/Density;", "density", "Landroidx/compose/animation/core/DecayAnimationSpec;", "splineBasedDecay", "(Landroidx/compose/ui/unit/Density;)Landroidx/compose/animation/core/DecayAnimationSpec;"})
public final class SplineBasedDecayKt {
    /*
     * WARNING - void declaration
     */
    private static final void computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        void var2_2;
        void var1_1;
        float xMin = 0.0f;
        float yMin = 0.0f;
        for (int i = 0; i < nbSamples; ++i) {
            float y;
            float coef;
            float x;
            float alpha = (float)i / (float)nbSamples;
            float xMax = 1.0f;
            while (true) {
                x = xMin + (xMax - xMin) / 2.0f;
                coef = 3.0f * x * (1.0f - x);
                float f = x;
                float tx = coef * ((1.0f - x) * 0.175f + x * 0.35000002f) + f * f * x;
                if ((double)Math.abs(tx - alpha) < 1.0E-5) break;
                if (tx > alpha) {
                    xMax = x;
                    continue;
                }
                xMin = x;
            }
            float f = x;
            splinePositions[i] = coef * ((1.0f - x) * 0.5f + x) + f * f * x;
            float yMax = 1.0f;
            while (true) {
                y = yMin + (yMax - yMin) / 2.0f;
                coef = 3.0f * y * (1.0f - y);
                float f2 = y;
                float dy = coef * ((1.0f - y) * 0.5f + y) + f2 * f2 * y;
                if ((double)Math.abs(dy - alpha) < 1.0E-5) break;
                if (dy > alpha) {
                    yMax = y;
                    continue;
                }
                yMin = y;
            }
            float f3 = y;
            splineTimes[i] = coef * ((1.0f - y) * 0.175f + y * 0.35000002f) + f3 * f3 * y;
        }
        splineTimes[nbSamples] = 1.0f;
        var0[nbSamples] = var1_1[var2_2];
    }

    public static final <T> DecayAnimationSpec<T> splineBasedDecay(Density density) {
        Density density2;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        return DecayAnimationSpecKt.generateDecayAnimationSpec((FloatDecayAnimationSpec)new SplineBasedFloatDecayAnimationSpec(density2));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void access$computeSplineInfo(float[] splinePositions, float[] splineTimes, int nbSamples) {
        void var2_2;
        void var1_1;
        SplineBasedDecayKt.computeSplineInfo(splinePositions, (float[])var1_1, (int)var2_2);
    }
}

