/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.AndroidFlingSpline;
import androidx.compose.animation.FlingCalculatorKt;
import androidx.compose.ui.unit.Density;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0001\u0019B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\b\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0018\u0010\u0016"}, d2={"Landroidx/compose/animation/FlingCalculator;", "", "", "friction", "Landroidx/compose/ui/unit/Density;", "density", "<init>", "(FLandroidx/compose/ui/unit/Density;)V", "computeDeceleration", "(Landroidx/compose/ui/unit/Density;)F", "velocity", "", "getSplineDeceleration", "(F)D", "", "flingDuration", "(F)J", "flingDistance", "(F)F", "Landroidx/compose/animation/FlingCalculator$FlingInfo;", "flingInfo", "(F)Landroidx/compose/animation/FlingCalculator$FlingInfo;", "F", "Landroidx/compose/ui/unit/Density;", "magicPhysicalCoefficient", "FlingInfo"})
public final class FlingCalculator {
    private final float friction;
    public final Density density;
    private final float magicPhysicalCoefficient;

    /*
     * WARNING - void declaration
     */
    public FlingCalculator(float friction, Density density) {
        void var2_2;
        void var1_1;
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        this.friction = var1_1;
        this.density = var2_2;
        this.magicPhysicalCoefficient = this.computeDeceleration(this.density);
    }

    /*
     * WARNING - void declaration
     */
    private final float computeDeceleration(Density density) {
        void var1_1;
        return FlingCalculatorKt.access$computeDeceleration(0.84f, var1_1.getDensity());
    }

    /*
     * WARNING - void declaration
     */
    private final double getSplineDeceleration(float velocity) {
        void var1_1;
        return AndroidFlingSpline.INSTANCE.deceleration((float)var1_1, this.friction * this.magicPhysicalCoefficient);
    }

    /*
     * WARNING - void declaration
     */
    public final long flingDuration(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration((float)var1_1);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (long)(1000.0 * Math.exp((double)(var2_2 / decelMinusOne)));
    }

    /*
     * WARNING - void declaration
     */
    public final float flingDistance(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration((float)var1_1);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public final FlingInfo flingInfo(float velocity) {
        void var2_2;
        void var1_1;
        double l = this.getSplineDeceleration(velocity);
        double decelMinusOne = (double)FlingCalculatorKt.access$getDecelerationRate$p() - 1.0;
        return new FlingInfo((float)var1_1, (float)((double)(this.friction * this.magicPhysicalCoefficient) * Math.exp((double)FlingCalculatorKt.access$getDecelerationRate$p() / decelMinusOne * l)), (long)(1000.0 * Math.exp((double)(var2_2 / decelMinusOne))));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\f\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0005\u00a2\u0006\u0004\b\f\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0012\u001a\u00020\u0011H\u00d6\u0001\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0010\u0010\u0015\u001a\u00020\u0014H\u00d6\u0001\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0017R\u0011\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\u0006\n\u0004\b\u0004\u0010\u0017R\u0011\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0018"}, d2={"Landroidx/compose/animation/FlingCalculator$FlingInfo;", "", "", "initialVelocity", "distance", "", "duration", "<init>", "(FFJ)V", "time", "position", "(J)F", "velocity", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "J"})
    public static final class FlingInfo {
        public final float initialVelocity;
        public final float distance;
        public final long duration;

        /*
         * WARNING - void declaration
         */
        public FlingInfo(float initialVelocity, float distance, long duration) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.initialVelocity = var1_1;
            this.distance = var2_2;
            this.duration = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        public final float position(long time) {
            void var1_2;
            float splinePos = this.duration > 0L ? (float)time / (float)this.duration : 1.0f;
            return this.distance * Math.signum(this.initialVelocity) * AndroidFlingSpline.INSTANCE.flingPosition((float)var1_2).getDistanceCoefficient();
        }

        /*
         * WARNING - void declaration
         */
        public final float velocity(long time) {
            void var1_2;
            float splinePos = this.duration > 0L ? (float)time / (float)this.duration : 1.0f;
            return AndroidFlingSpline.INSTANCE.flingPosition((float)var1_2).getVelocityCoefficient() * Math.signum(this.initialVelocity) * this.distance / (float)this.duration * 1000.0f;
        }

        public final String toString() {
            return "FlingInfo(initialVelocity=" + this.initialVelocity + ", distance=" + this.distance + ", duration=" + this.duration + ")";
        }

        public final int hashCode() {
            int n = Float.hashCode(this.initialVelocity);
            n = n * 31 + Float.hashCode(this.distance);
            n = n * 31 + Long.hashCode(this.duration);
            return n;
        }

        public final boolean equals(Object other) {
            FlingInfo flingInfo;
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingInfo)) {
                return false;
            }
            flingInfo = flingInfo;
            if (Float.compare(this.initialVelocity, flingInfo.initialVelocity) != 0) {
                return false;
            }
            if (Float.compare(this.distance, flingInfo.distance) != 0) {
                return false;
            }
            return this.duration == flingInfo.duration;
        }
    }
}

