/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation;

import androidx.compose.animation.SplineBasedDecayKt;
import kotlin.Metadata;
import kotlin.ranges.RangesKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\u0004\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0001\u0012B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\f\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0010"}, d2={"Landroidx/compose/animation/AndroidFlingSpline;", "", "<init>", "()V", "", "time", "Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "flingPosition", "(F)Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "velocity", "friction", "", "deceleration", "(FF)D", "", "SplinePositions", "[F", "SplineTimes", "FlingResult"})
public final class AndroidFlingSpline {
    public static final AndroidFlingSpline INSTANCE = new AndroidFlingSpline();
    private static final float[] SplinePositions = new float[101];
    private static final float[] SplineTimes = new float[101];
    public static final int $stable;

    private AndroidFlingSpline() {
    }

    /*
     * WARNING - void declaration
     */
    public final FlingResult flingPosition(float time) {
        float f;
        float f2;
        float clampedTime = RangesKt.coerceIn((float)time, (float)0.0f, (float)1.0f);
        int index = (int)(100.0f * clampedTime);
        float distanceCoef = 1.0f;
        float velocityCoef = 0.0f;
        if (index < 100) {
            void var1_1;
            void var2_2;
            float tInf = (float)index / 100.0f;
            float tSup = (float)(index + 1) / 100.0f;
            float dInf = SplinePositions[index];
            float f3 = SplinePositions[var2_2 + true];
            f2 = (f3 - dInf) / (tSup - tInf);
            f = dInf + (var1_1 - f) * f2;
        }
        return new FlingResult(f, f2);
    }

    /*
     * WARNING - void declaration
     */
    public final double deceleration(float velocity, float friction) {
        void var2_2;
        void var1_1;
        return Math.log((double)(0.35f * Math.abs((float)var1_1)) / (double)var2_2);
    }

    static {
        SplineBasedDecayKt.access$computeSplineInfo(SplinePositions, SplineTimes, 100);
        $stable = 8;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001a\u0010\t\u001a\u00020\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\f\u001a\u00020\u000bH\u00d6\u0001\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000f\u001a\u00020\u000eH\u00d6\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0011\u001a\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0011\u001a\u0004\b\u0014\u0010\u0013"}, d2={"Landroidx/compose/animation/AndroidFlingSpline$FlingResult;", "", "", "distanceCoefficient", "velocityCoefficient", "<init>", "(FF)V", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "F", "getDistanceCoefficient", "()F", "getVelocityCoefficient"})
    public static final class FlingResult {
        private final float distanceCoefficient;
        private final float velocityCoefficient;

        /*
         * WARNING - void declaration
         */
        public FlingResult(float distanceCoefficient, float velocityCoefficient) {
            void var2_2;
            void var1_1;
            this.distanceCoefficient = var1_1;
            this.velocityCoefficient = var2_2;
        }

        public final float getDistanceCoefficient() {
            return this.distanceCoefficient;
        }

        public final float getVelocityCoefficient() {
            return this.velocityCoefficient;
        }

        public final String toString() {
            return "FlingResult(distanceCoefficient=" + this.distanceCoefficient + ", velocityCoefficient=" + this.velocityCoefficient + ")";
        }

        public final int hashCode() {
            int n = Float.hashCode(this.distanceCoefficient);
            n = n * 31 + Float.hashCode(this.velocityCoefficient);
            return n;
        }

        public final boolean equals(Object other) {
            FlingResult flingResult;
            if (this == other) {
                return true;
            }
            if (!(other instanceof FlingResult)) {
                return false;
            }
            flingResult = flingResult;
            if (Float.compare(this.distanceCoefficient, flingResult.distanceCoefficient) != 0) {
                return false;
            }
            return Float.compare(this.velocityCoefficient, flingResult.velocityCoefficient) == 0;
        }
    }
}

