/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.string.AddressStringDivisionSeries;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import java.util.Iterator;

public class MACAddressSegment
extends AddressDivision
implements AddressSegment,
Iterable<MACAddressSegment> {
    private final int value;
    private final int upperValue;

    /*
     * WARNING - void declaration
     */
    public MACAddressSegment(int value) {
        void var1_1;
        if (value < 0 || value > 255) {
            throw new AddressValueException(value);
        }
        MACAddressSegment mACAddressSegment = this;
        mACAddressSegment.value = mACAddressSegment.upperValue = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public MACAddressSegment(int lower, int upper) {
        void var2_2;
        void var1_1;
        if (lower > upper) {
            void var3_3;
            int tmp = lower;
            lower = upper;
            upper = var3_3;
        }
        if (lower < 0 || upper < 0 || upper > 255) {
            throw new AddressValueException(lower < 0 ? (long)lower : (long)upper);
        }
        this.value = var1_1;
        this.upperValue = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var1_1;
        return new byte[]{(byte)(var1_1 != false ? this.getSegmentValue() : this.getUpperSegmentValue())};
    }

    /*
     * WARNING - void declaration
     */
    protected MACAddressSegment setPrefixedSegment(Integer oldPrefixLength, Integer segmentPrefixLength, boolean zeroed) {
        void var3_3;
        void var2_2;
        void var1_1;
        return MACAddressSegment.setPrefixedSegment(this, (Integer)var1_1, (Integer)var2_2, (boolean)var3_3, this.getSegmentCreator());
    }

    private MACAddressNetwork.MACAddressCreator getSegmentCreator() {
        return this.getNetwork().getAddressCreator();
    }

    public MACAddressNetwork getNetwork() {
        return MACAddress.defaultMACNetwork();
    }

    public int getValueCount() {
        return this.getUpperSegmentValue() - this.getSegmentValue() + 1;
    }

    @Override
    public int getBitCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public long getMaxValue() {
        return 255L;
    }

    @Override
    public long getDivisionValue() {
        return this.getSegmentValue();
    }

    @Override
    public long getUpperDivisionValue() {
        return this.getUpperSegmentValue();
    }

    @Override
    public int getSegmentValue() {
        return this.value;
    }

    @Override
    public int getUpperSegmentValue() {
        return this.upperValue;
    }

    /*
     * WARNING - void declaration
     */
    private MACAddressSegment getLowestOrHighest(boolean lowest) {
        void var1_1;
        if (!this.isMultiple()) {
            return this;
        }
        return this.getSegmentCreator().createSegment(var1_1 != false ? this.getSegmentValue() : this.getUpperSegmentValue());
    }

    public MACAddressSegment getLower() {
        return this.getLowestOrHighest(true);
    }

    public MACAddressSegment getUpper() {
        return this.getLowestOrHighest(false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameValues(AddressDivisionBase other) {
        void var1_1;
        return other instanceof MACAddressSegment && this.isSameValues((MACAddressSegment)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isSameValues(MACAddressSegment otherSegment) {
        void var1_1;
        return this.value == otherSegment.value && this.upperValue == var1_1.upperValue;
    }

    @Override
    public int hashCode() {
        return MACAddressSegment.hash(this.value, this.upperValue, this.getBitCount());
    }

    /*
     * WARNING - void declaration
     */
    static int hash(int lower, int upper, int bitCount) {
        void var2_2;
        void var1_1;
        return lower | var1_1 << var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof MACAddressSegment && ((MACAddressSegment)var1_1).isSameValues(this);
    }

    /*
     * WARNING - void declaration
     */
    public boolean contains(MACAddressSegment other) {
        void var1_1;
        return other.value >= this.value && var1_1.upperValue <= this.upperValue;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 16;
    }

    @Override
    public int getMaxDigitCount() {
        return 2;
    }

    /*
     * WARNING - void declaration
     */
    void setString(CharSequence addressStr, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex, int originalLowerValue) {
        void var2_2;
        if (this.cachedWildcardString == null && var2_2 != false && (long)originalLowerValue == ((AddressDivision)this).getDivisionValue()) {
            void var3_3;
            void var1_1;
            this.cachedWildcardString = var1_1.subSequence((int)var3_3, lowerStringEndIndex).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    void setString(CharSequence addressStr, boolean isStandardRangeString, int lowerStringStartIndex, int upperStringEndIndex, int rangeLower, int rangeUpper) {
        if (this.cachedWildcardString == null) {
            void var2_2;
            if (this.isFullRange()) {
                this.cachedWildcardString = MACAddress.SEGMENT_WILDCARD_STR;
                return;
            }
            if (var2_2 != false && (long)rangeLower == ((AddressDivision)this).getDivisionValue() && (long)rangeUpper == ((AddressDivision)this).getUpperDivisionValue()) {
                void var3_3;
                void var1_1;
                this.cachedWildcardString = var1_1.subSequence((int)var3_3, upperStringEndIndex).toString();
            }
        }
    }

    @Override
    public Iterator<MACAddressSegment> iterator() {
        MACAddressSegment mACAddressSegment = this;
        return MACAddressSegment.iterator(mACAddressSegment, mACAddressSegment.getSegmentCreator(), null, false, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressComponentSpliterator<MACAddressSegment> spliterator() {
        void var1_1;
        void var2_2;
        MACAddressNetwork.MACAddressCreator creator = this.getSegmentCreator();
        int bitCount = this.getBitCount();
        MACAddressSegment mACAddressSegment = this;
        return MACAddressSegment.createSegmentSpliterator(mACAddressSegment, mACAddressSegment.getSegmentValue(), this.getUpperSegmentValue(), this::iterator, (arg_0, arg_1, arg_2, arg_3) -> MACAddressSegment.lambda$spliterator$0((int)var2_2, creator, arg_0, arg_1, arg_2, arg_3), (arg_0, arg_1) -> MACAddressSegment.lambda$spliterator$1((MACAddressNetwork.MACAddressCreator)var1_1, arg_0, arg_1));
    }

    @Override
    public int getMaxSegmentValue() {
        return 255;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(AddressSegment other) {
        void var1_1;
        return other instanceof MACAddressSegment && other.getSegmentValue() >= this.value && var1_1.getUpperSegmentValue() <= this.upperValue;
    }

    @Override
    protected String getDefaultSegmentWildcardString() {
        return Address.SEGMENT_WILDCARD_STR;
    }

    @Override
    public String toNormalizedString() {
        return this.toNormalizedString(MACAddressSection.MACStringCache.canonicalParams);
    }

    /*
     * WARNING - void declaration
     */
    public String toNormalizedString(AddressDivisionGrouping.StringOptions options) {
        void var2_2;
        void var1_1;
        AddressDivisionGroupingBase.AddressStringParams<AddressStringDivisionSeries> params = MACAddressSection.toParams(options);
        StringBuilder builder = new StringBuilder(params.getDivisionStringLength(this));
        return var1_1.appendDivision((StringBuilder)var2_2, this).toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsPrefixBlock(int divisionPrefixLen) {
        void var1_1;
        MACAddressSegment mACAddressSegment = this;
        return mACAddressSegment.isPrefixBlock(((AddressDivision)mACAddressSegment).getDivisionValue(), ((AddressDivision)this).getUpperDivisionValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsSinglePrefixBlock(int divisionPrefixLen) {
        void var1_1;
        MACAddressSegment mACAddressSegment = this;
        return mACAddressSegment.isSinglePrefixBlock(((AddressDivision)mACAddressSegment).getDivisionValue(), ((AddressDivision)this).getUpperDivisionValue(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ MACAddressSegment lambda$spliterator$1(MACAddressNetwork.MACAddressCreator creator, int value, int upperValue) {
        void var2_2;
        void var1_1;
        return creator.createSegment((int)var1_1, (int)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Iterator lambda$spliterator$0(int bitCount, MACAddressNetwork.MACAddressCreator creator, boolean isLowest, boolean isHighest, int value, int upperValue) {
        void var1_1;
        int n;
        return MACAddressSegment.iterator(null, value, upperValue, n, var1_1, null, false, false);
    }
}

