/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressPositionException;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.string.AddressStringDivisionSeries;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSegment;
import java.math.BigInteger;
import java.util.Iterator;

public class MACAddressSection
extends AddressDivisionGrouping
implements AddressSection,
Iterable<MACAddressSection> {
    private static final long[] MAX_VALUES_LONG = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL, 0xFFFFFFFFFFL, 0xFFFFFFFFFFFFL, 0xFFFFFFFFFFFFFFL};
    private static final BigInteger[] MAX_VALUES = new BigInteger[]{BigInteger.ZERO, BigInteger.valueOf(MAX_VALUES_LONG[1]), BigInteger.valueOf(MAX_VALUES_LONG[2]), BigInteger.valueOf(MAX_VALUES_LONG[3]), BigInteger.valueOf(MAX_VALUES_LONG[4]), BigInteger.valueOf(MAX_VALUES_LONG[5]), BigInteger.valueOf(MAX_VALUES_LONG[6]), BigInteger.valueOf(MAX_VALUES_LONG[7]), BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.ONE)};
    private static MACAddressNetwork.MACAddressCreator[][] creators = new MACAddressNetwork.MACAddressCreator[2][8];
    private transient MACStringCache stringCache;
    private transient AddressDivisionGrouping.SectionCache<MACAddressSection> sectionCache;
    public final int addressSegmentIndex;
    public final boolean extended;

    /*
     * WARNING - void declaration
     */
    protected MACAddressSection(boolean cloneSegments, MACAddressSegment[] segments, int startIndex, boolean extended) {
        super(var1_1 != false ? (AddressDivision[])segments.clone() : segments);
        void var3_3;
        void var1_1;
        this.addressSegmentIndex = startIndex;
        this.extended = extended;
        if (startIndex < 0 || startIndex > (extended ? 8 : 6)) {
            throw new AddressPositionException(startIndex);
        }
        if (var3_3 + segments.length > (extended ? 8 : 6)) {
            void var2_2;
            throw new AddressValueException(((void)var2_2).length);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected MACAddressSection(byte[] bytes, int segmentCount, int startIndex, boolean extended, boolean cloneBytes) {
        this(bytes, 0, ((void)var1_1).length, (int)var2_2, (int)var3_3, extended, cloneBytes);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected MACAddressSection(byte[] bytes, int byteStartIndex, int byteEndIndex, int segmentCount, int startIndex, boolean extended, boolean cloneBytes) {
        super(new MACAddressSegment[segmentCount >= 0 ? segmentCount : Math.max(0, byteEndIndex - byteStartIndex)], false);
        void var3_3;
        void var2_2;
        AddressSegment[] segs = this.getSegmentsInternal();
        MACAddressSection.toSegments((AddressSegment[])segs, (byte[])bytes, (int)var2_2, (int)var3_3, (int)this.getBytesPerSegment(), (int)this.getBitsPerSegment(), (AddressNetwork)this.getNetwork(), null);
        if (startIndex < 0 || startIndex > (extended ? 8 : 6)) {
            throw new AddressPositionException(startIndex);
        }
        this.addressSegmentIndex = startIndex;
        this.extended = extended;
        if (bytes.length == segs.length) {
            void var1_1;
            this.setBytes((byte[])(cloneBytes ? (byte[])bytes.clone() : var1_1));
        }
    }

    public MACAddressNetwork getNetwork() {
        return MACAddress.defaultMACNetwork();
    }

    /*
     * WARNING - void declaration
     */
    protected MACAddressNetwork.MACAddressCreator getAddressCreator(int startIndex, boolean extended) {
        void var3_3;
        void var2_2;
        MACAddressNetwork.MACAddressCreator creator = null;
        MACAddressNetwork.MACAddressCreator defaultCreator = this.getNetwork().getAddressCreator();
        boolean useCached = startIndex < 8;
        int ext = 0;
        if (useCached) {
            if (extended) {
                ext = 1;
            }
            creator = creators[ext][startIndex];
        }
        if (creator != null && (useCached = true | creator.getNetwork().equals(this.getNetwork()))) {
            return creator;
        }
        MACAddressSection mACAddressSection = this;
        creator = new MACAddressNetwork.MACAddressCreator(mACAddressSection, mACAddressSection.getNetwork(), defaultCreator.cache, startIndex, (boolean)var2_2){
            final /* synthetic */ int val$startIndex;
            final /* synthetic */ boolean val$extended;
            final /* synthetic */ MACAddressSection this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$startIndex = n;
                this.val$extended = bl;
                super((MACAddressNetwork)var2_2, (MACAddressNetwork.MACAddressCreator.Cache)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected MACAddressSection createSectionInternal(MACAddressSegment[] segments) {
                void var1_1;
                return this.getNetwork().getAddressCreator().createSectionInternal((MACAddressSegment[])var1_1, this.val$startIndex, this.val$extended);
            }
        };
        if (useCached) {
            MACAddressSection.creators[ext][var1_1] = creator;
        }
        return var3_3;
    }

    MACAddressNetwork.MACAddressCreator getAddressCreator() {
        MACAddressSection mACAddressSection = this;
        return mACAddressSection.getAddressCreator(mACAddressSection.addressSegmentIndex, this.extended);
    }

    private AddressNetwork.AddressSegmentCreator<MACAddressSegment> getSegmentCreator() {
        return this.getAddressCreator(0, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        void var1_1;
        return other instanceof MACAddressSection && super.isSameGrouping((AddressDivisionGroupingBase)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof MACAddressSection) {
            void var1_1;
            MACAddressSection other = (MACAddressSection)o;
            return this.addressSegmentIndex == other.addressSegmentIndex && this.isExtended() == other.isExtended() && var1_1.isSameGrouping(this);
        }
        return false;
    }

    protected MACStringCache getStringCache() {
        return this.stringCache;
    }

    public MACAddressSegment[] getSegments() {
        return (MACAddressSegment[])this.getDivisionsInternal().clone();
    }

    protected MACAddressSegment[] getSegmentsInternal() {
        return (MACAddressSegment[])super.getDivisionsInternal();
    }

    public boolean isExtended() {
        return this.extended;
    }

    @Override
    public int getSegmentCount() {
        return this.getDivisionCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MACAddressSegment getDivision(int index) {
        void var1_1;
        return (MACAddressSegment)super.getDivision((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MACAddressSegment getSegment(int index) {
        void var1_1;
        return (MACAddressSegment)super.getDivision((int)var1_1);
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount();
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() << 3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var3_3;
        int segmentCount = this.getSegmentCount();
        byte[] bytes = new byte[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            MACAddressSegment seg = this.getSegment(i);
            int val = low ? seg.getSegmentValue() : seg.getUpperSegmentValue();
            bytes[i] = (byte)val;
        }
        return var3_3;
    }

    @Override
    protected BigInteger getCountImpl() {
        MACAddressSection mACAddressSection = this;
        return mACAddressSection.getCountImpl(mACAddressSection.getSegmentCount());
    }

    /*
     * WARNING - void declaration
     */
    private BigInteger getCountImpl(int segCount) {
        void var2_2;
        long lastValue;
        void var1_1;
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        long result = this.getSegment(0).getValueCount();
        int limit = Math.min(segCount, 7);
        for (int i = 1; i < limit; ++i) {
            result *= (long)this.getSegment(i).getValueCount();
        }
        if (var1_1 == 8 && (lastValue = (long)this.getSegment(7).getValueCount()) != 1L) {
            if (result <= 0x7FFFFFFFFFFFFFL) {
                result *= lastValue;
            } else {
                return BigInteger.valueOf(result).multiply(BigInteger.valueOf(lastValue));
            }
        }
        return BigInteger.valueOf((long)var2_2);
    }

    @Override
    public boolean isPrefixed() {
        return ((AddressDivisionGroupingBase)this).getPrefixLength() != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Integer getPrefixLength() {
        void var1_1;
        Integer ret = this.cachedPrefixLength;
        if (ret == null) {
            void var1_2;
            int prefix = this.getMinPrefixLengthForBlock();
            if (prefix == this.getBitCount()) {
                this.cachedPrefixLength = NO_PREFIX_LENGTH;
                return null;
            }
            this.cachedPrefixLength = MACAddressSection.cacheBits((int)var1_2);
            return this.cachedPrefixLength;
        }
        if (var1_1.intValue() == NO_PREFIX_LENGTH.intValue()) {
            return null;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void assignPrefixLength(Integer prefixLength) {
        void var1_1;
        if (prefixLength == null) {
            this.cachedPrefixLength = NO_PREFIX_LENGTH;
            return;
        }
        if (prefixLength < 0) {
            throw new PrefixLenException(prefixLength);
        }
        int max = this.getBitCount();
        if (prefixLength > max) {
            void var2_2;
            void var3_3;
            int maxPrefixLength;
            int n = maxPrefixLength = this.extended ? 64 : 48;
            if (prefixLength > var3_3) {
                throw new PrefixLenException(prefixLength);
            }
            prefixLength = (int)var2_2;
        }
        this.cachedPrefixLength = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private MACAddressSection getLowestOrHighestSection(boolean lowest) {
        MACAddressSection mACAddressSection;
        MACAddressSection result = MACAddressSection.getSingleLowestOrHighestSection(this);
        if (result == null && (this.sectionCache == null || (result = lowest ? (MACAddressSection)this.sectionCache.lower : (MACAddressSection)this.sectionCache.upper) == null)) {
            MACAddressSection mACAddressSection2 = this;
            synchronized (mACAddressSection2) {
                boolean create = this.sectionCache == null;
                if (create) {
                    this.sectionCache = new AddressDivisionGrouping.SectionCache();
                } else if (lowest) {
                    result = (MACAddressSection)this.sectionCache.lower;
                    create = result == null;
                } else {
                    result = (MACAddressSection)this.sectionCache.upper;
                    boolean bl = create = result == null;
                }
                if (create) {
                    void var1_1;
                    Integer prefLength;
                    MACAddressNetwork.MACAddressCreator creator = this.getAddressCreator();
                    MACAddressSegment[] segs = (MACAddressSegment[])MACAddressSection.createSingle((AddressSection)this, (AddressNetwork.AddressSegmentCreator)creator, (int i) -> {
                        void var2_2;
                        if (lowest) {
                            return this.getSegment(i).getLower();
                        }
                        return this.getSegment((int)var2_2).getUpper();
                    });
                    MACAddressSection mACAddressSection3 = mACAddressSection = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets() || (prefLength = ((AddressDivisionGroupingBase)this).getPrefixLength()) == null ? creator.createSectionInternal(segs) : ((MACAddressNetwork.MACAddressCreator)((Object)mACAddressSection)).createPrefixedSectionInternal(segs, prefLength, true);
                    if (var1_1 != false) {
                        this.sectionCache.lower = mACAddressSection;
                    } else {
                        this.sectionCache.upper = mACAddressSection;
                    }
                }
            }
        }
        return mACAddressSection;
    }

    public MACAddressSection getLower() {
        return this.getLowestOrHighestSection(true);
    }

    public MACAddressSection withoutPrefixLength() {
        return this.removePrefixLength(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public MACAddressSection removePrefixLength(boolean zeroed) {
        void var1_1;
        if (((AddressDivisionGroupingBase)this).getPrefixLength() == null) {
            return this;
        }
        return this.removePrefix((boolean)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private MACAddressSection removePrefix(boolean zeroed) {
        void var1_2;
        void var2_3;
        MACAddressSegment[] oldSegs = this.getSegmentsInternal();
        MACAddressSegment[] newSegs = (MACAddressSegment[])MACAddressSection.removePrefix((AddressSection)this, (AddressSegment[])var2_3, (int)this.getBitsPerSegment(), (S seg, Integer oldPrefLength, Integer newPrefLength) -> {
            boolean bl;
            void var3_3;
            void var2_2;
            return seg.setPrefixedSegment((Integer)var2_2, (Integer)var3_3, bl);
        });
        MACAddressSection result = this.getAddressCreator().createSectionInternal(newSegs);
        result.assignPrefixLength(null);
        return var1_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<MACAddressSection> iterator() {
        void var2_2;
        void var1_1;
        MACAddressNetwork.MACAddressCreator creator = this.getAddressCreator();
        boolean isSingle = !this.isMultiple();
        return MACAddressSection.iterator(isSingle, this, var1_1, var2_2 != false ? null : this.segmentsIterator(), ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets() ? null : ((AddressDivisionGroupingBase)this).getPrefixLength());
    }

    public Iterator<MACAddressSegment[]> segmentsIterator() {
        return MACAddressSection.segmentsIterator(this.getSegmentCount(), this.getSegmentCreator(), this.isMultiple() ? null : () -> this.getLower().getSegments(), index -> {
            void var1_1;
            return this.getSegment((int)var1_1).iterator();
        }, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressComponentSpliterator<MACAddressSection> spliterator() {
        void var1_1;
        void var2_2;
        void var3_4;
        MACAddressSection forIteration;
        int segmentCount = this.getSegmentCount();
        Integer prefixLength = ((AddressDivisionGroupingBase)this).getPrefixLength();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (bl) {
            Object iterationsPrefix = null;
            forIteration = this.withoutPrefixLength();
        } else {
            forIteration = this;
        }
        MACAddressNetwork.MACAddressCreator creator = this.getAddressCreator();
        int networkSegIndex = segmentCount - 1;
        int hostSegIndex = segmentCount;
        return MACAddressSection.createSeriesSpliterator(var3_4, arg_0 -> MACAddressSection.lambda$spliterator$20(creator, (Integer)var2_2, networkSegIndex, hostSegIndex, arg_0), (isLowest, isHighest, section) -> section.iterator(), AddressDivisionGroupingBase::getCount, section -> section.getCount().compareTo(LONG_MAX) <= 0, arg_0 -> MACAddressSection.lambda$spliterator$23((int)var1_1, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    protected AddressComponentSpliterator<MACAddress> spliterator(MACAddress original, MACAddressNetwork.MACAddressCreator creator) {
        void var3_3;
        void var2_2;
        void var1_1;
        Integer iterationsPrefix;
        int segmentCount = this.getSegmentCount();
        Integer prefixLength = ((AddressDivisionGroupingBase)this).getPrefixLength();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (bl) {
            iterationsPrefix = null;
            MACAddress forIteration = original.withoutPrefixLength();
        }
        int networkSegIndex = segmentCount - 1;
        int hostSegIndex = segmentCount;
        return MACAddressSection.createSeriesSpliterator(var1_1, arg_0 -> MACAddressSection.lambda$spliterator$25((MACAddressNetwork.MACAddressCreator)var2_2, iterationsPrefix, networkSegIndex, hostSegIndex, arg_0), (isLowest, isHighest, addr) -> addr.iterator(), Address::getCount, addr -> addr.getCount().compareTo(LONG_MAX) <= 0, arg_0 -> MACAddressSection.lambda$spliterator$28((int)var3_3, arg_0));
    }

    /*
     * WARNING - void declaration
     */
    protected Iterator<MACAddress> iterator(MACAddress original, MACAddressNetwork.MACAddressCreator creator) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isSingle = !this.isMultiple();
        return MACAddressSection.iterator(isSingle, var1_1, var2_2, var3_3 != false ? null : this.segmentsIterator(), ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets() ? null : ((AddressDivisionGroupingBase)this).getPrefixLength());
    }

    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            MACAddressSection mACAddressSection = this;
            synchronized (mACAddressSection) {
                if (this.stringCache == null) {
                    this.stringCache = new MACStringCache();
                    return true;
                }
            }
        }
        return false;
    }

    public String toNormalizedString(AddressDivisionGrouping.StringOptions stringOptions) {
        return MACAddressSection.toNormalizedString(stringOptions, this);
    }

    /*
     * WARNING - void declaration
     */
    public static String toNormalizedString(AddressDivisionGrouping.StringOptions opts, AddressDivisionGrouping section) {
        void var1_1;
        return MACAddressSection.toParams(opts).toString((AddressStringDivisionSeries)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().normalizedString) == null) {
            this.getStringCache().normalizedString = result = this.toNormalizedString(MACStringCache.normalizedParams);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toCanonicalString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().canonicalString) == null) {
            this.getStringCache().canonicalString = result = this.toNormalizedString(MACStringCache.canonicalParams);
        }
        return var1_1;
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(AddressSection other) {
        void var1_1;
        return other instanceof MACAddressSection && this.contains((MACAddressSection)var1_1);
    }

    public boolean contains(MACAddressSection other) {
        if (this.addressSegmentIndex != other.addressSegmentIndex || this.isExtended() != other.isExtended() || this.getSegmentCount() != other.getSegmentCount()) {
            return false;
        }
        for (int i = 0; i < this.getSegmentCount(); ++i) {
            if (this.getSegment(i).contains(other.getSegment(i))) continue;
            return false;
        }
        return true;
    }

    protected static AddressDivisionGroupingBase.AddressStringParams<AddressStringDivisionSeries> toParams(AddressDivisionGrouping.StringOptions opts) {
        return AddressDivisionGroupingBase.AddressStringParams.toParams(opts);
    }

    private static /* synthetic */ long lambda$spliterator$28(int segmentCount, MACAddress addr) {
        int n;
        return MACAddressSection.longCount(addr.getSection(), n);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$25(MACAddressNetwork.MACAddressCreator creator, Integer iterationsPrefix, int networkSegIndex, int hostSegIndex, AddressDivisionGroupingBase.SplitterSink spliterator) {
        void var1_1;
        void var3_3;
        void var2_2;
        MACAddressNetwork.MACAddressCreator mACAddressCreator;
        return MACAddressSection.split((AddressDivisionGroupingBase.SplitterSink)spliterator, (T segs) -> {
            void var1_1;
            MACAddressNetwork.MACAddressCreator mACAddressCreator;
            return (MACAddress)MACAddressSection.createIteratedAddress((AddressSegment[])segs, (AddressCreator)mACAddressCreator, (Integer)var1_1);
        }, (AddressNetwork.AddressSegmentCreator)mACAddressCreator, (AddressSegment[])((MACAddress)spliterator.getAddressItem()).getSection().getSegmentsInternal(), (int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    private static /* synthetic */ long lambda$spliterator$23(int segmentCount, MACAddressSection section) {
        int n;
        return MACAddressSection.longCount(section, n);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$20(MACAddressNetwork.MACAddressCreator creator, Integer iterationsPrefix, int networkSegIndex, int hostSegIndex, AddressDivisionGroupingBase.SplitterSink spliterator) {
        void var1_1;
        void var3_3;
        void var2_2;
        MACAddressNetwork.MACAddressCreator mACAddressCreator;
        return MACAddressSection.split((AddressDivisionGroupingBase.SplitterSink)spliterator, (T segs) -> {
            void var1_1;
            MACAddressNetwork.MACAddressCreator mACAddressCreator;
            return (MACAddressSection)MACAddressSection.createIteratedSection((AddressSegment[])segs, (AddressCreator)mACAddressCreator, (Integer)var1_1);
        }, (AddressNetwork.AddressSegmentCreator)mACAddressCreator, (AddressSegment[])((MACAddressSection)spliterator.getAddressItem()).getSegmentsInternal(), (int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    public static class MACStringOptions
    extends AddressDivisionGrouping.StringOptions {
        /*
         * WARNING - void declaration
         */
        protected MACStringOptions(int base, boolean expandSegments, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, String label, boolean reverse, boolean splitDigits, boolean uppercase) {
            super((int)var1_1, (boolean)var2_2, (AddressDivisionGrouping.StringOptions.Wildcards)var3_3, segmentStrPrefix, separator, label, reverse, splitDigits, uppercase);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public static class Builder
        extends AddressDivisionGrouping.StringOptions.Builder {
            public Builder() {
                this(16, ':');
            }

            /*
             * WARNING - void declaration
             */
            protected Builder(int base, char separator) {
                super((int)var1_1, (char)var2_2);
                void var2_2;
                void var1_1;
            }

            @Override
            public MACStringOptions toOptions() {
                return new MACStringOptions(this.base, this.expandSegments, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    protected static class MACStringCache
    extends AddressDivisionGrouping.StringCache {
        static final AddressDivisionGrouping.StringOptions hexParams = new MACStringOptions.Builder().setSeparator(null).setExpandedSegments(true).setRadix(16).toOptions();
        static final AddressDivisionGrouping.StringOptions hexPrefixedParams = new MACStringOptions.Builder().setSeparator(null).setExpandedSegments(true).setRadix(16).setAddressLabel("0x").toOptions();
        static final AddressDivisionGrouping.StringOptions canonicalParams;
        static final AddressDivisionGrouping.StringOptions compressedParams;
        static final AddressDivisionGrouping.StringOptions normalizedParams;
        static final AddressDivisionGrouping.StringOptions dottedParams;
        static final AddressDivisionGrouping.StringOptions spaceDelimitedParams;
        public String normalizedString;

        protected MACStringCache() {
        }

        static {
            normalizedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf(':')).setExpandedSegments(true).setRadix(16).toOptions();
            canonicalParams = new MACStringOptions.Builder().setSeparator(Character.valueOf('-')).setExpandedSegments(true).setRadix(16).setWildcards(new AddressDivisionGrouping.StringOptions.Wildcards(MACAddress.DASHED_SEGMENT_RANGE_SEPARATOR_STR, Address.SEGMENT_WILDCARD_STR, null)).toOptions();
            compressedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf(':')).setRadix(16).toOptions();
            dottedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf('.')).setExpandedSegments(true).setRadix(16).toOptions();
            spaceDelimitedParams = new MACStringOptions.Builder().setSeparator(Character.valueOf(' ')).setExpandedSegments(true).setRadix(16).toOptions();
        }
    }
}

