/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.mac.MACAddress;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.io.Serializable;

public class MACAddressNetwork
extends AddressNetwork<MACAddressSegment> {
    private static AddressNetwork.PrefixConfiguration defaultPrefixConfiguration = AddressNetwork.getDefaultPrefixConfiguration();
    private static final MACAddressSegment[] EMPTY_SEGMENTS = new MACAddressSegment[0];
    private MACAddressCreator creator = this.createAddressCreator();

    protected MACAddressCreator createAddressCreator() {
        return new MACAddressCreator(this);
    }

    public MACAddressCreator getAddressCreator() {
        return this.creator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isCompatible(AddressNetwork<?> other) {
        void var1_1;
        return super.isCompatible((AddressNetwork<?>)var1_1);
    }

    @Override
    public AddressNetwork.PrefixConfiguration getPrefixConfiguration() {
        return defaultPrefixConfiguration;
    }

    public static class MACAddressCreator
    extends AddressCreator<MACAddress, MACAddressSection, MACAddressSection, MACAddressSegment> {
        Cache cache;
        private final MACAddressNetwork owner;

        /*
         * WARNING - void declaration
         */
        MACAddressCreator(MACAddressNetwork owner) {
            void var1_1;
            this.owner = var1_1;
            this.cache = new Cache();
        }

        /*
         * WARNING - void declaration
         */
        MACAddressCreator(MACAddressNetwork owner, Cache cache) {
            void var2_2;
            void var1_1;
            this.owner = var1_1;
            this.cache = var2_2;
        }

        public MACAddressNetwork getNetwork() {
            return this.owner;
        }

        @Override
        public int getMaxValuePerSegment() {
            return 255;
        }

        /*
         * WARNING - void declaration
         */
        public MACAddressSegment[] createSegmentArray(int length) {
            void var1_1;
            if (length == 0) {
                return EMPTY_SEGMENTS;
            }
            return new MACAddressSegment[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MACAddressSegment createSegment(int value) {
            void var1_1;
            if (value >= 0 && value <= 255) {
                void var2_3;
                MACAddressSegment result;
                MACAddressSegment[] cache = this.cache.segmentCache;
                if (cache == null) {
                    cache = new MACAddressSegment[256];
                    Cache.access$102(this.cache, cache);
                    cache[value] = result = new MACAddressSegment(value);
                } else {
                    result = cache[value];
                    if (result == null) {
                        var3_2[value] = result = new MACAddressSegment(value);
                    }
                }
                return var2_3;
            }
            return new MACAddressSegment((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MACAddressSegment createSegment(int value, Integer segmentPrefixLength) {
            void var1_1;
            if (segmentPrefixLength != null) {
                if (segmentPrefixLength < 0) {
                    throw new PrefixLenException(segmentPrefixLength);
                }
                if (segmentPrefixLength > 64) {
                    throw new PrefixLenException(segmentPrefixLength);
                }
                if (((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                    void var3_4;
                    void var2_3;
                    MACAddressSegment result;
                    if (segmentPrefixLength == 0) {
                        result = this.cache.ALL_RANGE_SEGMENT;
                        if (result == null) {
                            result = new MACAddressSegment(0, 255);
                            Cache.access$202(this.cache, result);
                        }
                        return result;
                    }
                    int mask = -1 << 8 - (Integer)((Object)result);
                    int newLower = value & mask;
                    int newUpper = value | ~var2_3;
                    return this.createRangeSegment((int)var3_4, (int)var1_1);
                }
            }
            return this.createSegment((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public MACAddressSegment createRangeSegment(int lower, int upper) {
            void var1_1;
            if (lower != upper) {
                void var2_3;
                if (lower == 0 && upper == 255) {
                    void var1_2;
                    MACAddressSegment result = this.cache.ALL_RANGE_SEGMENT;
                    if (result == null) {
                        result = new MACAddressSegment(0, upper);
                        Cache.access$202(this.cache, result);
                    }
                    return var1_2;
                }
                return new MACAddressSegment((int)var1_1, (int)var2_3);
            }
            return this.createSegment((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public MACAddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            void var2_3;
            void var1_1;
            if (segmentPrefixLength == null) {
                return this.createRangeSegment(lower, upper);
            }
            if (segmentPrefixLength < 0) {
                throw new PrefixLenException(segmentPrefixLength);
            }
            if (segmentPrefixLength > 64) {
                throw new PrefixLenException(segmentPrefixLength);
            }
            if (((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                void var3_5;
                void result2;
                if (segmentPrefixLength == 0) {
                    MACAddressSegment result2 = this.cache.ALL_RANGE_SEGMENT;
                    if (result2 == null) {
                        result2 = new MACAddressSegment(0, 255);
                        Cache.access$202(this.cache, result2);
                    }
                    return result2;
                }
                int mask = -1 << 8 - segmentPrefixLength & 0xFF;
                int newLower = result2 & mask;
                int newUpper = upper | ~var3_5 & 0xFF;
                return this.createRangeSegment((int)var1_1, (int)var2_3);
            }
            return this.createRangeSegment((int)var1_1, (int)var2_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddressSegment createSegmentInternal(int value, Integer segmentPrefixLength, CharSequence addressStr, int originalVal, boolean isStandardString, int lowerStringStartIndex, int lowerStringEndIndex) {
            void var1_2;
            void var3_4;
            void var2_3;
            MACAddressSegment segment = this.createSegment(value, (Integer)var2_3);
            segment.setString((CharSequence)var3_4, isStandardString, lowerStringStartIndex, lowerStringEndIndex, originalVal);
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddressSegment createRangeSegmentInternal(int lower, int upper, Integer segmentPrefixLength, CharSequence addressStr, int originalLower, int originalUpper, boolean isStandardString, boolean isStandardRangeString, int lowerStringStartIndex, int lowerStringEndIndex, int upperStringEndIndex) {
            void var1_2;
            void var3_4;
            void var2_3;
            MACAddressSegment segment = this.createSegment(lower, (int)var2_3, (Integer)var3_4);
            segment.setString(addressStr, isStandardRangeString, lowerStringStartIndex, upperStringEndIndex, originalLower, originalUpper);
            return var1_2;
        }

        /*
         * WARNING - void declaration
         */
        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments) {
            void var1_1;
            return new MACAddressSection(false, segments, 0, ((void)var1_1).length > 6);
        }

        /*
         * WARNING - void declaration
         */
        protected MACAddressSection createPrefixedSectionInternal(MACAddressSegment[] segments, Integer prefixLength, boolean singleOnly) {
            void var2_2;
            void var1_1;
            return this.createPrefixedSectionInternal((MACAddressSegment[])var1_1, (Integer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected MACAddressSection createPrefixedSectionInternal(MACAddressSegment[] segments, Integer prefixLength) {
            void var1_1;
            void var2_2;
            MACAddressSection result = new MACAddressSection(false, segments, 0, segments.length > 6);
            result.assignPrefixLength((Integer)var2_2);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected MACAddressSection createSectionInternal(MACAddressSegment[] segments, int startIndex, boolean extended) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new MACAddressSection(false, (MACAddressSegment[])var1_1, (int)var2_2, (boolean)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddressSection createSectionInternal(byte[] bytes, int segmentCount, Integer prefixLength, boolean singleOnly) {
            void var1_1;
            void var3_3;
            void var2_2;
            MACAddressSection result = new MACAddressSection(bytes, segmentCount, 0, var2_2 > 6, false);
            result.assignPrefixLength((Integer)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddress createAddressInternal(byte[] bytes, CharSequence zone) {
            void var1_1;
            MACAddressSection section = new MACAddressSection(bytes, bytes.length, 0, bytes.length > 6, false);
            return this.createAddress((MACAddressSection)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected MACAddress createAddressInternal(MACAddressSegment[] segments, Integer prefix) {
            void var2_2;
            void var1_1;
            MACAddressCreator mACAddressCreator = this;
            return mACAddressCreator.createAddress(mACAddressCreator.createPrefixedSectionInternal((MACAddressSegment[])var1_1, (Integer)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        protected MACAddress createAddressInternal(MACAddressSegment[] segments, Integer prefix, boolean singleOnly) {
            void var2_2;
            void var1_1;
            return this.createAddressInternal((MACAddressSegment[])var1_1, (Integer)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, HostIdentifierString from) {
            void var1_1;
            void var2_2;
            MACAddress result = this.createAddress(section);
            result.cache((HostIdentifierString)var2_2);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, CharSequence zone, HostIdentifierString from) {
            void var1_1;
            void var3_3;
            MACAddress result = this.createAddress(section);
            result.cache((HostIdentifierString)var3_3);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected MACAddress createAddressInternal(MACAddressSection section, CharSequence zone, HostIdentifierString from, MACAddress lower, MACAddress upper) {
            void var3_3;
            void var2_2;
            MACAddress mACAddress;
            mACAddress = this.createAddressInternal((MACAddressSection)((Object)mACAddress), (CharSequence)var2_2, (HostIdentifierString)var3_3);
            return mACAddress;
        }

        /*
         * WARNING - void declaration
         */
        public MACAddress createAddress(MACAddressSection section) {
            void var1_1;
            return new MACAddress((MACAddressSection)var1_1);
        }

        static class Cache
        implements Serializable {
            private transient MACAddressSegment ALL_RANGE_SEGMENT;
            private transient MACAddressSegment[] segmentCache;

            Cache() {
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ MACAddressSegment[] access$102(Cache x0, MACAddressSegment[] x1) {
                void var1_1;
                x0.segmentCache = var1_1;
                return x0.segmentCache;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ MACAddressSegment access$202(Cache x0, MACAddressSegment x1) {
                void var1_1;
                x0.ALL_RANGE_SEGMENT = var1_1;
                return x0.ALL_RANGE_SEGMENT;
            }
        }
    }
}

