/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.mac;

import inet.ipaddr.Address;
import inet.ipaddr.AddressPositionException;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.MACAddressString;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.mac.MACAddressNetwork;
import inet.ipaddr.mac.MACAddressSection;
import inet.ipaddr.mac.MACAddressSegment;
import java.util.Iterator;

public class MACAddress
extends Address
implements Iterable<MACAddress> {
    public static final String DASHED_SEGMENT_RANGE_SEPARATOR_STR = "|";

    /*
     * WARNING - void declaration
     */
    public MACAddress(MACAddressSection section) throws AddressValueException {
        super(section);
        int segCount = section.getSegmentCount();
        if (segCount != 6 && segCount != 8) {
            void var2_2;
            throw new AddressValueException("ipaddress.error.mac.invalid.segment.count", (long)var2_2);
        }
        if (section.addressSegmentIndex != 0) {
            void var1_1;
            throw new AddressPositionException(var1_1.addressSegmentIndex);
        }
    }

    public MACAddressNetwork getNetwork() {
        return MACAddress.defaultMACNetwork();
    }

    public MACAddressNetwork.MACAddressCreator getAddressCreator() {
        return this.getNetwork().getAddressCreator();
    }

    @Override
    public MACAddressSection getSection() {
        return (MACAddressSection)super.getSection();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MACAddressSegment getDivision(int index) {
        void var1_1;
        return this.getSegment((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public MACAddressSegment getSegment(int index) {
        void var1_1;
        return this.getSection().getSegment((int)var1_1);
    }

    @Override
    public int getByteCount() {
        return this.getSection().getByteCount();
    }

    @Override
    public int getBitCount() {
        return this.getSection().getBitCount();
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isFromSameString(HostIdentifierString other) {
        if (this.fromString != null && other instanceof MACAddressString) {
            void var1_1;
            void var2_2;
            MACAddressString fromString = (MACAddressString)this.fromString;
            MACAddressString otherString = (MACAddressString)other;
            return fromString == otherString || fromString.toString().equals(otherString.toString()) && var2_2.getValidationOptions() == var1_1.getValidationOptions();
        }
        return false;
    }

    @Override
    public Iterator<MACAddress> iterator() {
        MACAddress mACAddress = this;
        return this.getSection().iterator(mACAddress, mACAddress.getAddressCreator());
    }

    @Override
    public AddressComponentSpliterator<MACAddress> spliterator() {
        MACAddress mACAddress = this;
        return this.getSection().spliterator(mACAddress, mACAddress.getAddressCreator());
    }

    /*
     * WARNING - void declaration
     */
    private MACAddress checkIdentity(MACAddressSection newSection) {
        void var1_1;
        void var2_2;
        MACAddressSection section = this.getSection();
        if (newSection == var2_2) {
            return this;
        }
        return this.getAddressCreator().createAddress((MACAddressSection)var1_1);
    }

    public MACAddress withoutPrefixLength() {
        return this.removePrefixLength(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public MACAddress removePrefixLength(boolean zeroed) {
        void var1_1;
        MACAddress mACAddress = this;
        return mACAddress.checkIdentity(mACAddress.getSection().removePrefixLength((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    void cache(HostIdentifierString string) {
        if (this.fromString instanceof MACAddressString) {
            void var1_1;
            this.fromString = var1_1;
        }
    }

    @Override
    public String toString() {
        return this.toNormalizedString();
    }
}

