/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressStringParameters;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.ipv4.IPv4AddressStringParameters;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import java.util.Objects;

public class IPv6AddressStringParameters
extends IPAddressStringParameters.IPAddressStringFormatParameters
implements Comparable<IPv6AddressStringParameters> {
    public final boolean allowMixed;
    public final boolean allowZone;
    public final boolean allowEmptyZone;
    public final boolean allowBase85;
    private final IPv6AddressNetwork network;
    private IPAddressStringParameters embeddedIPv4Options;

    /*
     * WARNING - void declaration
     */
    public IPv6AddressStringParameters(boolean allowLeadingZeros, boolean allowCIDRPrefixLeadingZeros, boolean allowUnlmitedLeadingZeros, boolean allowMixed, IPAddressStringParameters mixedOptions, boolean allowZone, boolean allowEmptyZone, boolean allowBase85, AddressStringParameters.RangeParameters rangeOptions, boolean allowWildcardedSeparator, boolean allowPrefixesBeyondAddressSize, boolean allowBinary, IPv6AddressNetwork network) {
        super(allowBinary, (boolean)var1_1, (boolean)var2_2, (boolean)var3_3, rangeOptions, allowWildcardedSeparator, allowPrefixesBeyondAddressSize);
        void var3_3;
        void var2_2;
        void var1_1;
        this.allowMixed = allowMixed;
        this.allowZone = allowZone;
        this.allowEmptyZone = allowEmptyZone;
        this.allowBase85 = allowBase85;
        this.embeddedIPv4Options = mixedOptions;
        this.network = network;
    }

    /*
     * WARNING - void declaration
     */
    public Builder toBuilder(boolean isMixed) {
        void var2_2;
        void var1_1;
        Builder builder = new Builder();
        Builder.access$002(builder, this.allowMixed);
        Builder.access$102(builder, this.allowZone);
        Builder.access$202(builder, this.allowEmptyZone);
        Builder.access$302(builder, this.allowBase85);
        Builder.access$402(builder, this.network);
        if (var1_1 == false) {
            Builder.access$502(builder, this.embeddedIPv4Options.toBuilder(true));
        }
        return (Builder)this.toBuilder((IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase)var2_2);
    }

    public IPv6AddressNetwork getNetwork() {
        if (this.network == null) {
            return Address.defaultIpv6Network();
        }
        return this.network;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressStringParameters clone() {
        try {
            void var1_1;
            IPv6AddressStringParameters result = (IPv6AddressStringParameters)super.clone();
            ((IPv6AddressStringParameters)super.clone()).embeddedIPv4Options = this.embeddedIPv4Options.clone();
            return var1_1;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public IPAddressStringParameters getMixedParameters() {
        return this.embeddedIPv4Options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(IPv6AddressStringParameters o) {
        void var2_2;
        int result = super.compareTo(o);
        if (result == 0 && (result = this.embeddedIPv4Options.getIPv4Parameters().compareTo(o.embeddedIPv4Options.getIPv4Parameters())) == 0 && (result = Boolean.compare(this.allowMixed, o.allowMixed)) == 0 && (result = Boolean.compare(this.allowZone, o.allowZone)) == 0 && (result = Boolean.compare(this.allowEmptyZone, o.allowEmptyZone)) == 0) {
            void var1_1;
            result = Boolean.compare(this.allowBase85, var1_1.allowBase85);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o instanceof IPv6AddressStringParameters && super.equals(o)) {
            void var1_1;
            IPv6AddressStringParameters other = (IPv6AddressStringParameters)o;
            return Objects.equals(this.embeddedIPv4Options.getIPv4Parameters(), other.embeddedIPv4Options.getIPv4Parameters()) && this.allowMixed == other.allowMixed && this.allowZone == other.allowZone && this.allowEmptyZone == other.allowEmptyZone && this.allowBase85 == var1_1.allowBase85;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = super.hashCode();
        int hash = n | ((AddressStringParameters.AddressStringFormatParameters)this.embeddedIPv4Options.getIPv4Parameters()).hashCode() << 6;
        if (this.allowMixed) {
            hash |= 0x8000;
        }
        if (this.allowZone) {
            hash |= 0x10000;
        }
        if (this.allowBase85) {
            hash |= 0x20000;
        }
        return n;
    }

    public static class Builder
    extends IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase {
        private boolean allowMixed = true;
        private boolean allowZone = true;
        private boolean allowEmptyZone = true;
        private boolean allowBase85 = true;
        private IPAddressStringParameters.Builder embeddedIPv4OptionsBuilder;
        private IPv6AddressNetwork network;
        private static IPAddressStringParameters DEFAULT_MIXED_OPTS = new IPAddressStringParameters(false, false, false, false, false, false, false, true, false, new IPv4AddressStringParameters.Builder().toParams(), new IPv6AddressStringParameters(false, false, false, false, null, true, false, false, AddressStringParameters.AddressStringFormatParameters.DEFAULT_RANGE_OPTIONS, false, false, false, null));

        /*
         * WARNING - void declaration
         */
        public Builder allowZone(boolean allow) {
            void var1_1;
            this.getEmbeddedIPv4ParametersBuilder().getIPv6AddressParametersBuilder().allowZone = allow;
            this.allowZone = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder allowMixed(boolean allow) {
            void var1_1;
            this.allowMixed = var1_1;
            return this;
        }

        public IPv4AddressStringParameters.Builder getEmbeddedIPv4AddressParametersBuilder() {
            return this.getEmbeddedIPv4ParametersBuilder().getIPv4AddressParametersBuilder();
        }

        IPAddressStringParameters.Builder getEmbeddedIPv4ParametersBuilder() {
            if (this.embeddedIPv4OptionsBuilder == null) {
                this.embeddedIPv4OptionsBuilder = new IPAddressStringParameters.Builder().allowEmpty(false).allowPrefix(false).allowMask(false).allowPrefixOnly(false).allowAll(false).allowIPv6(false);
                this.embeddedIPv4OptionsBuilder.getIPv6AddressParametersBuilder().allowZone = this.allowZone;
                this.embeddedIPv4OptionsBuilder.getIPv6AddressParametersBuilder().allowEmptyZone = this.allowEmptyZone;
            }
            Builder builder = this;
            Builder.setMixedParentInst(builder, builder.embeddedIPv4OptionsBuilder.getIPv4AddressParametersBuilder());
            return this.embeddedIPv4OptionsBuilder;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNetwork(IPv6AddressNetwork network) {
            void var1_1;
            this.network = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder allowUnlimitedLeadingZeros(boolean allow) {
            void var1_1;
            this.getEmbeddedIPv4AddressParametersBuilder().allowUnlimitedLeadingZeros(allow);
            super.allowUnlimitedLeadingZeros((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder setRangeOptions(AddressStringParameters.RangeParameters rangeOptions) {
            void var1_1;
            this.getEmbeddedIPv4ParametersBuilder().getIPv4AddressParametersBuilder().setRangeOptions(rangeOptions);
            super.setRangeOptions((AddressStringParameters.RangeParameters)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public IPv6AddressStringParameters toParams() {
            void var1_1;
            IPAddressStringParameters mixedOptions = this.embeddedIPv4OptionsBuilder == null ? DEFAULT_MIXED_OPTS : this.embeddedIPv4OptionsBuilder.toParams();
            return new IPv6AddressStringParameters(this.allowLeadingZeros, this.allowPrefixLengthLeadingZeros, this.allowUnlimitedLeadingZeros, this.allowMixed, (IPAddressStringParameters)var1_1, this.allowZone, this.allowEmptyZone, this.allowBase85, this.rangeOptions, this.allowWildcardedSeparator, this.allowPrefixesBeyondAddressSize, this.allowBinary, this.network);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$002(Builder x0, boolean x1) {
            void var1_1;
            x0.allowMixed = var1_1;
            return x0.allowMixed;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$102(Builder x0, boolean x1) {
            void var1_1;
            x0.allowZone = var1_1;
            return x0.allowZone;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$202(Builder x0, boolean x1) {
            void var1_1;
            x0.allowEmptyZone = var1_1;
            return x0.allowEmptyZone;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$302(Builder x0, boolean x1) {
            void var1_1;
            x0.allowBase85 = var1_1;
            return x0.allowBase85;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPv6AddressNetwork access$402(Builder x0, IPv6AddressNetwork x1) {
            void var1_1;
            x0.network = var1_1;
            return x0.network;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPAddressStringParameters.Builder access$502(Builder x0, IPAddressStringParameters.Builder x1) {
            void var1_1;
            x0.embeddedIPv4OptionsBuilder = var1_1;
            return x0.embeddedIPv4OptionsBuilder;
        }
    }
}

