/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.util.AddressComponentRangeSpliterator;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.math.BigInteger;
import java.util.Iterator;

public class IPv6AddressSeqRange
extends IPAddressSeqRange
implements Iterable<IPv6Address> {
    private static final BigInteger LONG_MAX = BigInteger.valueOf(Long.MAX_VALUE);
    private static final IPv6AddressSeqRange[] EMPTY = new IPv6AddressSeqRange[0];

    /*
     * WARNING - void declaration
     */
    IPv6AddressSeqRange(IPv6Address first, IPv6Address second, boolean preSet) {
        super(var1_1, var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSeqRange(IPv6Address first, IPv6Address second) {
        super(first, second, IPv6Address::getLower, IPv6Address::getUpper, a -> a.withoutPrefixLength().removeZone());
        if (!first.getNetwork().isCompatible(second.getNetwork())) {
            void var2_2;
            void var1_1;
            throw new NetworkMismatchException((AddressItem)var1_1, (AddressItem)var2_2);
        }
    }

    @Override
    public IPv6Address getLower() {
        return (IPv6Address)super.getLower();
    }

    @Override
    public IPv6Address getUpper() {
        return (IPv6Address)super.getUpper();
    }

    private IPv6AddressNetwork.IPv6AddressCreator getAddressCreator() {
        return this.getLower().getDefaultCreator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<IPv6Address> iterator() {
        void var3_3;
        void var2_2;
        void var1_1;
        IPv6Address lower = this.getLower();
        IPv6Address upper = this.getUpper();
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getAddressCreator();
        if (!this.isMultiple()) {
            return IPv6AddressSeqRange.iterator(lower, creator);
        }
        int divCount = ((Address)lower).getSegmentCount();
        return IPv6AddressSeqRange.iterator(var1_1, var2_2, var3_3, IPv6Address::getSegment, (seg, segIndex) -> seg.iterator(), (addr1, addr2, index) -> {
            void var2_2;
            void var1_1;
            return addr1.getSegment(index).getSegmentValue() == var1_1.getSegment((int)var2_2).getSegmentValue();
        }, divCount - 1, divCount, null);
    }

    /*
     * WARNING - void declaration
     */
    public AddressComponentRangeSpliterator<IPv6AddressSeqRange, IPv6Address> spliterator() {
        void var1_1;
        void var3_3;
        void var2_2;
        int segmentCount = ((Address)this.getLower()).getSegmentCount();
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getAddressCreator();
        int networkSegIndex = segmentCount - 1;
        return IPv6AddressSeqRange.createSpliterator(this, arg_0 -> IPv6AddressSeqRange.lambda$spliterator$4((IPv6AddressNetwork.IPv6AddressCreator)var2_2, (int)var3_3, (int)var1_1, arg_0), (lowest, highest, range) -> range.iterator(), IPAddressSeqRange::getCount, range -> range.getCount().compareTo(LONG_MAX) <= 0, range -> range.getCount().longValue());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$4(IPv6AddressNetwork.IPv6AddressCreator creator, int networkSegIndex, int hostSegIndex, IPAddressSeqRange.IPAddressSeqRangeSplitterSink spliterator) {
        void var2_2;
        void var1_1;
        IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator;
        void var3_3;
        IPv6AddressSeqRange range = (IPv6AddressSeqRange)spliterator.getAddressItem();
        return IPv6AddressSeqRange.split((IPAddressSeqRange.IPAddressSeqRangeSplitterSink)var3_3, (T segsLower, U segsUpper) -> {
            void var2_2;
            IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator;
            void var1_1;
            return new IPv6AddressSeqRange(creator.createAddressInternal((IPv6AddressSegment[])var1_1), iPv6AddressCreator.createAddressInternal((IPv6AddressSegment[])var2_2));
        }, (AddressNetwork.AddressSegmentCreator)iPv6AddressCreator, (AddressSegment[])range.getLower().getSection().getSegmentsInternal(), (AddressSegment[])range.getUpper().getSection().getSegmentsInternal(), (int)var1_1, (int)var2_2, null);
    }
}

