/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import java.util.Iterator;

public class IPv6AddressSegment
extends IPAddressSegment
implements Iterable<IPv6AddressSegment> {
    /*
     * WARNING - void declaration
     */
    public IPv6AddressSegment(int value) throws AddressValueException {
        super(value);
        if (value > 65535) {
            void var1_1;
            throw new AddressValueException((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSegment(int value, Integer segmentPrefixLength) throws AddressValueException {
        super(value, segmentPrefixLength);
        if (value > 65535) {
            void var1_1;
            throw new AddressValueException((long)var1_1);
        }
        if (segmentPrefixLength != null && segmentPrefixLength > 128) {
            void var2_2;
            throw new PrefixLenException(var2_2.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSegment(int lower, int upper, Integer segmentPrefixLength) throws AddressValueException {
        super((int)var1_1, (int)var2_2, segmentPrefixLength);
        void var2_2;
        void var1_1;
        if (this.getUpperSegmentValue() > 65535) {
            throw new AddressValueException(this.getUpperSegmentValue());
        }
        if (segmentPrefixLength != null && segmentPrefixLength > 128) {
            void var3_3;
            throw new PrefixLenException(var3_3.intValue());
        }
    }

    @Override
    public long getMaxValue() {
        return 65535L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var1_1;
        int val = low ? this.getSegmentValue() : this.getUpperSegmentValue();
        return new byte[]{(byte)(val >>> 8), (byte)(0xFF & var1_1)};
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return Address.defaultIpv6Network();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getSegmentNetworkMask(int bits) {
        void var1_1;
        return this.getNetwork().getSegmentNetworkMask((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getSegmentHostMask(int bits) {
        void var1_1;
        return this.getNetwork().getSegmentHostMask((int)var1_1);
    }

    @Override
    public int getMaxSegmentValue() {
        return IPv6AddressSegment.getMaxSegmentValue(IPAddress.IPVersion.IPV6);
    }

    protected IPv6AddressSegment toPrefixNormalizedSeg() {
        return this.getSegmentCreator().createSegment(this.getSegmentValue(), this.getUpperSegmentValue(), IPv6AddressSection.cacheBits(this.getBitCount()));
    }

    /*
     * WARNING - void declaration
     */
    protected IPv6AddressSegment toPrefixedSegment(Integer segmentPrefixLength) {
        if (this.isChangedByPrefix(segmentPrefixLength, ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets())) {
            void var1_1;
            return super.toPrefixedSegment((Integer)var1_1, this.getSegmentCreator());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        void var1_1;
        return this.toNetworkSegment((Integer)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSegment toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength) {
        if (this.isNetworkChangedByPrefix(segmentPrefixLength, withPrefixLength)) {
            void var2_2;
            void var1_1;
            return super.toNetworkSegment((Integer)var1_1, (boolean)var2_2, this.getSegmentCreator());
        }
        return this;
    }

    public IPv6AddressSegment getLower() {
        IPv6AddressSegment iPv6AddressSegment = this;
        return IPv6AddressSegment.getLowestOrHighest(iPv6AddressSegment, iPv6AddressSegment.getSegmentCreator(), true);
    }

    public IPv6AddressSegment getUpper() {
        IPv6AddressSegment iPv6AddressSegment = this;
        return IPv6AddressSegment.getLowestOrHighest(iPv6AddressSegment, iPv6AddressSegment.getSegmentCreator(), false);
    }

    public IPv6AddressSegment withoutPrefixLength() {
        return IPv6AddressSegment.removePrefix(this, false, this.getSegmentCreator());
    }

    protected IPv6AddressNetwork.IPv6AddressCreator getSegmentCreator() {
        return this.getNetwork().getAddressCreator();
    }

    /*
     * WARNING - void declaration
     */
    Iterator<IPv6AddressSegment> iterator(boolean withPrefix) {
        void var1_1;
        void var2_2;
        IPv6AddressSegment original = !withPrefix && this.isPrefixed() && !((AddressDivision)this).isMultiple() ? this.withoutPrefixLength() : this;
        return IPv6AddressSegment.iterator(var2_2, this.getSegmentCreator(), var1_1 != false ? this.getSegmentPrefixLength() : null, false, false);
    }

    @Override
    public Iterator<IPv6AddressSegment> iterator() {
        IPv6AddressSegment iPv6AddressSegment = this;
        return iPv6AddressSegment.iterator(!((AddressNetwork)iPv6AddressSegment.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressComponentSpliterator<IPv6AddressSegment> spliterator() {
        void var2_3;
        void var1_1;
        void var3_4;
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getSegmentCreator();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        Integer segPrefLength = bl ? null : this.getSegmentPrefixLength();
        int bitCount = this.getBitCount();
        IPv6AddressSegment iPv6AddressSegment = this;
        return IPv6AddressSegment.createSegmentSpliterator(iPv6AddressSegment, iPv6AddressSegment.getSegmentValue(), this.getUpperSegmentValue(), this::iterator, (arg_0, arg_1, arg_2, arg_3) -> IPv6AddressSegment.lambda$spliterator$0((int)var3_4, creator, segPrefLength, arg_0, arg_1, arg_2, arg_3), (arg_0, arg_1) -> IPv6AddressSegment.lambda$spliterator$1((IPv6AddressNetwork.IPv6AddressCreator)var1_1, (Integer)var2_3, arg_0, arg_1));
    }

    @Override
    public int getBitCount() {
        return 16;
    }

    @Override
    public int getByteCount() {
        return 2;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 16;
    }

    @Override
    public int getMaxDigitCount() {
        return 4;
    }

    /*
     * WARNING - void declaration
     */
    public <S extends AddressSegment> void getSplitSegments(S[] segs, int index, AddressNetwork.AddressSegmentCreator<S> creator) {
        void var3_3;
        void var2_2;
        void var1_1;
        if (!((AddressDivision)this).isMultiple()) {
            Integer myPrefix = this.getSegmentPrefixLength();
            Integer highPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 0);
            Integer lowPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 1);
            if (index >= 0 && index < segs.length) {
                segs[index] = creator.createSegment(this.highByte(), highPrefixBits);
            }
            if (++index >= 0 && index < segs.length) {
                segs[index] = creator.createSegment(this.lowByte(), lowPrefixBits);
            }
            return;
        }
        this.getSplitSegmentsMultiple((AddressSegment[])var1_1, (int)var2_2, (AddressNetwork.AddressSegmentCreator)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    private <S extends AddressSegment> void getSplitSegmentsMultiple(S[] segs, int index, AddressNetwork.AddressSegmentCreator<S> creator) {
        Integer myPrefix = this.getSegmentPrefixLength();
        int val = this.getSegmentValue();
        int upperVal = this.getUpperSegmentValue();
        int highLower = IPv6AddressSegment.highByte(val);
        int highUpper = IPv6AddressSegment.highByte(upperVal);
        int lowLower = IPv6AddressSegment.lowByte(val);
        int lowUpper = IPv6AddressSegment.lowByte(upperVal);
        boolean highIsMult = highLower != highUpper;
        if (highIsMult && (lowLower != 0 || lowUpper != 255)) {
            throw new IncompatibleAddressException(this, "ipaddress.error.splitSeg");
        }
        if (index >= 0 && index < segs.length) {
            Integer highPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 0);
            segs[index] = highIsMult ? creator.createSegment(highLower, highUpper, highPrefixBits) : creator.createSegment(highLower, highPrefixBits);
        }
        if (++index >= 0 && index < segs.length) {
            void var3_3;
            Integer lowPrefixBits = IPv6AddressSegment.getSplitSegmentPrefix(8, myPrefix, 1);
            if (lowLower == lowUpper) {
                segs[index] = creator.createSegment(lowLower, lowPrefixBits);
                return;
            }
            var1_1[var2_2] = var3_3.createSegment(lowLower, lowUpper, lowPrefixBits);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(AddressSegment other) {
        void var1_1;
        return this == other || this.containsSeg(other) && var1_1 instanceof IPv6AddressSegment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof IPv6AddressSegment && ((IPv6AddressSegment)var1_1).isSameValues(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameValues(AddressDivisionBase other) {
        void var1_1;
        return other instanceof IPv6AddressSegment && this.isSameValues((AddressSegment)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getRangeDigitCountImpl() {
        int bitCount;
        int prefix = ((AddressDivision)this).getMinPrefixLengthForBlock();
        if (prefix < (bitCount = this.getBitCount()) && this.containsSinglePrefixBlock(prefix) && prefix % 4 == 0) {
            void var1_1;
            void var2_2;
            return (int)((var2_2 - var1_1) / 4);
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected static int toUnsignedStringLength(int value, int radix) {
        void var1_1;
        return IPAddressSegment.toUnsignedStringLength(value, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected static StringBuilder toUnsignedString(int value, int radix, StringBuilder appendable) {
        void var2_2;
        void var1_1;
        return IPAddressSegment.toUnsignedString(value, (int)var1_1, (StringBuilder)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IPv6AddressSegment lambda$spliterator$1(IPv6AddressNetwork.IPv6AddressCreator creator, Integer segPrefLength, int value, int upperValue) {
        void var1_1;
        void var3_3;
        void var2_2;
        return creator.createSegment((int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Iterator lambda$spliterator$0(int bitCount, IPv6AddressNetwork.IPv6AddressCreator creator, Integer segPrefLength, boolean isLowest, boolean isHighest, int value, int upperValue) {
        void var2_2;
        void var1_1;
        int n;
        return IPv6AddressSegment.iterator(null, value, upperValue, n, var1_1, (Integer)var2_2, false, false);
    }
}

