/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressPositionException;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.InconsistentPrefixException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.SizeMismatchException;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.standard.IPAddressDivision;
import inet.ipaddr.format.standard.IPAddressDivisionGrouping;
import inet.ipaddr.format.string.AddressStringDivision;
import inet.ipaddr.format.string.IPAddressStringDivisionSeries;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.format.util.IPAddressStringWriter;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;

public class IPv6AddressSection
extends IPAddressSection
implements Iterable<IPv6AddressSection> {
    private static IPv6AddressNetwork.IPv6AddressCreator[] creators = new IPv6AddressNetwork.IPv6AddressCreator[8];
    private transient IPv6StringCache stringCache;
    private transient AddressDivisionGrouping.SectionCache<IPv6AddressSection> sectionCache;
    transient IPv4AddressSection embeddedIPv4Section;
    transient IPv6v4MixedAddressSection defaultMixedAddressSection;
    public final int addressSegmentIndex;
    private transient IPAddressDivisionGrouping.RangeList zeroSegments;
    private transient IPAddressDivisionGrouping.RangeList zeroRanges;
    private static final BigInteger[] MAX_VALUES_BY_SEGMENT = new BigInteger[]{BigInteger.ZERO, BigInteger.valueOf(65535L), BigInteger.valueOf(0xFFFFFFFFL), BigInteger.valueOf(0xFFFFFFFFFFFFL), BigInteger.valueOf(1L).shiftLeft(64).subtract(BigInteger.ONE), BigInteger.valueOf(1L).shiftLeft(80).subtract(BigInteger.ONE), BigInteger.valueOf(1L).shiftLeft(96).subtract(BigInteger.ONE), BigInteger.valueOf(1L).shiftLeft(112).subtract(BigInteger.ONE), BigInteger.valueOf(1L).shiftLeft(128).subtract(BigInteger.ONE)};

    /*
     * WARNING - void declaration
     */
    protected IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, boolean cloneSegments, Integer networkPrefixLength, boolean singleOnly) throws AddressValueException {
        this(segments, startIndex, (boolean)var3_4, networkPrefixLength == null);
        void var3_4;
        if (networkPrefixLength != null) {
            if (networkPrefixLength < 0) {
                throw new PrefixLenException(networkPrefixLength);
            }
            int max = segments.length << 4;
            if (networkPrefixLength > max) {
                if (networkPrefixLength > 128) {
                    throw new PrefixLenException(networkPrefixLength);
                }
                networkPrefixLength = max;
            }
            if (segments.length > 0) {
                void var2_3;
                void var1_1;
                if (this.cachedPrefixLength != NO_PREFIX_LENGTH && this.cachedPrefixLength < networkPrefixLength) {
                    networkPrefixLength = this.cachedPrefixLength;
                }
                IPv6AddressNetwork network = this.getNetwork();
                IPv6AddressSection.setPrefixedSegments((AddressNetwork)network, (int)networkPrefixLength, (AddressSegment[])this.getSegmentsInternal(), (int)this.getBitsPerSegment(), (int)this.getBytesPerSegment(), (AddressNetwork.AddressSegmentCreator)network.getAddressCreator(), !singleOnly && IPv6AddressSection.isPrefixSubnetSegs((IPAddressSegment[])var1_1, networkPrefixLength, var2_3, false) ? IPv6AddressSegment::toNetworkSegment : IPv6AddressSegment::toPrefixedSegment);
            }
            this.cachedPrefixLength = networkPrefixLength;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, boolean cloneSegments) throws AddressValueException {
        this((IPv6AddressSegment[])var1_1, (int)var2_2, (boolean)var3_3, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    IPv6AddressSection(IPv6AddressSegment[] segments, int startIndex, boolean cloneSegments, boolean normalizeSegments) throws AddressValueException {
        super(segments, (boolean)var3_3, true);
        void var3_3;
        if (normalizeSegments && this.isPrefixed()) {
            IPv6AddressSection.normalizePrefixBoundary((int)this.getNetworkPrefixLength(), (IPAddressSegment[])this.getSegmentsInternal(), (int)16, (int)2, IPv6AddressSegment::toPrefixNormalizedSeg);
        }
        this.addressSegmentIndex = startIndex;
        if (startIndex < 0) {
            throw new AddressPositionException(startIndex);
        }
        if (startIndex + segments.length > 8) {
            void var1_1;
            void var2_2;
            throw new AddressValueException((long)(var2_2 + ((void)var1_1).length));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected IPv6AddressSection(byte[] bytes, int segmentCount, Integer networkPrefixLength, boolean cloneBytes, boolean singleOnly) throws AddressValueException {
        this(bytes, 0, ((void)var1_1).length, (int)var2_2, (Integer)var3_3, cloneBytes, singleOnly);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected IPv6AddressSection(byte[] bytes, int byteStartIndex, int byteEndIndex, int segmentCount, Integer networkPrefixLength, boolean cloneBytes, boolean singleOnly) throws AddressValueException {
        super(new IPv6AddressSegment[segmentCount >= 0 ? segmentCount : Math.max(0, byteEndIndex - byteStartIndex) + 2 - 1 >> 1], false, false);
        boolean byteLengthIsExact;
        AddressSegment[] segs = this.getSegmentsInternal();
        IPv6AddressNetwork network = this.getNetwork();
        IPv6AddressSection.toSegments((AddressSegment[])segs, (byte[])bytes, (int)byteStartIndex, (int)byteEndIndex, (int)this.getBytesPerSegment(), (int)this.getBitsPerSegment(), (AddressNetwork)network, (Integer)networkPrefixLength);
        boolean bl = byteLengthIsExact = bytes.length == segs.length << 1;
        if (networkPrefixLength != null) {
            if (networkPrefixLength < 0) {
                throw new PrefixLenException(networkPrefixLength);
            }
            int max = segs.length << 4;
            if (networkPrefixLength > max) {
                void var3_3;
                if (networkPrefixLength > 128) {
                    throw new PrefixLenException(networkPrefixLength);
                }
                networkPrefixLength = (int)var3_3;
            }
            if (segs.length > 0) {
                if (((AddressNetwork)network).getPrefixConfiguration().zeroHostsAreSubnets() && !singleOnly) {
                    if (IPv6AddressSection.isPrefixSubnetSegs((IPAddressSegment[])segs, networkPrefixLength, network, false)) {
                        IPv6AddressSection.setPrefixedSegments((AddressNetwork)network, (int)networkPrefixLength, (AddressSegment[])segs, (int)this.getBitsPerSegment(), (int)this.getBytesPerSegment(), (AddressNetwork.AddressSegmentCreator)network.getAddressCreator(), IPv6AddressSegment::toNetworkSegment);
                    } else if (byteLengthIsExact && networkPrefixLength >= ((IPAddressSection)this).getBitCount()) {
                        this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
                    }
                } else if (byteLengthIsExact && ((AddressNetwork)network).getPrefixConfiguration().prefixedSubnetsAreExplicit() || networkPrefixLength >= ((IPAddressSection)this).getBitCount()) {
                    this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
                }
            } else if (byteLengthIsExact) {
                this.setBytes(bytes);
            }
            this.cachedPrefixLength = networkPrefixLength;
        } else {
            void var2_2;
            this.cachedPrefixLength = NO_PREFIX_LENGTH;
            if (var2_2 != false) {
                void var1_1;
                this.setBytes((byte[])(cloneBytes ? (byte[])bytes.clone() : var1_1));
            }
        }
        this.addressSegmentIndex = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void initCachedValues(Integer prefixLen, boolean network, Integer cachedNetworkPrefix, Integer cachedMinPrefix, Integer cachedEquivalentPrefix, BigInteger cachedCount, IPAddressDivisionGrouping.RangeList zeroSegments, IPAddressDivisionGrouping.RangeList zeroRanges) {
        void var3_3;
        void var2_2;
        void var1_1;
        super.initCachedValues((Integer)var1_1, (boolean)var2_2, (Integer)var3_3, cachedMinPrefix, cachedEquivalentPrefix, cachedCount, zeroSegments, zeroRanges);
        this.zeroSegments = zeroSegments;
        this.zeroRanges = zeroRanges;
    }

    public IPv6AddressSegment[] getSegments() {
        return (IPv6AddressSegment[])this.getDivisionsInternal().clone();
    }

    /*
     * WARNING - void declaration
     */
    void cache(IPv6AddressSection lower, IPv6AddressSection upper) {
        AddressDivisionGrouping.SectionCache<IPv6AddressSection> cache = this.sectionCache;
        if ((lower != null || upper != null) && (cache == null || lower != null && cache.lower == null || upper != null && cache.upper == null)) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                cache = this.sectionCache;
                boolean bl = cache == null;
                if (bl) {
                    this.sectionCache = cache = new AddressDivisionGrouping.SectionCache();
                    cache.lower = lower;
                    cache.upper = upper;
                } else {
                    if (cache.lower == null) {
                        void var1_1;
                        cache.lower = var1_1;
                    }
                    if (cache.upper == null) {
                        void var2_3;
                        var3_4.upper = var2_3;
                    }
                }
                return;
            }
        }
    }

    protected IPv6AddressSection getSingleLowestOrHighestSection() {
        return IPv6AddressSection.getSingleLowestOrHighestSection(this);
    }

    /*
     * WARNING - void declaration
     */
    IPv6AddressSection getLowestOrHighestSection(boolean lowest, boolean excludeZeroHost) {
        void var3_4;
        void var2_3;
        IPv6AddressSection result = this.getSingleLowestOrHighestSection();
        if (result == null) {
            AddressDivisionGrouping.SectionCache<IPv6AddressSection> cache = this.sectionCache;
            if (cache == null || (lowest ? (excludeZeroHost ? (result = (IPv6AddressSection)cache.lowerNonZeroHost) == null && !cache.lowerNonZeroHostIsNull : (result = (IPv6AddressSection)cache.lower) == null) : (result = (IPv6AddressSection)cache.upper) == null)) {
                IPv6AddressSection iPv6AddressSection = this;
                synchronized (iPv6AddressSection) {
                    cache = this.sectionCache;
                    boolean create = cache == null;
                    if (create) {
                        this.sectionCache = cache = new AddressDivisionGrouping.SectionCache();
                    } else if (lowest) {
                        create = excludeZeroHost ? (result = (IPv6AddressSection)cache.lowerNonZeroHost) == null && !cache.lowerNonZeroHostIsNull : (result = (IPv6AddressSection)cache.lower) == null;
                    } else {
                        result = (IPv6AddressSection)cache.upper;
                        boolean bl = create = result == null;
                    }
                    if (create) {
                        void var1_1;
                        IPv6AddressSection iPv6AddressSection2 = this;
                        result = IPv6AddressSection.createLowestOrHighestSection(iPv6AddressSection2, iPv6AddressSection2.getAddressCreator(), this::segmentsNonZeroHostIterator, i -> {
                            void var2_2;
                            if (lowest) {
                                return this.getSegment(i).getLower();
                            }
                            return this.getSegment((int)var2_2).getUpper();
                        }, lowest, excludeZeroHost);
                        if (result == null) {
                            cache.lowerNonZeroHostIsNull = true;
                        } else if (var1_1 != false) {
                            if (excludeZeroHost) {
                                cache.lowerNonZeroHost = result;
                            } else {
                                cache.lower = result;
                            }
                        } else {
                            cache.upper = result;
                        }
                    }
                }
            }
        } else if (var2_3 != false && ((IPAddressDivisionGrouping)this).includesZeroHost()) {
            return null;
        }
        return var3_4;
    }

    public IPv6AddressSection getLower() {
        return this.getLowestOrHighestSection(true, false);
    }

    public IPv6AddressSection getUpper() {
        return this.getLowestOrHighestSection(false, false);
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<IPv6AddressSection> iterator(Predicate<IPv6AddressSegment[]> excludeFunc) {
        void var2_2;
        void var1_1;
        void var3_3;
        boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        boolean useOriginal = !this.isMultiple() && (!isAllSubnets || !this.isPrefixed());
        IPv6AddressSection original = !useOriginal || excludeFunc != null && excludeFunc.test(this.getSegmentsInternal()) ? null : this;
        return IPv6AddressSection.iterator(useOriginal, original, this.getAddressCreator(), var3_3 != false ? null : this.segmentsIterator((Predicate<IPv6AddressSegment[]>)var1_1), var2_2 != false ? null : ((AddressDivisionGroupingBase)this).getPrefixLength());
    }

    @Override
    public Iterator<IPv6AddressSection> iterator() {
        return this.iterator(null);
    }

    @Override
    public AddressComponentSpliterator<IPv6AddressSection> spliterator() {
        return this.spliterator(false);
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<IPv6AddressSegment[]> segmentsIterator(Predicate<IPv6AddressSegment[]> excludeFunc) {
        void var1_1;
        void var2_2;
        boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        return IPAddressSection.segmentsIterator(this.getSegmentCount(), this.getSegmentCreator(), this.isMultiple() ? null : () -> this.getLower().getSegments(), arg_0 -> this.lambda$segmentsIterator$23((boolean)var2_2, arg_0), (Predicate<S[]>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Predicate<IPv6AddressSegment[]> excludeNonZeroHosts() {
        if (this.isPrefixed()) {
            void var1_1;
            int prefLength = this.getNetworkPrefixLength();
            return arg_0 -> this.lambda$excludeNonZeroHosts$24((int)var1_1, arg_0);
        }
        return null;
    }

    public Iterator<IPv6AddressSegment[]> segmentsNonZeroHostIterator() {
        IPv6AddressSection iPv6AddressSection = this;
        return iPv6AddressSection.segmentsIterator(iPv6AddressSection.excludeNonZeroHosts());
    }

    protected IPv6AddressSegment[] getSegmentsInternal() {
        return (IPv6AddressSegment[])super.getDivisionsInternal();
    }

    /*
     * WARNING - void declaration
     */
    protected AddressComponentSpliterator<IPv6AddressSection> spliterator(boolean excludeZeroHosts) {
        void var3_4;
        void var1_2;
        void var2_3;
        Function<IPv6AddressSection, BigInteger> sizer;
        ToLongFunction<IPv6AddressSection> longSizer;
        AddressDivisionGroupingBase.IteratorProvider iteratorProvider;
        IPv6AddressSection forIteration;
        Integer iterationsPrefix;
        int segmentCount = this.getSegmentCount();
        Integer prefixLength = this.getNetworkPrefixLength();
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getAddressCreator();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (bl) {
            iterationsPrefix = null;
            forIteration = this.withoutPrefixLength();
        } else {
            iterationsPrefix = prefixLength;
            forIteration = this;
        }
        if (excludeZeroHosts && ((IPAddressDivisionGrouping)this).includesZeroHost()) {
            int prefLength = prefixLength;
            iteratorProvider = (isLowest, isHighest, section) -> {
                void var1_1;
                return section.iterator(arg_0 -> this.lambda$spliterator$35((int)var1_1, arg_0));
            };
            longSizer = section -> {
                int n;
                void var1_1;
                void var2_2;
                return IPv6AddressSection.longCount(section, segmentCount) - var2_2.longZeroHostCount((int)var1_1, n);
            };
            sizer = section -> {
                void var1_1;
                int n;
                void var2_2;
                return section.getCount().subtract(var2_2.getZeroHostCountImpl(n, (int)var1_1));
            };
        } else {
            iteratorProvider = (isLowest, isHighest, section) -> section.iterator();
            longSizer = section -> {
                int n;
                return IPv6AddressSection.longCount(section, n);
            };
            sizer = AddressDivisionGroupingBase::getCount;
        }
        int networkSegIndex = segmentCount - 1;
        return IPv6AddressSection.createSeriesSpliterator(forIteration, arg_0 -> IPv6AddressSection.lambda$spliterator$42(creator, iterationsPrefix, networkSegIndex, (int)var2_3, arg_0), var1_2, var3_4, section -> section.getCount().compareTo(LONG_MAX) <= 0, longSizer);
    }

    /*
     * WARNING - void declaration
     */
    protected Iterator<IPv6Address> iterator(IPv6Address original, AddressCreator<IPv6Address, ?, ?, IPv6AddressSegment> creator, Predicate<IPv6AddressSegment[]> excludeFunc) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        boolean useOriginal = !this.isMultiple() && (!isAllSubnets || !this.isPrefixed());
        if (!useOriginal || excludeFunc != null && excludeFunc.test(this.getSegmentsInternal())) {
            original = null;
        }
        return IPv6AddressSection.iterator(useOriginal, var1_1, creator, useOriginal ? null : IPv6AddressSection.segmentsIterator(this.getSegmentCount(), var2_2, this.isMultiple() ? null : () -> this.getLower().getSegmentsInternal(), index -> {
            void var1_1;
            void var2_2;
            return this.getSegment((int)var2_2).iterator(var1_1 == false);
        }, (Predicate<S[]>)var3_3), isAllSubnets ? null : ((AddressDivisionGroupingBase)this).getPrefixLength());
    }

    /*
     * WARNING - void declaration
     */
    protected AddressComponentSpliterator<IPv6Address> spliterator(IPv6Address original, IPv6AddressNetwork.IPv6AddressCreator creator, boolean excludeZeroHosts) {
        void var3_4;
        void var2_2;
        void var1_1;
        Function<IPv6Address, BigInteger> sizer;
        ToLongFunction<IPv6Address> longSizer;
        AddressDivisionGroupingBase.IteratorProvider iteratorProvider;
        Integer iterationsPrefix;
        int segmentCount = this.getSegmentCount();
        Integer prefixLength = this.getNetworkPrefixLength();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (bl) {
            iterationsPrefix = null;
            IPv6Address forIteration = original.withoutPrefixLength();
        } else {
            iterationsPrefix = prefixLength;
        }
        if (excludeZeroHosts && ((IPAddressDivisionGrouping)this).includesZeroHost()) {
            int prefLength = prefixLength;
            iteratorProvider = (isLowest, isHighest, addr) -> {
                void var1_1;
                IPv6Address iPv6Address = addr;
                return addr.getSection().iterator(iPv6Address, iPv6Address.getCreator(), arg_0 -> this.lambda$spliterator$46((int)var1_1, arg_0));
            };
            longSizer = addr -> {
                int n;
                void var1_1;
                void var2_2;
                return IPv6AddressSection.longCount(addr.getSection(), segmentCount) - var2_2.getSection().longZeroHostCount((int)var1_1, n);
            };
            sizer = addr -> {
                void var1_1;
                int n;
                void var2_2;
                return addr.getSection().getCount().subtract(var2_2.getSection().getZeroHostCountImpl(n, (int)var1_1));
            };
        } else {
            iteratorProvider = (isLowest, isHighest, addr) -> addr.iterator();
            longSizer = addr -> {
                int n;
                return IPv6AddressSection.longCount(addr.getSection(), n);
            };
            sizer = Address::getCount;
        }
        int networkSegIndex = segmentCount - 1;
        int hostSegIndex = segmentCount;
        return IPv6AddressSection.createSeriesSpliterator(var1_1, arg_0 -> IPv6AddressSection.lambda$spliterator$53((IPv6AddressNetwork.IPv6AddressCreator)var2_2, iterationsPrefix, networkSegIndex, hostSegIndex, arg_0), var3_4, sizer, addr -> addr.getCount().compareTo(LONG_MAX) <= 0, longSizer);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isZeroHost(IPv6AddressSegment[] segments, int prefixLength) {
        void var2_2;
        void var1_1;
        return super.isZeroHost((IPAddressSegment[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BigInteger getCountImpl(int segCount) {
        void var1_1;
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        BigInteger bigInteger = IPv6AddressSection.getCountIPv6(i -> {
            void var1_1;
            return this.getSegment((int)var1_1).getValueCount();
        }, (int)var1_1);
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    private static BigInteger getCountIPv6(IntUnaryOperator segmentValueCountProvider, int segCount) {
        void var1_1;
        IntUnaryOperator intUnaryOperator;
        if (segCount < 0) {
            throw new IllegalArgumentException();
        }
        return IPv6AddressSection.count(intUnaryOperator, (int)var1_1, 2, 0x7FFFFFFFFFFFL);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BigInteger getZeroHostCountImpl(int prefixLength, int segCount) {
        if (this.includesZeroHost(prefixLength)) {
            if (this.isMultiple()) {
                void var2_3;
                void var1_1;
                int prefixedSegment = IPv6AddressSection.getNetworkSegmentIndex(prefixLength, this.getBytesPerSegment(), this.getBitsPerSegment());
                BigInteger bigInteger = IPv6AddressSection.getCountIPv6(arg_0 -> this.lambda$getZeroHostCountImpl$76(prefixedSegment, (int)var1_1, arg_0), (int)(var2_3 + true));
                return bigInteger;
            }
            return BigInteger.ONE;
        }
        return BigInteger.ZERO;
    }

    private AddressNetwork.AddressSegmentCreator<IPv6AddressSegment> getSegmentCreator() {
        return this.getNetwork().getAddressCreator();
    }

    private IPv6AddressNetwork.IPv6AddressCreator getAddressCreator() {
        IPv6AddressSection iPv6AddressSection = this;
        return iPv6AddressSection.getAddressCreator(iPv6AddressSection.addressSegmentIndex);
    }

    /*
     * WARNING - void declaration
     */
    protected IPv6AddressNetwork.IPv6AddressCreator getAddressCreator(int startIndex) {
        void var2_2;
        void var3_3;
        IPv6AddressNetwork.IPv6AddressCreator creator = null;
        IPv6AddressNetwork.IPv6AddressCreator defaultCreator = this.getNetwork().getAddressCreator();
        boolean useCached = startIndex < 8;
        if (useCached) {
            creator = creators[startIndex];
        }
        if (creator != null && (useCached = true | creator.getNetwork().equals(this.getNetwork()))) {
            return creator;
        }
        IPv6AddressSection iPv6AddressSection = this;
        creator = new IPv6AddressNetwork.IPv6AddressCreator(iPv6AddressSection, iPv6AddressSection.getNetwork(), defaultCreator.cache, startIndex){
            final /* synthetic */ int val$startIndex;
            final /* synthetic */ IPv6AddressSection this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                this.val$startIndex = n;
                super((IPv6AddressNetwork)var2_2, (IPv6AddressNetwork.IPv6AddressCreator.Cache)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments) {
                void var1_1;
                return this.getNetwork().getAddressCreator().createSectionInternal((IPv6AddressSegment[])var1_1, this.val$startIndex);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected IPv6AddressSection createPrefixedSectionInternal(IPv6AddressSegment[] segments, Integer prefix, boolean singleOnly) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new IPv6AddressSection((IPv6AddressSegment[])var1_1, this.val$startIndex, false, (Integer)var2_2, (boolean)var3_3);
            }
        };
        new /* invalid duplicate definition of identical inner class */.useSegmentCache = var3_3.useSegmentCache;
        if (useCached) {
            IPv6AddressSection.creators[var1_1] = creator;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6AddressSegment getDivision(int index) {
        void var1_1;
        return (IPv6AddressSegment)super.getDivision((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6AddressSegment getSegment(int index) {
        void var1_1;
        return (IPv6AddressSegment)super.getSegment((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSection getEmbeddedIPv4AddressSection() {
        if (this.embeddedIPv4Section == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.embeddedIPv4Section == null) {
                    void var2_3;
                    void mixed2;
                    AddressSegment[] mixed2;
                    int mixedCount = this.getSegmentCount() - Math.max(6 - this.addressSegmentIndex, 0);
                    int lastIndex = this.getSegmentCount() - 1;
                    IPv4AddressNetwork.IPv4AddressCreator creator = this.getIPv4Network().getAddressCreator();
                    if (mixedCount == 0) {
                        mixed2 = creator.createSegmentArray(0);
                    } else if (mixed2 == true) {
                        mixed2 = creator.createSegmentArray(this.getBytesPerSegment());
                        IPv6AddressSegment iPv6AddressSegment = this.getSegment(lastIndex);
                        iPv6AddressSegment.getSplitSegments(mixed2, 0, creator);
                    } else {
                        void var3_5;
                        mixed2 = creator.createSegmentArray(this.getBytesPerSegment() << 1);
                        IPv6AddressSegment low = this.getSegment(lastIndex);
                        IPv6AddressSegment iPv6AddressSegment = this.getSegment((int)(var3_5 - true));
                        iPv6AddressSegment.getSplitSegments(mixed2, 0, creator);
                        low.getSplitSegments(mixed2, this.getBytesPerSegment(), creator);
                    }
                    this.embeddedIPv4Section = (IPv4AddressSection)IPv6AddressSection.createEmbeddedSection((IPAddressNetwork.IPAddressCreator)creator, (IPAddressSegment[])var2_3, (IPAddressSection)this);
                }
            }
        }
        return this.embeddedIPv4Section;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSection createNonMixedSection() {
        void var3_3;
        void var2_2;
        void var1_1;
        int mixedCount = this.getSegmentCount() - Math.max(6 - this.addressSegmentIndex, 0);
        if (mixedCount <= 0) {
            return this;
        }
        int nonMixedCount = Math.max(0, this.getSegmentCount() - mixedCount);
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getNetwork().getAddressCreator();
        AddressSegment[] nonMixed = creator.createSegmentArray(nonMixedCount);
        this.getSegments(0, (int)var1_1, nonMixed, 0);
        return var2_2.createEmbeddedSectionInternal(this, (IPv6AddressSegment[])var3_3, this.addressSegmentIndex);
    }

    public IPv6v4MixedAddressSection getMixedAddressSection() {
        if (this.defaultMixedAddressSection == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.defaultMixedAddressSection == null) {
                    this.defaultMixedAddressSection = new IPv6v4MixedAddressSection(this.createNonMixedSection(), this.getEmbeddedIPv4AddressSection());
                }
            }
        }
        return this.defaultMixedAddressSection;
    }

    /*
     * WARNING - void declaration
     */
    public static IPv6AddressSection createSection(IPv6AddressNetwork.IPv6AddressCreator creator, IPv6AddressSegment[] nonMixedSection, IPv4Address mixedSection) throws IncompatibleAddressException {
        Serializable serializable;
        void var2_2;
        void var3_3;
        void var1_1;
        IPv4AddressSection ipv4Section = mixedSection.getSection();
        IPv6AddressSegment[] iPv6AddressSegmentArray = creator.createSegmentArray(nonMixedSection.length + 2);
        IPv6AddressSegment[] newSegs = iPv6AddressSegmentArray;
        iPv6AddressSegmentArray[0] = nonMixedSection[0];
        newSegs[1] = nonMixedSection[1];
        newSegs[2] = nonMixedSection[2];
        newSegs[3] = nonMixedSection[3];
        newSegs[4] = nonMixedSection[4];
        newSegs[5] = var1_1[5];
        newSegs[6] = ipv4Section.getSegment(0).join(creator, ipv4Section.getSegment(1));
        newSegs[7] = ipv4Section.getSegment(2).join(creator, ipv4Section.getSegment(3));
        Serializable result = creator.createSectionInternal((IPv6AddressSegment[])var3_3);
        creator.createSectionInternal((IPv6AddressSegment[])var3_3).embeddedIPv4Section = var2_2;
        return serializable;
    }

    @Override
    public int getBitsPerSegment() {
        return 16;
    }

    @Override
    public int getBytesPerSegment() {
        return 2;
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() << 4;
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount() << 1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var2_2;
        byte[] bytes = new byte[((IPAddressSection)this).getByteCount()];
        int segmentCount = this.getSegmentCount();
        for (int i = 0; i < segmentCount; ++i) {
            IPv6AddressSegment seg = this.getSegment(i);
            int byteIndex = i << 1;
            int val = low ? seg.getSegmentValue() : seg.getUpperSegmentValue();
            bytes[byteIndex] = (byte)(val >>> 8);
            bytes[byteIndex + 1] = (byte)val;
        }
        return var2_2;
    }

    @Override
    protected byte[] getBytesInternal() {
        return super.getBytesInternal();
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV6;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(AddressSection other) {
        void var1_1;
        return other instanceof IPv6AddressSection && this.addressSegmentIndex == ((IPv6AddressSection)other).addressSegmentIndex && super.contains((AddressSection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        void var1_1;
        return other instanceof IPv6AddressSection && super.isSameGrouping((AddressDivisionGroupingBase)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof IPv6AddressSection) {
            void var1_1;
            IPv6AddressSection other = (IPv6AddressSection)o;
            return this.addressSegmentIndex == other.addressSegmentIndex && var1_1.isSameGrouping(this);
        }
        return false;
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return Address.defaultIpv6Network();
    }

    public IPv4AddressNetwork getIPv4Network() {
        return Address.defaultIpv4Network();
    }

    public IPv6AddressSection withoutPrefixLength() {
        return this.removePrefixLength(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv6AddressSection removePrefixLength(boolean zeroed) {
        void var1_1;
        return IPv6AddressSection.removePrefixLength(this, (boolean)var1_1, this.getAddressCreator(), IPv6AddressSection::getSegment);
    }

    /*
     * WARNING - void declaration
     */
    IPv6AddressSection createZeroHost(boolean boundariesOnly) {
        void var1_1;
        void var2_2;
        void var3_3;
        int prefixLength = this.getNetworkPrefixLength();
        IPv6AddressNetwork network = this.getNetwork();
        IPv6Address mask = (IPv6Address)network.getNetworkMask(prefixLength);
        return IPv6AddressSection.getSubnetSegments(this, var3_3.getPrefixConfiguration().allPrefixedAddressesAreSubnets() ? null : IPv6AddressSection.cacheBits((int)var2_2), this.getAddressCreator(), var1_1 == false, this::getSegment, i -> {
            void var1_1;
            return mask.getSegment((int)var1_1).getSegmentValue();
        }, true);
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSection mask(IPv6AddressSection mask, boolean retainPrefix) throws IncompatibleAddressException, SizeMismatchException {
        void var1_1;
        void var2_2;
        this.checkMaskSegmentCount(mask);
        return IPv6AddressSection.getSubnetSegments(this, var2_2 != false ? ((AddressDivisionGroupingBase)this).getPrefixLength() : null, this.getAddressCreator(), true, this::getSegment, arg_0 -> IPv6AddressSection.lambda$mask$88((IPv6AddressSection)var1_1, arg_0), false);
    }

    protected static Integer cacheBits(int i) {
        return IPAddressSection.cacheBits(i);
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSection toPrefixBlock() {
        void var1_1;
        Integer prefixLength = this.getNetworkPrefixLength();
        if (prefixLength == null || ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return this;
        }
        return this.toPrefixBlock(var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSection toPrefixBlock(int networkPrefixLength) throws PrefixLenException {
        void var1_1;
        return IPv6AddressSection.toPrefixBlock(this, (int)var1_1, this.getAddressCreator(), (prefix, i) -> {
            void var1_1;
            void var2_2;
            return this.getSegment((int)var2_2).toNetworkSegment((Integer)var1_1, true);
        });
    }

    @Override
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv6AddressSection iPv6AddressSection = this;
            synchronized (iPv6AddressSection) {
                if (this.stringCache == null) {
                    this.stringCache = new IPv6StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    protected IPv6StringCache getStringCache() {
        return this.stringCache;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toCanonicalString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            this.stringCache.canonicalString = result = this.toNormalizedString(IPv6StringCache.canonicalParams);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toCanonicalWildcardString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().canonicalWildcardString) == null) {
            this.getStringCache().canonicalWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardCanonicalParams);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedWildcardString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().normalizedWildcardString) == null) {
            this.getStringCache().normalizedWildcardString = result = this.toNormalizedString(IPv6StringCache.wildcardNormalizedParams);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.getStringCache().normalizedString) == null) {
            this.getStringCache().normalizedString = result = this.toNormalizedString(IPv6StringCache.normalizedParams);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedString(IPAddressSection.IPStringOptions options) {
        void var1_1;
        if (options instanceof IPv6StringOptions) {
            return this.toNormalizedString((IPv6StringOptions)options);
        }
        return super.toNormalizedString((IPAddressSection.IPStringOptions)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String toNormalizedString(IPv6StringOptions options) {
        void var1_1;
        return this.toNormalizedString((IPv6StringOptions)var1_1, null);
    }

    /*
     * WARNING - void declaration
     */
    private String toNormalizedMixedString(IPv6v4MixedParams mixedParams, CharSequence zone) {
        void var2_2;
        void var3_3;
        String string;
        IPv6v4MixedAddressSection mixed = this.getMixedAddressSection();
        string = ((IPv6v4MixedParams)((Object)string)).toString((IPv6v4MixedAddressSection)var3_3, (CharSequence)var2_2);
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public String toNormalizedString(IPv6StringOptions options, CharSequence zone) {
        void var2_2;
        void var3_3;
        IPv6StringParams stringParams;
        if (options.isCacheable()) {
            IPv6v4MixedParams mixedParams;
            IPAddressStringWriter cachedParams = (IPAddressStringWriter)IPv6AddressSection.getCachedParams(options);
            if (cachedParams == null) {
                stringParams = IPv6StringOptions.access$100(options, this);
                if (options.makeMixed()) {
                    mixedParams = new IPv6v4MixedParams(stringParams, options.ipv4Opts);
                    IPv6AddressSection.setCachedParams(options, mixedParams);
                    return this.toNormalizedMixedString(mixedParams, zone);
                }
                IPv6AddressSection.setCachedParams(options, mixedParams);
            } else {
                if (mixedParams instanceof IPv6v4MixedParams) {
                    return this.toNormalizedMixedString(mixedParams, zone);
                }
                stringParams = (IPv6StringParams)((Object)mixedParams);
            }
        } else {
            stringParams = IPv6StringOptions.access$100(options, this);
            if (options.makeMixed() && stringParams.nextUncompressedIndex <= 6 - this.addressSegmentIndex) {
                void var1_1;
                return this.toNormalizedMixedString(new IPv6v4MixedParams(stringParams, var1_1.ipv4Opts), zone);
            }
        }
        return var3_3.toString(this, (CharSequence)var2_2);
    }

    @Override
    public IPAddressDivisionGrouping.RangeList getZeroSegments() {
        if (this.zeroSegments == null) {
            this.zeroSegments = super.getZeroSegments();
        }
        return this.zeroSegments;
    }

    @Override
    public IPAddressDivisionGrouping.RangeList getZeroRangeSegments() {
        if (this.zeroRanges == null) {
            this.zeroRanges = super.getZeroRangeSegments();
        }
        return this.zeroRanges;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isZero() {
        void var1_1;
        IPAddressDivisionGrouping.RangeList ranges = ((IPAddressDivisionGrouping)this).getZeroSegments();
        return ranges.size() == 1 && var1_1.getRange((int)0).length == this.getSegmentCount();
    }

    private int[] getCompressIndexAndCount(CompressOptions options, boolean createMixed) {
        if (options != null) {
            CompressOptions.CompressionChoiceOptions rangeSelection = options.rangeSelection;
            IPAddressDivisionGrouping.RangeList compressibleSegs = rangeSelection.compressHost() ? ((IPAddressDivisionGrouping)this).getZeroRangeSegments() : ((IPAddressDivisionGrouping)this).getZeroSegments();
            int maxIndex = -1;
            int maxCount = 0;
            int segmentCount = this.getSegmentCount();
            boolean compressMixed = createMixed && options.compressMixedOptions.compressMixed(this);
            boolean preferHost = rangeSelection == CompressOptions.CompressionChoiceOptions.HOST_PREFERRED;
            boolean preferMixed = createMixed && rangeSelection == CompressOptions.CompressionChoiceOptions.MIXED_PREFERRED;
            for (int i = compressibleSegs.size() - 1; i >= 0; --i) {
                IPAddressDivisionGrouping.Range range = compressibleSegs.getRange(i);
                int index = range.index;
                int count = range.length;
                if (createMixed) {
                    int mixedIndex = 6 - this.addressSegmentIndex;
                    if (!compressMixed || index > mixedIndex || index + count < segmentCount) {
                        count = Math.min(count, mixedIndex - index);
                    }
                }
                if (count > 0 && count >= maxCount && (options.compressSingle || count > 1)) {
                    maxIndex = index;
                    maxCount = count;
                }
                if (preferHost && this.isPrefixed() && (index + count) * this.getBitsPerSegment() > this.getNetworkPrefixLength() || preferMixed && index + count >= segmentCount) break;
            }
            if (maxIndex >= 0) {
                return new int[]{maxIndex, maxCount};
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$mask$88(IPv6AddressSection mask, int i) {
        void var1_1;
        return mask.getSegment((int)var1_1).getSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ int lambda$getZeroHostCountImpl$76(int prefixedSegment, int prefixLength, int i) {
        void var3_5;
        if (i == prefixedSegment) {
            void var2_4;
            void var1_2;
            IPv6AddressSegment seg = this.getSegment(i);
            int shift = seg.getBitCount() - IPv6AddressSection.getPrefixedSegmentPrefixLength(this.getBitsPerSegment(), prefixLength, i);
            int n = (seg.getUpperSegmentValue() >>> shift) - (var1_2.getSegmentValue() >>> var2_4) + 1;
            return n;
        }
        return this.getSegment((int)var3_5).getValueCount();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$53(IPv6AddressNetwork.IPv6AddressCreator creator, Integer iterationsPrefix, int networkSegIndex, int hostSegIndex, AddressDivisionGroupingBase.SplitterSink spliterator) {
        void var1_1;
        void var3_3;
        void var2_2;
        IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator;
        return IPv6AddressSection.split((AddressDivisionGroupingBase.SplitterSink)spliterator, (T segs) -> {
            void var1_1;
            IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator;
            return (IPv6Address)IPv6AddressSection.createIteratedAddress((AddressSegment[])segs, (AddressCreator)iPv6AddressCreator, (Integer)var1_1);
        }, (AddressNetwork.AddressSegmentCreator)iPv6AddressCreator, (AddressSegment[])((IPv6Address)spliterator.getAddressItem()).getSection().getSegmentsInternal(), (int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$spliterator$46(int prefLength, IPv6AddressSegment[] s) {
        void var1_1;
        void var2_2;
        return this.isZeroHost((IPv6AddressSegment[])var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$42(IPv6AddressNetwork.IPv6AddressCreator creator, Integer iterationsPrefix, int networkSegIndex, int hostSegIndex, AddressDivisionGroupingBase.SplitterSink spliterator) {
        void var1_1;
        void var3_3;
        void var2_2;
        IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator;
        return IPv6AddressSection.split((AddressDivisionGroupingBase.SplitterSink)spliterator, (T segs) -> {
            void var1_1;
            IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator;
            return (IPv6AddressSection)IPv6AddressSection.createIteratedSection((AddressSegment[])segs, (AddressCreator)iPv6AddressCreator, (Integer)var1_1);
        }, (AddressNetwork.AddressSegmentCreator)iPv6AddressCreator, (AddressSegment[])((IPv6AddressSection)spliterator.getAddressItem()).getSegmentsInternal(), (int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$spliterator$35(int prefLength, IPv6AddressSegment[] segs) {
        void var1_1;
        void var2_2;
        return this.isZeroHost((IPv6AddressSegment[])var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$excludeNonZeroHosts$24(int prefLength, IPv6AddressSegment[] segments) {
        void var1_1;
        void var2_2;
        return this.isZeroHost((IPv6AddressSegment[])var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Iterator lambda$segmentsIterator$23(boolean isAllSubnets, int index) {
        void var1_1;
        void var2_2;
        return this.getSegment((int)var2_2).iterator(var1_1 == false);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int[] access$200(IPv6AddressSection x0, CompressOptions x1, boolean x2) {
        void var2_2;
        void var1_1;
        return x0.getCompressIndexAndCount((CompressOptions)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$300(int x0, int x1, int x2) {
        void var2_2;
        void var1_1;
        return IPv6AddressSection.getHostSegmentIndex(x0, (int)var1_1, (int)var2_2);
    }

    static class IPv6v4MixedParams
    implements IPAddressStringWriter<IPv6v4MixedAddressSection>,
    Cloneable {
        private AddressDivisionGroupingBase.IPAddressStringParams<IPAddressStringDivisionSeries> ipv4Params;
        private IPv6StringParams ipv6Params;

        /*
         * WARNING - void declaration
         */
        IPv6v4MixedParams(IPv6StringParams ipv6Params, IPAddressSection.IPStringOptions ipv4Opts) {
            void var1_1;
            void var2_2;
            this.ipv4Params = IPv6AddressSection.toIPParams((IPAddressSection.IPStringOptions)var2_2);
            this.ipv6Params = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public int getStringLength(IPv6v4MixedAddressSection addr, CharSequence zone) {
            void var2_2;
            void var1_1;
            int ipv6length = this.ipv6Params.getSegmentsStringLength(addr.ipv6Section);
            int ipv4length = this.ipv4Params.getSegmentsStringLength(addr.ipv4Section);
            int length = ipv6length + ipv4length;
            if (this.ipv6Params.nextUncompressedIndex < addr.ipv6Section.getSegmentCount()) {
                ++length;
            }
            var3_3 += this.getPrefixStringLength((IPv6v4MixedAddressSection)var1_1);
            var3_3 += this.ipv6Params.getZoneLength((CharSequence)var2_2);
            var3_3 += this.ipv6Params.getAddressSuffixLength();
            return (int)(var3_3 += this.ipv6Params.getAddressLabelLength());
        }

        /*
         * WARNING - void declaration
         */
        public String toString(IPv6v4MixedAddressSection addr) {
            void var1_1;
            return this.toString((IPv6v4MixedAddressSection)var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        public String toString(IPv6v4MixedAddressSection addr, CharSequence zone) {
            void var3_3;
            void var2_2;
            void var1_1;
            int length = this.getStringLength(addr, zone);
            StringBuilder builder = new StringBuilder(length);
            this.append(builder, (IPv6v4MixedAddressSection)var1_1, (CharSequence)var2_2);
            AddressDivisionGroupingBase.AddressStringParams.checkLengths((int)var3_3, builder);
            return builder.toString();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getDivisionStringLength(AddressStringDivision seg) {
            void var1_1;
            return this.ipv6Params.getDivisionStringLength((AddressStringDivision)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuilder appendDivision(StringBuilder builder, AddressStringDivision seg) {
            void var2_2;
            void var1_1;
            return this.ipv6Params.appendDivision((StringBuilder)var1_1, (AddressStringDivision)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public StringBuilder append(StringBuilder builder, IPv6v4MixedAddressSection addr, CharSequence zone) {
            void var1_1;
            void var2_2;
            void var3_3;
            this.ipv6Params.appendLabel(builder);
            this.ipv6Params.appendSegments(builder, addr.ipv6Section);
            if (this.ipv6Params.nextUncompressedIndex < addr.ipv6Section.getSegmentCount()) {
                builder.append(this.ipv6Params.getTrailingSegmentSeparator());
            }
            this.ipv4Params.appendSegments(builder, addr.ipv4Section);
            this.ipv6Params.appendZone(builder, (CharSequence)var3_3);
            this.ipv6Params.appendSuffix(builder);
            this.appendPrefixIndicator(builder, (IPv6v4MixedAddressSection)var2_2);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        protected int getPrefixStringLength(IPv6v4MixedAddressSection addr) {
            if (this.requiresPrefixIndicator(addr.ipv6Section) || this.requiresPrefixIndicator(addr.ipv4Section)) {
                void var1_1;
                return AddressDivisionGroupingBase.IPAddressStringParams.getPrefixIndicatorStringLength((IPAddressStringDivisionSeries)var1_1);
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        public void appendPrefixIndicator(StringBuilder builder, IPv6v4MixedAddressSection addr) {
            if (this.requiresPrefixIndicator(addr.ipv6Section) || this.requiresPrefixIndicator(addr.ipv4Section)) {
                void var2_2;
                void var1_1;
                this.ipv6Params.appendPrefixIndicator((StringBuilder)var1_1, (IPAddressStringDivisionSeries)var2_2);
            }
        }

        protected boolean requiresPrefixIndicator(IPv4AddressSection ipv4Section) {
            return ipv4Section.isPrefixed() && !((AddressDivisionGroupingBase.AddressStringParams)this.ipv4Params).preferWildcards();
        }

        protected boolean requiresPrefixIndicator(IPv6AddressSection ipv6Section) {
            return ipv6Section.isPrefixed() && (!((AddressDivisionGroupingBase.AddressStringParams)this.ipv6Params).preferWildcards() || this.ipv6Params.hostCompressed);
        }

        /*
         * WARNING - void declaration
         */
        public IPv6v4MixedParams clone() {
            try {
                void var1_1;
                IPv6v4MixedParams params = (IPv6v4MixedParams)super.clone();
                ((IPv6v4MixedParams)super.clone()).ipv6Params = this.ipv6Params.clone();
                params.ipv4Params = this.ipv4Params.clone();
                return var1_1;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }
    }

    public static class IPv6v4MixedAddressSection
    extends IPAddressDivisionGrouping {
        private final IPv6AddressSection ipv6Section;
        private final IPv4AddressSection ipv4Section;
        private String string;

        /*
         * WARNING - void declaration
         */
        private IPv6v4MixedAddressSection(IPv6AddressSection ipv6Section, IPv4AddressSection ipv4Section) {
            super(IPv6v4MixedAddressSection.createSegments(ipv6Section, ipv4Section), ipv6Section.getNetwork());
            void var1_1;
            void var2_2;
            if (ipv6Section.isPrefixed()) {
                if (!ipv4Section.isPrefixed() || ipv4Section.getNetworkPrefixLength() != 0) {
                    IPv4AddressSection iPv4AddressSection = ipv4Section;
                    throw new InconsistentPrefixException(ipv6Section, iPv4AddressSection, iPv4AddressSection.getNetworkPrefixLength());
                }
                this.cachedPrefixLength = ipv6Section.getNetworkPrefixLength();
            } else {
                this.cachedPrefixLength = ipv4Section.isPrefixed() ? IPv6v4MixedAddressSection.cacheBits(ipv4Section.getNetworkPrefixLength() + ((IPAddressSection)ipv6Section).getBitCount()) : NO_PREFIX_LENGTH;
            }
            this.ipv4Section = var2_2;
            this.ipv6Section = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private static IPAddressDivision[] createSegments(IPv6AddressSection ipv6Section, IPv4AddressSection ipv4Section) {
            void var2_2;
            void var3_3;
            void var1_1;
            IPv6AddressSection iPv6AddressSection;
            int ipv4Len;
            int ipv6Len = ipv6Section.getSegmentCount();
            if (ipv6Len + ((ipv4Len = ipv4Section.getSegmentCount()) + 1 >> 1) + ipv6Section.addressSegmentIndex > 8) {
                throw new AddressValueException(ipv6Section, ipv4Section);
            }
            AddressSegment[] allSegs = new IPAddressSegment[ipv6Len + ipv4Len];
            iPv6AddressSection.getSegments(0, ipv6Len, allSegs, 0);
            var1_1.getSegments(0, (int)var3_3, allSegs, (int)var2_2);
            return allSegs;
        }

        @Override
        public int getByteCount() {
            return ((IPAddressSection)this.ipv6Section).getByteCount() + ((IPAddressSection)this.ipv4Section).getByteCount();
        }

        @Override
        public int getBitCount() {
            return ((IPAddressSection)this.ipv6Section).getBitCount() + ((IPAddressSection)this.ipv4Section).getBitCount();
        }

        @Override
        public boolean isPrefixBlock() {
            Integer n = this.getNetworkPrefixLength();
            if (n == null) {
                return false;
            }
            if (this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                return true;
            }
            if (this.ipv6Section.isPrefixed()) {
                return ((AddressDivisionGroupingBase)this.ipv6Section).isPrefixBlock() && ((AddressDivisionGroupingBase)this.ipv4Section).isFullRange();
            }
            return ((AddressDivisionGroupingBase)this.ipv4Section).isPrefixBlock();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public String toString() {
            if (this.string == null) {
                void var1_1;
                void var2_2;
                IPv6StringOptions mixedParams = IPv6StringCache.mixedParams;
                IPv6StringParams ipv6Params = IPv6StringOptions.access$100(mixedParams, this.ipv6Section);
                IPAddressSection.IPStringOptions ipv4Opts = mixedParams.ipv4Opts;
                IPv6v4MixedParams parms = new IPv6v4MixedParams((IPv6StringParams)var2_2, ipv4Opts);
                this.string = var1_1.toString(this);
            }
            return this.string;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected boolean isSameGrouping(AddressDivisionGroupingBase o) {
            if (o instanceof IPv6v4MixedAddressSection) {
                void var1_1;
                IPv6v4MixedAddressSection other = (IPv6v4MixedAddressSection)o;
                return ((AddressDivisionGroupingBase)this.ipv6Section).equals(other.ipv6Section) && ((AddressDivisionGroupingBase)this.ipv4Section).equals(var1_1.ipv4Section);
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof IPv6v4MixedAddressSection) {
                void var1_1;
                IPv6v4MixedAddressSection other = (IPv6v4MixedAddressSection)o;
                return ((AddressDivisionGroupingBase)this.ipv6Section).equals(other.ipv6Section) && ((AddressDivisionGroupingBase)this.ipv4Section).equals(var1_1.ipv4Section);
            }
            return false;
        }
    }

    static class EmbeddedIPv6AddressSection
    extends IPv6AddressSection {
        private final IPAddressSection encompassingSection;

        /*
         * WARNING - void declaration
         */
        EmbeddedIPv6AddressSection(IPAddressSection encompassingSection, IPv6AddressSegment[] subSegments, int startIndex) {
            super((IPv6AddressSegment[])var2_2, (int)var3_3, false);
            void var1_1;
            void var3_3;
            void var2_2;
            this.encompassingSection = var1_1;
        }

        @Override
        public boolean isPrefixBlock() {
            return ((AddressDivisionGroupingBase)this.encompassingSection).isPrefixBlock();
        }
    }

    static class IPv6StringParams
    extends AddressDivisionGroupingBase.IPAddressStringParams<IPv6AddressSection> {
        int firstCompressedSegmentIndex;
        int nextUncompressedIndex;
        boolean hostCompressed;

        IPv6StringParams() {
            this(-1, 0);
        }

        /*
         * WARNING - void declaration
         */
        IPv6StringParams(int firstCompressedSegmentIndex, int compressedCount) {
            this(false, (int)var1_1, (int)var2_2, false, ':', '%');
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private IPv6StringParams(boolean expandSegments, int firstCompressedSegmentIndex, int compressedCount, boolean uppercase, char separator, char zoneSeparator) {
            super(16, Character.valueOf(separator), uppercase, zoneSeparator);
            void var3_3;
            void var2_2;
            void var1_1;
            this.expandSegments((boolean)var1_1);
            this.firstCompressedSegmentIndex = firstCompressedSegmentIndex;
            this.nextUncompressedIndex = var2_2 + var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getStringLength(IPv6AddressSection addr) {
            int count = this.getSegmentsStringLength(addr);
            if (!(this.isReverse() || ((AddressDivisionGroupingBase.AddressStringParams)this).preferWildcards() && !this.hostCompressed)) {
                void var1_1;
                count += IPv6StringParams.getPrefixIndicatorStringLength((IPAddressStringDivisionSeries)var1_1);
            }
            var2_2 += this.getAddressSuffixLength();
            return (int)(var2_2 += this.getAddressLabelLength());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuilder append(StringBuilder builder, IPv6AddressSection addr, CharSequence zone) {
            void var1_1;
            void var3_3;
            IPv6StringParams iPv6StringParams = this;
            IPv6StringParams iPv6StringParams2 = this;
            iPv6StringParams.appendSuffix(iPv6StringParams.appendZone(iPv6StringParams2.appendSegments(iPv6StringParams2.appendLabel(builder), addr), (CharSequence)var3_3));
            if (!(this.isReverse() || ((AddressDivisionGroupingBase.AddressStringParams)this).preferWildcards() && !this.hostCompressed)) {
                void var2_2;
                this.appendPrefixIndicator(builder, (IPAddressStringDivisionSeries)var2_2);
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public StringBuilder appendSegments(StringBuilder builder, IPv6AddressSection addr) {
            void var1_1;
            int divisionCount = addr.getDivisionCount();
            if (divisionCount <= 0) {
                return builder;
            }
            int lastIndex = divisionCount - 1;
            Character separator = this.getSeparator();
            boolean reverse = this.isReverse();
            int i = 0;
            while (true) {
                int segIndex;
                if ((segIndex = reverse ? lastIndex - i : i) < this.firstCompressedSegmentIndex || segIndex >= this.nextUncompressedIndex) {
                    this.appendSegment(segIndex, builder, addr);
                    if (++i > lastIndex) break;
                    if (separator == null) continue;
                    builder.append(separator);
                    continue;
                }
                if (segIndex == (reverse ? this.nextUncompressedIndex - 1 : this.firstCompressedSegmentIndex) && separator != null) {
                    builder.append(separator);
                    if (i == 0) {
                        builder.append(separator);
                    }
                }
                if (++i > lastIndex) break;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getSegmentsStringLength(IPv6AddressSection part) {
            void var2_2;
            int count = 0;
            int divCount = part.getDivisionCount();
            if (divCount != 0) {
                Character separator = this.getSeparator();
                int i = 0;
                while (true) {
                    if (i < this.firstCompressedSegmentIndex || i >= this.nextUncompressedIndex) {
                        count += this.appendSegment(i, (StringBuilder)null, part);
                        if (++i >= divCount) break;
                        if (separator == null) continue;
                        ++count;
                        continue;
                    }
                    if (i == this.firstCompressedSegmentIndex && separator != null) {
                        ++count;
                        if (i == 0) {
                            ++count;
                        }
                    }
                    if (++i >= divCount) break;
                }
            }
            return (int)var2_2;
        }

        @Override
        public IPv6StringParams clone() {
            return (IPv6StringParams)super.clone();
        }
    }

    public static class IPv6StringOptions
    extends IPAddressSection.IPStringOptions {
        public final IPAddressSection.IPStringOptions ipv4Opts;
        public final CompressOptions compressOptions;

        /*
         * WARNING - void declaration
         */
        IPv6StringOptions(int base, boolean expandSegments, IPAddressSection.WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, boolean makeMixed, IPAddressSection.IPStringOptions ipv4Opts, CompressOptions compressOptions, Character separator, char zoneSeparator, String addressPrefix, String addressSuffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super((int)var1_1, expandSegments, wildcardOption, wildcards, segmentStrPrefix, separator, zoneSeparator, addressPrefix, addressSuffix, reverse, splitDigits, uppercase);
            void var1_1;
            this.compressOptions = compressOptions;
            if (makeMixed) {
                if (ipv4Opts == null) {
                    void var3_3;
                    void var2_2;
                    ipv4Opts = new IPv4AddressSection.IPv4StringOptions.Builder().setExpandedSegments((boolean)var2_2).setWildcardOption((IPAddressSection.WildcardOptions.WildcardOption)var3_3).setWildcards(wildcards).toOptions();
                }
                this.ipv4Opts = ipv4Opts;
                return;
            }
            this.ipv4Opts = null;
        }

        boolean isCacheable() {
            return this.compressOptions == null;
        }

        boolean makeMixed() {
            return this.ipv4Opts != null;
        }

        /*
         * WARNING - void declaration
         */
        private IPv6StringParams from(IPv6AddressSection addr) {
            void var2_2;
            boolean makeMixed;
            int[] vals;
            IPv6StringParams result = new IPv6StringParams();
            if (this.compressOptions != null && (vals = IPv6AddressSection.access$200(addr, this.compressOptions, makeMixed = this.makeMixed())) != null) {
                void var1_1;
                void var3_5;
                int maxIndex = vals[0];
                int maxCount = vals[1];
                result.firstCompressedSegmentIndex = maxIndex;
                result.nextUncompressedIndex = maxIndex + var3_5;
                result.hostCompressed = this.compressOptions.rangeSelection.compressHost() && addr.isPrefixed() && result.nextUncompressedIndex > IPv6AddressSection.access$300(var1_1.getNetworkPrefixLength(), 2, 16);
            }
            result.expandSegments(this.expandSegments);
            result.setWildcardOption(this.wildcardOption);
            result.setWildcards(this.wildcards);
            result.setSeparator(this.separator);
            result.setAddressSuffix(this.addrSuffix);
            result.setAddressLabel(this.addrLabel);
            result.setReverse(this.reverse);
            result.setSplitDigits(this.splitDigits);
            result.setZoneSeparator(this.zoneSeparator);
            result.setUppercase(this.uppercase);
            result.setRadix(this.base);
            result.setSegmentStrPrefix(this.segmentStrPrefix);
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPv6StringParams access$100(IPv6StringOptions x0, IPv6AddressSection x1) {
            void var1_1;
            return x0.from((IPv6AddressSection)var1_1);
        }

        public static class Builder
        extends IPAddressSection.IPStringOptions.Builder {
            private boolean makeMixed;
            private IPAddressSection.IPStringOptions ipv4Options;
            private CompressOptions compressOptions;

            public Builder() {
                super(16, ':');
            }

            /*
             * WARNING - void declaration
             */
            public Builder setCompressOptions(CompressOptions compressOptions) {
                void var1_1;
                this.compressOptions = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            public Builder setMakeMixed(boolean makeMixed) {
                void var1_1;
                this.makeMixed = var1_1;
                return this;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setWildcardOptions(IPAddressSection.WildcardOptions wildcardOptions) {
                void var1_1;
                return (Builder)super.setWildcardOptions((IPAddressSection.WildcardOptions)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setExpandedSegments(boolean expandSegments) {
                void var1_1;
                return (Builder)super.setExpandedSegments((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setRadix(int base) {
                void var1_1;
                return (Builder)super.setRadix((int)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setSeparator(Character separator) {
                void var1_1;
                return (Builder)super.setSeparator((Character)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setZoneSeparator(char separator) {
                void var1_1;
                return (Builder)super.setZoneSeparator((char)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setAddressSuffix(String suffix) {
                void var1_1;
                return (Builder)super.setAddressSuffix((String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setSegmentStrPrefix(String prefix) {
                void var1_1;
                return (Builder)super.setSegmentStrPrefix((String)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setReverse(boolean reverse) {
                void var1_1;
                return (Builder)super.setReverse((boolean)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Builder setSplitDigits(boolean splitDigits) {
                void var1_1;
                return (Builder)super.setSplitDigits((boolean)var1_1);
            }

            @Override
            public IPv6StringOptions toOptions() {
                return new IPv6StringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.makeMixed, this.ipv4Options, this.compressOptions, this.separator, this.zoneSeparator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    public static class CompressOptions {
        public final boolean compressSingle;
        public final CompressionChoiceOptions rangeSelection;
        public final MixedCompressionOptions compressMixedOptions;

        /*
         * WARNING - void declaration
         */
        public CompressOptions(boolean compressSingle, CompressionChoiceOptions rangeSelection) {
            this((boolean)var1_1, (CompressionChoiceOptions)var2_2, MixedCompressionOptions.YES);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public CompressOptions(boolean compressSingle, CompressionChoiceOptions rangeSelection, MixedCompressionOptions compressMixedOptions) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.compressSingle = var1_1;
            this.rangeSelection = var2_2;
            this.compressMixedOptions = compressMixedOptions == null ? MixedCompressionOptions.YES : var3_3;
        }

        public static final class MixedCompressionOptions
        extends Enum<MixedCompressionOptions> {
            public static final /* enum */ MixedCompressionOptions NO = new MixedCompressionOptions();
            public static final /* enum */ MixedCompressionOptions NO_HOST = new MixedCompressionOptions();
            public static final /* enum */ MixedCompressionOptions COVERED_BY_HOST = new MixedCompressionOptions();
            public static final /* enum */ MixedCompressionOptions YES = new MixedCompressionOptions();
            private static final /* synthetic */ MixedCompressionOptions[] $VALUES;

            public static MixedCompressionOptions[] values() {
                return (MixedCompressionOptions[])$VALUES.clone();
            }

            /*
             * WARNING - void declaration
             */
            final boolean compressMixed(IPv6AddressSection addressSection) {
                switch (this) {
                    default: {
                        return true;
                    }
                    case NO: {
                        return false;
                    }
                    case NO_HOST: {
                        return !addressSection.isPrefixed();
                    }
                    case COVERED_BY_HOST: 
                }
                if (addressSection.isPrefixed()) {
                    int mixedDistance = 6 - addressSection.addressSegmentIndex;
                    int n = addressSection.getSegmentCount() - Math.max(mixedDistance, 0);
                    if (n > 0) {
                        void var1_1;
                        void var2_2;
                        return var2_2 * addressSection.getBitsPerSegment() >= var1_1.getNetworkPrefixLength();
                    }
                }
                return true;
            }

            static {
                $VALUES = new MixedCompressionOptions[]{NO, NO_HOST, COVERED_BY_HOST, YES};
            }
        }

        public static final class CompressionChoiceOptions
        extends Enum<CompressionChoiceOptions> {
            public static final /* enum */ CompressionChoiceOptions HOST_PREFERRED = new CompressionChoiceOptions();
            public static final /* enum */ CompressionChoiceOptions MIXED_PREFERRED = new CompressionChoiceOptions();
            public static final /* enum */ CompressionChoiceOptions ZEROS_OR_HOST = new CompressionChoiceOptions();
            public static final /* enum */ CompressionChoiceOptions ZEROS = new CompressionChoiceOptions();
            private static final /* synthetic */ CompressionChoiceOptions[] $VALUES;

            final boolean compressHost() {
                return this != ZEROS;
            }

            static {
                $VALUES = new CompressionChoiceOptions[]{HOST_PREFERRED, MIXED_PREFERRED, ZEROS_OR_HOST, ZEROS};
            }
        }
    }

    static class IPv6AddressCache
    extends AddressDivisionGrouping.SectionCache<IPv6Address> {
        IPv6AddressCache() {
        }
    }

    static class IPv6StringCache
    extends IPAddressSection.IPStringCache {
        static final IPv6StringOptions mixedParams;
        static final IPv6StringOptions fullParams;
        static final IPv6StringOptions normalizedParams;
        static final IPv6StringOptions canonicalParams;
        static final IPv6StringOptions uncParams;
        static final IPv6StringOptions compressedParams;
        static final IPv6StringOptions wildcardNormalizedParams;
        static final IPv6StringOptions wildcardCanonicalParams;
        static final IPv6StringOptions sqlWildcardParams;
        static final IPv6StringOptions wildcardCompressedParams;
        static final IPv6StringOptions networkPrefixLengthParams;
        static final IPv6StringOptions reverseDNSParams;
        static final IPAddressSection.IPStringOptions base85Params;
        static final IPAddressSection.IPStringOptions segmentedBinaryParams;
        public String normalizedString;
        public String canonicalWildcardString;

        IPv6StringCache() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var3_3;
            void var0;
            void var1_1;
            void var2_2;
            CompressOptions compressAll = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.ZEROS_OR_HOST);
            CompressOptions compressMixed = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.MIXED_PREFERRED);
            CompressOptions compressAllNoSingles = new CompressOptions(false, CompressOptions.CompressionChoiceOptions.ZEROS_OR_HOST);
            CompressOptions compressHostPreferred = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.HOST_PREFERRED);
            CompressOptions compressZeros = new CompressOptions(true, CompressOptions.CompressionChoiceOptions.ZEROS);
            CompressOptions compressZerosNoSingles = new CompressOptions(false, CompressOptions.CompressionChoiceOptions.ZEROS);
            mixedParams = new IPv6StringOptions.Builder().setMakeMixed(true).setCompressOptions(compressMixed).toOptions();
            fullParams = new IPv6StringOptions.Builder().setExpandedSegments(true).setWildcardOptions(new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR))).toOptions();
            canonicalParams = new IPv6StringOptions.Builder().setCompressOptions((CompressOptions)var2_2).toOptions();
            uncParams = new IPv6StringOptions.Builder().setSeparator(Character.valueOf('-')).setZoneSeparator('s').setAddressSuffix(".ipv6-literal.net").setWildcardOptions(new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new AddressDivisionGrouping.StringOptions.Wildcards(IPv6Address.UNC_RANGE_SEPARATOR_STR, IPAddress.SEGMENT_WILDCARD_STR, null))).toOptions();
            compressedParams = new IPv6StringOptions.Builder().setCompressOptions(compressAll).toOptions();
            normalizedParams = new IPv6StringOptions.Builder().toOptions();
            IPAddressSection.WildcardOptions allWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL);
            IPAddressSection.WildcardOptions allSQLWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.SEGMENT_SQL_WILDCARD_STR, IPAddress.SEGMENT_SQL_SINGLE_WILDCARD_STR));
            wildcardCanonicalParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).setCompressOptions(compressZerosNoSingles).toOptions();
            wildcardNormalizedParams = new IPv6StringOptions.Builder().setWildcardOptions(allWildcards).toOptions();
            sqlWildcardParams = new IPv6StringOptions.Builder().setWildcardOptions((IPAddressSection.WildcardOptions)var1_1).toOptions();
            wildcardCompressedParams = new IPv6StringOptions.Builder().setWildcardOptions((IPAddressSection.WildcardOptions)var0).setCompressOptions(compressZeros).toOptions();
            networkPrefixLengthParams = new IPv6StringOptions.Builder().setCompressOptions((CompressOptions)var3_3).toOptions();
            reverseDNSParams = new IPv6StringOptions.Builder().setReverse(true).setAddressSuffix(".ip6.arpa").setSplitDigits(true).setExpandedSegments(true).setSeparator(Character.valueOf('.')).toOptions();
            base85Params = new IPAddressSection.IPStringOptions.Builder(85).setExpandedSegments(true).setWildcards(new AddressDivisionGrouping.StringOptions.Wildcards(Address.ALTERNATIVE_RANGE_SEPARATOR_STR)).setZoneSeparator('\u00a7').toOptions();
            segmentedBinaryParams = new IPAddressSection.IPStringOptions.Builder(2).setSeparator(Character.valueOf(':')).setSegmentStrPrefix("0b").setExpandedSegments(true).toOptions();
        }
    }
}

