/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;
import java.net.Inet6Address;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IPv6AddressNetwork
extends IPAddressNetwork<IPv6Address, IPv6AddressSection, IPv4AddressSection, IPv6AddressSegment, Inet6Address> {
    private static AddressNetwork.PrefixConfiguration defaultPrefixConfiguration = AddressNetwork.getDefaultPrefixConfiguration();
    static final IPv6AddressSegment[] EMPTY_SEGMENTS = new IPv6AddressSegment[0];
    private static final IPv6AddressSection[] EMPTY_SECTION = new IPv6AddressSection[0];
    private static final IPv6Address[] EMPTY_ADDRESS = new IPv6Address[0];
    private static boolean CACHE_SEGMENTS_BY_PREFIX = true;

    public IPv6AddressNetwork() {
        super(IPv6Address.class);
    }

    @Override
    public AddressNetwork.PrefixConfiguration getPrefixConfiguration() {
        return defaultPrefixConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isCompatible(IPv6AddressNetwork other) {
        void var1_1;
        return super.isCompatible((AddressNetwork<?>)var1_1);
    }

    @Override
    protected BiFunction<IPv6Address, Integer, IPv6AddressSegment> getSegmentProducer() {
        return (address, index) -> {
            void var1_1;
            return address.getSegment(var1_1.intValue());
        };
    }

    @Override
    protected Function<IPv6Address, IPv6AddressSection> getSectionProducer() {
        return IPv6Address::getSection;
    }

    protected IPv6AddressCreator createAddressCreator() {
        return new IPv6AddressCreator(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IPv6Address createLoopback() {
        void var3_3;
        void var1_1;
        void var2_2;
        IPv6AddressCreator creator = this.getAddressCreator();
        IPv6AddressSegment zero = creator.createSegment(0);
        IPv6AddressSegment[] iPv6AddressSegmentArray = creator.createSegmentArray(8);
        IPv6AddressSegment[] segs = iPv6AddressSegmentArray;
        segs[5] = segs[6] = var2_2;
        segs[4] = segs[6];
        segs[3] = segs[6];
        segs[2] = segs[6];
        segs[1] = segs[6];
        iPv6AddressSegmentArray[0] = segs[6];
        segs[7] = creator.createSegment(1);
        return var1_1.createAddressInternal((IPv6AddressSegment[])var3_3);
    }

    @Override
    public IPv6AddressCreator getAddressCreator() {
        return (IPv6AddressCreator)super.getAddressCreator();
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV6;
    }

    public static class IPv6AddressCreator
    extends IPAddressNetwork.IPAddressCreator<IPv6Address, IPv6AddressSection, IPv4AddressSection, IPv6AddressSegment, Inet6Address> {
        Cache cache;
        boolean useSegmentCache = true;

        /*
         * WARNING - void declaration
         */
        public IPv6AddressCreator(IPv6AddressNetwork network) {
            super(var1_1);
            void var1_1;
            this.cache = new Cache();
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressCreator(IPv6AddressNetwork network, Cache cache) {
            super(var1_1);
            void var2_2;
            void var1_1;
            this.cache = var2_2;
        }

        public IPv6AddressNetwork getNetwork() {
            return (IPv6AddressNetwork)super.getNetwork();
        }

        @Override
        public int getMaxValuePerSegment() {
            return 65535;
        }

        @Override
        protected int getAddressSegmentCount() {
            return 8;
        }

        /*
         * WARNING - void declaration
         */
        public IPv6AddressSegment[] createSegmentArray(int length) {
            void var1_1;
            if (length == 0) {
                return EMPTY_SEGMENTS;
            }
            return new IPv6AddressSegment[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv6AddressSegment createSegment(int value) {
            void var1_1;
            if (this.useSegmentCache && value >= 0 && value <= 65535) {
                void var2_2;
                IPv6AddressSegment result;
                IPv6AddressSegment[][] cache = this.cache.segmentCache;
                int blockIndex = value >>> 8;
                int resultIndex = value - (blockIndex << 8);
                if (cache == null) {
                    cache = new IPv6AddressSegment[511][];
                    Cache.access$002(this.cache, cache);
                    IPv6AddressSegment[] block = new IPv6AddressSegment[256];
                    cache[blockIndex] = block;
                    result = block[resultIndex] = new IPv6AddressSegment(value);
                } else {
                    IPv6AddressSegment[] block = result[blockIndex];
                    if (block == null) {
                        result[blockIndex] = block = new IPv6AddressSegment[256];
                        result = block[resultIndex] = new IPv6AddressSegment(value);
                    } else {
                        result = block[resultIndex];
                        if (result == null) {
                            result = var3_6[resultIndex] = new IPv6AddressSegment(value);
                        }
                    }
                }
                return var2_2;
            }
            return new IPv6AddressSegment((int)var1_1);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public IPv6AddressSegment createSegment(int value, Integer segmentPrefixLength) {
            block10: {
                block11: {
                    if (segmentPrefixLength == null) {
                        return this.createSegment(value);
                    }
                    if (!this.useSegmentCache || value < 0 || value > 65535 || segmentPrefixLength < 0 || segmentPrefixLength > 128) break block10;
                    if (segmentPrefixLength == 0 && this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                        result = Cache.access$100(this.cache);
                        if (result == null) {
                            result = new IPv6AddressSegment(0, 0);
                            Cache.access$102(this.cache, result);
                        }
                        return result;
                    }
                    if (!IPv6AddressNetwork.access$200()) break block10;
                    prefixIndex = segmentPrefixLength;
                    isAllSubnets = this.getNetwork().getPrefixConfiguration().allPrefixedAddressesAreSubnets();
                    if (isAllSubnets) {
                        mask = this.getNetwork().getSegmentNetworkMask(segmentPrefixLength);
                        valueIndex = (value &= mask) >>> 16 - segmentPrefixLength;
                    } else {
                        valueIndex = value;
                    }
                    cache = Cache.access$300(this.cache);
                    blockIndex = valueIndex >>> 8;
                    resultIndex = valueIndex - (blockIndex << 8);
                    if (cache != null) break block11;
                    cache = new IPv6AddressSegment[17][][];
                    Cache.access$302(this.cache, cache);
                    prefixCache = null;
                    ** GOTO lbl-1000
                }
                prefixCache = cache[prefixIndex];
                if (prefixCache != null) {
                    block = prefixCache[blockIndex];
                    result = block != null ? block[resultIndex] : null;
                } else lbl-1000:
                // 2 sources

                {
                    block = null;
                    result = null;
                }
                if (prefixCache == null) {
                    prefixCacheSize = isAllSubnets != false ? 1 << segmentPrefixLength : 65536;
                    prefixCache = new IPv6AddressSegment[prefixCacheSize + 256 - 1 >>> 8][];
                    cache[prefixIndex] = prefixCache;
                }
                if (block == null) {
                    prefixCacheSize = isAllSubnets != false ? 1 << segmentPrefixLength : 65536;
                    highestIndex = prefixCacheSize >>> 8;
                    block = valueIndex >>> 8 == highestIndex ? new IPv6AddressSegment[prefixCacheSize - (var3_4 << 8)] : new IPv6AddressSegment[256];
                    prefixCache[blockIndex] = block;
                }
                if (result == null) {
                    block[resultIndex] = result = new IPv6AddressSegment(value, segmentPrefixLength);
                }
                return result;
            }
            var3_5 = new IPv6AddressSegment((int)var1_1, (Integer)var2_2);
            return var3_5;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv6AddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            void var3_6;
            void var2_5;
            void var1_1;
            if (segmentPrefixLength == null) {
                if (lower == upper) {
                    return this.createSegment(lower);
                }
                if (this.useSegmentCache && lower == 0 && upper == 65535) {
                    IPv6AddressSegment result = this.cache.ALL_RANGE_SEGMENT;
                    if (result == null) {
                        result = new IPv6AddressSegment(0, 65535, null);
                        Cache.access$402(this.cache, result);
                    }
                    return result;
                }
            } else {
                int result;
                if (result == upper) {
                    return this.createSegment(result, segmentPrefixLength);
                }
                if (this.useSegmentCache && result >= 0 && result <= 65535 && upper >= 0 && upper <= 65535 && segmentPrefixLength >= 0 && segmentPrefixLength <= 128) {
                    if (segmentPrefixLength == 0 && ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                        return this.createSegment(0, segmentPrefixLength);
                    }
                    if (CACHE_SEGMENTS_BY_PREFIX) {
                        if (segmentPrefixLength > 16) {
                            segmentPrefixLength = 16;
                        }
                        if (((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                            int mask = this.getNetwork().getSegmentNetworkMask(segmentPrefixLength);
                            if ((upper & mask) == (result &= mask)) {
                                return this.createSegment(result, segmentPrefixLength);
                            }
                            int hostMask = this.getNetwork().getSegmentHostMask(segmentPrefixLength);
                            upper |= hostMask;
                        }
                        if (result == 0 && upper == 65535) {
                            IPv6AddressSegment result2;
                            int prefixIndex = segmentPrefixLength;
                            IPv6AddressSegment[] cache = this.cache.allPrefixedCache;
                            if (cache == null) {
                                cache = new IPv6AddressSegment[17];
                                Cache.access$502(this.cache, cache);
                                cache[prefixIndex] = result2 = new IPv6AddressSegment(0, 65535, segmentPrefixLength);
                            } else {
                                result2 = cache[prefixIndex];
                                if (result2 == null) {
                                    var1_3[prefixIndex] = result2 = new IPv6AddressSegment(0, 65535, segmentPrefixLength);
                                }
                            }
                            return result2;
                        }
                    }
                }
            }
            IPv6AddressSegment iPv6AddressSegment = new IPv6AddressSegment((int)var1_1, (int)var2_5, (Integer)var3_6);
            return iPv6AddressSegment;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPv6AddressSection createSectionInternal(byte[] bytes, int segmentCount, Integer prefix, boolean singleOnly) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv6AddressSection((byte[])var1_1, (int)var2_2, (Integer)var3_3, false, singleOnly);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments) {
            void var1_1;
            return new IPv6AddressSection((IPv6AddressSegment[])var1_1, 0, false);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressSection createPrefixedSectionInternal(IPv6AddressSegment[] segments, Integer prefix, boolean singleOnly) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv6AddressSection((IPv6AddressSegment[])var1_1, 0, false, (Integer)var2_2, (boolean)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressSection createEmbeddedSectionInternal(IPv6AddressSection encompassingSection, IPv6AddressSegment[] segments, int startIndex) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv6AddressSection.EmbeddedIPv6AddressSection((IPAddressSection)var1_1, (IPv6AddressSegment[])var2_2, (int)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressSection createEmbeddedSectionInternal(IPAddressSection encompassingSection, IPv6AddressSegment[] segments) {
            void var2_2;
            void var1_1;
            return new IPv6AddressSection.EmbeddedIPv6AddressSection((IPv6AddressSection)var1_1, (IPv6AddressSegment[])var2_2, 0);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressSection createSectionInternal(IPv6AddressSegment[] segments, int startIndex) {
            void var2_2;
            void var1_1;
            return new IPv6AddressSection((IPv6AddressSegment[])var1_1, (int)var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6AddressSection createSection(byte[] bytes, int byteStartIndex, int byteEndIndex, int segmentCount, Integer prefix) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv6AddressSection((byte[])var1_1, (int)var2_2, (int)var3_3, segmentCount, prefix, true, false);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments) {
            void var1_1;
            return (IPv6Address)super.createAddressInternal((IPAddressSegment[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPv6Address createAddressInternal(IPv6AddressSection section, CharSequence zone) {
            void var2_2;
            void var1_1;
            if (zone == null || zone.length() == 0) {
                return this.createAddress(section);
            }
            String zoneStr = zone.toString().trim();
            if (zoneStr.length() == 0) {
                return this.createAddress(section);
            }
            IPv6Address.IPv6Zone zoneObj = this.getCacheZoneObj(zoneStr);
            return this.createAddress((IPv6AddressSection)var1_1, (IPv6Address.IPv6Zone)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        private IPv6Address.IPv6Zone getCacheZoneObj(String zoneStr) {
            void var3_4;
            IPv6Address.IPv6Zone zoneObj;
            int scope = IPv6Address.IPv6Zone.checkIfScope(zoneStr);
            if (scope >= 0) {
                if (scope < this.cache.scopedZoneCache.length) {
                    zoneObj = this.cache.scopedZoneCache[scope];
                    if (zoneObj == null) {
                        ((Cache)this.cache).scopedZoneCache[scope] = zoneObj = new IPv6Address.IPv6Zone(scope);
                    }
                } else {
                    zoneObj = new IPv6Address.IPv6Zone(scope);
                }
                zoneObj.zoneStr = zoneStr;
            } else {
                Lock readLock = this.cache.zoneInterfaceCacheLock.readLock();
                readLock.lock();
                zoneObj = (IPv6Address.IPv6Zone)this.cache.zoneInterfaceCache.get(zoneStr);
                readLock.unlock();
                if (zoneObj == null) {
                    IPv6Address.IPv6Zone newZoneObj = new IPv6Address.IPv6Zone(zoneStr);
                    Lock writeLock = this.cache.zoneInterfaceCacheLock.writeLock();
                    writeLock.lock();
                    zoneObj = (IPv6Address.IPv6Zone)this.cache.zoneInterfaceCache.get(zoneStr);
                    if (zoneObj == null) {
                        void var1_1;
                        void var2_3;
                        zoneObj = var2_3;
                        this.cache.zoneInterfaceCache.put(var1_1, zoneObj);
                    }
                    writeLock.unlock();
                }
            }
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        public IPv6Address createAddress(IPv6AddressSegment[] segments, IPv6Address.IPv6Zone zone) {
            void var2_2;
            void var1_1;
            if (zone == null) {
                return this.createAddressInternal(segments);
            }
            IPv6AddressCreator iPv6AddressCreator = this;
            return iPv6AddressCreator.createAddress(iPv6AddressCreator.createSectionInternal((IPv6AddressSegment[])var1_1), (IPv6Address.IPv6Zone)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public IPv6Address createAddress(IPv6AddressSection section, IPv6Address.IPv6Zone zone) {
            void var2_2;
            void var1_1;
            if (zone == null) {
                return this.createAddress(section);
            }
            return new IPv6Address((IPv6AddressSection)var1_1, (IPv6Address.IPv6Zone)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPv6Address createAddressInternal(IPv6AddressSection section, CharSequence zone, HostIdentifierString from, IPv6Address lower, IPv6Address upper) {
            void var1_1;
            void var3_3;
            void var2_2;
            IPv6Address result = (IPv6Address)this.createAddressInternal(section, (CharSequence)var2_2, (HostIdentifierString)var3_3);
            result.cache(lower, upper);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv6Address createAddress(IPv6AddressSection section) {
            void var1_1;
            return new IPv6Address((IPv6AddressSection)var1_1);
        }

        protected static class Cache
        implements Serializable {
            private transient IPv6AddressSegment ZERO_PREFIX_SEGMENT;
            private transient IPv6AddressSegment ALL_RANGE_SEGMENT;
            private transient IPv6AddressSegment[][] segmentCache;
            private transient IPv6AddressSegment[][][] segmentPrefixCache;
            private transient IPv6AddressSegment[] allPrefixedCache;
            private transient LinkedHashMap<String, IPv6Address.IPv6Zone> zoneInterfaceCache = new LinkedHashMap<String, IPv6Address.IPv6Zone>(this, 16, 0.75f, true){
                final /* synthetic */ Cache this$0;
                {
                    void var3_3;
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super((int)var2_2, (float)var3_3, arg2);
                }

                @Override
                protected boolean removeEldestEntry(Map.Entry<String, IPv6Address.IPv6Zone> eldest) {
                    return this.size() > 100;
                }
            };
            private ReadWriteLock zoneInterfaceCacheLock = new ReentrantReadWriteLock();
            private transient IPv6Address.IPv6Zone[] scopedZoneCache = new IPv6Address.IPv6Zone[256];

            protected Cache() {
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv6AddressSegment[][] access$002(Cache x0, IPv6AddressSegment[][] x1) {
                void var1_1;
                x0.segmentCache = var1_1;
                return x0.segmentCache;
            }

            static /* synthetic */ IPv6AddressSegment access$100(Cache x0) {
                return x0.ZERO_PREFIX_SEGMENT;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv6AddressSegment access$102(Cache x0, IPv6AddressSegment x1) {
                void var1_1;
                x0.ZERO_PREFIX_SEGMENT = var1_1;
                return x0.ZERO_PREFIX_SEGMENT;
            }

            static /* synthetic */ IPv6AddressSegment[][][] access$300(Cache x0) {
                return x0.segmentPrefixCache;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv6AddressSegment[][][] access$302(Cache x0, IPv6AddressSegment[][][] x1) {
                void var1_1;
                x0.segmentPrefixCache = var1_1;
                return x0.segmentPrefixCache;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv6AddressSegment access$402(Cache x0, IPv6AddressSegment x1) {
                void var1_1;
                x0.ALL_RANGE_SEGMENT = var1_1;
                return x0.ALL_RANGE_SEGMENT;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv6AddressSegment[] access$502(Cache x0, IPv6AddressSegment[] x1) {
                void var1_1;
                x0.allPrefixedCache = var1_1;
                return x0.allPrefixedCache;
            }
        }
    }
}

