/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv6;

import inet.ipaddr.Address;
import inet.ipaddr.AddressConversionException;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressPositionException;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.format.validate.Validator;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import inet.ipaddr.ipv6.IPv6AddressSeqRange;
import java.io.Serializable;
import java.net.NetworkInterface;
import java.util.Iterator;
import java.util.Objects;

public class IPv6Address
extends IPAddress
implements Iterable<IPv6Address> {
    public static final String UNC_RANGE_SEPARATOR_STR = "\u00bb";
    private final IPv6Zone zone;
    private transient IPv6AddressSection.IPv6StringCache stringCache;
    transient IPv6AddressSection.IPv6AddressCache addressCache;

    /*
     * WARNING - void declaration
     */
    IPv6Address(IPv6AddressSection section, CharSequence zone, boolean checkZone) throws AddressValueException {
        this((IPv6AddressSection)var1_1, var3_3 != false ? IPv6Address.checkZone(zone) : (zone != null && zone.length() > 0 ? new IPv6Zone(var2_2.toString()) : null));
        void var2_2;
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6Address(IPv6AddressSection section, IPv6Zone zone) throws AddressValueException {
        super(section);
        void var2_2;
        if (section.getSegmentCount() != 8) {
            throw new AddressValueException("ipaddress.error.ipv6.invalid.segment.count", section.getSegmentCount());
        }
        if (section.addressSegmentIndex != 0) {
            void var1_1;
            throw new AddressPositionException(var1_1.addressSegmentIndex);
        }
        this.zone = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv6Address(IPv6AddressSection section, CharSequence zone) throws AddressValueException {
        this((IPv6AddressSection)var1_1, (CharSequence)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6Address(IPv6AddressSection section) throws AddressValueException {
        this((IPv6AddressSection)var1_1, (CharSequence)null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6Address(byte[] bytes) throws AddressValueException {
        this((byte[])var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private IPv6Address(byte[] bytes, Integer networkPrefixLength, IPv6Zone zone) throws AddressValueException {
        this(bytes, 0, ((void)var1_1).length, (Integer)var2_2, (IPv6Zone)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private IPv6Address(byte[] bytes, int byteStartIndex, int byteEndIndex, Integer networkPrefixLength, IPv6Zone zone) throws AddressValueException {
        super(arg_0 -> IPv6Address.lambda$new$3((byte[])var1_1, (int)var2_2, (int)var3_3, networkPrefixLength, arg_0));
        void var3_3;
        void var2_2;
        void var1_1;
        this.zone = zone;
    }

    /*
     * WARNING - void declaration
     */
    static IPv6Zone checkZone(CharSequence zone) throws AddressValueException {
        void var1_2;
        if (zone == null) {
            return null;
        }
        String zoneStr = zone.toString().trim();
        if (zone.length() == 0) {
            return null;
        }
        int invalidIndex = Validator.validateZone(zoneStr);
        if (invalidIndex >= 0) {
            void var0_1;
            throw new AddressValueException("ipaddress.error.invalid.zone", (long)var0_1);
        }
        return new IPv6Zone((String)var1_2);
    }

    IPv6AddressNetwork.IPv6AddressCreator getDefaultCreator() {
        return this.getNetwork().getAddressCreator();
    }

    /*
     * WARNING - void declaration
     */
    IPv6AddressNetwork.IPv6AddressCreator getCreator() {
        void var2_2;
        void var1_1;
        IPv6AddressNetwork.IPv6AddressCreator defaultCreator = this.getDefaultCreator();
        if (!this.hasZone()) {
            return defaultCreator;
        }
        IPv6Address iPv6Address = this;
        IPv6AddressNetwork.IPv6AddressCreator creator = new IPv6AddressNetwork.IPv6AddressCreator(iPv6Address, iPv6Address.getNetwork(), defaultCreator.cache){
            final /* synthetic */ IPv6Address this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((IPv6AddressNetwork)var2_2, (IPv6AddressNetwork.IPv6AddressCreator.Cache)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected IPv6Address createAddressInternal(IPv6AddressSegment[] segments) {
                void var1_1;
                IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator = this.this$0.getDefaultCreator();
                return iPv6AddressCreator.createAddress((IPv6AddressSegment[])var1_1, this.this$0.zone);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public IPv6Address createAddress(IPv6AddressSection section) {
                void var1_1;
                IPv6AddressNetwork.IPv6AddressCreator iPv6AddressCreator = this.this$0.getDefaultCreator();
                return iPv6AddressCreator.createAddress((IPv6AddressSection)var1_1, this.this$0.zone);
            }
        };
        new /* invalid duplicate definition of identical inner class */.useSegmentCache = var1_1.useSegmentCache;
        return var2_2;
    }

    @Override
    public IPv6AddressNetwork getNetwork() {
        return IPv6Address.defaultIpv6Network();
    }

    public IPv4AddressNetwork getIPv4Network() {
        return IPv6Address.defaultIpv4Network();
    }

    @Override
    public IPv6AddressSection getSection() {
        return (IPv6AddressSection)super.getSection();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6AddressSegment getDivision(int index) {
        void var1_1;
        return this.getSegment((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6AddressSegment getSegment(int index) {
        void var1_1;
        return this.getSection().getSegment((int)var1_1);
    }

    @Override
    public int getSegmentCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 16;
    }

    @Override
    public int getBitCount() {
        return 128;
    }

    /*
     * WARNING - void declaration
     */
    void cache(IPv6Address lower, IPv6Address upper) {
        if ((lower != null || upper != null) && this.getSection().getSingleLowestOrHighestSection() == null) {
            this.getSection().cache(lower != null ? lower.getSection() : null, upper != null ? upper.getSection() : null);
            IPv6AddressSection.IPv6AddressCache cache = this.addressCache;
            if (cache == null || lower != null && cache.lower == null || upper != null && cache.upper == null) {
                IPv6Address iPv6Address = this;
                synchronized (iPv6Address) {
                    cache = this.addressCache;
                    boolean bl = cache == null;
                    if (bl) {
                        this.addressCache = cache = new IPv6AddressSection.IPv6AddressCache();
                        cache.lower = lower;
                        cache.upper = upper;
                    } else {
                        if (cache.lower == null) {
                            void var1_1;
                            cache.lower = var1_1;
                        }
                        if (cache.upper == null) {
                            void var2_3;
                            var3_4.upper = var2_3;
                        }
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private IPv6Address getLowestOrHighest(boolean lowest, boolean excludeZeroHost) {
        void var3_4;
        block18: {
            IPv6AddressSection.IPv6AddressCache cache;
            IPv6Address result;
            IPv6AddressSection sectionResult;
            block17: {
                IPv6AddressSection currentSection = this.getSection();
                sectionResult = currentSection.getLowestOrHighestSection(lowest, excludeZeroHost);
                if (sectionResult == currentSection) {
                    return this;
                }
                if (sectionResult == null) {
                    return null;
                }
                result = null;
                cache = this.addressCache;
                if (cache == null) break block17;
                IPv6Address iPv6Address = lowest ? (excludeZeroHost ? (IPv6Address)cache.lowerNonZeroHost : (IPv6Address)cache.lower) : (result = (IPv6Address)cache.upper);
                if (iPv6Address != null) break block18;
            }
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                cache = this.addressCache;
                boolean create = cache == null;
                if (create) {
                    this.addressCache = cache = new IPv6AddressSection.IPv6AddressCache();
                } else if (lowest) {
                    create = excludeZeroHost ? (result = (IPv6Address)cache.lowerNonZeroHost) == null : (result = (IPv6Address)cache.lower) == null;
                } else {
                    result = (IPv6Address)cache.upper;
                    boolean bl = create = result == null;
                }
                if (create) {
                    void var1_1;
                    result = this.getCreator().createAddress(sectionResult);
                    if (var1_1 != false) {
                        void var2_3;
                        if (var2_3 != false) {
                            cache.lowerNonZeroHost = result;
                        } else {
                            cache.lower = result;
                        }
                    } else {
                        cache.upper = result;
                    }
                }
            }
        }
        return var3_4;
    }

    @Override
    public IPv6Address getLower() {
        return this.getLowestOrHighest(true, false);
    }

    public IPv6Address getUpper() {
        return this.getLowestOrHighest(false, false);
    }

    @Override
    public Iterator<IPv6Address> iterator() {
        IPv6Address iPv6Address = this;
        return this.getSection().iterator(iPv6Address, iPv6Address.getCreator(), null);
    }

    @Override
    public AddressComponentSpliterator<IPv6Address> spliterator() {
        IPv6Address iPv6Address = this;
        return this.getSection().spliterator(iPv6Address, iPv6Address.getCreator(), false);
    }

    @Override
    public IPv4Address toIPv4() {
        IPAddressConverter iPAddressConverter = DEFAULT_ADDRESS_CONVERTER;
        return iPAddressConverter.toIPv4(this);
    }

    @Override
    public IPv6Address toIPv6() {
        return this;
    }

    @Override
    public boolean isIPv6() {
        return true;
    }

    public IPv4Address getEmbeddedIPv4Address() {
        IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator = this.getIPv4Network().getAddressCreator();
        return iPv4AddressCreator.createAddress(this.getSection().getEmbeddedIPv4AddressSection());
    }

    public boolean isIPv4Mapped() {
        if (this.getSegment(5).matches(65535)) {
            for (int i = 0; i < 5; ++i) {
                if (this.getSegment(i).isZero()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private IPv6Address checkIdentity(IPv6AddressSection newSection) {
        void var1_1;
        if (newSection == this.getSection()) {
            return this;
        }
        return this.getCreator().createAddress((IPv6AddressSection)var1_1);
    }

    @Override
    public IPv6Address withoutPrefixLength() {
        return this.removePrefixLength(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv6Address removePrefixLength(boolean zeroed) {
        void var1_1;
        IPv6Address iPv6Address = this;
        return iPv6Address.checkIdentity(iPv6Address.getSection().removePrefixLength((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    protected IPv6Address convertArg(IPAddress arg) throws AddressConversionException {
        void var2_2;
        IPv6Address converted = arg.toIPv6();
        if (converted == null) {
            void var1_1;
            throw new AddressConversionException(this, (AddressItem)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IPv6Address toZeroHost(boolean boundariesOnly) {
        void var1_1;
        if (!this.isPrefixed()) {
            void var1_2;
            void var2_3;
            IPv6AddressNetwork network;
            AddressNetwork.PrefixConfiguration config = ((AddressNetwork)(network = this.getNetwork())).getPrefixConfiguration();
            IPv6Address addr = (IPv6Address)network.getNetworkMask(0, !config.allPrefixedAddressesAreSubnets());
            if (var2_3.zeroHostsAreSubnets()) {
                addr = addr.getLower();
            }
            return var1_2;
        }
        if (this.includesZeroHost() && this.isSingleNetwork()) {
            return this.getLower();
        }
        IPv6Address iPv6Address = this;
        return iPv6Address.checkIdentity(iPv6Address.getSection().createZeroHost((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public IPv6Address mask(IPAddress mask, boolean retainPrefix) throws IncompatibleAddressException, AddressConversionException {
        void var2_2;
        void var1_1;
        IPv6Address iPv6Address = this;
        return iPv6Address.checkIdentity(iPv6Address.getSection().mask(this.convertArg((IPAddress)var1_1).getSection(), (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6Address mask(IPAddress mask) throws IncompatibleAddressException, AddressConversionException {
        void var1_1;
        return this.mask((IPAddress)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6AddressSeqRange spanWithRange(IPAddress other) throws AddressConversionException {
        void var1_1;
        return this.toSequentialRange((IPAddress)var1_1);
    }

    public boolean hasZone() {
        return this.zone != null;
    }

    public String getZone() {
        return this.getZoneString();
    }

    public IPv6Address removeZone() {
        if (this.hasZone()) {
            return this.getDefaultCreator().createAddress(this.getSection());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv6AddressSeqRange toSequentialRange(IPAddress other) {
        void var1_1;
        IPv6Address iPv6Address = this;
        return new IPv6AddressSeqRange(iPv6Address, iPv6Address.convertArg((IPAddress)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv6AddressSeqRange toSequentialRange() {
        void var1_1;
        IPv6Address thiz = this.removeZone().withoutPrefixLength();
        return new IPv6AddressSeqRange(thiz.getLower(), var1_1.getUpper(), true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result = super.hashCode();
        if (this.hasZone()) {
            result *= this.zone.getName().hashCode();
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSameAddress(Address other) {
        void var1_1;
        return other instanceof IPv6Address && super.isSameAddress(other) && this.isSameZone((IPv6Address)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isSameZone(IPv6Address otherIPv6Address) {
        void var1_1;
        return Objects.equals(this.zone, var1_1.zone);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Address other) {
        if (super.contains(other)) {
            if (other != this) {
                IPv6Address otherAddr = (IPv6Address)other;
                if (this.hasZone() || otherAddr.hasZone()) {
                    void var1_1;
                    return this.isSameZone((IPv6Address)var1_1);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected IPAddressStringParameters createFromStringParams() {
        return ((IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase)((IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase)new IPAddressStringParameters.Builder().getIPv4AddressParametersBuilder().setNetwork(this.getIPv4Network())).getParentBuilder().getIPv6AddressParametersBuilder().setNetwork(this.getNetwork())).getParentBuilder().toParams();
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv6Address iPv6Address = this;
            synchronized (iPv6Address) {
                if (this.stringCache == null) {
                    void var3_4;
                    void var2_2;
                    if (this.hasZone()) {
                        this.stringCache = new IPv6AddressSection.IPv6StringCache();
                        return true;
                    }
                    IPv6AddressSection section = this.getSection();
                    boolean result = section.hasNoStringCache();
                    this.stringCache = var2_2.getStringCache();
                    return (boolean)var3_4;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toCanonicalString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.canonicalParams);
            } else {
                result = this.getSection().toCanonicalString();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.normalizedParams);
            } else {
                result = this.getSection().toNormalizedString();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedWildcardString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardNormalizedParams);
            } else {
                result = this.getSection().toNormalizedWildcardString();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toCanonicalWildcardString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalWildcardString) == null) {
            if (this.hasZone()) {
                this.stringCache.canonicalWildcardString = result = this.toNormalizedString(IPv6AddressSection.IPv6StringCache.wildcardCanonicalParams);
            } else {
                result = this.getSection().toCanonicalWildcardString();
            }
        }
        return var1_1;
    }

    private String getZoneString() {
        if (this.hasZone()) {
            return this.zone.getName();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toNormalizedString(IPv6AddressSection.IPv6StringOptions params) {
        void var1_1;
        return this.getSection().toNormalizedString((IPv6AddressSection.IPv6StringOptions)var1_1, this.getZoneString());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ AddressSection lambda$new$3(byte[] bytes, int byteStartIndex, int byteEndIndex, Integer networkPrefixLength, Address thisAddress) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        return ((IPv6Address)thisAddress).getDefaultCreator().createSection(byArray, (int)var1_1, (int)var2_2, 8, (Integer)var3_3);
    }

    public static interface IPv6AddressConverter {
        public IPv6Address toIPv6(IPAddress var1);
    }

    public static class IPv6Zone
    implements Serializable {
        String zoneStr;
        private int scopeId;
        private transient NetworkInterface networkInterface;
        private Boolean referencesInterface;

        /*
         * WARNING - void declaration
         */
        public IPv6Zone(String zoneStr) {
            void var1_1;
            if (zoneStr == null) {
                throw new NullPointerException();
            }
            this.zoneStr = var1_1.trim();
            this.scopeId = -1;
        }

        /*
         * WARNING - void declaration
         */
        public IPv6Zone(int scopeId) {
            void var1_1;
            if (scopeId < 0) {
                throw new IllegalArgumentException();
            }
            this.scopeId = var1_1;
            this.referencesInterface = Boolean.FALSE;
        }

        public boolean referencesIntf() {
            if (this.referencesInterface == null) {
                this.scopeId = IPv6Zone.checkIfScope(this.zoneStr);
                this.referencesInterface = this.scopeId < 0;
            }
            return this.referencesInterface;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object o) {
            void var1_1;
            return o instanceof IPv6Zone && this.toString().equals(var1_1.toString());
        }

        public String getName() {
            if (this.zoneStr == null) {
                this.zoneStr = this.referencesIntf() ? this.networkInterface.getName() : IPv6AddressSegment.toUnsignedString(this.scopeId, 10, new StringBuilder(IPv6AddressSegment.toUnsignedStringLength(this.scopeId, 10))).toString();
            }
            return this.zoneStr;
        }

        public String toString() {
            return this.getName();
        }

        /*
         * WARNING - void declaration
         */
        static int checkIfScope(String zoneStr) {
            void var1_1;
            long digits = 0L;
            int len = zoneStr.length();
            for (int i = 0; i < len; ++i) {
                char c = zoneStr.charAt(i);
                int digit = Character.digit(c, 10);
                if (digit < 0) {
                    return -1;
                }
                if ((digits = digits * 10L + (long)digit) <= Integer.MAX_VALUE) continue;
                return -1;
            }
            return (int)var1_1;
        }
    }
}

