/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressStringParameters;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressStringParameters;

public class IPv4AddressStringParameters
extends IPAddressStringParameters.IPAddressStringFormatParameters
implements Comparable<IPv4AddressStringParameters> {
    public final boolean inet_aton_hex;
    public final boolean inet_aton_octal;
    public final boolean inet_aton_leading_zeros;
    public final boolean inet_aton_joinedSegments;
    public final boolean inet_aton_single_segment_mask;
    public final boolean inet_aton_extraneous_digits;
    private final IPv4AddressNetwork network;

    /*
     * WARNING - void declaration
     */
    public IPv4AddressStringParameters(boolean allowLeadingZeros, boolean allowCIDRPrefixLeadingZeros, boolean allowUnlimitedLeadingZeros, AddressStringParameters.RangeParameters rangeOptions, boolean allowWildcardedSeparator, boolean allowPrefixesBeyondAddressSize, boolean allowBinary, boolean inet_aton_hex, boolean inet_aton_octal, boolean inet_aton_leading_zeros, boolean inet_aton_joinedSegments, boolean inet_aton_single_segment_mask, boolean inet_aton_extraneous_digits, IPv4AddressNetwork network) {
        super(allowBinary, (boolean)var1_1, (boolean)var2_2, (boolean)var3_3, rangeOptions, allowWildcardedSeparator, allowPrefixesBeyondAddressSize);
        void var3_3;
        void var2_2;
        void var1_1;
        this.inet_aton_hex = inet_aton_hex;
        this.inet_aton_octal = inet_aton_octal;
        this.inet_aton_leading_zeros = inet_aton_leading_zeros;
        this.inet_aton_joinedSegments = inet_aton_joinedSegments;
        this.inet_aton_single_segment_mask = inet_aton_single_segment_mask;
        this.inet_aton_extraneous_digits = inet_aton_extraneous_digits;
        this.network = network;
    }

    /*
     * WARNING - void declaration
     */
    public Builder toBuilder() {
        void var1_1;
        Builder builder = new Builder();
        Builder.access$002(builder, this.inet_aton_hex);
        Builder.access$102(builder, this.inet_aton_octal);
        Builder.access$202(builder, this.inet_aton_joinedSegments);
        Builder.access$302(builder, this.inet_aton_single_segment_mask);
        Builder.access$402(builder, this.inet_aton_extraneous_digits);
        Builder.access$502(builder, this.network);
        return (Builder)this.toBuilder((IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase)var1_1);
    }

    public IPv4AddressNetwork getNetwork() {
        if (this.network == null) {
            return Address.defaultIpv4Network();
        }
        return this.network;
    }

    public IPv4AddressStringParameters clone() {
        try {
            return (IPv4AddressStringParameters)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int compareTo(IPv4AddressStringParameters o) {
        void var2_2;
        int result = super.compareTo(o);
        if (result == 0 && (result = Boolean.compare(this.inet_aton_hex, o.inet_aton_hex)) == 0 && (result = Boolean.compare(this.inet_aton_octal, o.inet_aton_octal)) == 0 && (result = Boolean.compare(this.inet_aton_joinedSegments, o.inet_aton_joinedSegments)) == 0 && (result = Boolean.compare(this.inet_aton_leading_zeros, o.inet_aton_leading_zeros)) == 0 && (result = Boolean.compare(this.inet_aton_single_segment_mask, o.inet_aton_single_segment_mask)) == 0) {
            void var1_1;
            result = Boolean.compare(this.inet_aton_extraneous_digits, var1_1.inet_aton_extraneous_digits);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o instanceof IPv4AddressStringParameters && super.equals(o)) {
            void var1_1;
            IPv4AddressStringParameters other = (IPv4AddressStringParameters)o;
            return this.inet_aton_hex == other.inet_aton_hex && this.inet_aton_octal == other.inet_aton_octal && this.inet_aton_joinedSegments == other.inet_aton_joinedSegments && this.inet_aton_leading_zeros == other.inet_aton_leading_zeros && this.inet_aton_single_segment_mask == other.inet_aton_single_segment_mask && this.inet_aton_extraneous_digits == var1_1.inet_aton_extraneous_digits;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hash = super.hashCode();
        if (this.inet_aton_hex) {
            hash |= 0x40;
        }
        if (this.inet_aton_octal) {
            hash |= 0x80;
        }
        if (this.inet_aton_joinedSegments) {
            hash |= 0x100;
        }
        return (int)var1_1;
    }

    public static class Builder
    extends IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase {
        private boolean inet_aton_hex = true;
        private boolean inet_aton_octal = true;
        private boolean inet_aton_leading_zeros = true;
        private boolean inet_aton_joinedSegments = true;
        private boolean inet_aton_single_segment_mask = false;
        private boolean inet_aton_extraneous_digits = false;
        private IPv4AddressNetwork network;
        IPv6AddressStringParameters.Builder mixedParent;

        /*
         * WARNING - void declaration
         */
        @Override
        protected void setMixedParent(IPv6AddressStringParameters.Builder parent) {
            void var1_1;
            this.mixedParent = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public Builder allow_inet_aton(boolean allow) {
            void var1_1;
            Builder builder = this;
            builder.inet_aton_octal = this.inet_aton_hex = allow;
            builder.inet_aton_joinedSegments = this.inet_aton_hex;
            super.allowUnlimitedLeadingZeros((boolean)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder setNetwork(IPv4AddressNetwork network) {
            void var1_1;
            this.network = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder setRangeOptions(AddressStringParameters.RangeParameters rangeOptions) {
            void var1_1;
            super.setRangeOptions((AddressStringParameters.RangeParameters)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder allowUnlimitedLeadingZeros(boolean allow) {
            void var1_1;
            super.allowUnlimitedLeadingZeros((boolean)var1_1);
            return this;
        }

        public IPv4AddressStringParameters toParams() {
            return new IPv4AddressStringParameters(this.allowLeadingZeros, this.allowPrefixLengthLeadingZeros, this.allowUnlimitedLeadingZeros, this.rangeOptions, this.allowWildcardedSeparator, this.allowPrefixesBeyondAddressSize, this.allowBinary, this.inet_aton_hex, this.inet_aton_octal, this.inet_aton_leading_zeros, this.inet_aton_joinedSegments, this.inet_aton_single_segment_mask, this.inet_aton_extraneous_digits, this.network);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$002(Builder x0, boolean x1) {
            void var1_1;
            x0.inet_aton_hex = var1_1;
            return x0.inet_aton_hex;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$102(Builder x0, boolean x1) {
            void var1_1;
            x0.inet_aton_octal = var1_1;
            return x0.inet_aton_octal;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$202(Builder x0, boolean x1) {
            void var1_1;
            x0.inet_aton_joinedSegments = var1_1;
            return x0.inet_aton_joinedSegments;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$302(Builder x0, boolean x1) {
            void var1_1;
            x0.inet_aton_single_segment_mask = var1_1;
            return x0.inet_aton_single_segment_mask;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$402(Builder x0, boolean x1) {
            void var1_1;
            x0.inet_aton_extraneous_digits = var1_1;
            return x0.inet_aton_extraneous_digits;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPv4AddressNetwork access$502(Builder x0, IPv4AddressNetwork x1) {
            void var1_1;
            x0.network = var1_1;
            return x0.network;
        }
    }
}

