/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.NetworkMismatchException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.util.AddressComponentRangeSpliterator;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import java.math.BigInteger;
import java.util.Iterator;

public class IPv4AddressSeqRange
extends IPAddressSeqRange
implements Iterable<IPv4Address> {
    private static final IPv4AddressSeqRange[] EMPTY = new IPv4AddressSeqRange[0];

    /*
     * WARNING - void declaration
     */
    IPv4AddressSeqRange(IPv4Address first, IPv4Address second, boolean preSet) {
        super(var1_1, var2_2, (boolean)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSeqRange(IPv4Address first, IPv4Address second) {
        super(first, second, IPv4Address::getLower, IPv4Address::getUpper, IPv4Address::withoutPrefixLength);
        if (!first.getNetwork().isCompatible(second.getNetwork())) {
            void var2_2;
            void var1_1;
            throw new NetworkMismatchException((AddressItem)var1_1, (AddressItem)var2_2);
        }
    }

    @Override
    public IPv4Address getLower() {
        return (IPv4Address)super.getLower();
    }

    @Override
    public IPv4Address getUpper() {
        return (IPv4Address)super.getUpper();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return this.getLower().getNetwork().getAddressCreator();
    }

    public long getIPv4Count() {
        return this.getUpper().longValue() - this.getLower().longValue() + 1L;
    }

    @Override
    protected BigInteger getCountImpl() {
        return BigInteger.valueOf(this.getIPv4Count());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Iterator<IPv4Address> iterator() {
        void var3_3;
        void var2_2;
        void var1_1;
        IPv4Address lower = this.getLower();
        IPv4Address upper = this.getUpper();
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getAddressCreator();
        if (!this.isMultiple()) {
            return IPv4AddressSeqRange.iterator(lower, creator);
        }
        int divCount = ((Address)lower).getSegmentCount();
        return IPv4AddressSeqRange.iterator(var1_1, var2_2, var3_3, IPv4Address::getSegment, (seg, segIndex) -> seg.iterator(), (addr1, addr2, index) -> {
            void var2_2;
            void var1_1;
            return addr1.getSegment(index).getSegmentValue() == var1_1.getSegment((int)var2_2).getSegmentValue();
        }, divCount - 1, divCount, null);
    }

    /*
     * WARNING - void declaration
     */
    public AddressComponentRangeSpliterator<IPv4AddressSeqRange, IPv4Address> spliterator() {
        void var1_1;
        void var3_3;
        void var2_2;
        int segmentCount = ((Address)this.getLower()).getSegmentCount();
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getAddressCreator();
        int networkSegIndex = segmentCount - 1;
        return IPv4AddressSeqRange.createSpliterator(this, arg_0 -> IPv4AddressSeqRange.lambda$spliterator$3((IPv4AddressNetwork.IPv4AddressCreator)var2_2, (int)var3_3, (int)var1_1, arg_0), (lowest, highest, range) -> range.iterator(), IPv4AddressSeqRange::getIPv4Count);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getMinPrefixLengthForBlock() {
        void var1_1;
        int upperOnes;
        int result = this.getBitCount();
        int lowerZeros = Integer.numberOfTrailingZeros(this.getLower().intValue());
        if (lowerZeros != 0 && (upperOnes = Integer.numberOfTrailingZeros(~this.getUpper().intValue())) != 0) {
            void var2_2;
            void var3_3;
            int prefixedBitCount = Math.min(lowerZeros, (int)var3_3);
            result -= var2_2;
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$3(IPv4AddressNetwork.IPv4AddressCreator creator, int networkSegIndex, int hostSegIndex, IPAddressSeqRange.IPAddressSeqRangeSplitterSink sink) {
        void var2_2;
        void var1_1;
        IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator;
        void var3_3;
        IPv4AddressSeqRange range = (IPv4AddressSeqRange)sink.getAddressItem();
        return IPv4AddressSeqRange.split((IPAddressSeqRange.IPAddressSeqRangeSplitterSink)var3_3, (T segsLower, U segsUpper) -> {
            void var2_2;
            IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator;
            void var1_1;
            return new IPv4AddressSeqRange(creator.createAddressInternal((IPv4AddressSegment[])var1_1), iPv4AddressCreator.createAddressInternal((IPv4AddressSegment[])var2_2));
        }, (AddressNetwork.AddressSegmentCreator)iPv4AddressCreator, (AddressSegment[])range.getLower().getSection().getSegmentsInternal(), (AddressSegment[])range.getUpper().getSection().getSegmentsInternal(), (int)var1_1, (int)var2_2, null);
    }
}

