/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.format.AddressDivisionBase;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.util.Iterator;

public class IPv4AddressSegment
extends IPAddressSegment
implements Iterable<IPv4AddressSegment> {
    /*
     * WARNING - void declaration
     */
    public IPv4AddressSegment(int value) throws AddressValueException {
        super(value);
        if (value > 255) {
            void var1_1;
            throw new AddressValueException((long)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSegment(int value, Integer segmentPrefixLength) throws AddressValueException {
        super(value, segmentPrefixLength);
        if (value > 255) {
            void var1_1;
            throw new AddressValueException((long)var1_1);
        }
        if (segmentPrefixLength != null && segmentPrefixLength > 32) {
            void var2_2;
            throw new PrefixLenException(var2_2.intValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSegment(int lower, int upper, Integer segmentPrefixLength) throws AddressValueException {
        super((int)var1_1, (int)var2_2, segmentPrefixLength);
        void var2_2;
        void var1_1;
        if (this.getUpperSegmentValue() > 255) {
            throw new AddressValueException(this.getUpperSegmentValue());
        }
        if (segmentPrefixLength != null && segmentPrefixLength > 32) {
            void var3_3;
            throw new PrefixLenException(var3_3.intValue());
        }
    }

    @Override
    public long getMaxValue() {
        return 255L;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var1_1;
        return new byte[]{(byte)(var1_1 != false ? this.getSegmentValue() : this.getUpperSegmentValue())};
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getSegmentNetworkMask(int bits) {
        void var1_1;
        return this.getNetwork().getSegmentNetworkMask((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected int getSegmentHostMask(int bits) {
        void var1_1;
        return this.getNetwork().getSegmentHostMask((int)var1_1);
    }

    @Override
    public int getMaxSegmentValue() {
        return IPv4AddressSegment.getMaxSegmentValue(IPAddress.IPVersion.IPV4);
    }

    protected IPv4AddressSegment toPrefixNormalizedSeg() {
        return this.getSegmentCreator().createSegment(this.getSegmentValue(), this.getUpperSegmentValue(), IPv4AddressSection.cacheBits(this.getBitCount()));
    }

    /*
     * WARNING - void declaration
     */
    protected IPv4AddressSegment toPrefixedSegment(Integer segmentPrefixLength) {
        if (this.isChangedByPrefix(segmentPrefixLength, ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets())) {
            void var1_1;
            return super.toPrefixedSegment((Integer)var1_1, this.getSegmentCreator());
        }
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSegment toNetworkSegment(Integer segmentPrefixLength) {
        void var1_1;
        return this.toNetworkSegment((Integer)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSegment toNetworkSegment(Integer segmentPrefixLength, boolean withPrefixLength) {
        if (this.isNetworkChangedByPrefix(segmentPrefixLength, withPrefixLength)) {
            void var2_2;
            void var1_1;
            return super.toNetworkSegment((Integer)var1_1, (boolean)var2_2, this.getSegmentCreator());
        }
        return this;
    }

    public IPv4AddressSegment getLower() {
        IPv4AddressSegment iPv4AddressSegment = this;
        return IPv4AddressSegment.getLowestOrHighest(iPv4AddressSegment, iPv4AddressSegment.getSegmentCreator(), true);
    }

    public IPv4AddressSegment getUpper() {
        IPv4AddressSegment iPv4AddressSegment = this;
        return IPv4AddressSegment.getLowestOrHighest(iPv4AddressSegment, iPv4AddressSegment.getSegmentCreator(), false);
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return Address.defaultIpv4Network();
    }

    public IPv4AddressNetwork.IPv4AddressCreator getSegmentCreator() {
        return this.getNetwork().getAddressCreator();
    }

    /*
     * WARNING - void declaration
     */
    Iterator<IPv4AddressSegment> iterator(boolean withPrefix) {
        void var1_1;
        void var2_2;
        IPv4AddressSegment original = !withPrefix && this.isPrefixed() && !((AddressDivision)this).isMultiple() ? this.withoutPrefixLength() : this;
        return IPv4AddressSegment.iterator(var2_2, this.getSegmentCreator(), var1_1 != false ? this.getSegmentPrefixLength() : null, false, false);
    }

    @Override
    public Iterator<IPv4AddressSegment> iterator() {
        IPv4AddressSegment iPv4AddressSegment = this;
        return iPv4AddressSegment.iterator(!((AddressNetwork)iPv4AddressSegment.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AddressComponentSpliterator<IPv4AddressSegment> spliterator() {
        void var2_3;
        void var1_1;
        void var3_4;
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getSegmentCreator();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        Integer segPrefLength = bl ? null : this.getSegmentPrefixLength();
        int bitCount = this.getBitCount();
        IPv4AddressSegment iPv4AddressSegment = this;
        return IPv4AddressSegment.createSegmentSpliterator(iPv4AddressSegment, iPv4AddressSegment.getSegmentValue(), this.getUpperSegmentValue(), this::iterator, (arg_0, arg_1, arg_2, arg_3) -> IPv4AddressSegment.lambda$spliterator$0((int)var3_4, creator, segPrefLength, arg_0, arg_1, arg_2, arg_3), (arg_0, arg_1) -> IPv4AddressSegment.lambda$spliterator$1((IPv4AddressNetwork.IPv4AddressCreator)var1_1, (Integer)var2_3, arg_0, arg_1));
    }

    @Override
    public int getBitCount() {
        return 8;
    }

    @Override
    public int getByteCount() {
        return 1;
    }

    @Override
    public int getDefaultTextualRadix() {
        return 10;
    }

    @Override
    public int getMaxDigitCount() {
        return 3;
    }

    public IPv4AddressSegment withoutPrefixLength() {
        return IPv4AddressSegment.removePrefix(this, false, this.getSegmentCreator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(AddressSegment other) {
        void var1_1;
        return this == other || this.containsSeg(other) && var1_1 instanceof IPv4AddressSegment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object other) {
        void var1_1;
        return this == other || other instanceof IPv4AddressSegment && ((IPv4AddressSegment)var1_1).isSameValues(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameValues(AddressDivisionBase other) {
        void var1_1;
        return other instanceof IPv4AddressSegment && this.isSameValues((AddressSegment)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public IPv6AddressSegment join(IPv6AddressNetwork.IPv6AddressCreator creator, IPv4AddressSegment low) throws IncompatibleAddressException {
        void var3_3;
        void var2_2;
        void var1_1;
        Integer prefix = IPv4AddressSegment.getJoinedSegmentPrefixLength(8, this.getSegmentPrefixLength(), low.getSegmentPrefixLength());
        if (((AddressDivision)this).isMultiple() && !low.isFullRange()) {
            throw new IncompatibleAddressException((AddressItem)this, low, "ipaddress.error.invalidMixedRange");
        }
        return var1_1.createSegment(this.getSegmentValue() << 8 | low.getSegmentValue(), this.getUpperSegmentValue() << 8 | var2_2.getUpperSegmentValue(), (Integer)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static Integer getJoinedSegmentPrefixLength(int bitsPerSegment, Integer highBits, Integer lowBits) {
        int n;
        void var2_2;
        if (lowBits == null) {
            return null;
        }
        if (lowBits == 0) {
            void var1_1;
            return var1_1;
        }
        return IPv4AddressSection.cacheBits(var2_2.intValue() + n);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ IPv4AddressSegment lambda$spliterator$1(IPv4AddressNetwork.IPv4AddressCreator creator, Integer segPrefLength, int value, int upperValue) {
        void var1_1;
        void var3_3;
        void var2_2;
        return creator.createSegment((int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ Iterator lambda$spliterator$0(int bitCount, IPv4AddressNetwork.IPv4AddressCreator creator, Integer segPrefLength, boolean isLowest, boolean isHighest, int value, int upperValue) {
        void var2_2;
        void var1_1;
        int n;
        return IPv4AddressSegment.iterator(null, value, upperValue, n, var1_1, (Integer)var2_2, false, false);
    }
}

