/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.PrefixLenException;
import inet.ipaddr.SizeMismatchException;
import inet.ipaddr.format.AddressDivisionGroupingBase;
import inet.ipaddr.format.standard.AddressCreator;
import inet.ipaddr.format.standard.AddressDivisionGrouping;
import inet.ipaddr.format.standard.IPAddressDivisionGrouping;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;

public class IPv4AddressSection
extends IPAddressSection
implements Iterable<IPv4AddressSection> {
    private static final long[] MAX_VALUES = new long[]{0L, 255L, 65535L, 0xFFFFFFL, 0xFFFFFFFFL};
    transient IPv4StringCache stringCache;
    private transient AddressDivisionGrouping.SectionCache<IPv4AddressSection> sectionCache;
    private transient Integer cachedLowerVal;
    private transient Integer cachedUpperVal;

    /*
     * WARNING - void declaration
     */
    protected IPv4AddressSection(IPv4AddressSegment[] segments, boolean cloneSegments, Integer networkPrefixLength, boolean singleOnly) throws AddressValueException {
        this(segments, cloneSegments, networkPrefixLength == null);
        if (networkPrefixLength != null) {
            void var3_4;
            if (networkPrefixLength < 0) {
                throw new PrefixLenException(networkPrefixLength);
            }
            int max = segments.length << 3;
            if (networkPrefixLength > max) {
                if (networkPrefixLength > 32) {
                    throw new PrefixLenException(networkPrefixLength);
                }
                networkPrefixLength = max;
            }
            if (segments.length > 0) {
                void var2_3;
                void var1_1;
                if (this.cachedPrefixLength != NO_PREFIX_LENGTH && this.cachedPrefixLength < networkPrefixLength) {
                    networkPrefixLength = this.cachedPrefixLength;
                }
                IPv4AddressNetwork network = this.getNetwork();
                IPv4AddressSection.setPrefixedSegments((AddressNetwork)network, (int)networkPrefixLength, (AddressSegment[])this.getSegmentsInternal(), (int)this.getBitsPerSegment(), (int)this.getBytesPerSegment(), (AddressNetwork.AddressSegmentCreator)network.getAddressCreator(), !singleOnly && IPv4AddressSection.isPrefixSubnetSegs((IPAddressSegment[])var1_1, networkPrefixLength, var2_3, false) ? IPv4AddressSegment::toNetworkSegment : IPv4AddressSegment::toPrefixedSegment);
            }
            this.cachedPrefixLength = var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected IPv4AddressSection(IPv4AddressSegment[] segments, boolean cloneSegments) throws AddressValueException {
        this((IPv4AddressSegment[])var1_1, (boolean)var2_2, true);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    IPv4AddressSection(IPv4AddressSegment[] segments, boolean cloneSegments, boolean normalizeSegments) throws AddressValueException {
        super(segments, (boolean)var2_2, true);
        void var3_3;
        void var2_2;
        if (var3_3 != false && this.isPrefixed()) {
            IPv4AddressSection.normalizePrefixBoundary((int)this.getNetworkPrefixLength(), (IPAddressSegment[])this.getSegmentsInternal(), (int)8, (int)1, IPv4AddressSegment::toPrefixNormalizedSeg);
        }
        if (segments.length > 4) {
            void var1_1;
            throw new AddressValueException(((void)var1_1).length);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected IPv4AddressSection(byte[] bytes, int segmentCount, Integer networkPrefixLength, boolean cloneBytes, boolean singleOnly) throws AddressValueException {
        this(bytes, 0, ((void)var1_1).length, (int)var2_2, (Integer)var3_3, cloneBytes, singleOnly);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected IPv4AddressSection(byte[] bytes, int byteStartIndex, int byteEndIndex, int segmentCount, Integer networkPrefixLength, boolean cloneBytes, boolean singleOnly) throws AddressValueException {
        super(new IPv4AddressSegment[segmentCount >= 0 ? segmentCount : Math.max(0, byteEndIndex - byteStartIndex)], false, false);
        void var2_2;
        boolean byteLengthIsExact;
        AddressSegment[] segs = this.getSegmentsInternal();
        IPv4AddressNetwork network = this.getNetwork();
        IPv4AddressSection.toSegments((AddressSegment[])segs, (byte[])bytes, (int)byteStartIndex, (int)byteEndIndex, (int)this.getBytesPerSegment(), (int)this.getBitsPerSegment(), (AddressNetwork)network, (Integer)networkPrefixLength);
        boolean bl = byteLengthIsExact = bytes.length == segs.length;
        if (networkPrefixLength != null) {
            if (networkPrefixLength < 0) {
                throw new PrefixLenException(networkPrefixLength);
            }
            int max = segs.length << 3;
            if (networkPrefixLength > max) {
                if (networkPrefixLength > 32) {
                    throw new PrefixLenException(networkPrefixLength);
                }
                networkPrefixLength = max;
            }
            if (segs.length > 0) {
                void var3_4;
                AddressNetwork.PrefixConfiguration prefConf = ((AddressNetwork)network).getPrefixConfiguration();
                if (prefConf.zeroHostsAreSubnets()) {
                    if (IPv4AddressSection.isPrefixSubnetSegs((IPAddressSegment[])segs, networkPrefixLength, network, false) && !singleOnly) {
                        IPv4AddressSection.setPrefixedSegments((AddressNetwork)network, (int)networkPrefixLength, (AddressSegment[])segs, (int)this.getBitsPerSegment(), (int)this.getBytesPerSegment(), (AddressNetwork.AddressSegmentCreator)network.getAddressCreator(), IPv4AddressSegment::toNetworkSegment);
                    } else if (byteLengthIsExact && networkPrefixLength >= ((IPAddressSection)this).getBitCount()) {
                        this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
                    }
                } else if (byteLengthIsExact && (var3_4.prefixedSubnetsAreExplicit() || networkPrefixLength >= ((IPAddressSection)this).getBitCount())) {
                    this.setBytes(cloneBytes ? (byte[])bytes.clone() : bytes);
                }
            } else if (byteLengthIsExact) {
                this.setBytes(bytes);
            }
            this.cachedPrefixLength = networkPrefixLength;
            return;
        }
        this.cachedPrefixLength = NO_PREFIX_LENGTH;
        if (var2_2 != false) {
            void var1_1;
            this.setBytes((byte[])(cloneBytes ? (byte[])bytes.clone() : var1_1));
        }
    }

    /*
     * WARNING - void declaration
     */
    protected IPv4AddressSection(byte[] bytes, int byteStartIndex, int byteEndIndex, int segmentCount, Integer prefix) throws AddressValueException {
        this((byte[])var1_1, (int)var2_2, (int)var3_3, segmentCount, prefix, true, false);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    public IPv4AddressSegment[] getSegments() {
        return (IPv4AddressSegment[])this.getDivisionsInternal().clone();
    }

    public IPv4AddressSection getSection() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    void cache(IPv4Address thisAddr, IPv4Address lower, IPv4Address upper) {
        if ((lower != null || upper != null) && IPv4AddressSection.getSingleLowestOrHighestSection(this) == null) {
            this.getSection().cache(lower != null ? lower.getSection() : null, upper != null ? upper.getSection() : null);
            IPv4AddressCache cache = thisAddr.addressCache;
            if (cache == null || lower != null && cache.lower == null || upper != null && cache.upper == null) {
                IPv4AddressSection iPv4AddressSection = this;
                synchronized (iPv4AddressSection) {
                    cache = thisAddr.addressCache;
                    boolean bl = cache == null;
                    if (bl) {
                        var1_1.addressCache = cache = new IPv4AddressCache();
                        cache.lower = lower;
                        cache.upper = upper;
                    } else {
                        if (cache.lower == null) {
                            void var2_3;
                            cache.lower = var2_3;
                        }
                        if (cache.upper == null) {
                            void var3_4;
                            cache.upper = var3_4;
                        }
                    }
                    return;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    void cache(IPv4AddressSection lower, IPv4AddressSection upper) {
        AddressDivisionGrouping.SectionCache<IPv4AddressSection> cache = this.sectionCache;
        if ((lower != null || upper != null) && (cache == null || lower != null && cache.lower == null || upper != null && cache.upper == null)) {
            IPv4AddressSection iPv4AddressSection = this;
            synchronized (iPv4AddressSection) {
                cache = this.sectionCache;
                boolean bl = cache == null;
                if (bl) {
                    this.sectionCache = cache = new AddressDivisionGrouping.SectionCache();
                    cache.lower = lower;
                    cache.upper = upper;
                } else {
                    if (cache.lower == null) {
                        void var1_1;
                        cache.lower = var1_1;
                    }
                    if (cache.upper == null) {
                        void var2_3;
                        var3_4.upper = var2_3;
                    }
                }
                return;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private IPv4AddressSection getLowestOrHighestSection(boolean lowest, boolean excludeZeroHost) {
        void var3_4;
        void var2_3;
        IPv4AddressSection result = IPv4AddressSection.getSingleLowestOrHighestSection(this);
        if (result == null) {
            AddressDivisionGrouping.SectionCache<IPv4AddressSection> cache = this.sectionCache;
            if (cache == null || (lowest ? (excludeZeroHost ? (result = (IPv4AddressSection)cache.lowerNonZeroHost) == null && !cache.lowerNonZeroHostIsNull : (result = (IPv4AddressSection)cache.lower) == null) : (result = (IPv4AddressSection)cache.upper) == null)) {
                IPv4AddressSection iPv4AddressSection = this;
                synchronized (iPv4AddressSection) {
                    cache = this.sectionCache;
                    boolean create = cache == null;
                    if (create) {
                        this.sectionCache = cache = new AddressDivisionGrouping.SectionCache();
                    } else if (lowest) {
                        create = excludeZeroHost ? (result = (IPv4AddressSection)cache.lowerNonZeroHost) == null && !cache.lowerNonZeroHostIsNull : (result = (IPv4AddressSection)cache.lower) == null;
                    } else {
                        result = (IPv4AddressSection)cache.upper;
                        boolean bl = create = result == null;
                    }
                    if (create) {
                        void var1_1;
                        IPv4AddressSection iPv4AddressSection2 = this;
                        result = IPv4AddressSection.createLowestOrHighestSection(iPv4AddressSection2, iPv4AddressSection2.getAddressCreator(), this::segmentsNonZeroHostIterator, i -> {
                            void var2_2;
                            if (lowest) {
                                return this.getSegment(i).getLower();
                            }
                            return this.getSegment((int)var2_2).getUpper();
                        }, lowest, excludeZeroHost);
                        if (result == null) {
                            cache.lowerNonZeroHostIsNull = true;
                        } else if (var1_1 != false) {
                            if (excludeZeroHost) {
                                cache.lowerNonZeroHost = result;
                            } else {
                                cache.lower = result;
                            }
                        } else {
                            cache.upper = result;
                        }
                    }
                }
            }
        } else if (var2_3 != false && ((IPAddressDivisionGrouping)this).includesZeroHost()) {
            return null;
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    IPv4Address getLowestOrHighest(IPv4Address addr, boolean lowest, boolean excludeZeroHost) {
        IPv4Address result;
        block18: {
            IPv4AddressCache cache;
            IPv4AddressSection sectionResult;
            block17: {
                sectionResult = this.getLowestOrHighestSection(lowest, excludeZeroHost);
                if (sectionResult == this) {
                    return addr;
                }
                if (sectionResult == null) {
                    return null;
                }
                result = null;
                cache = addr.addressCache;
                if (cache == null) break block17;
                IPv4Address iPv4Address = lowest ? (excludeZeroHost ? (IPv4Address)cache.lowerNonZeroHost : (IPv4Address)cache.lower) : (result = (IPv4Address)cache.upper);
                if (iPv4Address != null) break block18;
            }
            IPv4AddressSection iPv4AddressSection = this;
            synchronized (iPv4AddressSection) {
                cache = addr.addressCache;
                boolean create = cache == null;
                if (create) {
                    void var1_1;
                    cache = var1_1.addressCache = new IPv4AddressCache();
                } else if (lowest) {
                    create = excludeZeroHost ? (result = (IPv4Address)cache.lowerNonZeroHost) == null : (result = (IPv4Address)cache.lower) == null;
                } else {
                    result = (IPv4Address)cache.upper;
                    boolean bl = create = result == null;
                }
                if (create) {
                    void var2_3;
                    result = this.getAddressCreator().createAddress(sectionResult);
                    if (var2_3 != false) {
                        void var3_4;
                        if (var3_4 != false) {
                            cache.lowerNonZeroHost = result;
                        } else {
                            cache.lower = result;
                        }
                    } else {
                        cache.upper = result;
                    }
                }
            }
        }
        return result;
    }

    public IPv4AddressSection getLower() {
        return this.getLowestOrHighestSection(true, false);
    }

    public IPv4AddressSection getUpper() {
        return this.getLowestOrHighestSection(false, false);
    }

    public int intValue() {
        return this.getIntValue(true);
    }

    public long longValue() {
        return (long)this.intValue() & 0xFFFFFFFFL;
    }

    /*
     * WARNING - void declaration
     */
    private int calcValue(boolean lower) {
        int n;
        int segCount = this.getSegmentCount();
        boolean result = false;
        if (segCount != 0) {
            void var3_4;
            IPv4AddressSegment first = this.getSegment(0);
            int n2 = n = lower ? first.getSegmentValue() : var3_4.getUpperSegmentValue();
            if (segCount != 1) {
                int bitsPerSegment = this.getBitsPerSegment();
                for (int i = 1; i < segCount; ++i) {
                    IPv4AddressSegment seg = this.getSegment(i);
                    n = n << bitsPerSegment | (lower ? seg.getSegmentValue() : seg.getUpperSegmentValue());
                }
            }
        }
        return n;
    }

    /*
     * WARNING - void declaration
     */
    private int getIntValue(boolean lower) {
        int n;
        if (lower || !this.isMultiple()) {
            int result22;
            Integer cachedInt = this.cachedLowerVal;
            if (cachedInt == null) {
                result22 = this.calcValue(true);
                this.cachedLowerVal = result22;
            } else {
                void result22;
                result22 = result22.intValue();
            }
        } else {
            Integer cachedInt2 = this.cachedUpperVal;
            if (cachedInt2 == null) {
                int cachedInt2 = this.calcValue(false);
                this.cachedUpperVal = cachedInt2;
            } else {
                void var1_4;
                n = var1_4.intValue();
            }
        }
        return n;
    }

    protected IPv4AddressSegment[] getSegmentsInternal() {
        return (IPv4AddressSegment[])super.getDivisionsInternal();
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<IPv4AddressSection> iterator(Predicate<IPv4AddressSegment[]> excludeFunc) {
        void var2_2;
        void var1_1;
        void var3_3;
        boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        boolean useOriginal = !this.isMultiple() && (!isAllSubnets || !this.isPrefixed());
        IPv4AddressSection original = !useOriginal || excludeFunc != null && excludeFunc.test(this.getSegmentsInternal()) ? null : this;
        return IPv4AddressSection.iterator(useOriginal, original, this.getAddressCreator(), var3_3 != false ? null : this.segmentsIterator((Predicate<IPv4AddressSegment[]>)var1_1), var2_2 != false ? null : ((AddressDivisionGroupingBase)this).getPrefixLength());
    }

    /*
     * WARNING - void declaration
     */
    AddressComponentSpliterator<IPv4AddressSection> spliterator(boolean excludeZeroHosts) {
        void var1_2;
        void var2_3;
        void var3_5;
        AddressDivisionGroupingBase.IteratorProvider iteratorProvider;
        ToLongFunction<IPv4AddressSection> longSizer;
        IPv4AddressSection forIteration;
        Integer iterationsPrefix;
        int segmentCount = this.getSegmentCount();
        Integer prefixLength = this.getNetworkPrefixLength();
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getAddressCreator();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (bl) {
            iterationsPrefix = null;
            forIteration = this.withoutPrefixLength();
        } else {
            iterationsPrefix = prefixLength;
            forIteration = this;
        }
        if (excludeZeroHosts && ((IPAddressDivisionGrouping)this).includesZeroHost()) {
            longSizer = section -> {
                int n;
                void var1_1;
                void var2_2;
                return IPv4AddressSection.longCount(section, segmentCount) - var2_2.longZeroHostCount(var1_1.intValue(), n);
            };
            iteratorProvider = (isLowest, isHighest, section) -> {
                void var1_1;
                return section.iterator(arg_0 -> this.lambda$spliterator$4((Integer)var1_1, arg_0));
            };
        } else {
            longSizer = section -> {
                int n;
                return IPv4AddressSection.longCount(section, n);
            };
            iteratorProvider = (isLowest, isHighest, section) -> section.iterator();
        }
        int networkSegIndex = segmentCount - 1;
        return IPv4AddressSection.createSeriesSpliterator(forIteration, arg_0 -> IPv4AddressSection.lambda$spliterator$9(creator, iterationsPrefix, (int)var3_5, (int)var2_3, arg_0), var1_2, null, null, longSizer);
    }

    /*
     * WARNING - void declaration
     */
    Iterator<IPv4Address> iterator(IPv4Address original, AddressCreator<IPv4Address, ?, ?, IPv4AddressSegment> creator, Predicate<IPv4AddressSegment[]> excludeFunc) {
        void var3_3;
        void var2_2;
        void var1_1;
        boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        boolean useOriginal = !this.isMultiple() && (!isAllSubnets || !this.isPrefixed());
        if (useOriginal && excludeFunc != null && excludeFunc.test(original.getSection().getSegmentsInternal())) {
            original = null;
        }
        return IPv4AddressSection.iterator(useOriginal, var1_1, creator, useOriginal ? null : IPv4AddressSection.segmentsIterator(this.getSegmentCount(), var2_2, this.isMultiple() ? null : () -> this.getLower().getSegmentsInternal(), index -> {
            void var1_1;
            void var2_2;
            return this.getSegment((int)var2_2).iterator(var1_1 == false);
        }, (Predicate<S[]>)var3_3), isAllSubnets ? null : ((AddressDivisionGroupingBase)this).getPrefixLength());
    }

    /*
     * WARNING - void declaration
     */
    AddressComponentSpliterator<IPv4Address> spliterator(IPv4Address original, IPv4AddressNetwork.IPv4AddressCreator creator, boolean excludeZeroHosts) {
        void var3_4;
        void var2_2;
        void var1_1;
        AddressDivisionGroupingBase.IteratorProvider iteratorProvider;
        ToLongFunction<IPv4Address> longSizer;
        Integer iterationsPrefix;
        int segmentCount = this.getSegmentCount();
        Integer prefixLength = this.getNetworkPrefixLength();
        boolean bl = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        if (bl) {
            iterationsPrefix = null;
            IPv4Address forIteration = original.withoutPrefixLength();
        } else {
            iterationsPrefix = prefixLength;
        }
        if (excludeZeroHosts && ((IPAddressDivisionGrouping)this).includesZeroHost()) {
            longSizer = addr -> {
                int n;
                void var1_1;
                void var2_2;
                return IPv4AddressSection.longCount(addr.getSection(), segmentCount) - var2_2.getSection().longZeroHostCount(var1_1.intValue(), n);
            };
            iteratorProvider = (isLowest, isHighest, addr) -> {
                void var1_1;
                IPv4Address iPv4Address = addr;
                return addr.getSection().iterator(iPv4Address, iPv4Address.getAddressCreator(), arg_0 -> this.lambda$spliterator$13((Integer)var1_1, arg_0));
            };
        } else {
            longSizer = addr -> {
                int n;
                return IPv4AddressSection.longCount(addr.getSection(), n);
            };
            iteratorProvider = (isLowest, isHighest, addr) -> addr.iterator();
        }
        int networkSegIndex = segmentCount - 1;
        int hostSegIndex = segmentCount;
        return IPv4AddressSection.createSeriesSpliterator(var1_1, arg_0 -> IPv4AddressSection.lambda$spliterator$18((IPv4AddressNetwork.IPv4AddressCreator)var2_2, iterationsPrefix, networkSegIndex, hostSegIndex, arg_0), var3_4, null, null, longSizer);
    }

    @Override
    public Iterator<IPv4AddressSection> iterator() {
        return this.iterator(null);
    }

    @Override
    public AddressComponentSpliterator<IPv4AddressSection> spliterator() {
        return this.spliterator(false);
    }

    /*
     * WARNING - void declaration
     */
    private Iterator<IPv4AddressSegment[]> segmentsIterator(Predicate<IPv4AddressSegment[]> excludeFunc) {
        void var1_1;
        void var2_2;
        boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
        return IPv4AddressSection.segmentsIterator(this.getSegmentCount(), this.getSegmentCreator(), this.isMultiple() ? null : () -> this.getLower().getSegments(), arg_0 -> this.lambda$segmentsIterator$35((boolean)var2_2, arg_0), (Predicate<S[]>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Predicate<IPv4AddressSegment[]> excludeNonZeroHosts() {
        if (this.isPrefixed()) {
            void var1_1;
            int prefLength = this.getNetworkPrefixLength();
            return arg_0 -> this.lambda$excludeNonZeroHosts$36((int)var1_1, arg_0);
        }
        return null;
    }

    public Iterator<IPv4AddressSegment[]> segmentsNonZeroHostIterator() {
        IPv4AddressSection iPv4AddressSection = this;
        return iPv4AddressSection.segmentsIterator(iPv4AddressSection.excludeNonZeroHosts());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isZeroHost(IPv4AddressSegment[] segments, int prefixLength) {
        void var2_2;
        void var1_1;
        return super.isZeroHost((IPAddressSegment[])var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BigInteger getCountImpl(int segCount) {
        void var1_1;
        if (!this.isMultiple()) {
            return BigInteger.ONE;
        }
        return BigInteger.valueOf(IPv4AddressSection.longCount(this, (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected BigInteger getZeroHostCountImpl(int prefixLength, int segCount) {
        if (this.includesZeroHost(prefixLength)) {
            if (this.isMultiple()) {
                void var2_2;
                void var1_1;
                return BigInteger.valueOf(this.longZeroHostCount((int)var1_1, (int)var2_2));
            }
            return BigInteger.ONE;
        }
        return BigInteger.ZERO;
    }

    private IPv4AddressNetwork.IPv4AddressCreator getSegmentCreator() {
        return this.getIPv4SegmentCreator();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return this.getIPv4SegmentCreator();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getIPv4SegmentCreator() {
        return this.getNetwork().getAddressCreator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4AddressSegment getDivision(int index) {
        void var1_1;
        return (IPv4AddressSegment)super.getDivision((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4AddressSegment getSegment(int index) {
        void var1_1;
        return (IPv4AddressSegment)super.getSegment((int)var1_1);
    }

    @Override
    public int getBitsPerSegment() {
        return 8;
    }

    @Override
    public int getBytesPerSegment() {
        return 1;
    }

    @Override
    public int getBitCount() {
        return this.getSegmentCount() << 3;
    }

    @Override
    public int getByteCount() {
        return this.getSegmentCount();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] getBytesImpl(boolean low) {
        void var3_3;
        int segmentCount = this.getSegmentCount();
        byte[] bytes = new byte[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            IPv4AddressSegment seg = this.getSegment(i);
            int val = low ? seg.getSegmentValue() : seg.getUpperSegmentValue();
            bytes[i] = (byte)val;
        }
        return var3_3;
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean isSameGrouping(AddressDivisionGroupingBase other) {
        void var1_1;
        return other instanceof IPv4AddressSection && super.isSameGrouping((AddressDivisionGroupingBase)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        void var1_1;
        return o == this || o instanceof IPv4AddressSection && ((IPv4AddressSection)var1_1).isSameGrouping(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(AddressSection other) {
        void var1_1;
        return other instanceof IPv4AddressSection && super.contains((AddressSection)var1_1);
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return Address.defaultIpv4Network();
    }

    public IPv4AddressSection withoutPrefixLength() {
        return this.removePrefixLength(false);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv4AddressSection removePrefixLength(boolean zeroed) {
        void var1_1;
        return IPv4AddressSection.removePrefixLength(this, (boolean)var1_1, this.getAddressCreator(), IPv4AddressSection::getSegment);
    }

    /*
     * WARNING - void declaration
     */
    IPv4AddressSection createZeroHost(boolean boundariesOnly) {
        void var1_1;
        void var2_2;
        void var3_3;
        int prefixLength = this.getNetworkPrefixLength();
        IPv4AddressNetwork network = this.getNetwork();
        IPv4Address mask = (IPv4Address)network.getNetworkMask(prefixLength);
        return IPv4AddressSection.getSubnetSegments(this, var3_3.getPrefixConfiguration().allPrefixedAddressesAreSubnets() ? null : IPv4AddressSection.cacheBits((int)var2_2), this.getAddressCreator(), var1_1 == false, this::getSegment, i -> {
            void var1_1;
            return mask.getSegment((int)var1_1).getSegmentValue();
        }, true);
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSection mask(IPv4AddressSection mask, boolean retainPrefix) throws IncompatibleAddressException, SizeMismatchException {
        void var1_1;
        void var2_2;
        this.checkMaskSegmentCount(mask);
        return IPv4AddressSection.getSubnetSegments(this, var2_2 != false ? ((AddressDivisionGroupingBase)this).getPrefixLength() : null, this.getAddressCreator(), true, this::getSegment, arg_0 -> IPv4AddressSection.lambda$mask$71((IPv4AddressSection)var1_1, arg_0), false);
    }

    protected static Integer cacheBits(int i) {
        return IPAddressSection.cacheBits(i);
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSection toPrefixBlock() {
        void var1_1;
        Integer prefixLength = this.getNetworkPrefixLength();
        if (prefixLength == null || ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
            return this;
        }
        return this.toPrefixBlock(var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    public IPv4AddressSection toPrefixBlock(int networkPrefixLength) throws PrefixLenException {
        void var1_1;
        return IPv4AddressSection.toPrefixBlock(this, (int)var1_1, this.getAddressCreator(), (prefix, i) -> {
            void var1_1;
            void var2_2;
            return this.getSegment((int)var2_2).toNetworkSegment((Integer)var1_1, true);
        });
    }

    @Override
    protected boolean hasNoStringCache() {
        if (this.stringCache == null) {
            IPv4AddressSection iPv4AddressSection = this;
            synchronized (iPv4AddressSection) {
                if (this.stringCache == null) {
                    this.stringCache = new IPv4StringCache();
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toCanonicalString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.canonicalString) == null) {
            this.stringCache.canonicalString = result = this.toNormalizedString(IPv4StringCache.canonicalParams);
        }
        return var1_1;
    }

    @Override
    public String toNormalizedString() {
        return this.toCanonicalString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toNormalizedWildcardString() {
        void var1_1;
        String result;
        if (this.hasNoStringCache() || (result = this.stringCache.normalizedWildcardString) == null) {
            this.stringCache.normalizedWildcardString = result = this.toNormalizedString(IPv4StringCache.normalizedWildcardParams);
        }
        return var1_1;
    }

    @Override
    public String toCanonicalWildcardString() {
        return this.toNormalizedWildcardString();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$mask$71(IPv4AddressSection mask, int i) {
        void var1_1;
        return mask.getSegment((int)var1_1).getSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$excludeNonZeroHosts$36(int prefLength, IPv4AddressSegment[] segments) {
        void var1_1;
        void var2_2;
        return this.isZeroHost((IPv4AddressSegment[])var2_2, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ Iterator lambda$segmentsIterator$35(boolean isAllSubnets, int index) {
        void var1_1;
        void var2_2;
        return this.getSegment((int)var2_2).iterator(var1_1 == false);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$18(IPv4AddressNetwork.IPv4AddressCreator creator, Integer iterationsPrefix, int networkSegIndex, int hostSegIndex, AddressDivisionGroupingBase.SplitterSink spliterator) {
        void var1_1;
        void var3_3;
        void var2_2;
        IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator;
        return IPv4AddressSection.split((AddressDivisionGroupingBase.SplitterSink)spliterator, (T segs) -> {
            void var1_1;
            IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator;
            return (IPv4Address)IPv4AddressSection.createIteratedAddress((AddressSegment[])segs, (AddressCreator)iPv4AddressCreator, (Integer)var1_1);
        }, (AddressNetwork.AddressSegmentCreator)iPv4AddressCreator, (AddressSegment[])((IPv4Address)spliterator.getAddressItem()).getSection().getSegmentsInternal(), (int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$spliterator$13(Integer prefixLength, IPv4AddressSegment[] s) {
        void var1_1;
        void var2_2;
        return this.isZeroHost((IPv4AddressSegment[])var2_2, var1_1.intValue());
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ boolean lambda$spliterator$9(IPv4AddressNetwork.IPv4AddressCreator creator, Integer iterationsPrefix, int networkSegIndex, int hostSegIndex, AddressDivisionGroupingBase.SplitterSink spliterator) {
        void var1_1;
        void var3_3;
        void var2_2;
        IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator;
        return IPv4AddressSection.split((AddressDivisionGroupingBase.SplitterSink)spliterator, (T segs) -> {
            void var1_1;
            IPv4AddressNetwork.IPv4AddressCreator iPv4AddressCreator;
            return (IPv4AddressSection)IPv4AddressSection.createIteratedSection((AddressSegment[])segs, (AddressCreator)iPv4AddressCreator, (Integer)var1_1);
        }, (AddressNetwork.AddressSegmentCreator)iPv4AddressCreator, (AddressSegment[])((IPv4AddressSection)spliterator.getAddressItem()).getSegmentsInternal(), (int)var2_2, (int)var3_3, (Integer)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private /* synthetic */ boolean lambda$spliterator$4(Integer prefixLength, IPv4AddressSegment[] segs) {
        void var1_1;
        void var2_2;
        return this.isZeroHost((IPv4AddressSegment[])var2_2, var1_1.intValue());
    }

    public static class IPv4StringOptions
    extends IPAddressSection.IPStringOptions {
        /*
         * WARNING - void declaration
         */
        protected IPv4StringOptions(int base, boolean expandSegments, IPAddressSection.WildcardOptions.WildcardOption wildcardOption, AddressDivisionGrouping.StringOptions.Wildcards wildcards, String segmentStrPrefix, Character separator, String label, String suffix, boolean reverse, boolean splitDigits, boolean uppercase) {
            super((int)var1_1, (boolean)var2_2, (IPAddressSection.WildcardOptions.WildcardOption)var3_3, wildcards, segmentStrPrefix, separator, ' ', label, suffix, reverse, splitDigits, uppercase);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public static class Builder
        extends IPAddressSection.IPStringOptions.Builder {
            public Builder() {
                this(10, '.');
            }

            /*
             * WARNING - void declaration
             */
            protected Builder(int base, char separator) {
                super((int)var1_1, (char)var2_2);
                void var2_2;
                void var1_1;
            }

            @Override
            public IPv4StringOptions toOptions() {
                return new IPv4StringOptions(this.base, this.expandSegments, this.wildcardOption, this.wildcards, this.segmentStrPrefix, this.separator, this.addrLabel, this.addrSuffix, this.reverse, this.splitDigits, this.uppercase);
            }
        }
    }

    static class EmbeddedIPv4AddressSection
    extends IPv4AddressSection {
        private final IPAddressSection encompassingSection;

        /*
         * WARNING - void declaration
         */
        EmbeddedIPv4AddressSection(IPAddressSection encompassingSection, IPv4AddressSegment[] subSegments) {
            super((IPv4AddressSegment[])var2_2, false);
            void var1_1;
            void var2_2;
            this.encompassingSection = var1_1;
        }

        @Override
        public boolean isPrefixBlock() {
            return ((AddressDivisionGroupingBase)this.encompassingSection).isPrefixBlock();
        }
    }

    static class IPv4AddressCache
    extends AddressDivisionGrouping.SectionCache<IPv4Address> {
        IPv4AddressCache() {
        }
    }

    static class IPv4StringCache
    extends IPAddressSection.IPStringCache {
        static final IPAddressSection.IPStringOptions fullParams;
        static final IPAddressSection.IPStringOptions normalizedWildcardParams;
        static final IPAddressSection.IPStringOptions sqlWildcardParams;
        static final IPAddressSection.IPStringOptions inetAtonOctalParams;
        static final IPAddressSection.IPStringOptions inetAtonHexParams;
        static final IPAddressSection.IPStringOptions canonicalParams;
        static final IPAddressSection.IPStringOptions reverseDNSParams;
        static final IPAddressSection.IPStringOptions segmentedBinaryParams;

        IPv4StringCache() {
        }

        /*
         * WARNING - void declaration
         */
        static {
            void var0;
            void var1_1;
            void var2_2;
            IPAddressSection.WildcardOptions allWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL);
            IPAddressSection.WildcardOptions allSQLWildcards = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.ALL, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.SEGMENT_SQL_WILDCARD_STR, IPAddress.SEGMENT_SQL_SINGLE_WILDCARD_STR));
            IPAddressSection.WildcardOptions wildcardsRangeOnlyNetworkOnly = new IPAddressSection.WildcardOptions(IPAddressSection.WildcardOptions.WildcardOption.NETWORK_ONLY, new AddressDivisionGrouping.StringOptions.Wildcards(IPAddress.RANGE_SEPARATOR_STR));
            fullParams = new IPv4StringOptions.Builder().setExpandedSegments(true).setWildcardOptions((IPAddressSection.WildcardOptions)var2_2).toOptions();
            normalizedWildcardParams = new IPv4StringOptions.Builder().setWildcardOptions(allWildcards).toOptions();
            sqlWildcardParams = new IPv4StringOptions.Builder().setWildcardOptions((IPAddressSection.WildcardOptions)var1_1).toOptions();
            inetAtonOctalParams = new IPv4StringOptions.Builder().setRadix(IPv4Address.inet_aton_radix.OCTAL.getRadix()).setSegmentStrPrefix(IPv4Address.inet_aton_radix.OCTAL.getSegmentStrPrefix()).toOptions();
            inetAtonHexParams = new IPv4StringOptions.Builder().setRadix(IPv4Address.inet_aton_radix.HEX.getRadix()).setSegmentStrPrefix(IPv4Address.inet_aton_radix.HEX.getSegmentStrPrefix()).toOptions();
            canonicalParams = new IPv4StringOptions.Builder().toOptions();
            reverseDNSParams = new IPv4StringOptions.Builder().setWildcardOptions((IPAddressSection.WildcardOptions)var0).setReverse(true).setAddressSuffix(".in-addr.arpa").toOptions();
            segmentedBinaryParams = new IPAddressSection.IPStringOptions.Builder(2).setSeparator(Character.valueOf('.')).setSegmentStrPrefix("0b").toOptions();
        }
    }
}

