/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import java.io.Serializable;
import java.net.Inet4Address;
import java.util.function.BiFunction;
import java.util.function.Function;

public class IPv4AddressNetwork
extends IPAddressNetwork<IPv4Address, IPv4AddressSection, IPv4AddressSection, IPv4AddressSegment, Inet4Address> {
    private static AddressNetwork.PrefixConfiguration defaultPrefixConfiguration = AddressNetwork.getDefaultPrefixConfiguration();
    private static boolean CACHE_SEGMENTS_BY_PREFIX = true;
    private static final IPv4AddressSegment[] EMPTY_SEGMENTS = new IPv4AddressSegment[0];
    private static final IPv4AddressSection[] EMPTY_SECTION = new IPv4AddressSection[0];
    private static final IPv4Address[] EMPTY_ADDRESS = new IPv4Address[0];

    public IPv4AddressNetwork() {
        super(IPv4Address.class);
    }

    @Override
    public AddressNetwork.PrefixConfiguration getPrefixConfiguration() {
        return defaultPrefixConfiguration;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isCompatible(IPv4AddressNetwork other) {
        void var1_1;
        return super.isCompatible((AddressNetwork<?>)var1_1);
    }

    @Override
    protected BiFunction<IPv4Address, Integer, IPv4AddressSegment> getSegmentProducer() {
        return (address, index) -> {
            void var1_1;
            return address.getSegment(var1_1.intValue());
        };
    }

    @Override
    protected Function<IPv4Address, IPv4AddressSection> getSectionProducer() {
        return IPv4Address::getSection;
    }

    protected IPv4AddressCreator createAddressCreator() {
        return new IPv4AddressCreator(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IPv4Address createLoopback() {
        void var3_3;
        void var1_1;
        void var2_2;
        IPv4AddressCreator creator = this.getAddressCreator();
        IPv4AddressSegment zero = creator.createSegment(0);
        IPv4AddressSegment[] iPv4AddressSegmentArray = creator.createSegmentArray(4);
        IPv4AddressSegment[] segs = iPv4AddressSegmentArray;
        iPv4AddressSegmentArray[0] = creator.createSegment(127);
        segs[1] = segs[2] = var2_2;
        segs[3] = creator.createSegment(1);
        return var1_1.createAddressInternal((IPv4AddressSegment[])var3_3);
    }

    @Override
    public IPv4AddressCreator getAddressCreator() {
        return (IPv4AddressCreator)super.getAddressCreator();
    }

    @Override
    public IPAddress.IPVersion getIPVersion() {
        return IPAddress.IPVersion.IPV4;
    }

    public static class IPv4AddressCreator
    extends IPAddressNetwork.IPAddressCreator<IPv4Address, IPv4AddressSection, IPv4AddressSection, IPv4AddressSegment, Inet4Address> {
        Cache cache = new Cache();
        boolean useSegmentCache = true;

        /*
         * WARNING - void declaration
         */
        public IPv4AddressCreator(IPv4AddressNetwork network) {
            super(var1_1);
            void var1_1;
        }

        public IPv4AddressNetwork getNetwork() {
            return (IPv4AddressNetwork)super.getNetwork();
        }

        @Override
        public int getMaxValuePerSegment() {
            return 255;
        }

        @Override
        protected int getAddressSegmentCount() {
            return 4;
        }

        /*
         * WARNING - void declaration
         */
        public IPv4AddressSegment[] createSegmentArray(int length) {
            void var1_1;
            if (length == 0) {
                return EMPTY_SEGMENTS;
            }
            return new IPv4AddressSegment[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv4AddressSegment createSegment(int value) {
            void var1_1;
            if (this.useSegmentCache && value >= 0 && value <= 255) {
                void var2_3;
                IPv4AddressSegment result;
                IPv4AddressSegment[] cache = this.cache.segmentCache;
                if (cache == null) {
                    cache = new IPv4AddressSegment[256];
                    Cache.access$102(this.cache, cache);
                    cache[value] = result = new IPv4AddressSegment(value);
                } else {
                    result = cache[value];
                    if (result == null) {
                        var3_2[value] = result = new IPv4AddressSegment(value);
                    }
                }
                return var2_3;
            }
            return new IPv4AddressSegment((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv4AddressSegment createSegment(int value, Integer segmentPrefixLength) {
            void var2_2;
            void var1_1;
            if (segmentPrefixLength == null) {
                return this.createSegment(value);
            }
            if (this.useSegmentCache && value >= 0 && value <= 255 && segmentPrefixLength >= 0 && segmentPrefixLength <= 32) {
                if (segmentPrefixLength == 0 && ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                    IPv4AddressSegment result = this.cache.ZERO_PREFIX_SEGMENT;
                    if (result == null) {
                        result = new IPv4AddressSegment(0, 0);
                        Cache.access$202(this.cache, result);
                    }
                    return result;
                }
                if (CACHE_SEGMENTS_BY_PREFIX) {
                    IPv4AddressSegment result;
                    int mask = this.getNetwork().getSegmentNetworkMask(segmentPrefixLength);
                    int prefixIndex = segmentPrefixLength;
                    boolean isAllSubnets = ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets();
                    int valueIndex = isAllSubnets ? (value &= mask) >>> 8 - segmentPrefixLength : value;
                    IPv4AddressSegment[][] cache = this.cache.segmentPrefixCache;
                    if (cache == null) {
                        cache = new IPv4AddressSegment[9][];
                        Cache.access$402(this.cache, cache);
                        IPv4AddressSegment[] block = new IPv4AddressSegment[isAllSubnets ? 1 << prefixIndex : 256];
                        cache[prefixIndex] = block;
                        block[valueIndex] = result = new IPv4AddressSegment(value, segmentPrefixLength);
                    } else {
                        void result2;
                        IPv4AddressSegment[] block = cache[result2];
                        if (block == null) {
                            block = new IPv4AddressSegment[isAllSubnets ? 1 << result2 : 256];
                            cache[result2] = block;
                            block[valueIndex] = result = new IPv4AddressSegment(value, segmentPrefixLength);
                        } else {
                            result = block[valueIndex];
                            if (result == null) {
                                block[var3_4] = result = new IPv4AddressSegment(value, segmentPrefixLength);
                            }
                        }
                    }
                    return result;
                }
            }
            IPv4AddressSegment iPv4AddressSegment = new IPv4AddressSegment((int)var1_1, (Integer)var2_2);
            return iPv4AddressSegment;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv4AddressSegment createSegment(int lower, int upper, Integer segmentPrefixLength) {
            void var3_8;
            void var2_5;
            void var1_1;
            if (segmentPrefixLength == null) {
                if (lower == upper) {
                    return this.createSegment(lower);
                }
                if (this.useSegmentCache && lower == 0 && upper == 255) {
                    IPv4AddressSegment result = this.cache.ALL_RANGE_SEGMENT;
                    if (result == null) {
                        result = new IPv4AddressSegment(0, 255, null);
                        Cache.access$502(this.cache, result);
                    }
                    return result;
                }
            } else {
                int result;
                if (result == upper) {
                    return this.createSegment(result, segmentPrefixLength);
                }
                if (this.useSegmentCache && result >= 0 && result <= 255 && upper >= 0 && upper <= 255 && segmentPrefixLength >= 0 && segmentPrefixLength <= 32) {
                    if (segmentPrefixLength == 0 && ((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                        return this.createSegment(0, IPv4AddressNetwork.cacheBits(0));
                    }
                    if (CACHE_SEGMENTS_BY_PREFIX) {
                        void result22;
                        int prefixIndex;
                        if (segmentPrefixLength > 8) {
                            segmentPrefixLength = 8;
                        }
                        if (((AddressNetwork)this.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                            int mask = this.getNetwork().getSegmentNetworkMask(segmentPrefixLength);
                            if ((upper & mask) == (result &= mask)) {
                                return this.createSegment(result, segmentPrefixLength);
                            }
                            if (result == 0 && upper >= mask) {
                                IPv4AddressSegment result22;
                                prefixIndex = segmentPrefixLength;
                                IPv4AddressSegment[] cache = this.cache.allPrefixedCache;
                                if (cache == null) {
                                    cache = new IPv4AddressSegment[9];
                                    Cache.access$702(this.cache, cache);
                                    cache[prefixIndex] = result22 = new IPv4AddressSegment(0, 255, segmentPrefixLength);
                                } else {
                                    result22 = cache[prefixIndex];
                                    if (result22 == null) {
                                        cache[prefixIndex] = result22 = new IPv4AddressSegment(0, 255, segmentPrefixLength);
                                    }
                                }
                                return result22;
                            }
                        } else if (prefixIndex == 0 && result22 == 255) {
                            void var1_3;
                            int prefixIndex2 = segmentPrefixLength;
                            IPv4AddressSegment[] cache = this.cache.allPrefixedCache;
                            if (cache == null) {
                                cache = new IPv4AddressSegment[9];
                                Cache.access$702(this.cache, cache);
                                cache[prefixIndex2] = result3 = new IPv4AddressSegment(0, 255, segmentPrefixLength);
                            } else {
                                IPv4AddressSegment result3 = cache[prefixIndex2];
                                if (result3 == null) {
                                    var2_7[prefixIndex2] = result3 = new IPv4AddressSegment(0, 255, segmentPrefixLength);
                                }
                            }
                            return var1_3;
                        }
                    }
                }
            }
            IPv4AddressSegment iPv4AddressSegment = new IPv4AddressSegment((int)var1_1, (int)var2_5, (Integer)var3_8);
            return iPv4AddressSegment;
        }

        /*
         * WARNING - void declaration
         */
        protected IPv4AddressSection createSectionInternal(IPv4AddressSegment[] segments) {
            void var1_1;
            return new IPv4AddressSection((IPv4AddressSegment[])var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv4AddressSection createPrefixedSectionInternal(IPv4AddressSegment[] segments, Integer prefix, boolean singleOnly) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv4AddressSection((IPv4AddressSegment[])var1_1, false, (Integer)var2_2, (boolean)var3_3);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPv4AddressSection createSectionInternal(byte[] bytes, int segmentCount, Integer prefix, boolean singleOnly) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv4AddressSection((byte[])var1_1, (int)var2_2, (Integer)var3_3, false, singleOnly);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv4AddressSection createSection(byte[] bytes, int byteStartIndex, int byteEndIndex, int segmentCount, Integer prefix) {
            void var3_3;
            void var2_2;
            void var1_1;
            return new IPv4AddressSection((byte[])var1_1, (int)var2_2, (int)var3_3, segmentCount, prefix);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv4AddressSection createEmbeddedSectionInternal(IPAddressSection encompassingSection, IPv4AddressSegment[] segments) {
            void var2_2;
            void var1_1;
            return new IPv4AddressSection.EmbeddedIPv4AddressSection((IPAddressSection)var1_1, (IPv4AddressSegment[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected IPv4Address createAddressInternal(IPv4AddressSegment[] segments) {
            void var1_1;
            return (IPv4Address)super.createAddressInternal((IPAddressSegment[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPv4Address createAddressInternal(IPv4AddressSection section, CharSequence zone, HostIdentifierString from, IPv4Address lower, IPv4Address upper) {
            void var1_1;
            void var3_3;
            IPv4Address result = (IPv4Address)this.createAddressInternal(section, (HostIdentifierString)var3_3);
            result.cache(lower, upper);
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected IPv4Address createAddressInternal(IPv4AddressSection section, CharSequence zone) {
            void var1_1;
            return this.createAddress((IPv4AddressSection)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public IPv4Address createAddress(IPv4AddressSection section) {
            void var1_1;
            return new IPv4Address((IPv4AddressSection)var1_1);
        }

        protected static class Cache
        implements Serializable {
            private transient IPv4AddressSegment ZERO_PREFIX_SEGMENT;
            private transient IPv4AddressSegment ALL_RANGE_SEGMENT;
            private transient IPv4AddressSegment[] segmentCache;
            private transient IPv4AddressSegment[][] segmentPrefixCache;
            private transient IPv4AddressSegment[] allPrefixedCache;

            protected Cache() {
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv4AddressSegment[] access$102(Cache x0, IPv4AddressSegment[] x1) {
                void var1_1;
                x0.segmentCache = var1_1;
                return x0.segmentCache;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv4AddressSegment access$202(Cache x0, IPv4AddressSegment x1) {
                void var1_1;
                x0.ZERO_PREFIX_SEGMENT = var1_1;
                return x0.ZERO_PREFIX_SEGMENT;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv4AddressSegment[][] access$402(Cache x0, IPv4AddressSegment[][] x1) {
                void var1_1;
                x0.segmentPrefixCache = var1_1;
                return x0.segmentPrefixCache;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv4AddressSegment access$502(Cache x0, IPv4AddressSegment x1) {
                void var1_1;
                x0.ALL_RANGE_SEGMENT = var1_1;
                return x0.ALL_RANGE_SEGMENT;
            }

            /*
             * WARNING - void declaration
             */
            static /* synthetic */ IPv4AddressSegment[] access$702(Cache x0, IPv4AddressSegment[] x1) {
                void var1_1;
                x0.allPrefixedCache = var1_1;
                return x0.allPrefixedCache;
            }
        }
    }
}

