/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.ipv4;

import inet.ipaddr.Address;
import inet.ipaddr.AddressConversionException;
import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSection;
import inet.ipaddr.AddressValueException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressConverter;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.util.AddressComponentSpliterator;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv4.IPv4AddressSeqRange;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.util.Iterator;

public class IPv4Address
extends IPAddress
implements Iterable<IPv4Address> {
    transient IPv4AddressSection.IPv4AddressCache addressCache;

    /*
     * WARNING - void declaration
     */
    public IPv4Address(IPv4AddressSection section) throws AddressValueException {
        super(section);
        if (section.getSegmentCount() != 4) {
            void var1_1;
            throw new AddressValueException("ipaddress.error.ipv4.invalid.segment.count", var1_1.getSegmentCount());
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPv4Address(byte[] bytes) throws AddressValueException {
        this((byte[])var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv4Address(byte[] bytes, Integer networkPrefixLength) throws AddressValueException {
        this(bytes, 0, ((void)var1_1).length, (Integer)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IPv4Address(byte[] bytes, int byteStartIndex, int byteEndIndex, Integer networkPrefixLength) throws AddressValueException {
        super(arg_0 -> IPv4Address.lambda$new$3((byte[])var1_1, (int)var2_2, (int)var3_3, networkPrefixLength, arg_0));
        void var3_3;
        void var2_2;
        void var1_1;
    }

    @Override
    public IPv4AddressSection getSection() {
        return (IPv4AddressSection)super.getSection();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4AddressSegment getDivision(int index) {
        void var1_1;
        return this.getSegment((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4AddressSegment getSegment(int index) {
        void var1_1;
        return this.getSection().getSegment((int)var1_1);
    }

    @Override
    public int getSegmentCount() {
        return 4;
    }

    @Override
    public int getByteCount() {
        return 4;
    }

    @Override
    public int getBitCount() {
        return 32;
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public IPv4Address toIPv4() {
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public IPv6Address getIPv6Address(IPv6AddressSegment[] segs) {
        void var1_1;
        void var2_2;
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getIPv6Network().getAddressCreator();
        return creator.createAddress(IPv6AddressSection.createSection((IPv6AddressNetwork.IPv6AddressCreator)var2_2, (IPv6AddressSegment[])var1_1, this));
    }

    /*
     * WARNING - void declaration
     */
    public IPv6Address getIPv4MappedAddress() {
        void var3_3;
        void var1_1;
        void var2_2;
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getIPv6Network().getAddressCreator();
        IPv6AddressSegment zero = creator.createSegment(0);
        IPv6AddressSegment[] iPv6AddressSegmentArray = creator.createSegmentArray(6);
        IPv6AddressSegment[] segs = iPv6AddressSegmentArray;
        segs[3] = segs[4] = var2_2;
        segs[2] = segs[4];
        segs[1] = segs[4];
        iPv6AddressSegmentArray[0] = segs[4];
        segs[5] = var1_1.createSegment(65535);
        return this.getIPv6Address((IPv6AddressSegment[])var3_3);
    }

    @Override
    public IPv6Address toIPv6() {
        IPAddressConverter iPAddressConverter = DEFAULT_ADDRESS_CONVERTER;
        return iPAddressConverter.toIPv6(this);
    }

    /*
     * WARNING - void declaration
     */
    void cache(IPv4Address lower, IPv4Address upper) {
        void var2_2;
        void var1_1;
        this.getSection().cache(this, (IPv4Address)var1_1, (IPv4Address)var2_2);
    }

    @Override
    public IPv4Address getLower() {
        return this.getSection().getLowestOrHighest(this, true, false);
    }

    public IPv4Address getUpper() {
        return this.getSection().getLowestOrHighest(this, false, false);
    }

    public int intValue() {
        return this.getSection().intValue();
    }

    public long longValue() {
        return this.getSection().longValue();
    }

    /*
     * WARNING - void declaration
     */
    private IPv4Address checkIdentity(IPv4AddressSection newSection) {
        void var1_1;
        void var2_2;
        IPv4AddressSection section = this.getSection();
        if (newSection == var2_2) {
            return this;
        }
        return this.getAddressCreator().createAddress((IPv4AddressSection)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv4Address removePrefixLength(boolean zeroed) {
        void var1_1;
        IPv4Address iPv4Address = this;
        return iPv4Address.checkIdentity(iPv4Address.getSection().removePrefixLength((boolean)var1_1));
    }

    @Override
    public IPv4Address withoutPrefixLength() {
        return this.removePrefixLength(false);
    }

    @Override
    public Iterator<IPv4Address> iterator() {
        IPv4Address iPv4Address = this;
        return this.getSection().iterator(iPv4Address, iPv4Address.getAddressCreator(), null);
    }

    @Override
    public AddressComponentSpliterator<IPv4Address> spliterator() {
        IPv4Address iPv4Address = this;
        return this.getSection().spliterator(iPv4Address, iPv4Address.getAddressCreator(), false);
    }

    IPv4AddressNetwork.IPv4AddressCreator getAddressCreator() {
        return this.getNetwork().getAddressCreator();
    }

    @Override
    public IPv4AddressNetwork getNetwork() {
        return IPv4Address.defaultIpv4Network();
    }

    public IPv6AddressNetwork getIPv6Network() {
        return IPv4Address.defaultIpv6Network();
    }

    /*
     * WARNING - void declaration
     */
    protected IPv4Address convertArg(IPAddress arg) throws AddressConversionException {
        void var2_2;
        IPv4Address converted = arg.toIPv4();
        if (converted == null) {
            void var1_1;
            throw new AddressConversionException(this, (AddressItem)var1_1);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected IPv4Address toZeroHost(boolean boundariesOnly) {
        void var1_1;
        if (!this.isPrefixed()) {
            void var1_2;
            void var2_3;
            IPv4AddressNetwork network;
            AddressNetwork.PrefixConfiguration config = ((AddressNetwork)(network = this.getNetwork())).getPrefixConfiguration();
            IPv4Address addr = (IPv4Address)network.getNetworkMask(0, !config.allPrefixedAddressesAreSubnets());
            if (var2_3.zeroHostsAreSubnets()) {
                addr = addr.getLower();
            }
            return var1_2;
        }
        if (this.includesZeroHost() && this.isSingleNetwork()) {
            return this.getLower();
        }
        IPv4Address iPv4Address = this;
        return iPv4Address.checkIdentity(iPv4Address.getSection().createZeroHost((boolean)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public IPv4Address mask(IPAddress mask, boolean retainPrefix) throws IncompatibleAddressException, AddressConversionException {
        void var2_2;
        void var1_1;
        IPv4Address iPv4Address = this;
        return iPv4Address.checkIdentity(iPv4Address.getSection().mask(this.convertArg((IPAddress)var1_1).getSection(), (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4Address mask(IPAddress mask) throws IncompatibleAddressException, AddressConversionException {
        void var1_1;
        return this.mask((IPAddress)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4AddressSeqRange spanWithRange(IPAddress other) throws AddressConversionException {
        void var1_1;
        return this.toSequentialRange((IPAddress)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public IPv4AddressSeqRange toSequentialRange(IPAddress other) {
        void var1_1;
        IPv4Address iPv4Address = this;
        return new IPv4AddressSeqRange(iPv4Address, iPv4Address.convertArg((IPAddress)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPv4AddressSeqRange toSequentialRange() {
        void var1_1;
        IPv4Address thiz = this.withoutPrefixLength();
        return new IPv4AddressSeqRange(thiz.getLower(), var1_1.getUpper(), true);
    }

    @Override
    protected IPAddressStringParameters createFromStringParams() {
        return ((IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase)((IPAddressStringParameters.IPAddressStringFormatParameters.BuilderBase)new IPAddressStringParameters.Builder().getIPv4AddressParametersBuilder().setNetwork(this.getNetwork())).getParentBuilder().getIPv6AddressParametersBuilder().setNetwork(this.getIPv6Network())).getParentBuilder().toParams();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ AddressSection lambda$new$3(byte[] bytes, int byteStartIndex, int byteEndIndex, Integer networkPrefixLength, Address thisAddress) {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        return ((IPv4Address)thisAddress).getAddressCreator().createSection(byArray, (int)var1_1, (int)var2_2, 4, (Integer)var3_3);
    }

    public static final class inet_aton_radix
    extends Enum<inet_aton_radix> {
        public static final /* enum */ inet_aton_radix OCTAL = new inet_aton_radix();
        public static final /* enum */ inet_aton_radix HEX = new inet_aton_radix();
        public static final /* enum */ inet_aton_radix DECIMAL = new inet_aton_radix();
        private static final /* synthetic */ inet_aton_radix[] $VALUES;

        final int getRadix() {
            if (this == OCTAL) {
                return 8;
            }
            if (this == HEX) {
                return 16;
            }
            return 10;
        }

        final String getSegmentStrPrefix() {
            if (this == OCTAL) {
                return "0";
            }
            if (this == HEX) {
                return "0x";
            }
            return null;
        }

        public final String toString() {
            if (this == OCTAL) {
                return "octal";
            }
            if (this == HEX) {
                return "hexadecimal";
            }
            return "decimal";
        }

        static {
            $VALUES = new inet_aton_radix[]{OCTAL, HEX, DECIMAL};
        }
    }

    public static interface IPv4AddressConverter {
        public IPv4Address toIPv4(IPAddress var1);
    }
}

