/*
 * Decompiled with CFR 0.152.
 */
package inet.ipaddr.format.validate;

import inet.ipaddr.AddressNetwork;
import inet.ipaddr.AddressSegment;
import inet.ipaddr.HostIdentifierString;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressNetwork;
import inet.ipaddr.IPAddressSection;
import inet.ipaddr.IPAddressSegment;
import inet.ipaddr.IPAddressSeqRange;
import inet.ipaddr.IPAddressStringParameters;
import inet.ipaddr.IncompatibleAddressException;
import inet.ipaddr.format.AddressItem;
import inet.ipaddr.format.IPAddressDivisionSeries;
import inet.ipaddr.format.standard.AddressDivision;
import inet.ipaddr.format.validate.AddressParseData;
import inet.ipaddr.format.validate.IPAddressParseData;
import inet.ipaddr.format.validate.IPAddressProvider;
import inet.ipaddr.format.validate.ParsedAddressCreator;
import inet.ipaddr.format.validate.ParsedAddressGrouping;
import inet.ipaddr.format.validate.ParsedHostIdentifierStringQualifier;
import inet.ipaddr.ipv4.IPv4Address;
import inet.ipaddr.ipv4.IPv4AddressNetwork;
import inet.ipaddr.ipv4.IPv4AddressSection;
import inet.ipaddr.ipv4.IPv4AddressSegment;
import inet.ipaddr.ipv4.IPv4AddressSeqRange;
import inet.ipaddr.ipv6.IPv6Address;
import inet.ipaddr.ipv6.IPv6AddressNetwork;
import inet.ipaddr.ipv6.IPv6AddressSection;
import inet.ipaddr.ipv6.IPv6AddressSegment;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.Objects;

public class ParsedIPAddress
extends IPAddressParseData
implements IPAddressProvider {
    private static final ExtendedMasker DEFAULT_MASKER = new ExtendedMasker(true);
    private static final ExtendedMasker DEFAULT_NON_SEQUENTIAL_MASKER = new ExtendedMasker(false);
    private static final ExtendedFullRangeMasker[] EXTENDED_FULL_RANGE_MASKERS = new ExtendedFullRangeMasker[129];
    private static final ExtendedFullRangeMasker[] EXTENDED_SEQUENTIAL_FULL_RANGE_MASKERS = new ExtendedFullRangeMasker[129];
    private static final WrappedMasker[] WRAPPED_FULL_RANGE_MASKERS = new WrappedMasker[65];
    private static final WrappedMasker[] WRAPPED_SEQUENTIAL_FULL_RANGE_MASKERS = new WrappedMasker[65];
    private static final FullRangeMasker[] FULL_RANGE_MASKERS = new FullRangeMasker[65];
    private static final FullRangeMasker[] SEQUENTIAL_FULL_RANGE_MASKERS = new FullRangeMasker[65];
    private static final BitwiseOrer DEFAULT_OR_MASKER = new BitwiseOrer(true);
    private static final BitwiseOrer DEFAULT_NON_SEQUENTIAL_OR_MASKER = new BitwiseOrer(false);
    private static final FullRangeBitwiseOrer[] FULL_RANGE_OR_MASKERS = new FullRangeBitwiseOrer[65];
    private static final FullRangeBitwiseOrer[] SEQUENTIAL_FULL_RANGE_OR_MASKERS = new FullRangeBitwiseOrer[65];
    private static final BigInteger ONE_EXTENDED = new BigInteger(1, new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0});
    private static final BigInteger HIGH_BIT = new BigInteger(1, new byte[]{-128, 0, 0, 0, 0, 0, 0, 0});
    private static final BigInteger[] ONE_SHIFTED = new BigInteger[64];
    private static final BigInteger[] ONE_SHIFTED_EXTENDED = new BigInteger[64];
    private static final BigInteger[] NETWORK_MASK_EXTENDED = new BigInteger[64];
    private static final BigInteger[] HOST_MASK_EXTENDED = new BigInteger[64];
    private final IPAddressStringParameters options;
    private final HostIdentifierString originator;
    private TranslatedResult<?, ?> values;
    private Masker[] maskers;
    private Masker[] mixedMaskers;

    /*
     * WARNING - void declaration
     */
    ParsedIPAddress(HostIdentifierString from, CharSequence addressString, IPAddressStringParameters options) {
        super((CharSequence)var2_2);
        void var1_1;
        void var3_3;
        void var2_2;
        this.options = var3_3;
        this.originator = var1_1;
    }

    private IPv6AddressNetwork.IPv6AddressCreator getIPv6AddressCreator() {
        return this.getParameters().getIPv6Parameters().getNetwork().getAddressCreator();
    }

    private IPv4AddressNetwork.IPv4AddressCreator getIPv4AddressCreator() {
        return this.getParameters().getIPv4Parameters().getNetwork().getAddressCreator();
    }

    @Override
    public boolean isProvidingIPAddress() {
        return true;
    }

    @Override
    public IPAddressProvider.IPType getType() {
        return IPAddressProvider.IPType.from(this.getProviderIPVersion());
    }

    @Override
    public IPAddressStringParameters getParameters() {
        return this.options;
    }

    /*
     * WARNING - void declaration
     */
    void createSections(boolean doAddress, boolean doRangeBoundaries, boolean withUpper) {
        IPAddress.IPVersion version = this.getProviderIPVersion();
        if (version.isIPv4()) {
            this.createIPv4Sections(doAddress, doRangeBoundaries, withUpper);
            return;
        }
        if (version.isIPv6()) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.createIPv6Sections((boolean)var1_1, (boolean)var2_2, (boolean)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    public IPAddressSeqRange getProviderSeqRange() {
        void var1_1;
        TranslatedResult<?, ?> val = this.values;
        if (val == null || ((TranslatedResult)val).range == null) {
            ParsedIPAddress parsedIPAddress = this;
            synchronized (parsedIPAddress) {
                val = this.values;
                if (val == null || ((TranslatedResult)val).range == null) {
                    if (val != null && !val.withoutSections() && val.withoutAddressException()) {
                        TranslatedResult<?, ?> translatedResult = val;
                        TranslatedResult.access$102(translatedResult, ((IPAddress)translatedResult.getAddress()).toSequentialRange());
                    } else {
                        this.createSections(false, true, true);
                        val = this.values;
                        val.createRange();
                        if (this.isDoneTranslating()) {
                            this.releaseSegmentData();
                        }
                    }
                }
            }
        }
        return ((TranslatedResult)var1_1).range;
    }

    /*
     * WARNING - void declaration
     */
    IPAddress getValForMask() {
        void var1_1;
        TranslatedResult<?, ?> val = this.values;
        if (val == null || !val.hasLowerSection()) {
            ParsedIPAddress parsedIPAddress = this;
            synchronized (parsedIPAddress) {
                val = this.values;
                if (val == null || !val.hasLowerSection()) {
                    this.createSections(false, true, false);
                    val = this.values;
                    this.releaseSegmentData();
                }
            }
        }
        return var1_1.getValForMask();
    }

    public IPAddress getProviderMask() {
        return this.getQualifier().getMaskLower();
    }

    /*
     * WARNING - void declaration
     */
    boolean isDoneTranslating() {
        void var1_1;
        TranslatedResult<?, ?> val = this.values;
        return !val.withoutSections() && (val.withoutAddressException() || !val.withoutRange()) && !var1_1.withoutGrouping();
    }

    /*
     * WARNING - void declaration
     */
    TranslatedResult<?, ?> getCachedAddresses(boolean forHostAddr) {
        void var2_4;
        TranslatedResult<?, ?> val = this.values;
        if (val == null || val.withoutSections()) {
            ParsedIPAddress parsedIPAddress = this;
            synchronized (parsedIPAddress) {
                val = this.values;
                if (val == null || val.withoutSections()) {
                    this.createSections(true, false, false);
                    val = this.values;
                    if (this.isDoneTranslating()) {
                        this.releaseSegmentData();
                    }
                }
                if (forHostAddr) {
                    val.getHostAddress();
                } else {
                    val.getAddress();
                }
            }
        }
        if (forHostAddr ? !val.hasHostAddress() : !val.hasAddress()) {
            ParsedIPAddress parsedIPAddress = this;
            synchronized (parsedIPAddress) {
                void var1_1;
                if (var1_1 != false) {
                    val.getHostAddress();
                } else {
                    val.getAddress();
                }
            }
        }
        return var2_4;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public IPAddress getProviderAddress() throws IncompatibleAddressException {
        void var1_1;
        TranslatedResult<?, ?> addrs = this.getCachedAddresses(false);
        if (((TranslatedResult)addrs).mixedException != null) {
            throw ((TranslatedResult)addrs).mixedException;
        }
        if (((TranslatedResult)addrs).maskException != null) {
            throw ((TranslatedResult)addrs).maskException;
        }
        if (((TranslatedResult)addrs).joinAddressException != null) {
            throw ((TranslatedResult)addrs).joinAddressException;
        }
        return var1_1.getAddress();
    }

    /*
     * WARNING - void declaration
     */
    public static ExtendedMasker maskExtendedRange(long value, long extendedValue, long upperValue, long extendedUpperValue, long maskValue, long extendedMaskValue, long maxValue, long extendedMaxValue) {
        int highestDifferingBitMasked;
        ExtendedFullRangeMasker[] cache;
        ExtendedFullRangeMasker result;
        void bigHostMask2;
        void masker2;
        long extendedDiffering = extendedValue ^ extendedUpperValue;
        if (extendedDiffering == 0L) {
            Masker masker2 = ParsedIPAddress.maskRange(value, upperValue, maskValue, maxValue);
            if (masker2 == DEFAULT_MASKER) {
                return DEFAULT_MASKER;
            }
            if (masker2 instanceof FullRangeMasker) {
                int fullRangeBit = ((FullRangeMasker)masker2).fullRangeBit;
                WrappedMasker[] cache2 = masker2.isSequential() ? WRAPPED_SEQUENTIAL_FULL_RANGE_MASKERS : WRAPPED_FULL_RANGE_MASKERS;
                WrappedMasker result2 = cache2[fullRangeBit];
                if (result2 == null) {
                    cache2[fullRangeBit] = result2 = new WrappedMasker(masker2);
                }
                return result2;
            }
            return new WrappedMasker(masker2);
        }
        if (extendedValue > extendedUpperValue) {
            throw new IllegalArgumentException("value > upper value");
        }
        if (maskValue == maxValue && extendedMaskValue == extendedMaxValue || maskValue == 0L && extendedMaskValue == 0L) {
            return DEFAULT_MASKER;
        }
        int highestDifferingBitInRange = Long.numberOfLeadingZeros((long)masker2);
        long extendedDifferingMasked = extendedMaskValue & -1L >>> highestDifferingBitInRange;
        if (extendedDifferingMasked != 0L) {
            boolean maskedIsSequential;
            boolean differingIsLowestBit = extendedDifferingMasked == 1L;
            int highestDifferingBitMasked2 = Long.numberOfLeadingZeros(extendedDifferingMasked);
            long hostMask = -1L >>> highestDifferingBitMasked2 + 1;
            if (!differingIsLowestBit) {
                maskedIsSequential = (extendedMaskValue & hostMask) == hostMask && maskValue == maxValue;
            } else {
                boolean bl = maskedIsSequential = maskValue == maxValue;
            }
            if (value == 0L && extendedValue == 0L && upperValue == maxValue && extendedUpperValue == extendedMaxValue) {
                if (maskedIsSequential) {
                    return DEFAULT_MASKER;
                }
                return DEFAULT_NON_SEQUENTIAL_MASKER;
            }
            if (highestDifferingBitMasked2 > highestDifferingBitInRange) {
                ExtendedFullRangeMasker[] cache3;
                ExtendedFullRangeMasker result3;
                if (maskedIsSequential) {
                    BigInteger lowerBig;
                    BigInteger upperBig;
                    BigInteger bigInteger;
                    int shift = 64 - highestDifferingBitMasked2;
                    BigInteger countRequiredForSequential = ONE_SHIFTED_EXTENDED[shift];
                    if (countRequiredForSequential == null) {
                        countRequiredForSequential = ParsedIPAddress.ONE_SHIFTED_EXTENDED[shift] = BigInteger.valueOf(1L << shift).shiftLeft(64);
                    }
                    maskedIsSequential = (bigInteger = (upperBig = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(upperValue, extendedUpperValue, 16))).subtract(lowerBig = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(value, extendedValue, 16))).add(BigInteger.ONE)).compareTo(countRequiredForSequential) >= 0;
                }
                if ((result3 = (cache3 = maskedIsSequential ? EXTENDED_SEQUENTIAL_FULL_RANGE_MASKERS : EXTENDED_FULL_RANGE_MASKERS)[highestDifferingBitMasked2]) == null) {
                    cache3[highestDifferingBitMasked2] = result3 = new ExtendedFullRangeMasker(highestDifferingBitMasked2, maskedIsSequential);
                }
                return result3;
            }
            if (!maskedIsSequential) {
                void var1_39;
                void var2_4;
                long lowerBig;
                void upperBig;
                BigInteger bigHostZeroed;
                BigInteger bigHostMask2 = HOST_MASK_EXTENDED[highestDifferingBitMasked2];
                if (bigHostMask2 == null) {
                    bigHostMask2 = BigInteger.valueOf(hostMask);
                    bigHostMask2 = bigHostMask2.shiftLeft(64);
                    ParsedIPAddress.HOST_MASK_EXTENDED[highestDifferingBitMasked2] = bigHostMask2 = bigHostMask2.or(new BigInteger(1, new byte[]{-1, -1, -1, -1, -1, -1, -1, -1}));
                }
                if ((bigHostZeroed = NETWORK_MASK_EXTENDED[highestDifferingBitMasked2]) == null) {
                    bigHostZeroed = ParsedIPAddress.NETWORK_MASK_EXTENDED[highestDifferingBitMasked2] = bigHostMask2.not();
                }
                BigInteger upperBig2 = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted((long)upperBig, extendedUpperValue, 16));
                BigInteger lowerBig2 = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(lowerBig, extendedValue, 16));
                BigInteger upperToBeMaskedBig = upperBig2.and(bigHostZeroed);
                BigInteger lowerToBeMaskedBig = lowerBig2.or(bigHostMask2);
                BigInteger maskBig = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(maskValue, extendedMaskValue, 16));
                for (int nextBit = 128 - (highestDifferingBitMasked2 + 1) - 1; nextBit >= 0; --nextBit) {
                    if (!maskBig.testBit(nextBit)) continue;
                    BigInteger candidate = upperToBeMaskedBig.setBit(nextBit);
                    if (candidate.compareTo(upperBig2) <= 0) {
                        upperToBeMaskedBig = candidate;
                    }
                    if ((candidate = lowerToBeMaskedBig.clearBit(nextBit)).compareTo(lowerBig2) < 0) continue;
                    lowerToBeMaskedBig = candidate;
                }
                return new ExtendedSpecificValueMasker(lowerToBeMaskedBig.shiftRight(64).longValue(), var2_4.longValue(), upperToBeMaskedBig.shiftRight(64).longValue(), var1_39.longValue());
            }
            return DEFAULT_MASKER;
        }
        if (maskValue == 0L) {
            return DEFAULT_MASKER;
        }
        boolean maskedIsSequential = true;
        int highestDifferingBitMaskedLow = Long.numberOfLeadingZeros(maskValue);
        if (maskValue != bigHostMask2 && highestDifferingBitMaskedLow < 63) {
            long hostMask = -1L >>> highestDifferingBitMaskedLow + 1;
            boolean bl = maskedIsSequential = (maskValue & hostMask) == hostMask;
        }
        if (maskedIsSequential) {
            void var2_3;
            long l;
            void var6_8;
            void var4_5;
            BigInteger countRequiredForSequential;
            if (highestDifferingBitMaskedLow == 0) {
                countRequiredForSequential = ONE_EXTENDED;
            } else if (highestDifferingBitMaskedLow == 1) {
                countRequiredForSequential = HIGH_BIT;
            } else {
                int shift = 64 - highestDifferingBitMaskedLow;
                countRequiredForSequential = ONE_SHIFTED[shift];
                if (countRequiredForSequential == null) {
                    countRequiredForSequential = ParsedIPAddress.ONE_SHIFTED[shift] = BigInteger.valueOf(1L << shift);
                }
            }
            BigInteger upperBig = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted((long)var4_5, (long)var6_8, 16));
            BigInteger lowerBig = new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(l, (long)var2_3, 16));
            BigInteger bigInteger = upperBig.subtract(lowerBig).add(BigInteger.ONE);
            maskedIsSequential = bigInteger.compareTo(countRequiredForSequential) >= 0;
        }
        if ((result = (cache = maskedIsSequential ? EXTENDED_SEQUENTIAL_FULL_RANGE_MASKERS : EXTENDED_FULL_RANGE_MASKERS)[highestDifferingBitMasked = highestDifferingBitMaskedLow + 64]) == null) {
            cache[highestDifferingBitMasked] = result = new ExtendedFullRangeMasker(highestDifferingBitMasked, maskedIsSequential);
        }
        return result;
    }

    public static Masker maskRange(long value, long upperValue, long maskValue, long maxValue) {
        int highestDifferingBitInRange;
        long maskMask;
        long differingMasked;
        boolean bl;
        if (value == upperValue) {
            return DEFAULT_MASKER;
        }
        if (value > upperValue) {
            throw new IllegalArgumentException("value > upper value");
        }
        if (maskValue == 0L || maskValue == maxValue) {
            return DEFAULT_MASKER;
        }
        long differing = value ^ upperValue;
        if (differing != 1L && (bl = (differingMasked = maskValue & (maskMask = -1L >>> (highestDifferingBitInRange = Long.numberOfLeadingZeros(differing)))) != 0L)) {
            boolean maskedIsSequential;
            int highestDifferingBitMasked = Long.numberOfLeadingZeros(differingMasked);
            long hostMask = highestDifferingBitMasked == 63 ? 0L : -1L >>> highestDifferingBitMasked + 1;
            boolean bl2 = maskedIsSequential = (maskValue & hostMask) == hostMask;
            if (!(maxValue != -1L || maskedIsSequential && highestDifferingBitMasked <= highestDifferingBitInRange)) {
                int highestOneBit = Long.numberOfLeadingZeros(upperValue);
                maxValue = -1L >>> highestOneBit;
            }
            if (value == 0L && upperValue == maxValue) {
                if (maskedIsSequential) {
                    return DEFAULT_MASKER;
                }
                return DEFAULT_NON_SEQUENTIAL_MASKER;
            }
            if (highestDifferingBitMasked > highestDifferingBitInRange) {
                FullRangeMasker[] cache;
                FullRangeMasker result;
                long countRequiredForSequential;
                long count;
                if (maskedIsSequential && highestDifferingBitMasked < 63 && (count = upperValue - value + 1L) < (countRequiredForSequential = 1L << 64 - highestDifferingBitMasked)) {
                    maskedIsSequential = false;
                }
                if ((result = (cache = maskedIsSequential ? SEQUENTIAL_FULL_RANGE_MASKERS : FULL_RANGE_MASKERS)[highestDifferingBitMasked]) == null) {
                    cache[highestDifferingBitMasked] = result = new FullRangeMasker(highestDifferingBitMasked, maskedIsSequential);
                }
                return result;
            }
            if (!maskedIsSequential) {
                long hostZeroed = hostMask ^ 0xFFFFFFFFFFFFFFFFL;
                long upperToBeMasked = upperValue & hostZeroed;
                long lowerToBeMasked = value | hostMask;
                for (long nextBit = (long)(1 << 64 - (highestDifferingBitMasked + 1) - 1); nextBit != 0L; nextBit >>>= 1) {
                    if ((maskValue & nextBit) == 0L) continue;
                    long candidate = upperToBeMasked | nextBit;
                    if (candidate <= upperValue) {
                        upperToBeMasked = candidate;
                    }
                    if ((candidate = lowerToBeMasked & (nextBit ^ 0xFFFFFFFFFFFFFFFFL)) < value) continue;
                    lowerToBeMasked = candidate;
                }
                return new SpecificValueMasker(lowerToBeMasked, upperToBeMasked);
            }
        }
        return DEFAULT_MASKER;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] toBytesSizeAdjusted(long val, long extended, int numBytes) {
        void var2_2;
        long l;
        byte b;
        int adjustedNumBytes = numBytes;
        int boundary = numBytes - 8;
        int adj = numBytes + boundary;
        for (int j = 1; j <= numBytes && (b = j <= boundary ? (byte)(extended >>> (numBytes - j << 3)) : (byte)(val >>> (adj - j << 3))) == 0; ++j) {
            --adjustedNumBytes;
        }
        return ParsedIPAddress.toBytes(l, (long)var2_2, adjustedNumBytes);
    }

    static byte[] toBytes(long val, long extended, int numBytes) {
        byte[] bytes = new byte[numBytes];
        int boundary = numBytes - 8;
        for (int j = numBytes - 1; j >= 0; --j) {
            if (j >= boundary) {
                bytes[j] = (byte)(val & 0xFFL);
                val >>>= 8;
                continue;
            }
            bytes[j] = (byte)(extended & 0xFFL);
            extended >>>= 8;
        }
        return bytes;
    }

    /*
     * WARNING - void declaration
     */
    private boolean skipContains(boolean skipMixed) {
        void var1_2;
        IPAddress mask;
        AddressParseData addressParseData = this.getAddressParseData();
        int segmentCount = addressParseData.getSegmentCount();
        if (this.isProvidingIPv4()) {
            if (segmentCount != 4) {
                return true;
            }
        } else {
            void var2_4;
            int expectedSegmentCount;
            if (this.isProvidingMixedIPv6()) {
                if (skipMixed) {
                    return true;
                }
                expectedSegmentCount = 6;
            } else {
                expectedSegmentCount = 8;
            }
            if (var2_4 != expectedSegmentCount && !this.isCompressed()) {
                return true;
            }
        }
        return (mask = this.getProviderMask()) != null && var1_2.getBlockMaskPrefixLength(true) == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Boolean parsedEquals(IPAddressProvider other) {
        if (other instanceof ParsedIPAddress) {
            ParsedIPAddress parsedOther;
            Boolean result;
            void var3_3;
            TranslatedResult<?, ?> vals = this.values;
            TranslatedResult<?, ?> otherVals = this.values;
            if ((vals == null || var3_3 == null) && (result = this.contains(parsedOther = (ParsedIPAddress)other, false, true)) != null) {
                void var1_1;
                void var2_2;
                return var2_2.booleanValue() && Objects.equals(this.getQualifier().getZone(), var1_1.getQualifier().getZone());
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private Boolean contains(ParsedIPAddress other, boolean networkOnly, boolean equals) {
        int networkSegIndex;
        int otherHostAllSegIndex;
        int hostAllSegIndex;
        int hostSegIndex;
        boolean bl;
        boolean compressedAlready22;
        IPAddressNetwork network;
        int bytesPerSegment;
        int bitsPerSegment;
        int expectedSegCount;
        int expectedOtherSegCount;
        int max;
        boolean skipMixed22;
        AddressParseData parseData = this.getAddressParseData();
        AddressParseData otherParseData = other.getAddressParseData();
        int[] segmentData = parseData.getSegmentData();
        int[] otherSegmentData = otherParseData.getSegmentData();
        if (segmentData == null || otherSegmentData == null) {
            return null;
        }
        Integer pref = this.getProviderNetworkPrefixLength();
        boolean bl2 = skipMixed22 = !networkOnly || pref == null || pref > 96;
        if (this.skipContains(skipMixed22) || other.skipContains(skipMixed22)) {
            return null;
        }
        IPAddress.IPVersion skipMixed22 = this.getProviderIPVersion();
        if (!skipMixed22.equals((Object)other.getProviderIPVersion())) {
            return Boolean.FALSE;
        }
        IPAddressStringParameters options = this.getParameters();
        int segmentCount = parseData.getSegmentCount();
        int otherSegmentCount = otherParseData.getSegmentCount();
        if (this.isProvidingIPv4()) {
            max = 255;
            expectedOtherSegCount = 4;
            expectedSegCount = 4;
            bitsPerSegment = 8;
            bytesPerSegment = 1;
            network = options.getIPv4Parameters().getNetwork();
            compressedAlready22 = true;
            bl = true;
        } else {
            void compressedAlready22;
            max = 65535;
            expectedOtherSegCount = 8;
            expectedSegCount = 8;
            if (this.isProvidingMixedIPv6()) {
                expectedSegCount -= 2;
            }
            if (other.isProvidingMixedIPv6()) {
                expectedOtherSegCount -= 2;
            }
            bitsPerSegment = 16;
            bytesPerSegment = 2;
            network = compressedAlready22.getIPv6Parameters().getNetwork();
            compressedAlready22 = expectedSegCount == segmentCount;
            bl = expectedOtherSegCount == otherSegmentCount;
        }
        boolean otherCompressedAlready = bl;
        AddressNetwork.PrefixConfiguration prefConf = network.getPrefixConfiguration();
        boolean zeroHostsAreSubnets = prefConf.zeroHostsAreSubnets();
        boolean allPrefixedAddressesAreSubnets = prefConf.allPrefixedAddressesAreSubnets();
        Integer otherPref = other.getProviderNetworkPrefixLength();
        int endIndex = segmentCount;
        Integer adjustedOtherPref = null;
        if (pref == null) {
            networkOnly = false;
            hostAllSegIndex = hostSegIndex = expectedSegCount;
            otherHostAllSegIndex = expectedOtherSegCount;
            networkSegIndex = hostSegIndex - 1;
        } else if (networkOnly) {
            hostAllSegIndex = otherHostAllSegIndex = ParsedAddressGrouping.getHostSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            networkSegIndex = ParsedAddressGrouping.getNetworkSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            adjustedOtherPref = pref;
        } else {
            otherHostAllSegIndex = expectedOtherSegCount;
            hostSegIndex = ParsedAddressGrouping.getHostSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            networkSegIndex = ParsedAddressGrouping.getNetworkSegmentIndex(pref, bytesPerSegment, bitsPerSegment);
            if (allPrefixedAddressesAreSubnets || zeroHostsAreSubnets && this.isPrefixSubnet(pref, network, segmentData)) {
                hostAllSegIndex = hostSegIndex;
                if (!equals) {
                    networkOnly = true;
                }
            } else {
                hostAllSegIndex = expectedSegCount;
            }
        }
        if (otherPref != null) {
            int otherPrefLen = otherPref;
            if (adjustedOtherPref == null || otherPrefLen < adjustedOtherPref) {
                int otherHostIndex = ParsedAddressGrouping.getHostSegmentIndex(otherPrefLen, bytesPerSegment, bitsPerSegment);
                if (otherHostIndex < otherHostAllSegIndex && (allPrefixedAddressesAreSubnets || zeroHostsAreSubnets && other.isPrefixSubnet(otherPrefLen, network, otherSegmentData))) {
                    otherHostAllSegIndex = otherHostIndex;
                }
            } else {
                otherPref = adjustedOtherPref;
            }
        } else {
            otherPref = adjustedOtherPref;
        }
        int i = 0;
        int j = 0;
        int otherCompressedCount = 0;
        int compressedCount = 0;
        for (int normalizedCount = 0; !(i >= endIndex && compressedCount <= 0 || networkOnly && normalizedCount > networkSegIndex); ++normalizedCount) {
            long otherUpper;
            long otherLower;
            long lower;
            long upper;
            if (compressedCount > 0) {
                upper = 0L;
                lower = 0L;
            } else {
                lower = ParsedIPAddress.getValue(i, 2, segmentData);
                upper = ParsedIPAddress.getValue(i, 10, segmentData);
            }
            if (normalizedCount >= hostAllSegIndex) {
                Integer segPrefLength = ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, pref, normalizedCount);
                lower &= (long)network.getSegmentNetworkMask(segPrefLength);
                upper |= (long)network.getSegmentHostMask(segPrefLength);
            }
            if (normalizedCount > otherHostAllSegIndex) {
                otherLower = 0L;
                otherUpper = max;
            } else {
                if (otherCompressedCount > 0) {
                    otherUpper = 0L;
                    otherLower = 0L;
                } else {
                    otherLower = ParsedIPAddress.getValue(j, 2, otherSegmentData);
                    otherUpper = ParsedIPAddress.getValue(j, 10, otherSegmentData);
                }
                if (normalizedCount == otherHostAllSegIndex) {
                    Integer segPrefLength = ParsedAddressGrouping.getSegmentPrefixLength(bitsPerSegment, otherPref, normalizedCount);
                    otherLower &= (long)network.getSegmentNetworkMask(segPrefLength);
                    otherUpper |= (long)network.getSegmentHostMask(segPrefLength);
                }
            }
            if (equals ? lower != otherLower || upper != otherUpper : lower > otherLower || upper < otherUpper) {
                return Boolean.FALSE;
            }
            if (!compressedAlready22) {
                if (compressedCount > 0) {
                    if (--compressedCount == 0) {
                        compressedAlready22 = true;
                    }
                } else if (this.isCompressed(i, segmentData)) {
                    ++i;
                    compressedCount = expectedSegCount - segmentCount;
                } else {
                    ++i;
                }
            } else {
                ++i;
            }
            if (!otherCompressedAlready) {
                if (otherCompressedCount > 0) {
                    if (--otherCompressedCount != 0) continue;
                    otherCompressedAlready = true;
                    continue;
                }
                if (other.isCompressed(j, otherSegmentData)) {
                    ++j;
                    otherCompressedCount = expectedOtherSegCount - otherSegmentCount;
                    continue;
                }
                ++j;
                continue;
            }
            ++j;
        }
        return Boolean.TRUE;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean isPrefixSubnet(Integer networkPrefixLength, IPAddressNetwork<?, ?, ?, ?, ?> network, int[] segmentData) {
        void var2_2;
        void var1_1;
        void var3_3;
        IPAddress.IPVersion version = network.getIPVersion();
        int bytesPerSegment = IPAddressSection.bytesPerSegment(version);
        int bitsPerSegment = IPAddressSection.bitsPerSegment(version);
        int max = IPAddressSegment.getMaxSegmentValue(version);
        AddressNetwork.PrefixConfiguration prefConf = network.getPrefixConfiguration();
        AddressParseData addressParseData = this.getAddressParseData();
        int segmentCount = addressParseData.getSegmentCount();
        if (this.isCompressed()) {
            int compressedCount = 8 - segmentCount;
            int compressedIndex = addressParseData.getConsecutiveSeparatorSegmentIndex();
            return ParsedAddressGrouping.isPrefixSubnet(segmentIndex -> {
                void var2_2;
                void var3_3;
                if (segmentIndex >= compressedIndex) {
                    void var1_1;
                    int n;
                    if (segmentIndex - n < compressedCount) {
                        return 0;
                    }
                    segmentIndex -= var1_1;
                }
                return (int)ParsedIPAddress.getValue((int)var3_3, 2, (int[])var2_2);
            }, segmentIndex -> {
                void var2_2;
                void var3_3;
                if (segmentIndex >= compressedIndex) {
                    void var1_1;
                    int n;
                    if (segmentIndex - n < compressedCount) {
                        return 0;
                    }
                    segmentIndex -= var1_1;
                }
                return (int)ParsedIPAddress.getValue((int)var3_3, 10, (int[])var2_2);
            }, segmentCount + compressedCount, bytesPerSegment, bitsPerSegment, max, networkPrefixLength, prefConf, false);
        }
        return ParsedAddressGrouping.isPrefixSubnet(segmentIndex -> {
            int[] nArray;
            return (int)ParsedIPAddress.getValue(segmentIndex, 2, nArray);
        }, arg_0 -> ParsedIPAddress.lambda$isPrefixSubnet$13((int[])var3_3, arg_0), segmentCount, bytesPerSegment, bitsPerSegment, max, (Integer)var1_1, (AddressNetwork.PrefixConfiguration)var2_2, false);
    }

    @Override
    public Integer getProviderNetworkPrefixLength() {
        return this.getQualifier().getEquivalentPrefixLength();
    }

    /*
     * WARNING - void declaration
     */
    private static <S extends IPAddressSegment> S[] allocateSegments(S[] segments, S[] originalSegments, AddressNetwork.AddressSegmentCreator<S> creator, int segmentCount, int originalCount) {
        S[] SArray;
        if (segments == null) {
            void var3_3;
            void var2_2;
            segments = (IPAddressSegment[])var2_2.createSegmentArray((int)var3_3);
            if (originalCount > 0) {
                void var1_1;
                System.arraycopy(var1_1, 0, segments, 0, originalCount);
            }
        }
        return SArray;
    }

    /*
     * WARNING - void declaration
     */
    private void createIPv4Sections(boolean doAddress, boolean doRangeBoundaries, boolean withUpper) {
        void var2_2;
        AddressSegment[] lowerSegments;
        AddressSegment[] segments;
        ParsedHostIdentifierStringQualifier qualifier = this.getQualifier();
        IPAddress mask = this.getProviderMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        AddressParseData addrParseData = this.getAddressParseData();
        int segmentCount = addrParseData.getSegmentCount();
        if (hasMask && this.maskers == null) {
            this.maskers = new Masker[segmentCount];
        }
        IPv4AddressNetwork.IPv4AddressCreator creator = this.getIPv4AddressCreator();
        int missingCount = 4 - segmentCount;
        IPAddressSegment[] upperSegments = null;
        IPAddressSegment[] hostSegments = null;
        if (doAddress) {
            segments = creator.createSegmentArray(4);
            lowerSegments = null;
        } else if (doRangeBoundaries) {
            lowerSegments = creator.createSegmentArray(4);
            segments = null;
        } else {
            return;
        }
        TranslatedResult<IPv4Address, IPv4AddressSection> finalResult = this.values;
        if (this.values == null) {
            this.values = finalResult = new TranslatedResult<IPv4Address, IPv4AddressSection>(){
                {
                    void var1_1;
                    super((ParsedIPAddress)var1_1);
                }

                @Override
                ParsedAddressCreator<IPv4Address, IPv4AddressSection, ?, ?> getCreator() {
                    return ParsedIPAddress.this.getIPv4AddressCreator();
                }
            };
        }
        boolean expandedSegments = missingCount <= 0;
        int expandedEnd = -1;
        int expandedStart = -1;
        CharSequence addressString = this.str;
        boolean maskedIsDifferent = false;
        int normalizedSegmentIndex = 0;
        for (int i = 0; i < segmentCount; ++i) {
            long lower = addrParseData.getValue(i, 2);
            long upper = addrParseData.getValue(i, 10);
            if (!expandedSegments) {
                boolean isLastSegment = i == segmentCount - 1;
                boolean isWildcard = addrParseData.isWildcard(i);
                expandedSegments = isLastSegment;
                if (!expandedSegments && (expandedSegments = !this.is_inet_aton_joined() && isWildcard)) {
                    for (int j = i + 1; j < segmentCount; ++j) {
                        if (!addrParseData.isWildcard(j)) continue;
                        expandedSegments = false;
                        break;
                    }
                }
                if (expandedSegments) {
                    long maskedUpper;
                    long maskedLower;
                    if (isWildcard) {
                        upper = -1 >>> (3 - missingCount << 3);
                    } else {
                        expandedStart = i;
                        expandedEnd = i + missingCount;
                    }
                    int bits = 8 * (missingCount + 1);
                    if (hasMask) {
                        long divMask = 0L;
                        for (int k = 0; k <= missingCount; ++k) {
                            divMask = divMask << 8 | (long)((IPAddressSegment)mask.getSegment(normalizedSegmentIndex + k)).getSegmentValue();
                        }
                        Masker masker = this.maskers[i];
                        if (masker == null) {
                            long maxValue = bits == 32 ? 0xFFFFFFFFL : (long)(~(-1 << bits));
                            this.maskers[i] = masker = ParsedIPAddress.maskRange(lower, upper, divMask, maxValue);
                        }
                        if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                            TranslatedResult.access$402(finalResult, new IncompatibleAddressException(lower, upper, divMask, "ipaddress.error.maskMismatch"));
                        }
                        maskedLower = masker.getMaskedLower(lower, divMask);
                        maskedUpper = masker.getMaskedUpper(upper, divMask);
                        maskedIsDifferent = maskedIsDifferent || maskedLower != lower || maskedUpper != upper;
                    } else {
                        maskedLower = lower;
                        maskedUpper = upper;
                    }
                    int shift = bits;
                    for (int count = missingCount; count >= 0; --count) {
                        int maskedSegUpper;
                        int maskedSegLower;
                        int hostSegUpper;
                        Integer currentPrefix = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, qualifier);
                        int hostSegLower = (int)(lower >>> (shift -= 8)) & 0xFF;
                        int n = hostSegUpper = lower == upper ? hostSegLower : (int)(upper >>> shift) & 0xFF;
                        if (hasMask) {
                            maskedSegLower = (int)(maskedLower >>> shift) & 0xFF;
                            maskedSegUpper = maskedLower == maskedUpper ? maskedSegLower : (int)(maskedUpper >>> shift) & 0xFF;
                        } else {
                            maskedSegLower = hostSegLower;
                            maskedSegUpper = hostSegUpper;
                        }
                        if (doAddress) {
                            if (maskedIsDifferent || currentPrefix != null) {
                                IPv4AddressSegment[] iPv4AddressSegmentArray = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)normalizedSegmentIndex);
                                hostSegments = iPv4AddressSegmentArray;
                                iPv4AddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, hostSegLower, hostSegUpper, false, i, null, creator);
                            }
                            segments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, maskedSegLower, maskedSegUpper, false, i, currentPrefix, creator);
                        }
                        if (doRangeBoundaries) {
                            boolean isRange;
                            boolean bl = isRange = maskedSegLower != maskedSegUpper;
                            if (!doAddress || isRange) {
                                if (doAddress) {
                                    lowerSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)normalizedSegmentIndex);
                                }
                                int n2 = maskedSegLower;
                                lowerSegments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, n2, n2, false, i, currentPrefix, creator);
                            } else if (lowerSegments != null) {
                                lowerSegments[normalizedSegmentIndex] = segments[normalizedSegmentIndex];
                            }
                            if (withUpper) {
                                if (isRange) {
                                    IPv4AddressSegment[] iPv4AddressSegmentArray = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)normalizedSegmentIndex);
                                    upperSegments = iPv4AddressSegmentArray;
                                    int n3 = maskedSegUpper;
                                    iPv4AddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, n3, n3, false, i, currentPrefix, creator);
                                } else if (upperSegments != null) {
                                    upperSegments[normalizedSegmentIndex] = lowerSegments[normalizedSegmentIndex];
                                }
                            }
                        }
                        ++normalizedSegmentIndex;
                    }
                    addrParseData.setBitLength(i, bits);
                    continue;
                }
            }
            long hostLower = lower;
            long hostUpper = upper;
            boolean unmasked = true;
            if (hasMask) {
                Masker masker = this.maskers[i];
                int maskInt = ((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue();
                if (masker == null) {
                    this.maskers[i] = masker = ParsedIPAddress.maskRange(lower, upper, maskInt, creator.getMaxValuePerSegment());
                }
                if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                    TranslatedResult.access$402(finalResult, new IncompatibleAddressException(lower, upper, maskInt, "ipaddress.error.maskMismatch"));
                }
                lower = (int)masker.getMaskedLower(lower, maskInt);
                upper = (int)masker.getMaskedUpper(upper, maskInt);
                unmasked = hostLower == lower && hostUpper == upper;
                maskedIsDifferent = maskedIsDifferent || !unmasked;
            }
            Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 8, qualifier);
            if (doAddress) {
                if (maskedIsDifferent || segmentPrefixLength != null) {
                    IPAddressSegment[] iPAddressSegmentArray = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments(hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)normalizedSegmentIndex);
                    hostSegments = iPAddressSegmentArray;
                    iPAddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)hostLower, (int)hostUpper, true, i, null, creator);
                }
                segments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)upper, unmasked, i, segmentPrefixLength, creator);
            }
            if (doRangeBoundaries) {
                boolean isRange;
                boolean bl = isRange = lower != upper;
                if (!doAddress || isRange) {
                    if (doAddress) {
                        lowerSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)normalizedSegmentIndex);
                    }
                    lowerSegments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)lower, (int)lower, false, i, segmentPrefixLength, creator);
                } else if (lowerSegments != null) {
                    lowerSegments[normalizedSegmentIndex] = segments[normalizedSegmentIndex];
                }
                if (withUpper) {
                    if (isRange) {
                        IPv4AddressSegment[] iPv4AddressSegmentArray = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)normalizedSegmentIndex);
                        upperSegments = iPv4AddressSegmentArray;
                        iPv4AddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV4, (int)upper, (int)upper, false, i, segmentPrefixLength, creator);
                    } else if (upperSegments != null) {
                        upperSegments[normalizedSegmentIndex] = lowerSegments[normalizedSegmentIndex];
                    }
                }
            }
            ++normalizedSegmentIndex;
            addrParseData.setBitLength(i, 8);
        }
        IPv4AddressNetwork.IPv4AddressCreator addressCreator = creator;
        Integer prefLength = ParsedIPAddress.getPrefixLength(qualifier);
        IPv4AddressSection hostResult = null;
        if (doAddress) {
            IPv4AddressSection result = (IPv4AddressSection)addressCreator.createPrefixedSectionInternal(segments, prefLength);
            TranslatedResult.access$802(finalResult, result);
            if (hostSegments != null) {
                hostResult = (IPv4AddressSection)addressCreator.createSectionInternal(hostSegments);
                TranslatedResult.access$902(finalResult, hostResult);
                if (ParsedIPAddress.checkExpandedValues(hostResult, expandedStart, expandedEnd)) {
                    TranslatedResult.access$302(finalResult, new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges"));
                }
            }
            if (ParsedIPAddress.checkExpandedValues(result, expandedStart, expandedEnd)) {
                TranslatedResult.access$502(finalResult, new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges"));
                if (hostResult == null) {
                    TranslatedResult<IPv4Address, IPv4AddressSection> translatedResult = finalResult;
                    TranslatedResult.access$302(translatedResult, ((TranslatedResult)translatedResult).joinAddressException);
                }
            }
        }
        if (var2_2 != false) {
            boolean isPrefixSubnet;
            Integer prefixLength = ParsedIPAddress.getPrefixLength(qualifier);
            if (prefixLength != null) {
                AddressSegment[] lowerSegs;
                AddressSegment[] upperSegs;
                void var1_1;
                IPv4AddressNetwork network = this.getParameters().getIPv4Parameters().getNetwork();
                if (var1_1 != false) {
                    upperSegs = segments;
                    lowerSegs = segments;
                } else {
                    lowerSegs = lowerSegments;
                    upperSegs = upperSegments == null ? lowerSegments : upperSegments;
                }
                isPrefixSubnet = ParsedAddressGrouping.isPrefixSubnet(arg_0 -> ParsedIPAddress.lambda$createIPv4Sections$14((IPv4AddressSegment[])lowerSegs, arg_0), arg_0 -> ParsedIPAddress.lambda$createIPv4Sections$15((IPv4AddressSegment[])upperSegs, arg_0), lowerSegs.length, 1, 8, 255, prefixLength, ((AddressNetwork)network).getPrefixConfiguration(), false);
                if (isPrefixSubnet) {
                    if (lowerSegments == null) {
                        lowerSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)4);
                    }
                    if (upperSegments == null) {
                        upperSegments = (IPv4AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)4, (int)4);
                    }
                }
            } else {
                isPrefixSubnet = false;
            }
            if (lowerSegments != null) {
                TranslatedResult.access$1002(finalResult, ((IPv4AddressSection)addressCreator.createPrefixedSectionInternal(lowerSegments, prefLength, true)).getLower());
            }
            if (upperSegments != null) {
                IPv4AddressSection section = (IPv4AddressSection)addressCreator.createPrefixedSectionInternal(upperSegments, prefLength);
                if (isPrefixSubnet) {
                    section = section.toPrefixBlock();
                }
                TranslatedResult.access$1102(finalResult, section.getUpper());
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createIPv6Sections(boolean doAddress, boolean doRangeBoundaries, boolean withUpper) {
        void var2_2;
        AddressSegment[] lowerSegments;
        AddressSegment[] segments;
        ParsedHostIdentifierStringQualifier qualifier = this.getQualifier();
        IPAddress mask = this.getProviderMask();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        AddressParseData addressParseData = this.getAddressParseData();
        int segmentCount = addressParseData.getSegmentCount();
        if (hasMask && this.maskers == null) {
            this.maskers = new Masker[segmentCount];
        }
        IPv6AddressNetwork.IPv6AddressCreator creator = this.getIPv6AddressCreator();
        IPAddressSegment[] upperSegments = null;
        IPAddressSegment[] hostSegments = null;
        if (doAddress) {
            segments = creator.createSegmentArray(8);
            lowerSegments = null;
        } else if (doRangeBoundaries) {
            lowerSegments = creator.createSegmentArray(8);
            segments = null;
        } else {
            return;
        }
        TranslatedResult<IPv6Address, IPv6AddressSection> finalResult = this.values;
        if (this.values == null) {
            this.values = finalResult = new TranslatedResult<IPv6Address, IPv6AddressSection>(){
                {
                    void var1_1;
                    super((ParsedIPAddress)var1_1);
                }

                @Override
                ParsedAddressCreator<IPv6Address, IPv6AddressSection, ?, ?> getCreator() {
                    return ParsedIPAddress.this.getIPv6AddressCreator();
                }
            };
        }
        boolean mixed = this.isProvidingMixedIPv6();
        int normalizedSegmentIndex = 0;
        int missingSegmentCount = (mixed ? 6 : 8) - segmentCount;
        boolean expandedSegments = missingSegmentCount <= 0;
        int expandedEnd = -1;
        int expandedStart = -1;
        CharSequence addressString = this.str;
        boolean maskedIsDifferent = false;
        for (int i = 0; i < segmentCount; ++i) {
            long lower = addressParseData.getValue(i, 2);
            long upper = addressParseData.getValue(i, 10);
            if (!expandedSegments) {
                boolean isLastSegment = i == segmentCount - 1;
                boolean isWildcard = addressParseData.isWildcard(i);
                boolean isCompressed = this.isCompressed(i);
                expandedSegments = isLastSegment || isCompressed;
                if (!expandedSegments && (expandedSegments = isWildcard)) {
                    for (int j = i + 1; j < segmentCount; ++j) {
                        if (!addressParseData.isWildcard(j) && !this.isCompressed(j)) continue;
                        expandedSegments = false;
                        break;
                    }
                }
                if (expandedSegments) {
                    boolean maskedIsRange;
                    long maskedLower;
                    long maskedUpper;
                    long maskedLowerHighBytes;
                    long maskedUpperHighBytes;
                    boolean hostIsRange;
                    long lowerHighBytes;
                    long upperHighBytes;
                    if (isCompressed) {
                        upperHighBytes = 0L;
                        lowerHighBytes = 0L;
                        upper = 0L;
                        lower = 0L;
                        hostIsRange = false;
                    } else if (hostIsRange) {
                        if (missingSegmentCount > 3) {
                            upperHighBytes = -1L >>> (7 - missingSegmentCount << 4);
                            upper = -1L;
                        } else {
                            upperHighBytes = 0L;
                            upper = -1L >>> (3 - missingSegmentCount << 4);
                        }
                        lowerHighBytes = 0L;
                        lower = 0L;
                        hostIsRange = true;
                    } else {
                        if (missingSegmentCount > 3) {
                            lowerHighBytes = addressParseData.getValue(i, 4);
                            upperHighBytes = addressParseData.getValue(i, 12);
                            hostIsRange = lower != upper || lowerHighBytes != upperHighBytes;
                        } else {
                            upperHighBytes = 0L;
                            lowerHighBytes = 0L;
                            hostIsRange = lower != upper;
                        }
                        expandedStart = i;
                        expandedEnd = i + missingSegmentCount;
                    }
                    int bits = 16 * (missingSegmentCount + 1);
                    if (hasMask) {
                        if (isCompressed) {
                            this.maskers[i] = DEFAULT_MASKER;
                            maskedUpperHighBytes = 0L;
                            maskedLowerHighBytes = 0L;
                            maskedUpper = 0L;
                            maskedLower = 0L;
                            maskedIsRange = false;
                        } else {
                            Masker masker;
                            long maskVal = 0L;
                            if (missingSegmentCount >= 4) {
                                int k;
                                masker = (ExtendedMasker)this.maskers[i];
                                long extendedMaskVal = 0L;
                                int extendedCount = missingSegmentCount - 3;
                                for (k = 0; k < extendedCount; ++k) {
                                    extendedMaskVal = extendedMaskVal << 16 | (long)((IPAddressSegment)mask.getSegment(normalizedSegmentIndex + k)).getSegmentValue();
                                }
                                for (k = extendedCount; k <= missingSegmentCount; ++k) {
                                    maskVal = maskVal << 16 | (long)((IPAddressSegment)mask.getSegment(normalizedSegmentIndex + k)).getSegmentValue();
                                }
                                if (masker == null) {
                                    long extendedMaxValue = bits == 64 ? -1L : -1L << bits - 64 ^ 0xFFFFFFFFFFFFFFFFL;
                                    this.maskers[i] = masker = ParsedIPAddress.maskExtendedRange(lower, lowerHighBytes, upper, upperHighBytes, maskVal, extendedMaskVal, -1L, extendedMaxValue);
                                }
                                if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                                    int byteCount = missingSegmentCount + 1 << 1;
                                    TranslatedResult.access$402(finalResult, new IncompatibleAddressException(new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(lower, lowerHighBytes, byteCount)).toString(), new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(upper, upperHighBytes, byteCount)).toString(), new BigInteger(1, ParsedIPAddress.toBytesSizeAdjusted(maskVal, extendedMaskVal, byteCount)).toString(), "ipaddress.error.maskMismatch"));
                                }
                                maskedLowerHighBytes = ((ExtendedMasker)masker).getExtendedMaskedLower(lowerHighBytes, extendedMaskVal);
                                maskedUpperHighBytes = ((ExtendedMasker)masker).getExtendedMaskedUpper(upperHighBytes, extendedMaskVal);
                                maskedLower = masker.getMaskedLower(lower, maskVal);
                                maskedIsRange = maskedLower != (maskedUpper = masker.getMaskedUpper(upper, maskVal)) || maskedLowerHighBytes != maskedUpperHighBytes;
                                maskedIsDifferent = maskedIsDifferent || maskedLower != lower || maskedUpper != upper || maskedLowerHighBytes != lowerHighBytes || maskedUpperHighBytes != upperHighBytes;
                            } else {
                                masker = this.maskers[i];
                                for (int k = 0; k <= missingSegmentCount; ++k) {
                                    maskVal = maskVal << 16 | (long)((IPAddressSegment)mask.getSegment(normalizedSegmentIndex + k)).getSegmentValue();
                                }
                                if (masker == null) {
                                    long maxValue = bits == 64 ? -1L : -1L << bits ^ 0xFFFFFFFFFFFFFFFFL;
                                    this.maskers[i] = masker = ParsedIPAddress.maskRange(lower, upper, maskVal, maxValue);
                                }
                                if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                                    TranslatedResult.access$402(finalResult, new IncompatibleAddressException(lower, upper, maskVal, "ipaddress.error.maskMismatch"));
                                }
                                maskedUpperHighBytes = 0L;
                                maskedLowerHighBytes = 0L;
                                maskedLower = masker.getMaskedLower(lower, maskVal);
                                maskedIsRange = maskedLower != (maskedUpper = masker.getMaskedUpper(upper, maskVal));
                                maskedIsDifferent = maskedIsDifferent || maskedLower != lower || maskedUpper != upper;
                            }
                        }
                    } else {
                        maskedLowerHighBytes = lowerHighBytes;
                        maskedUpperHighBytes = upperHighBytes;
                        maskedLower = lower;
                        maskedUpper = upper;
                        maskedIsRange = hostIsRange;
                    }
                    int shift = bits;
                    for (int count = missingSegmentCount; count >= 0; --count) {
                        int hostSegLower;
                        int hostSegUpper;
                        int maskedSegLower;
                        int maskedSegUpper;
                        Integer currentPrefix = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
                        if (isCompressed) {
                            maskedSegUpper = 0;
                            maskedSegLower = 0;
                            hostSegUpper = 0;
                            hostSegLower = 0;
                        } else {
                            shift -= 16;
                            if (count >= 4) {
                                int shorterShift = shift - 64;
                                hostSegLower = (int)(lowerHighBytes >>> shorterShift) & 0xFFFF;
                                int n = hostSegUpper = hostIsRange ? (int)(upperHighBytes >>> shorterShift) & 0xFFFF : hostSegLower;
                                if (hasMask) {
                                    maskedSegLower = (int)(maskedLowerHighBytes >>> shorterShift) & 0xFFFF;
                                    maskedSegUpper = maskedIsRange ? (int)(maskedUpperHighBytes >>> shorterShift) & 0xFFFF : maskedSegLower;
                                } else {
                                    maskedSegLower = hostSegLower;
                                    maskedSegUpper = hostSegUpper;
                                }
                            } else {
                                hostSegLower = (int)(lower >>> shift) & 0xFFFF;
                                int n = hostSegUpper = hostIsRange ? (int)(upper >>> shift) & 0xFFFF : hostSegLower;
                                if (hasMask) {
                                    maskedSegLower = (int)(maskedLower >>> shift) & 0xFFFF;
                                    maskedSegUpper = maskedIsRange ? (int)(maskedUpper >>> shift) & 0xFFFF : maskedSegLower;
                                } else {
                                    maskedSegLower = hostSegLower;
                                    maskedSegUpper = hostSegUpper;
                                }
                            }
                        }
                        if (doAddress) {
                            if (maskedIsDifferent || currentPrefix != null) {
                                IPv6AddressSegment[] iPv6AddressSegmentArray = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                                hostSegments = iPv6AddressSegmentArray;
                                iPv6AddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, hostSegLower, hostSegUpper, false, i, null, creator);
                            }
                            segments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, maskedSegLower, maskedSegUpper, false, i, currentPrefix, creator);
                        }
                        if (doRangeBoundaries) {
                            boolean isSegRange;
                            boolean bl = isSegRange = maskedSegLower != maskedSegUpper;
                            if (!doAddress || isSegRange) {
                                if (doAddress) {
                                    lowerSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                                }
                                int n = maskedSegLower;
                                lowerSegments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, n, n, false, i, currentPrefix, creator);
                            } else if (lowerSegments != null) {
                                lowerSegments[normalizedSegmentIndex] = segments[normalizedSegmentIndex];
                            }
                            if (withUpper) {
                                if (isSegRange) {
                                    IPv6AddressSegment[] iPv6AddressSegmentArray = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                                    upperSegments = iPv6AddressSegmentArray;
                                    int n = maskedSegUpper;
                                    iPv6AddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, n, n, false, i, currentPrefix, creator);
                                } else if (upperSegments != null) {
                                    upperSegments[normalizedSegmentIndex] = lowerSegments[normalizedSegmentIndex];
                                }
                            }
                        }
                        ++normalizedSegmentIndex;
                    }
                    addressParseData.setBitLength(i, bits);
                    continue;
                }
            }
            long hostLower = lower;
            long hostUpper = upper;
            boolean unmasked = true;
            if (hasMask) {
                Masker masker = this.maskers[i];
                int maskInt = ((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue();
                if (masker == null) {
                    this.maskers[i] = masker = ParsedIPAddress.maskRange(lower, upper, maskInt, creator.getMaxValuePerSegment());
                }
                if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                    TranslatedResult.access$402(finalResult, new IncompatibleAddressException(lower, upper, maskInt, "ipaddress.error.maskMismatch"));
                }
                lower = (int)masker.getMaskedLower(lower, maskInt);
                upper = (int)masker.getMaskedUpper(upper, maskInt);
                unmasked = hostLower == lower && hostUpper == upper;
                maskedIsDifferent = maskedIsDifferent || !unmasked;
            }
            Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
            if (doAddress) {
                if (maskedIsDifferent || segmentPrefixLength != null) {
                    IPAddressSegment[] iPAddressSegmentArray = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments(hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                    hostSegments = iPAddressSegmentArray;
                    iPAddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, (int)hostLower, (int)hostUpper, true, i, null, creator);
                }
                segments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)upper, unmasked, i, segmentPrefixLength, creator);
            }
            if (doRangeBoundaries) {
                boolean isRange;
                boolean bl = isRange = lower != upper;
                if (!doAddress || isRange) {
                    if (doAddress) {
                        lowerSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                    }
                    lowerSegments[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, (int)lower, (int)lower, false, i, segmentPrefixLength, creator);
                } else if (lowerSegments != null) {
                    lowerSegments[normalizedSegmentIndex] = segments[normalizedSegmentIndex];
                }
                if (withUpper) {
                    if (isRange) {
                        IPv6AddressSegment[] iPv6AddressSegmentArray = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                        upperSegments = iPv6AddressSegmentArray;
                        iPv6AddressSegmentArray[normalizedSegmentIndex] = this.createSegment(addressString, IPAddress.IPVersion.IPV6, (int)upper, (int)upper, false, i, segmentPrefixLength, creator);
                    } else if (upperSegments != null) {
                        upperSegments[normalizedSegmentIndex] = lowerSegments[normalizedSegmentIndex];
                    }
                }
            }
            ++normalizedSegmentIndex;
            addressParseData.setBitLength(i, 16);
        }
        IPv6AddressNetwork.IPv6AddressCreator addressCreator = creator;
        Integer prefLength = ParsedIPAddress.getPrefixLength(qualifier);
        if (mixed) {
            IPv4AddressSeqRange ipv4Range = (IPv4AddressSeqRange)this.mixedParsedAddress.getProviderSeqRange();
            if (hasMask && this.mixedMaskers == null) {
                this.mixedMaskers = new Masker[4];
            }
            for (int n = 0; n < 2; ++n) {
                boolean isRange;
                int m = n << 1;
                Integer segmentPrefixLength = ParsedIPAddress.getSegmentPrefixLength(normalizedSegmentIndex, 16, qualifier);
                IPv4AddressSegment oneLow = ipv4Range.getLower().getSegment(m);
                int o = m + 1;
                IPv4AddressSegment twoLow = ipv4Range.getLower().getSegment(o);
                IPv4AddressSegment oneUp = ipv4Range.getUpper().getSegment(m);
                IPv4AddressSegment twoUp = ipv4Range.getUpper().getSegment(o);
                int oneLower = oneLow.getSegmentValue();
                int twoLower = twoLow.getSegmentValue();
                int oneUpper = oneUp.getSegmentValue();
                int twoUpper = twoUp.getSegmentValue();
                int originalOneLower = oneLower;
                int originalTwoLower = twoLower;
                int originalOneUpper = oneUpper;
                int originalTwoUpper = twoUpper;
                if (hasMask) {
                    int maskInt = ((IPAddressSegment)mask.getSegment(normalizedSegmentIndex)).getSegmentValue();
                    int shiftedMask = maskInt >> 8;
                    Masker masker = this.mixedMaskers[m];
                    if (masker == null) {
                        this.mixedMaskers[m] = masker = ParsedIPAddress.maskRange(oneLower, oneUpper, shiftedMask, 255L);
                    }
                    if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                        TranslatedResult.access$402(finalResult, new IncompatibleAddressException(oneLower, oneUpper, shiftedMask, "ipaddress.error.maskMismatch"));
                    }
                    oneLower = (int)masker.getMaskedLower(oneLower, shiftedMask);
                    oneUpper = (int)masker.getMaskedUpper(oneUpper, shiftedMask);
                    masker = this.mixedMaskers[m + 1];
                    if (masker == null) {
                        this.mixedMaskers[m + 1] = masker = ParsedIPAddress.maskRange(twoLower, twoUpper, maskInt, 255L);
                    }
                    if (!masker.isSequential() && ((TranslatedResult)finalResult).maskException == null) {
                        TranslatedResult.access$402(finalResult, new IncompatibleAddressException(twoLower, twoUpper, maskInt, "ipaddress.error.maskMismatch"));
                    }
                    twoLower = (int)masker.getMaskedLower(twoLower, maskInt);
                    twoUpper = (int)masker.getMaskedUpper(twoUpper, maskInt);
                    maskedIsDifferent = maskedIsDifferent || oneLower != originalOneLower || oneUpper != originalOneUpper || twoLower != originalTwoLower || twoUpper != originalTwoUpper;
                }
                boolean bl = isRange = oneLower != oneUpper || twoLower != twoUpper;
                if (doAddress) {
                    boolean doHostSegment = maskedIsDifferent || segmentPrefixLength != null;
                    if (doHostSegment) {
                        hostSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])hostSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                    }
                    if (!isRange) {
                        if (doHostSegment) {
                            hostSegments[normalizedSegmentIndex] = this.createIPv6Segment(originalOneLower, originalTwoLower, null, creator);
                        }
                        segments[normalizedSegmentIndex] = this.createIPv6Segment(oneLower, twoLower, segmentPrefixLength, creator);
                    } else {
                        if (doHostSegment) {
                            hostSegments[normalizedSegmentIndex] = ParsedIPAddress.createIPv6RangeSegment(finalResult, ipv4Range, originalOneLower, originalOneUpper, originalTwoLower, originalTwoUpper, null, creator);
                        }
                        segments[normalizedSegmentIndex] = ParsedIPAddress.createIPv6RangeSegment(finalResult, ipv4Range, oneLower, oneUpper, twoLower, twoUpper, segmentPrefixLength, creator);
                    }
                }
                if (doRangeBoundaries) {
                    if (!doAddress || isRange) {
                        if (doAddress) {
                            lowerSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                        }
                        lowerSegments[normalizedSegmentIndex] = this.createIPv6Segment(oneLower, twoLower, segmentPrefixLength, creator);
                    } else if (lowerSegments != null) {
                        lowerSegments[normalizedSegmentIndex] = segments[normalizedSegmentIndex];
                    }
                    if (withUpper) {
                        if (isRange) {
                            IPv6AddressSegment[] iPv6AddressSegmentArray = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)normalizedSegmentIndex);
                            upperSegments = iPv6AddressSegmentArray;
                            iPv6AddressSegmentArray[normalizedSegmentIndex] = this.createIPv6Segment(oneUpper, twoUpper, segmentPrefixLength, creator);
                        } else if (upperSegments != null) {
                            upperSegments[normalizedSegmentIndex] = lowerSegments[normalizedSegmentIndex];
                        }
                    }
                }
                ++normalizedSegmentIndex;
            }
        }
        IPv6AddressSection hostResult = null;
        if (doAddress) {
            if (hostSegments != null) {
                hostResult = (IPv6AddressSection)addressCreator.createSectionInternal(hostSegments);
                TranslatedResult.access$902(finalResult, hostResult);
                if (ParsedIPAddress.checkExpandedValues(hostResult, expandedStart, expandedEnd)) {
                    TranslatedResult.access$302(finalResult, new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges"));
                }
            }
            IPv6AddressSection result = (IPv6AddressSection)addressCreator.createPrefixedSectionInternal(segments, prefLength);
            TranslatedResult.access$802(finalResult, result);
            if (ParsedIPAddress.checkExpandedValues(result, expandedStart, expandedEnd)) {
                TranslatedResult.access$502(finalResult, new IncompatibleAddressException(addressString, "ipaddress.error.invalid.joined.ranges"));
                if (hostResult == null) {
                    TranslatedResult<IPv6Address, IPv6AddressSection> translatedResult = finalResult;
                    TranslatedResult.access$302(translatedResult, ((TranslatedResult)translatedResult).joinAddressException);
                }
            }
        }
        if (var2_2 != false) {
            boolean isPrefixSubnet;
            Integer prefixLength = ParsedIPAddress.getPrefixLength(qualifier);
            if (prefixLength != null) {
                AddressSegment[] lowerSegs;
                AddressSegment[] upperSegs;
                void var1_1;
                IPv6AddressNetwork network = this.getParameters().getIPv6Parameters().getNetwork();
                if (var1_1 != false) {
                    upperSegs = segments;
                    lowerSegs = segments;
                } else {
                    lowerSegs = lowerSegments;
                    upperSegs = upperSegments == null ? lowerSegments : upperSegments;
                }
                isPrefixSubnet = ParsedAddressGrouping.isPrefixSubnet(arg_0 -> ParsedIPAddress.lambda$createIPv6Sections$16((IPv6AddressSegment[])lowerSegs, arg_0), arg_0 -> ParsedIPAddress.lambda$createIPv6Sections$17((IPv6AddressSegment[])upperSegs, arg_0), lowerSegs.length, 2, 16, 65535, prefixLength, ((AddressNetwork)network).getPrefixConfiguration(), false);
                if (isPrefixSubnet) {
                    if (lowerSegments == null) {
                        lowerSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])lowerSegments, (IPAddressSegment[])segments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)8);
                    }
                    if (upperSegments == null) {
                        upperSegments = (IPv6AddressSegment[])ParsedIPAddress.allocateSegments((IPAddressSegment[])upperSegments, (IPAddressSegment[])lowerSegments, (AddressNetwork.AddressSegmentCreator)creator, (int)8, (int)8);
                    }
                }
            } else {
                isPrefixSubnet = false;
            }
            if (lowerSegments != null) {
                TranslatedResult.access$1002(finalResult, ((IPv6AddressSection)addressCreator.createPrefixedSectionInternal(lowerSegments, prefLength, true)).getLower());
            }
            if (upperSegments != null) {
                IPv6AddressSection section = (IPv6AddressSection)addressCreator.createPrefixedSectionInternal(upperSegments, prefLength);
                if (isPrefixSubnet) {
                    section = section.toPrefixBlock();
                }
                TranslatedResult.access$1102(finalResult, section.getUpper());
            }
        }
    }

    private static boolean checkExpandedValues(IPAddressSection section, int start, int end) {
        if (section != null && start < end) {
            IPAddressSegment iPAddressSegment = section.getSegment(start);
            boolean lastWasRange = ((AddressDivision)iPAddressSegment).isMultiple();
            do {
                IPAddressSegment seg = section.getSegment(++start);
                if (lastWasRange) {
                    if (seg.isFullRange()) continue;
                    return true;
                }
                lastWasRange = ((AddressDivision)iPAddressSegment).isMultiple();
            } while (start < end);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private <S extends IPAddressSegment> S createSegment(CharSequence addressString, IPAddress.IPVersion version, int val, int upperVal, boolean useFlags, int parsedSegIndex, Integer segmentPrefixLength, ParsedAddressCreator<?, ?, ?, S> creator) {
        void var1_1;
        IPAddressSegment result;
        AddressParseData parseData = this.getAddressParseData();
        if (val != upperVal) {
            void var2_2;
            return ParsedIPAddress.createRangeSeg(addressString, (IPAddress.IPVersion)var2_2, val, upperVal, useFlags, parseData, parsedSegIndex, segmentPrefixLength, creator);
        }
        if (!useFlags) {
            int n = val;
            result = (IPAddressSegment)creator.createSegment(n, n, segmentPrefixLength);
        } else {
            void var3_3;
            result = (IPAddressSegment)creator.createSegmentInternal(val, segmentPrefixLength, (CharSequence)((Object)result), (int)var3_3, parseData.getFlag(parsedSegIndex, 262144), parseData.getIndex(parsedSegIndex, 6), parseData.getIndex(parsedSegIndex, 7));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private IPv6AddressSegment createIPv6Segment(int value1, int value2, Integer segmentPrefixLength, IPv6AddressNetwork.IPv6AddressCreator creator) {
        void var3_4;
        void var1_1;
        void var2_3;
        int value = value1 << 8 | var2_3;
        IPv6AddressSegment iPv6AddressSegment = creator.createSegment((int)var1_1, (Integer)var3_4);
        return iPv6AddressSegment;
    }

    /*
     * WARNING - void declaration
     */
    private static IPv6AddressSegment createIPv6RangeSegment(TranslatedResult<?, ?> finalResult, AddressItem item, int upperRangeLower, int upperRangeUpper, int lowerRangeLower, int lowerRangeUpper, Integer segmentPrefixLength, IPv6AddressNetwork.IPv6AddressCreator creator) {
        void var3_3;
        void var2_2;
        if (upperRangeLower != upperRangeUpper) {
            if (segmentPrefixLength != null && ((AddressNetwork)creator.getNetwork()).getPrefixConfiguration().allPrefixedAddressesAreSubnets()) {
                if (segmentPrefixLength > 8) {
                    int lowerPrefixLength = segmentPrefixLength - 8;
                    int networkMask = 0xFF & 255 << 8 - lowerPrefixLength;
                    int hostMask = ~networkMask & 0xFF;
                    if (((TranslatedResult)finalResult).mixedException == null && (lowerRangeLower &= networkMask) != 0 || (lowerRangeUpper |= hostMask) != 255) {
                        TranslatedResult.access$202(finalResult, new IncompatibleAddressException(item, "ipaddress.error.invalidMixedRange"));
                    }
                } else {
                    lowerRangeLower = 0;
                    lowerRangeUpper = 255;
                }
            } else if (((TranslatedResult)finalResult).mixedException == null && lowerRangeLower != 0 || lowerRangeUpper != 255) {
                void var1_1;
                TranslatedResult<?, ?> translatedResult;
                TranslatedResult.access$202(translatedResult, new IncompatibleAddressException((AddressItem)var1_1, "ipaddress.error.invalidMixedRange"));
            }
        }
        return creator.createSegment(var2_2 << 8 | lowerRangeLower, var3_3 << 8 | lowerRangeUpper, segmentPrefixLength);
    }

    /*
     * WARNING - void declaration
     */
    private static <S extends IPAddressSegment> S createRangeSeg(CharSequence addressString, IPAddress.IPVersion version, int stringLower, int stringUpper, boolean useFlags, AddressParseData parseData, int parsedSegIndex, Integer segmentPrefixLength, ParsedAddressCreator<?, ?, ?, S> creator) {
        IPAddressSegment iPAddressSegment;
        void var3_4;
        void var2_3;
        IPAddressSegment result;
        void var1_2;
        int lower = stringLower;
        int upper = stringUpper;
        result = !useFlags ? (IPAddressSegment)creator.createSegment(lower, upper, segmentPrefixLength) : (IPAddressSegment)creator.createRangeSegmentInternal((int)var1_2, upper, segmentPrefixLength, (CharSequence)((Object)result), (int)var2_3, (int)var3_4, parseData.getFlag(parsedSegIndex, 262144), parseData.getFlag(parsedSegIndex, 524288), parseData.getIndex(parsedSegIndex, 6), parseData.getIndex(parsedSegIndex, 7), parseData.getIndex(parsedSegIndex, 15));
        return (S)iPAddressSegment;
    }

    /*
     * WARNING - void declaration
     */
    private static <S extends IPAddressSegment> S createFullRangeSegment(IPAddress.IPVersion version, int stringLower, int stringUpper, int parsedSegIndex, Integer segmentPrefixLength, Integer mask, ParsedAddressCreator<?, ?, ?, S> creator) {
        void var3_3;
        void var2_2;
        void var1_1;
        IPAddress.IPVersion iPVersion;
        boolean bl = mask != null;
        if (bl) {
            int maskInt = mask;
            Masker masker = ParsedIPAddress.maskRange(stringLower, stringUpper, maskInt, creator.getMaxValuePerSegment());
            if (!masker.isSequential()) {
                throw new IncompatibleAddressException(stringLower, stringUpper, maskInt, "ipaddress.error.maskMismatch");
            }
            stringLower = (int)masker.getMaskedLower(stringLower, maskInt);
            stringUpper = (int)masker.getMaskedUpper(stringUpper, maskInt);
        }
        S s = ParsedIPAddress.createRangeSeg(null, iPVersion, (int)var1_1, (int)var2_2, false, null, (int)var3_3, segmentPrefixLength, creator);
        return s;
    }

    /*
     * WARNING - void declaration
     */
    static IPAddress createAllAddress(IPAddress.IPVersion version, ParsedHostIdentifierStringQualifier qualifier, HostIdentifierString originator, IPAddressStringParameters options) {
        void var2_2;
        void var1_1;
        void var3_3;
        IPAddressNetwork.IPAddressCreator creator;
        int segmentCount = IPAddress.getSegmentCount(version);
        IPAddress mask = qualifier.getMaskLower();
        if (mask != null && mask.getBlockMaskPrefixLength(true) != null) {
            mask = null;
        }
        boolean hasMask = mask != null;
        Integer prefLength = ParsedIPAddress.getPrefixLength(qualifier);
        if (version.isIPv4()) {
            creator = options.getIPv4Parameters().getNetwork().getAddressCreator();
            AddressSegment[] segments = (IPv4AddressSegment[])creator.createSegmentArray(segmentCount);
            for (int i = 0; i < segmentCount; ++i) {
                Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(i)).getSegmentValue()) : null;
                int n = i;
                segments[i] = ParsedIPAddress.createFullRangeSegment(version, 0, 255, n, ParsedIPAddress.getSegmentPrefixLength(n, version, qualifier), segmentMask, creator);
            }
            return (IPAddress)creator.createAddressInternal(segments, originator, prefLength);
        }
        creator = ((IPAddressStringParameters)((Object)creator)).getIPv6Parameters().getNetwork().getAddressCreator();
        AddressSegment[] segments = (IPv6AddressSegment[])creator.createSegmentArray(segmentCount);
        for (int i = 0; i < segmentCount; ++i) {
            Integer segmentMask = hasMask ? ParsedIPAddress.cacheSegmentMask(((IPAddressSegment)mask.getSegment(i)).getSegmentValue()) : null;
            int n = i;
            segments[i] = (IPv6AddressSegment)((Object)ParsedIPAddress.createFullRangeSegment(version, 0, 65535, n, ParsedIPAddress.getSegmentPrefixLength(n, version, qualifier), segmentMask, creator));
        }
        return (IPAddress)var3_3.createAddressInternal(segments, var1_1.getZone(), (HostIdentifierString)var2_2, prefLength);
    }

    private static Integer getPrefixLength(ParsedHostIdentifierStringQualifier qualifier) {
        return qualifier.getEquivalentPrefixLength();
    }

    /*
     * WARNING - void declaration
     */
    private static Integer getSegmentPrefixLength(int segmentIndex, int bitsPerSegment, ParsedHostIdentifierStringQualifier qualifier) {
        int n;
        void var2_2;
        void var1_1;
        Integer bits = ParsedIPAddress.getPrefixLength(qualifier);
        return ParsedAddressGrouping.getSegmentPrefixLength((int)var1_1, (Integer)var2_2, n);
    }

    /*
     * WARNING - void declaration
     */
    private static Integer getSegmentPrefixLength(int segmentIndex, IPAddress.IPVersion version, ParsedHostIdentifierStringQualifier qualifier) {
        void var2_2;
        void var1_1;
        return ParsedIPAddress.getSegmentPrefixLength(segmentIndex, IPAddressSection.bitsPerSegment((IPAddress.IPVersion)var1_1), (ParsedHostIdentifierStringQualifier)var2_2);
    }

    private static Integer cacheSegmentMask(int i) {
        return ParsedAddressGrouping.cache(i);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$createIPv6Sections$17(IPv6AddressSegment[] upperSegs, int segmentIndex) {
        void var1_1;
        return upperSegs[var1_1].getUpperSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$createIPv6Sections$16(IPv6AddressSegment[] lowerSegs, int segmentIndex) {
        void var1_1;
        return lowerSegs[var1_1].getSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$createIPv4Sections$15(IPv4AddressSegment[] upperSegs, int segmentIndex) {
        void var1_1;
        return upperSegs[var1_1].getUpperSegmentValue();
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ int lambda$createIPv4Sections$14(IPv4AddressSegment[] lowerSegs, int segmentIndex) {
        void var1_1;
        return lowerSegs[var1_1].getSegmentValue();
    }

    private static /* synthetic */ int lambda$isPrefixSubnet$13(int[] segmentData, int segmentIndex) {
        int[] nArray;
        return (int)ParsedIPAddress.getValue(segmentIndex, 10, nArray);
    }

    public static class WrappedMasker
    extends ExtendedMasker {
        private final Masker masker;

        /*
         * WARNING - void declaration
         */
        WrappedMasker(Masker masker) {
            super(masker.isSequential());
            void var1_1;
            this.masker = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedLower(long value, long maskValue) {
            void var3_2;
            void var1_1;
            return this.masker.getMaskedLower((long)var1_1, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedUpper(long upperValue, long maskValue) {
            void var3_2;
            void var1_1;
            return this.masker.getMaskedUpper((long)var1_1, (long)var3_2);
        }
    }

    public static class ExtendedSpecificValueMasker
    extends ExtendedMasker {
        private final long extendedLower;
        private final long lower;
        private final long extendedUpper;
        private final long upper;

        /*
         * WARNING - void declaration
         */
        public ExtendedSpecificValueMasker(long extendedLower, long lower, long extendedUpper, long upper) {
            super(false);
            void var1_1;
            void var3_2;
            this.lower = var3_2;
            this.upper = upper;
            this.extendedLower = var1_1;
            this.extendedUpper = extendedUpper;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedLower(long value, long maskValue) {
            void var3_2;
            ExtendedSpecificValueMasker extendedSpecificValueMasker = this;
            return super.getMaskedLower(extendedSpecificValueMasker.lower, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedUpper(long upperValue, long maskValue) {
            void var3_2;
            ExtendedSpecificValueMasker extendedSpecificValueMasker = this;
            return super.getMaskedUpper(extendedSpecificValueMasker.upper, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getExtendedMaskedLower(long extendedValue, long extendedMaskValue) {
            void var3_2;
            ExtendedSpecificValueMasker extendedSpecificValueMasker = this;
            return super.getExtendedMaskedLower(extendedSpecificValueMasker.extendedLower, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getExtendedMaskedUpper(long extendedUpperValue, long extendedMaskValue) {
            void var3_2;
            ExtendedSpecificValueMasker extendedSpecificValueMasker = this;
            return super.getExtendedMaskedUpper(extendedSpecificValueMasker.extendedUpper, (long)var3_2);
        }
    }

    public static class ExtendedFullRangeMasker
    extends ExtendedMasker {
        private final long upperMask;
        private final long extendedUpperMask;

        /*
         * WARNING - void declaration
         */
        ExtendedFullRangeMasker(int fullRangeBit, boolean isSequential) {
            super((boolean)var2_2);
            void var1_1;
            void var2_2;
            if (fullRangeBit >= 64) {
                this.extendedUpperMask = 0L;
                this.upperMask = -1L >>> fullRangeBit - 64;
                return;
            }
            this.extendedUpperMask = -1L >>> var1_1;
            this.upperMask = -1L;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedLower(long value, long maskValue) {
            void var3_2;
            void var1_1;
            return super.getMaskedLower((long)(var1_1 & (this.upperMask ^ 0xFFFFFFFFFFFFFFFFL)), (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedUpper(long upperValue, long maskValue) {
            void var3_2;
            void var1_1;
            return super.getMaskedUpper((long)(var1_1 | this.upperMask), (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getExtendedMaskedLower(long extendedValue, long extendedMaskValue) {
            void var3_2;
            void var1_1;
            return super.getExtendedMaskedLower((long)(var1_1 & (this.extendedUpperMask ^ 0xFFFFFFFFFFFFFFFFL)), (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getExtendedMaskedUpper(long extendedUpperValue, long extendedMaskValue) {
            void var3_2;
            void var1_1;
            return super.getMaskedUpper((long)(var1_1 | this.extendedUpperMask), (long)var3_2);
        }
    }

    public static class ExtendedMasker
    extends Masker {
        /*
         * WARNING - void declaration
         */
        public ExtendedMasker(boolean isSequential) {
            super((boolean)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public long getExtendedMaskedLower(long extendedValue, long extendedMaskValue) {
            void var3_2;
            return extendedValue & var3_2;
        }

        /*
         * WARNING - void declaration
         */
        public long getExtendedMaskedUpper(long extendedUpperValue, long extendedMaskValue) {
            void var3_2;
            return extendedUpperValue & var3_2;
        }
    }

    public static class SpecificValueMasker
    extends Masker {
        private final long lower;
        private final long upper;

        /*
         * WARNING - void declaration
         */
        public SpecificValueMasker(long lower, long upper) {
            super(false);
            void var3_2;
            void var1_1;
            this.lower = var1_1;
            this.upper = var3_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedLower(long value, long maskValue) {
            void var3_2;
            SpecificValueMasker specificValueMasker = this;
            return super.getMaskedLower(specificValueMasker.lower, (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedUpper(long upperValue, long maskValue) {
            void var3_2;
            SpecificValueMasker specificValueMasker = this;
            return super.getMaskedUpper(specificValueMasker.upper, (long)var3_2);
        }
    }

    public static class FullRangeMasker
    extends Masker {
        private final long upperMask;
        public final int fullRangeBit;

        /*
         * WARNING - void declaration
         */
        public FullRangeMasker(int fullRangeBit, boolean isSequential) {
            super((boolean)var2_2);
            void var1_1;
            void var2_2;
            this.fullRangeBit = fullRangeBit;
            this.upperMask = -1L >>> var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedLower(long value, long maskValue) {
            void var3_2;
            void var1_1;
            return super.getMaskedLower((long)(var1_1 & (this.upperMask ^ 0xFFFFFFFFFFFFFFFFL)), (long)var3_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getMaskedUpper(long upperValue, long maskValue) {
            void var3_2;
            void var1_1;
            return super.getMaskedUpper((long)(var1_1 | this.upperMask), (long)var3_2);
        }
    }

    public static abstract class Masker
    implements Serializable {
        private final boolean isSequential;

        /*
         * WARNING - void declaration
         */
        public Masker(boolean isSequential) {
            void var1_1;
            this.isSequential = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public long getMaskedLower(long value, long maskValue) {
            void var3_2;
            return value & var3_2;
        }

        /*
         * WARNING - void declaration
         */
        public long getMaskedUpper(long upperValue, long maskValue) {
            void var3_2;
            return upperValue & var3_2;
        }

        public boolean isSequential() {
            return this.isSequential;
        }
    }

    public static class FullRangeBitwiseOrer
    extends BitwiseOrer {
    }

    public static class BitwiseOrer
    implements Serializable {
        private final boolean isSequential;

        /*
         * WARNING - void declaration
         */
        public BitwiseOrer(boolean isSequential) {
            void var1_1;
            this.isSequential = var1_1;
        }
    }

    abstract class TranslatedResult<T extends IPAddress, R extends IPAddressSection>
    extends CachedIPAddresses<T> {
        private R section;
        private R hostSection;
        private R lowerSection;
        private R upperSection;
        private IncompatibleAddressException joinHostException;
        private IncompatibleAddressException joinAddressException;
        private IncompatibleAddressException mixedException;
        private IncompatibleAddressException maskException;
        private IPAddressSeqRange range;
        private T rangeLower;
        private T rangeUpper;
        private IPAddressDivisionSeries series;
        final /* synthetic */ ParsedIPAddress this$0;

        /*
         * WARNING - void declaration
         */
        TranslatedResult(ParsedIPAddress this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        abstract ParsedAddressCreator<T, R, ?, ?> getCreator();

        @Override
        public T getAddress() {
            if (this.address == null) {
                this.address = this.range == null ? (IPAddress)this.getCreator().createAddressInternal(this.section, this.getZone(), this.this$0.originator) : (IPAddress)this.getCreator().createAddressInternal(this.section, this.getZone(), this.this$0.originator, this.rangeLower, this.rangeUpper);
            }
            return this.address;
        }

        boolean hasLowerSection() {
            return this.lowerSection != null;
        }

        boolean hasHostAddress() {
            return this.hostAddress != null;
        }

        boolean hasAddress() {
            return this.address != null;
        }

        @Override
        public T getHostAddress() {
            if (this.hostSection == null) {
                return this.getAddress();
            }
            if (this.hostAddress == null) {
                this.hostAddress = (IPAddress)this.getCreator().createAddressInternal(this.hostSection, this.getZone(), null);
            }
            return this.hostAddress;
        }

        private CharSequence getZone() {
            return this.this$0.getQualifier().getZone();
        }

        boolean withoutSections() {
            return this.section == null;
        }

        boolean withoutAddressException() {
            return this.joinAddressException == null && this.mixedException == null && this.maskException == null;
        }

        boolean withoutRange() {
            return this.range == null;
        }

        boolean withoutGrouping() {
            return this.series == null;
        }

        IPAddressSeqRange createRange() {
            this.rangeLower = (IPAddress)this.getCreator().createAddressInternal(this.lowerSection, this.getZone(), null);
            this.rangeUpper = this.upperSection == null ? this.rangeLower : (IPAddress)this.getCreator().createAddressInternal(this.upperSection, this.getZone(), null);
            this.range = ((IPAddress)this.rangeLower).spanWithRange((IPAddress)this.rangeUpper);
            return this.range;
        }

        IPAddress getValForMask() {
            return (IPAddress)this.getCreator().createAddressInternal(this.lowerSection, null, null);
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPAddressSeqRange access$102(TranslatedResult x0, IPAddressSeqRange x1) {
            void var1_1;
            x0.range = var1_1;
            return x0.range;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IncompatibleAddressException access$402(TranslatedResult x0, IncompatibleAddressException x1) {
            void var1_1;
            x0.maskException = var1_1;
            return x0.maskException;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPAddressSection access$802(TranslatedResult x0, IPAddressSection x1) {
            void var1_1;
            x0.section = var1_1;
            return x0.section;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPAddressSection access$902(TranslatedResult x0, IPAddressSection x1) {
            void var1_1;
            x0.hostSection = var1_1;
            return x0.hostSection;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IncompatibleAddressException access$302(TranslatedResult x0, IncompatibleAddressException x1) {
            void var1_1;
            x0.joinHostException = var1_1;
            return x0.joinHostException;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IncompatibleAddressException access$502(TranslatedResult x0, IncompatibleAddressException x1) {
            void var1_1;
            x0.joinAddressException = var1_1;
            return x0.joinAddressException;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPAddressSection access$1002(TranslatedResult x0, IPAddressSection x1) {
            void var1_1;
            x0.lowerSection = var1_1;
            return x0.lowerSection;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IPAddressSection access$1102(TranslatedResult x0, IPAddressSection x1) {
            void var1_1;
            x0.upperSection = var1_1;
            return x0.upperSection;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ IncompatibleAddressException access$202(TranslatedResult x0, IncompatibleAddressException x1) {
            void var1_1;
            x0.mixedException = var1_1;
            return x0.mixedException;
        }
    }

    static class CachedIPAddresses<T extends IPAddress>
    implements Serializable {
        protected T address;
        protected T hostAddress;

        CachedIPAddresses() {
        }

        /*
         * WARNING - void declaration
         */
        public CachedIPAddresses(T address) {
            void var1_1;
            void v0 = var1_1;
            this(v0, v0);
        }

        /*
         * WARNING - void declaration
         */
        public CachedIPAddresses(T address, T hostAddress) {
            void var2_2;
            void var1_1;
            this.address = var1_1;
            this.hostAddress = var2_2;
        }

        public T getAddress() {
            return this.address;
        }

        public T getHostAddress() {
            return this.hostAddress;
        }
    }
}

